<?php
/**
 * The template for displaying 404 pages (Not Found)
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */

$oxelar_opt = get_option( 'oxelar_opt' );

get_header('error');

if(is_ssl()){
	$oxelar_opt['logo_error']['url'] = str_replace('http:', 'https:', $oxelar_opt['logo_error']['url']);
}
?>
	<div class="wrapper-error404">
		<div class="container">
			<div class="inner-error404"> 
				<?php if( isset($oxelar_opt['logo_error']['url']) ){ ?>
					<div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url($oxelar_opt['logo_error']['url']); ?>" alt="" /></a></div>
				<?php
				} else { ?>
					<h1 class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<?php
				} ?>
				<h2><?php esc_html_e( "error - not found", "oxelar" ); ?></h2>
				<p><?php esc_html_e( "It looks like you are lost! Try searching here", 'oxelar' ); ?></p> 
				<div class="search-form-wrapper"> 
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div> 
<?php get_footer('error'); ?>