<?php
/**
 * The template for displaying Category pages
 *
 * Used to display archive-type pages for posts in a category.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */

$oxelar_opt = get_option( 'oxelar_opt' );

get_header();

if(isset($oxelar_opt)){
	$bloglayout = 'nosidebar';
} else {
	$bloglayout = 'sidebar';
}
if(isset($oxelar_opt['blog_layout']) && $oxelar_opt['blog_layout']!=''){
	$bloglayout = $oxelar_opt['blog_layout'];
}
if(isset($_GET['layout']) && $_GET['layout']!=''){
	$bloglayout = $_GET['layout'];
}
$blogsidebar = 'right';
if(isset($oxelar_opt['sidebarblog_pos']) && $oxelar_opt['sidebarblog_pos']!=''){
	$blogsidebar = $oxelar_opt['sidebarblog_pos'];
}
if(isset($_GET['sidebar']) && $_GET['sidebar']!=''){
	$blogsidebar = $_GET['sidebar'];
}
switch($bloglayout) {
	case 'sidebar':
		$blogclass = 'blog-sidebar';
		$blogcolclass = 9;
		Oxelar::oxelar_post_thumbnail_size('oxelar-category-thumb');
		break;
	default:
		$blogclass = 'blog-nosidebar';
		$blogcolclass = 12;
		$blogsidebar = 'none';
		Oxelar::oxelar_post_thumbnail_size('oxelar-post-thumb');
}
?>
<div class="main-container"> 
	<div class="container-box"> 
		<div class="blog_header"> 
			<header class="entry-header"> 
				<h1 class="entry-title"><?php if(isset($oxelar_opt)) { echo esc_html($oxelar_opt['blog_header_text']); } else { esc_html_e('Blog', 'oxelar');}  ?></h1>
				
			</header>
			<?php Oxelar::oxelar_breadcrumb(); ?>

		</div>
		<div class="container">
			<div class="row">
				
				<?php if($blogsidebar=='left') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
				<div class="col-xs-12 <?php echo 'col-md-'.$blogcolclass; ?>">
				
					<div class="page-content blog-page <?php echo esc_attr($blogclass); if($blogsidebar=='left') {echo ' left-sidebar'; } if($blogsidebar=='right') {echo ' right-sidebar'; } ?>">
					
						<?php if ( have_posts() ) : ?>
							<header class="archive-header">
								<h1 class="archive-title"><?php printf( esc_html__( 'Category Archives: %s', 'oxelar' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h1>

							<?php if ( category_description() ) : // Show an optional category description ?>
								<div class="archive-meta"><?php echo category_description(); ?></div>
							<?php endif; ?>
							</header><!-- .archive-header -->

							<?php
							/* Start the Loop */
							while ( have_posts() ) : the_post();

								/* Include the post format-specific template for the content. If you want to
								 * this in a child theme then include a file called called content-___.php
								 * (where ___ is the post format) and that will be used instead.
								 */
								get_template_part( 'content', get_post_format() );

							endwhile;
							?>
							
							<div class="pagination">
								<?php oxelar::oxelar_pagination(); ?>
							</div>
							
						<?php else : ?>
							<?php get_template_part( 'content', 'none' ); ?>
						<?php endif; ?>
					</div>
				</div>
				<?php if( $blogsidebar=='right') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>

<?php get_footer(); ?>