<?php
/**
 * Grouped product add to cart
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.1.7
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $product, $post;

$parent_product_post = $post;

do_action( 'woocommerce_before_add_to_cart_form' ); ?>

<form class="cart" method="post" enctype='multipart/form-data'>
	<div class="group_table">
		<?php
			foreach ( $grouped_products as $product_id ) :
				$product = wc_get_product( $product_id );
				$post    = $product->post;
				setup_postdata( $post );
				?>
					<div class="group-row">
						<div class="quantity-row">
							<?php if ( $product->is_sold_individually() || ! $product->is_purchasable() ) : ?>
								<?php woocommerce_template_loop_add_to_cart(); ?>
							<?php else : ?>
								<?php
									$quantites_required = true;
									woocommerce_quantity_input( array( 'input_name' => 'quantity[' . $product_id . ']', 'input_value' => '0' ) );
								?>
							<?php endif; ?>
						</div>

						<div class="label">
							<label>
								<?php
								if($product->is_visible()) {
									echo '<a href="' . get_permalink() . '">' . get_the_title() . '</a>';
								} else {
									echo get_the_title();
								}
								?>
							</label>
						</div>

						<?php do_action ( 'woocommerce_grouped_product_list_before_price', $product ); ?>

						<div class="price">
							<?php
								echo ''.$product->get_price_html();

								if ( $availability = $product->get_availability() ) {
									$availability_html = empty( $availability['availability'] ) ? '' : '<p class="stock ' . esc_attr( $availability['class'] ) . '">' . esc_html( $availability['availability'] ) . '</p>';
									echo apply_filters( 'woocommerce_stock_html', $availability_html, $availability['availability'], $product );
								}
							?>
						</div>
					</div>
				<?php
			endforeach;

			// Reset to parent grouped product
			$post    = $parent_product_post;
			$product = wc_get_product( $parent_product_post->ID );
			setup_postdata( $parent_product_post );
		?>
	</div>
<?php if($product) {?>
	<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />

	<?php if ( $quantites_required ) : ?>

		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

		<button type="submit" class="single_add_to_cart_button button alt"><?php echo ''.$product->single_add_to_cart_text(); ?></button>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

	<?php endif; ?>
<?php } else { ?>
	<?php 
		$productid = intval( $_POST['data'] );
		$product = get_product( $productid );
	?>
	<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />

	<?php if ( $quantites_required ) : ?>

		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

		<button type="submit" class="single_add_to_cart_button button alt"><?php echo ''.$product->single_add_to_cart_text(); ?></button>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

	<?php endif; ?>
<?php }?>
</form>

<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>