window.$ = jQuery;

$(function ($) {
    SrPago.setPublishableKey(wc_srpago_params.public_key);
    SrPago.setLiveMode(! wc_srpago_params.sandbox_mode);

    var form = $('form.checkout, form#order_review');

    var onSuccessHandler = function (response) {
        form.append($('<input type="hidden" name="srpago_token" />').val(response.token));

        form.submit();
    };

    var onFailHandler = function (response) {
        SrPagoErrorHandler([ response.message, ]);

        form.unblock();
    };


    $('body').on('click', 'form#order_review input:submit', function () {
        return $('input[name=payment_method]:checked').val() != 'WC_Gateway_SrPagoCard';
    });

    $('body').on('click', 'form.checkout input:submit', function () {
        $('.woocommerce_error, .woocommerce-error, .woocommerce-message, .woocommerce_message, .srpago-error-param').remove();

        $('form.checkout').find('[name="srpago_token"]').remove();
    });


    $('form.checkout').bind('checkout_place_order_WC_Gateway_SrPagoCard', function (e) {
        try {
            form.find('.srpago-errors').html('');
            form.block({
                message: null,
                overlayCSS: {
                    backgroundSize: '16px 16px',
                    opacity: 0.6
                }
            });

            if (form.find('[name="srpago_token"]').length) {
                return true;
            }

            var errors = [];
            var card = {
                number:         form.find('[data-srpago="card[number]"]').val(),
                holder_name:    form.find('[data-srpago="card[holder_name]"]').val(),
                cvv:            form.find('[data-srpago="card[cvv]"]').val(),
                exp_month:      form.find('[data-srpago="card[exp_month]"]').val(),
                exp_year:       form.find('[data-srpago="card[exp_year]"]').val(),
            };

            if (! SrPago.card.validateCardNumber(card.number)) {
                errors.push('El número de la tarjeta es inválido.');
            }

            if (5 > card.holder_name.length) {
                errors.push('El nombre del titular es inválido.');
            }

            if (! SrPago.card.validateCVV(card.cvv)) {
                errors.push('El código de seguridad es inválido.');
            }

            if (! SrPago.card.validateExpiration(card.exp_month, card.exp_year)) {
                errors.push('La fecha de expiración es inválida.');
            }

            if (0 < errors.length) {
                SrPagoErrorHandler(errors);

                form.unblock();

                return false;
            }

            SrPago.token.create(card, onSuccessHandler, onFailHandler);
        } catch (e) {
            SrPagoErrorHandler([ 'Ha ocurrido un error en la comunicación, favor de volver a intentarlo mas tarde.', ]);

            console.log(e);

            form.unblock();
        }

        return false;
    });
});

function SrPagoErrorHandler(errors) {
    var output = '<ul>';

    errors.forEach(function (v) {
        output += '<li>* ' + v + '</li>';
    });

    output += '</ul>';

    $('.srpago-errors').html(output);
}
