
window.projectVersion = 'master';

(function(root) {

    var bhIndex = null;
    var rootPath = '';
    var treeHtml = '        <ul>                <li data-name="namespace:" class="opened">                    <div style="padding-left:0px" class="hd">                        <span class="glyphicon glyphicon-play"></span><a href=".html">[Global Namespace]</a>                    </div>                    <div class="bd">                                <ul>                <li data-name="class:WC_Gateway_SrPagoCard" class="opened">                    <div style="padding-left:26px" class="hd leaf">                        <a href="WC_Gateway_SrPagoCard.html">WC_Gateway_SrPagoCard</a>                    </div>                </li>                            <li data-name="class:WC_SrPago" class="opened">                    <div style="padding-left:26px" class="hd leaf">                        <a href="WC_SrPago.html">WC_SrPago</a>                    </div>                </li>                            <li data-name="class:WC_SrPagoCard" class="opened">                    <div style="padding-left:26px" class="hd leaf">                        <a href="WC_SrPagoCard.html">WC_SrPagoCard</a>                    </div>                </li>                </ul></div>                </li>                </ul>';

    var searchTypeClasses = {
        'Namespace': 'label-default',
        'Class': 'label-info',
        'Interface': 'label-primary',
        'Trait': 'label-success',
        'Method': 'label-danger',
        '_': 'label-warning'
    };

    var searchIndex = [
                    
            {"type": "Namespace", "link": ".html", "name": "", "doc": "Namespace "},
            
            {"type": "Class",  "link": "WC_Gateway_SrPagoCard.html", "name": "WC_Gateway_SrPagoCard", "doc": "&quot;Clase principal para la integraci\u00f3n del plugin.&quot;"},
                                                        {"type": "Method", "fromName": "WC_Gateway_SrPagoCard", "fromLink": "WC_Gateway_SrPagoCard.html", "link": "WC_Gateway_SrPagoCard.html#method___construct", "name": "WC_Gateway_SrPagoCard::__construct", "doc": "&quot;Inicializar la configuraci\u00f3n del plugin.&quot;"},
                    {"type": "Method", "fromName": "WC_Gateway_SrPagoCard", "fromLink": "WC_Gateway_SrPagoCard.html", "link": "WC_Gateway_SrPagoCard.html#method_init_form_fields", "name": "WC_Gateway_SrPagoCard::init_form_fields", "doc": "&quot;Inicializar los campos de configuraci\u00f3n.&quot;"},
                    {"type": "Method", "fromName": "WC_Gateway_SrPagoCard", "fromLink": "WC_Gateway_SrPagoCard.html", "link": "WC_Gateway_SrPagoCard.html#method_admin_options", "name": "WC_Gateway_SrPagoCard::admin_options", "doc": "&quot;Muestra los campos de configuraci\u00f3n.&quot;"},
                    {"type": "Method", "fromName": "WC_Gateway_SrPagoCard", "fromLink": "WC_Gateway_SrPagoCard.html", "link": "WC_Gateway_SrPagoCard.html#method_payment_fields", "name": "WC_Gateway_SrPagoCard::payment_fields", "doc": "&quot;Incluir los campos para el pago con tarjeta.&quot;"},
                    {"type": "Method", "fromName": "WC_Gateway_SrPagoCard", "fromLink": "WC_Gateway_SrPagoCard.html", "link": "WC_Gateway_SrPagoCard.html#method_process_payment", "name": "WC_Gateway_SrPagoCard::process_payment", "doc": "&quot;Procesa el pago&quot;"},
            
            {"type": "Class",  "link": "WC_SrPago.html", "name": "WC_SrPago", "doc": "&quot;&quot;"},
                                                        {"type": "Method", "fromName": "WC_SrPago", "fromLink": "WC_SrPago.html", "link": "WC_SrPago.html#method___construct", "name": "WC_SrPago::__construct", "doc": "&quot;Inicializa los parametros por default del SDK\ny agrega la hoja de estilo para el formulario de pago.&quot;"},
                    {"type": "Method", "fromName": "WC_SrPago", "fromLink": "WC_SrPago.html", "link": "WC_SrPago.html#method_addGateway", "name": "WC_SrPago::addGateway", "doc": "&quot;Registra el gateway en WooCommerce.&quot;"},
                    {"type": "Method", "fromName": "WC_SrPago", "fromLink": "WC_SrPago.html", "link": "WC_SrPago.html#method_wcAddNotice", "name": "WC_SrPago::wcAddNotice", "doc": "&quot;Agrega un mensaje para ser mostrado al cliente.&quot;"},
                    {"type": "Method", "fromName": "WC_SrPago", "fromLink": "WC_SrPago.html", "link": "WC_SrPago.html#method_checkRequirements", "name": "WC_SrPago::checkRequirements", "doc": "&quot;Valida los requerimientos del plugin, en caso de que no se cumplan al\n100% los campos de configuraci\u00f3n apareceran desabilitados.&quot;"},
                    {"type": "Method", "fromName": "WC_SrPago", "fromLink": "WC_SrPago.html", "link": "WC_SrPago.html#method_buildError", "name": "WC_SrPago::buildError", "doc": "&quot;Maneja los mensajes de error que se muestran al cliente.&quot;"},
                    {"type": "Method", "fromName": "WC_SrPago", "fromLink": "WC_SrPago.html", "link": "WC_SrPago.html#method_log", "name": "WC_SrPago::log", "doc": "&quot;Guarda un mensaje de log.&quot;"},
            
            {"type": "Class",  "link": "WC_SrPagoCard.html", "name": "WC_SrPagoCard", "doc": "&quot;&quot;"},
                                                        {"type": "Method", "fromName": "WC_SrPagoCard", "fromLink": "WC_SrPagoCard.html", "link": "WC_SrPagoCard.html#method_buildMetadata", "name": "WC_SrPagoCard::buildMetadata", "doc": "&quot;Contruye la metadata de la transacci\u00f3n.&quot;"},
                    {"type": "Method", "fromName": "WC_SrPagoCard", "fromLink": "WC_SrPagoCard.html", "link": "WC_SrPagoCard.html#method_processCardCharge", "name": "WC_SrPagoCard::processCardCharge", "doc": "&quot;Procesa el pago&quot;"},
                    {"type": "Method", "fromName": "WC_SrPagoCard", "fromLink": "WC_SrPagoCard.html", "link": "WC_SrPagoCard.html#method_enqueue_payment_scripts", "name": "WC_SrPagoCard::enqueue_payment_scripts", "doc": "&quot;Incluye las librerias externas para la\ntokenizaci\u00f3n de las tarejtas.&quot;"},
            
            
                                        // Fix trailing commas in the index
        {}
    ];

    /** Tokenizes strings by namespaces and functions */
    function tokenizer(term) {
        if (!term) {
            return [];
        }

        var tokens = [term];
        var meth = term.indexOf('::');

        // Split tokens into methods if "::" is found.
        if (meth > -1) {
            tokens.push(term.substr(meth + 2));
            term = term.substr(0, meth - 2);
        }

        // Split by namespace or fake namespace.
        if (term.indexOf('\\') > -1) {
            tokens = tokens.concat(term.split('\\'));
        } else if (term.indexOf('_') > 0) {
            tokens = tokens.concat(term.split('_'));
        }

        // Merge in splitting the string by case and return
        tokens = tokens.concat(term.match(/(([A-Z]?[^A-Z]*)|([a-z]?[^a-z]*))/g).slice(0,-1));

        return tokens;
    };

    root.Sami = {
        /**
         * Cleans the provided term. If no term is provided, then one is
         * grabbed from the query string "search" parameter.
         */
        cleanSearchTerm: function(term) {
            // Grab from the query string
            if (typeof term === 'undefined') {
                var name = 'search';
                var regex = new RegExp("[\\?&]" + name + "=([^&#]*)");
                var results = regex.exec(location.search);
                if (results === null) {
                    return null;
                }
                term = decodeURIComponent(results[1].replace(/\+/g, " "));
            }

            return term.replace(/<(?:.|\n)*?>/gm, '');
        },

        /** Searches through the index for a given term */
        search: function(term) {
            // Create a new search index if needed
            if (!bhIndex) {
                bhIndex = new Bloodhound({
                    limit: 500,
                    local: searchIndex,
                    datumTokenizer: function (d) {
                        return tokenizer(d.name);
                    },
                    queryTokenizer: Bloodhound.tokenizers.whitespace
                });
                bhIndex.initialize();
            }

            results = [];
            bhIndex.get(term, function(matches) {
                results = matches;
            });

            if (!rootPath) {
                return results;
            }

            // Fix the element links based on the current page depth.
            return $.map(results, function(ele) {
                if (ele.link.indexOf('..') > -1) {
                    return ele;
                }
                ele.link = rootPath + ele.link;
                if (ele.fromLink) {
                    ele.fromLink = rootPath + ele.fromLink;
                }
                return ele;
            });
        },

        /** Get a search class for a specific type */
        getSearchClass: function(type) {
            return searchTypeClasses[type] || searchTypeClasses['_'];
        },

        /** Add the left-nav tree to the site */
        injectApiTree: function(ele) {
            ele.html(treeHtml);
        }
    };

    $(function() {
        // Modify the HTML to work correctly based on the current depth
        rootPath = $('body').attr('data-root-path');
        treeHtml = treeHtml.replace(/href="/g, 'href="' + rootPath);
        Sami.injectApiTree($('#api-tree'));
    });

    return root.Sami;
})(window);

$(function() {

    // Enable the version switcher
    $('#version-switcher').change(function() {
        window.location = $(this).val()
    });

    
        // Toggle left-nav divs on click
        $('#api-tree .hd span').click(function() {
            $(this).parent().parent().toggleClass('opened');
        });

        // Expand the parent namespaces of the current page.
        var expected = $('body').attr('data-name');

        if (expected) {
            // Open the currently selected node and its parents.
            var container = $('#api-tree');
            var node = $('#api-tree li[data-name="' + expected + '"]');
            // Node might not be found when simulating namespaces
            if (node.length > 0) {
                node.addClass('active').addClass('opened');
                node.parents('li').addClass('opened');
                var scrollPos = node.offset().top - container.offset().top + container.scrollTop();
                // Position the item nearer to the top of the screen.
                scrollPos -= 200;
                container.scrollTop(scrollPos);
            }
        }

    
    
        var form = $('#search-form .typeahead');
        form.typeahead({
            hint: true,
            highlight: true,
            minLength: 1
        }, {
            name: 'search',
            displayKey: 'name',
            source: function (q, cb) {
                cb(Sami.search(q));
            }
        });

        // The selection is direct-linked when the user selects a suggestion.
        form.on('typeahead:selected', function(e, suggestion) {
            window.location = suggestion.link;
        });

        // The form is submitted when the user hits enter.
        form.keypress(function (e) {
            if (e.which == 13) {
                $('#search-form').submit();
                return true;
            }
        });

    
});


