<div class="clear"></div>

<div class='srpago-errors'></div>

<p class="form-row form-row-wide">
    <label for="card_number">Número de la tarjeta <abbr class="required" title="required">*</abbr></label>
    <input type="text" id="card_number" data-srpago="card[number]" maxlength="19" min="15" title="Número de tarjeta" autocomplete="off" data-autofocus="true" placeholder="Número de tarjeta" class="input-text">
</p>

<p class="form-row form-row-wide">
    <label for="card_name">Nombre del titular <abbr class="required" title="required">*</abbr></label>
    <input type="text" id="card_name" data-srpago="card[holder_name]" maxlength="26" title="Nombre del titular" min="5" autocomplete="off" placeholder="Nombre del titular" class="input-text">
</p>

<div class="clear"></div>
<p class="form-row form-row-first">
    <label for="card_exp_month">Mes de expiración <abbr class="required" title="required">*</abbr></label>
    <select id="card_exp_month" data-srpago="card[exp_month]">
        <option selected="selected" value=""> - Seleccionar - </option>
        <option value="01">01 - Enero</option>
        <option value="02">02 - Febrero</option>
        <option value="03">03 - Marzo</option>
        <option value="04">04 - Abril</option>
        <option value="05">05 - Mayo</option>
        <option value="06">06 - Junio</option>
        <option value="07">07 - Julio</option>
        <option value="08">08 - Agosto</option>
        <option value="09">09 - Septiembre</option>
        <option value="10">10 - Octubre</option>
        <option value="11">11 - Noviembre</option>
        <option value="12">12 - Diciembre</option>
    </select>
</p>

<p class="form-row form-row-last">
    <label>Año de expiración <abbr class="required" title="required">*</abbr></label>
    <select id="card_exp_year" data-srpago="card[exp_year]">
        <option selected="selected" value=""> - Seleccionar - </option>
        <?php
            $start_year = date('Y');
            $end_year = date('Y', strtotime('+10 years'));
            for ($i = $start_year; $i <= $end_year; $i++) {
        ?>
            <option value="<?php echo substr($i, -2); ?>"><?php echo $i; ?></option>
        <?php } ?>
    </select>
</p>

<div class="clear"></div>
<p class="form-row form-row-first">
    <label for="card_cvv">CVV <abbr class="required" title="required">*</abbr></label>
    <input type="password" id="card_cvv" data-srpago="card[cvv]" maxlength="4" min="3" title="Cvv" autocomplete="off" placeholder="CVV" class="input-text">
</p>

<?php if ($monthly_installments_available): ?>
    <div class="clear"></div>
    <p class="form-row form-row-wide">
        <label for="monthly_installments">Tipo de pago <span class="required">*</span></label>
        <select id="monthly_installments" name="monthly_installments">
            <option selected="selected" value="1">Pago directo</option>
            <?php foreach($monthly_installments_available_months AS $months): ?>
                <option value="<?php echo esc_html($months); ?>"><?php echo esc_html($months); ?> meses</option>
            <?php endforeach; ?>
        </select>
        <small>Meses sin intereses con los <a href="https://senorpago.com/#bancos" target="_blank">principales bancos</a></small>
    </p>
<?php endif ?>

<div class="clear"></div>
