<?php

/*
  Title:        SrPago Payment Gateway
  Author:       Roberto Ramírez
  URL:          https://www.srpago.com
  License:
  License URI:
*/

$settings = apply_filters('wc_gateway_srpagospei_settings',
    array(
        'enabled' => array(
            'type'          => 'checkbox',
            'title'         => __('Enable/Disable', 'SrPagoPaymentGateway'),
            'label'         => __('Habilitar pago por SPEI', 'SrPagoPaymentGateway'),
            'default'       => 'yes',
        ),
        'title' => array(
            'type'          => 'text',
            'title'         => __('Titulo', 'SrPagoPaymentGateway'),
            'description'   => __('Titulo que el usuario ve en el checkout.', 'SrPagoPaymentGateway'),
            'default'       => __('SrPago - Pago por SPEI', 'SrPagoPaymentGateway'),
            'desc_tip'      => true,
        ),
        'sandbox' => array(
            'type'          => 'checkbox',
            'title'         => __('Modo de prueba', 'SrPagoPaymentGateway'),
            'label'         => __('Habilitar modo de prueba (sandbox)', 'SrPagoPaymentGateway'),
            'default'       => 'no',
        ),
        'sandbox_app_key' => array(
            'type'          => 'text',
            'title'         => __('Sandbox - App Key', 'SrPagoPaymentGateway'),
            'description'   => __('Obtenga la App Key de su cuenta en SrPago.com', 'SrPagoPaymentGateway'),
            'default'       => null,
            'desc_tip'      => true,
        ),
        'sandbox_app_secret' => array(
            'type'          => 'password',
            'title'         => __('Sandbox - App Secret', 'SrPagoPaymentGateway'),
            'description'   => __('Obtenga la App Secret de su cuenta en SrPago.com', 'SrPagoPaymentGateway'),
            'default'       => null,
            'desc_tip'      => true,
        ),
        'sandbox_public_key' => array(
            'type'          => 'text',
            'title'         => __('Sandbox - Public Key', 'SrPagoPaymentGateway'),
            'description'   => __('Obtenga la Public Key de su cuenta en SrPago.com', 'SrPagoPaymentGateway'),
            'default'       => null,
            'desc_tip'      => true,
        ),
        'live_app_key' => array(
            'type'          => 'text',
            'title'         => __('Producción - App Key', 'SrPagoPaymentGateway'),
            'description'   => __('Obtenga la App Key de su cuenta en SrPago.com', 'SrPagoPaymentGateway'),
            'default'       => null,
            'desc_tip'      => true,
        ),
        'live_app_secret' => array(
            'type'          => 'password',
            'title'         => __('Producción - App Secret', 'SrPagoPaymentGateway'),
            'description'   => __('Obtenga la App Secret de su cuenta en SrPago.com', 'SrPagoPaymentGateway'),
            'default'       => null,
            'desc_tip'      => true,
        ),
        'live_public_key' => array(
            'type'          => 'text',
            'title'         => __('Producción - Public Key', 'SrPagoPaymentGateway'),
            'description'   => __('Obtenga la Public Key de su cuenta en SrPago.com', 'SrPagoPaymentGateway'),
            'default'       => null,
            'desc_tip'      => true,
        ),
        'logging' => array(
            'type'        => 'checkbox',
            'title'       => __( 'Logging', 'SrPagoPaymentGateway'),
            'label'       => __( 'Registrar mensajes de depuración', 'SrPagoPaymentGateway'),
            'description' => sprintf(__( 'Guardar mensajes de depuración en el registro de estado del sistema WooCommerce, dentro de %s Nota: esto puede registrar información personal. Recomendamos usar esto solo para fines de depuración y eliminar los registros cuando haya terminado.', 'SrPagoPaymentGateway'), '<code>' . WC_Log_Handler_File::get_log_file_path( 'woocommerce-gateway-srpago' ) . '</code>'),
            'default'     => 'no',
            'desc_tip'    => false,
        ),
    )
);

if (0 < count($this->requirement_errors)) {
    array_walk($settings, function (&$setting) {
        $setting['disabled'] = true;
    });
}

return $settings;
