<?php
/**
 * Main class
 *
 * @author Your Inspiration Themes
 * @package YITH Newsletter Popup
 * @version 1.0.0
 */
if ( !defined( 'YITH_NEWSLETTER_POPUP' ) ) { exit; } // Exit if accessed directly

if( !class_exists( 'YITH_Newsletter_Popup_Frontend' ) ) {

    /**
     * YITH Custom Login Frontend
     *
     * @since 1.0.0
     */
class YITH_Newsletter_Popup_Frontend {

    /**
     * Plugin version
     *
     * @var string
     * @since 1.0.0
     */
    public $version;

    /**
     * Plugin version
     *
     * @var string
     * @since 1.0.0
     */
    public $template_file = 'yith-newsletter-popup.php';

    /**
     * Fonts used within the plugin
     *
     * @var array
     * @since 1.0.0
     */
    public $fonts = array();

    /**
     * Constructor
     *
     * @return YITH_Newsletter_Popup_Frontend
     * @since 1.0.0
     */
    public function __construct( $version ) {
        $this->version = $version;
        global $yith_newsletter_popup_base;
        $yith_newsletter_popup_base = "yith-newsletter-popup-" . basename( get_template_directory() ) . "-hide-popup-" . get_option('yith_newsletter_popup_cookie_var');
        if (
            ( ! yith_newsletter_popup_is_enabled())
            ||(isset($_COOKIE[$yith_newsletter_popup_base]))
//            ||(wp_is_mobile())
        ) return $this;
        add_action( 'wp_enqueue_scripts', array( $this, 'newsletter_popup_in_place_inserter_master'), 99 );
        add_action('wp_head', array( $this, 'newsletter_popup_style_to_the_head'));
        add_action('init', array( $this, 'add_google_fonts'));
        add_action('wp_footer', array( $this, 'newsletter_popup_in_place_inserter'), 999);
        return $this;
    }
    public function add_google_fonts() {
        $this->fonts = array(
            'title_font' => yit_typo_option_to_css( get_option('yith_newsletter_popup_title_font') ),
            'p_font' => yit_typo_option_to_css( get_option('yith_newsletter_popup_paragraph_font') ),
            'n_font' => yit_typo_option_to_css( get_option('yith_newsletter_popup_newsletter_email_font')),
            's_font' => yit_typo_option_to_css( get_option('yith_newsletter_popup_submit_font')),
            's_hover_font' => yit_typo_option_to_css( get_option('yith_newsletter_popup_submit_font_hover')),
            'hider_font' => yit_typo_option_to_css( get_option('yith_newsletter_popup_hide_font')),
        );
    }

    /**
     * Return URL of the template
     */
    public function newsletter_popup_in_place_inserter() {
        $plugin_path   = plugin_dir_path(__FILE__) . 'templates/' . $this->template_file;
        $template_path = get_template_directory() . '/' . $this->template_file;
        $child_path    = get_stylesheet_directory() . '/' . $this->template_file;
        foreach ( array( 'child_path', 'template_path', 'plugin_path' ) as $var ) {
            if ( file_exists( ${$var} ) ) {
                include ${$var};
                return;
            }
        }
    }

    /**
     * Return the url of stylesheet position
     *
     */
    public function stylesheet_url() {
        $filename = 'yith-newsletter-popup.css';
        $plugin_path   = array( 'path' => plugin_dir_path(__FILE__) . 'assets/css/style.css', 'url' => YITH_NEWSLETTER_POPUP_URL . 'assets/css/style.css' );
        $template_path = array( 'path' => get_template_directory() . '/' . $filename,         'url' => get_template_directory_uri() . '/' . $filename );
        $child_path    = array( 'path' => get_stylesheet_directory() . '/' . $filename,       'url' => get_stylesheet_directory_uri() . '/' . $filename );
        foreach ( array( 'child_path', 'template_path', 'plugin_path' ) as $var ) {
            if ( file_exists( ${$var}['path'] ) ) {
                return ${$var}['url'];
            }
        }
        exit();
    }

// add style in head section of your website
public function newsletter_popup_style_to_the_head(){
    if (get_option('yith_newsletter_popup_woocommerce_integration')){
        $yith_popup_submit_style = get_option('yith_newsletter_popup_woo_custom_submit');
        $yith_popup_submit_background = get_option('yith_newsletter_popup_woo_submit_background');
        $yith_popup_submit_background_hover = get_option('yith_newsletter_popup_woo_submit_hover_background');
    }else{
        $yith_popup_submit_style = get_option('yith_newsletter_popup_custom_submit');
        $yith_popup_submit_background = get_option('yith_newsletter_popup_submit_background');
        $yith_popup_submit_background_hover = get_option('yith_newsletter_popup_submit_hover_background');
    };?>
    <style type="text/css" >
        .yithpopup_wrapper{background: <?php echo get_option('yith_newsletter_popup_background');?>}

        h2#yith-popup-title{<?php if ($this->fonts): echo $this->fonts['title_font']; endif ?>}
        p#yith-popup-message{<?php if ($this->fonts): echo $this->fonts['p_font']; endif ?>}

        .yith-popup-checkzone label{<?php if ($this->fonts): echo $this->fonts['hider_font']; endif ?>}

        input.name-field.text-field, input.email-field.text-field,.newsletterfields INPUT[type="text"] {
        <?php if ($this->fonts): echo $this->fonts['n_font']; endif;?>
        ::-webkit-input-placeholder { <?php if ($this->fonts): echo $this->fonts['n_font']; endif; ?> !important; }
        :-moz-placeholder, ::-moz-placeholder { <?php if ($this->fonts): echo $this->fonts['n_font']; endif; ?> !important; }
        :-ms-input-placeholder { <?php if ($this->fonts): echo $this->fonts['n_font']; endif; ?> !important; }
            }
        <?php if ($yith_popup_submit_style):?>
            .submit-field.newslettersubmit.button,input.submit-field.newslettersubmit{background:<?php echo $yith_popup_submit_background ;?>;<?php if ($this->fonts): echo $this->fonts['s_font']; endif ?>;}
            .submit-field.newslettersubmit.button:hover,input.submit-field.newslettersubmit:hover{background:<?php echo $yith_popup_submit_background_hover ;?>;<?php if ($this->fonts): echo $this->fonts['s_hover_font']; endif ?>;}
            #yithhider_yith-popup{padding:6px 10px;text-decoration: none;-webkit-border-radius: 0px;-moz-border-radius: 0px;border-radius: 0px;left: auto;text-shadow: none;border: none;white-space: nowrap;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;}
        <?php endif;?>

        <?php if (get_option('yith_newsletter_popup_custom_style')):echo get_option('yith_newsletter_popup_custom_style');endif;?>
    </style>
    <script type="text/javascript">
        var templateDir = "<?php global $yith_newsletter_popup_base; echo $yith_newsletter_popup_base; ?>";
    </script>
<?php }

    /* Enqueue style */
    public function newsletter_popup_in_place_inserter_master() {
        wp_enqueue_style( 'yith-newsletter-popup-google-fonts', yith_google_fonts_url(), false, $this->version );
        wp_enqueue_script( 'jquery-cookie', plugins_url( 'assets/js/jquery.cookie.js', __FILE__ ), array('jquery'), '1.3.1');
        wp_enqueue_script( 'jquery-yithpopup', plugins_url( 'assets/js/jquery.yithpopup.js', __FILE__ ), array('jquery'), '1.0.0');
        wp_enqueue_script( 'yith-newsletter-popup', plugins_url( 'assets/js/yith-newsletter-popup.js', __FILE__ ), array('jquery'), $this->version);
        wp_enqueue_style( 'yith-newsletter-popup',  $this->stylesheet_url(), array(), $this->version );
    }

} // class YITH_Newsletter_Popup_Frontend
}// if class !YITH_Newsletter_Popup_Frontend