<?php
/**
 * Main admin class
 *
 * @author Your Inspiration Themes
 * @package YITH Newsletter Popup
 * @version 1.0.0
 */
if ( !defined( 'YITH_NEWSLETTER_POPUP' ) ) { exit; } // Exit if accessed directly
global $yith_newsletter_popup_options;
$yith_newsletter_popup_options = array(
    //tab general
    'general' => array(
        'label' => __('General', 'yith-newsletter-popup'),
        'sections' => array(
            'general' => array(
                'title' =>  __('General Settings', 'yith-newsletter-popup'),
                'description' => '',
                'fields' => array(
                    'yith_newsletter_popup_enable' => array(
                        'title' => __('Enable Newsletter Popup', 'yith-newsletter-popup'),
                        'description' => __( 'Enable the newsletter popup. (Default: Off)', 'yith-newsletter-popup' ),
                        'type' => 'checkbox',
                        'std' => false
                    ),
                    'yith_newsletter_popup_cookie_var' => array(
                        'title' => __('Cookie Variable', 'yith-newsletter-popup'),
                        'description' => __( 'Write here a name to be given to the cookie generated by the closing link of the popup, in this way, as soon as you\'ll change this value all your visitors will see it again even if they disabled it. Don\'t abuse of this function!', 'yith-newsletter-popup' ),
                        'type' => 'text',
                        'std' => __( 'yithpopup', 'yith-newsletter-popup' )
                    ),
                    'yith_newsletter_popup_title' => array(
                        'title' => __('Popup Title', 'yith-newsletter-popup'),
                        'description' => __( 'The title displayed. You can also use HTML code.', 'yith-newsletter-popup' ),
                        'type' => 'text',
                        'std' => __( 'Join our faboulous community today!', 'yith-newsletter-popup' )
                    ),
                    'yith_newsletter_popup_image' => array(
                        'title' => 'Popup Image',
                        'description' => __( 'Upload an image. (Tip: best viewed with a rectangular image sized like 315px X 225px)', 'yith-newsletter-popup' ),
                        'type' => 'upload',
                        'std' => YITH_NEWSLETTER_POPUP_URL . 'assets/images/popup.jpg'
                    ),
                    'yith_newsletter_popup_message' => array(
                        'title' => __('Popup Message', 'yith-newsletter-popup'),
                        'description' => __( 'The message displayed. You can also use HTML code.', 'yith-newsletter-popup' ),
                        'type' => 'textarea',
                        'std' => sprintf( __( "If you would like to be always informed about our latest templates, plugins and products, just fill the form with your name and email.We, Yithemes are here to help you succeed in your web based business.<a href='%s' title='Yithemes FREE  WordPress themes download'>Yithemes FREE  WordPress themes download.</a>", 'yith-newsletter-popup' ),'http://yithemes.com/?ap_id=yith-popup-newsletter'),
                    ),
                    'yith_newsletter_popup_hide_text' => array(
                        'title' => __('Hiding text', 'yith-newsletter-popup'),
                        'description' => __( 'The title displayed next to the checkbox that let users hide the popup forever. You can also use HTML code.', 'yith-newsletter-popup' ),
                        'type' => 'text',
                        'std' => __( 'Do not show it anymore.', 'yith-newsletter-popup' )
                    ),
                    'yith_newsletter_popup_custom_style' => array(
                        'title' => 'Custom style',
                        'description' => __( 'Insert here your custom CSS style.', 'yith-newsletter-popup' ),
                        'type' => 'textarea',
                        'std' => ''
                    ),
                )//fields
            ),//general
            'typography' => array(
                'title' =>  __('Typography', 'yith-newsletter-popup'),
                'description' => '',
                'fields' => array(
                    'yith_newsletter_popup_title_font' => array(
                        'title' =>  __('Title font of message', 'yith-newsletter-popup'),
                        'description' => __('Choose the font type, size and color for the title.', 'yith-newsletter-popup'),
                        'type' => 'typography',
                        'std' => array(
                            'size' => 25,
                            'unit' => 'px',
                            'family' => 'Roboto',
                            'style' => 'bold',
                            'color' => '#373736',
                        ),
                    ),
                    'yith_newsletter_popup_paragraph_font' => array(
                        'title' =>  __('Paragraph font of message', 'yith-newsletter-popup'),
                        'description' => __('Choose the font type, size and color for the message.', 'yith-newsletter-popup'),
                        'type' => 'typography',
                        'std' => array(
                            'size' => 12,
                            'unit' => 'px',
                            'family' => 'Roboto',
                            'style' => 'regular',
                            'color' => '#747373',
                        ),
                    ),
                    'yith_newsletter_popup_hide_font' => array(
                        'title' =>  __('Hiding buttons fonts', 'yith-newsletter-popup'),
                        'description' => __('Choose the font type, size and color for the newsletter popup hiding buttons.', 'yith-newsletter-popup'),
                        'type' => 'typography',
                        'std' => array(
                            'size' => 10,
                            'unit' => 'px',
                            'family' => 'Roboto',
                            'style' => 'regular',
                            'color' => '#111111',
                        ),
                    ),
                    'yith_newsletter_popup_submit_font' => array(
                        'title' =>  __('Newsletter Submit and Add to cart buttons font', 'yith-newsletter-popup'),
                        'description' => __('Choose the font type, size and color for the email submit button and Add to cart button.', 'yith-newsletter-popup'),
                        'type' => 'typography',
                        'std' => array(
                            'size' => 10,
                            'unit' => 'px',
                            'family' => 'Roboto',
                            'style' => 'bold',
                            'color' => '#ffffff',
                        ),
                    ),

                    'yith_newsletter_popup_submit_font_hover' => array(
                        'title' =>  __('Newsletter Submit and Add to cart buttons font on hover status', 'yith-newsletter-popup'),
                        'description' => __('Choose the font type, size and color for the email submit button and Add to cart button on hover status.', 'yith-newsletter-popup'),
                        'type' => 'typography',
                        'std' => array(
                            'size' => 10,
                            'unit' => 'px',
                            'family' => 'Roboto',
                            'style' => 'bold',
                            'color' => '#eeeeee',
                        ),
                    )
                ) // typography fields
            ), //typography
            // Popup background
            'background' => array(
                'title' =>  __('Background Settings', 'yith-newsletter-popup'),
                'description' => __('Customize the background of newsletter popup', 'yith-newsletter-popup'),
                'fields' => array(
                    'yith_newsletter_popup_background' => array(
                        'title' =>  __('Choose a color to be used as background', 'yith-newsletter-popup'),
                        'description' => __("Choose a color to be used as background.", 'yith-newsletter-popup'),
                        'type' => 'colorpicker',
                        'std' => '#FFFFFF',
                    ),
                )//fields
            ), // background
        ) //sections
    ), //general tab
    //tab container
    'newsletter' => array(
        'label' => __('Newsletter', 'yith-newsletter-popup'),
        'sections' => array(
            'newsletter' => array(
                'title' =>  __('Newsletter', 'yith-newsletter-popup'),
                'description' => __('Add a newsletter form in your newsletter popup.', 'yith-newsletter-popup'),
                'fields' => array(
                    'yith_newsletter_popup_enable_newsletter_form' => array(
                        'title' =>  __('Enable Newsletter form', 'yith-newsletter-popup'),
                        'description' => __('Choose if you want to enable the newsletter form in the newsletter popup.', 'yith-newsletter-popup'),
                        'type' => 'checkbox',
                        'std' => true
                    ),

                    'yith_newsletter_popup_newsletter_email_font' => array(
                        'title' =>  __('Newsletter Name and Email Inputs Font', 'yith-newsletter-popup'),
                        'description' => __('Choose the font type, size and color for the name and email inputs field.', 'yith-newsletter-popup'),
                        'type' => 'typography',
                        'std' => array(
                            'size' => 10,
                            'unit' => 'px',
                            'family' => 'Roboto',
                            'style' => 'regular',
                            'color' => '#8f8f8f',
                        ),
                    ),

                    'yith_newsletter_popup_custom_submit' => array(
                        'title' =>  __("Enable custom submit button's colors", 'yith-newsletter-popup'),
                        'description' => __("Choose if you want to use custom submit button's colors or your theme default ones.(Default: Custom)", 'yith-newsletter-popup'),
                        'type' => 'checkbox',
                        'std' => true
                    ),

                    'yith_newsletter_popup_submit_background' => array(
                        'title' =>  __('Newsletter submit background', 'yith-newsletter-popup'),
                        'description' => __('The submit button background.', 'yith-newsletter-popup'),
                        'type' => 'colorpicker',
                        'std' => '#C58408',
                    ),
                    'yith_newsletter_popup_submit_hover_background' => array(
                        'title' =>  __('Newsletter submit hover background', 'yith-newsletter-popup'),
                        'description' => __('The submit button hover background.', 'yith-newsletter-popup'),
                        'type' => 'colorpicker',
                        'std' => '#e79c0c',
                    )
                )
            ),
           'newsletter_configuration' => array(
                'title' =>  __('Form configuration', 'yith-newsletter-popup'),
                'description' => __('Configure the form and each field, to integrate the newsletter features of an external service.', 'yith-newsletter-popup'),
                'fields' => array(
                    'yith_newsletter_popup_action' => array(
                        'title' =>  __('Newsletter Action URL', 'yith-newsletter-popup'),
                        'description' => __('Set the action url of the form.', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => ''
                    ),
                    'yith_newsletter_popup_name_name' => array(
                        'title' =>  __('Name "name"', 'yith-newsletter-popup'),
                        'description' => __('The attribute "name" of the name field.', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => 'name',
                    ),
                    'yith_newsletter_popup_name_icon' => array(
                        'title' =>  __('Name icon', 'yith-newsletter-popup'),
                        'description' => __('Upload or select an icon to be shown in newsletter\'s name input field', 'yith-newsletter-popup'),
                        'type' => 'upload',
                        'std' => YITH_NEWSLETTER_POPUP_URL . 'assets/images/icon_name.png',
                    ),
                    'yith_newsletter_popup_name_label' => array(
                        'title' =>  __('Name field label', 'yith-newsletter-popup'),
                        'description' => __('The name field label', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => 'ENTER YOUR NAME',
                    ),
                    'yith_newsletter_popup_email_name' => array(
                        'title' =>  __('Email "name"', 'yith-newsletter-popup'),
                        'description' => __('The attribute "name" of the email address field.', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => 'email',
                    ),
                    'yith_newsletter_popup_email_icon' => array(
                        'title' =>  __('Email icon', 'yith-newsletter-popup'),
                        'description' => __('Upload or select an icon to be shown in newsletter\'s email input field', 'yith-newsletter-popup'),
                        'type' => 'upload',
                        'std' => YITH_NEWSLETTER_POPUP_URL . 'assets/images/mailwhite.png',
                    ),
                    'yith_newsletter_popup_email_label' => array(
                        'title' =>  __('Email field label', 'yith-newsletter-popup'),
                        'description' => __('The email field label', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => 'ENTER YOUR MAIL ADDRESS',
                    ),
                    'yith_newsletter_popup_submit_button_label' => array(
                        'title' =>  __('Submit button label', 'yith-newsletter-popup'),
                        'description' => __('Submit button label', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => 'ADD ME TO THE LIST',
                    ),
                    'yith_newsletter_popup_newsletter_hidden_fields' => array(
                        'title' =>  __('Newsletter Hidden fields', 'yith-newsletter-popup'),
                        'description' => __('Set the hidden fields to include in the form. Use the form: field1=value1&field2=value2&field3=value3', 'yith-newsletter-popup'),
                        'type' => 'text',
                        'std' => '',
                   ),
                    'yith_newsletter_popup_newsletter_method' => array(
                        'title' =>  __('Form method', 'yith-newsletter-popup'),
                        'description' => __('Set the method for the form request.', 'yith-newsletter-popup'),
                        'type' => 'select',
                        'options' => array(
                            'POST' => 'POST',
                            'GET'  => 'GET',
                        ),
                        'std' => 'POST'
                    )
                ) //fields
            ) //newsletter configuration
        ) //sections -> newsletter
    ), //newsletter
); //whole array

if( yit_is_woocommerce_active() ) {
    $yith_newsletter_popup_options['woocommerce'] = array(
        'label' => __('WooCommerce Integration', 'yith-newsletter-popup'),
        'sections' => array(
            'woocommerce' => array(
                'title' =>  __('WooCommerce Integration', 'yith-newsletter-popup'),
                'description' => '',
                'fields' => array(
                    'yith_newsletter_popup_woocommerce_integration' => array(
                        'title' => __('Enable the WooCommerce integration', 'yith-newsletter-popup'),
                        'description' => __( 'If the option is enabled, the popup shows the informations about the WooCommerce products selected below. (Default: Off)', 'yith-newsletter-popup' ),
                        'type' => 'checkbox',
                        'std' => false
                    ),
                    'yith_newsletter_popup_woocommerce_product_id' => array(
                        'title' => __('WooCommerce Product ID', 'yith-newsletter-popup'),
                        'description' => sprintf( __( 'Write here the ID of the product that you would like to show in your popup. <a href="%s">More info</a>.', 'yith-newsletter-popup' ), 'http://yithemes.com/docs/yith_newsletter_popup/index.html'),
                        'type' => 'text',
                        'std' => ''
                    ),
                    'yith_newsletter_popup_woocommerce_submit_text' => array(
                        'title' => __('WooCommerce Add to Cart Button Call to Action', 'yith-newsletter-popup'),
                        'description' => ('Write here the text that you would like to display in "Add to cart" button'),
                        'type' => 'text',
                        'std' => __('ADD TO CART','yith-newsletter-popup')
                    ),
                    'yith_newsletter_popup_woo_custom_submit' => array(
                        'title' =>  __("Enable custom submit button's colors", 'yith-newsletter-popup'),
                        'description' => __("Choose if you want to use custom submit button's colors or your theme default ones.(Default: Custom)", 'yith-newsletter-popup'),
                        'type' => 'checkbox',
                        'std' => true
                    ),
                    'yith_newsletter_popup_woo_submit_background' => array(
                        'title' =>  __('Newsletter submit background', 'yith-newsletter-popup'),
                        'description' => __('The submit button background.', 'yith-newsletter-popup'),
                        'type' => 'colorpicker',
                        'std' => '#C58408',
                    ),
                    'yith_newsletter_popup_woo_submit_hover_background' => array(
                        'title' =>  __('Newsletter submit hover background', 'yith-newsletter-popup'),
                        'description' => __('The submit button hover background.', 'yith-newsletter-popup'),
                        'type' => 'colorpicker',
                        'std' => '#e79c0c',
                    )
                ) //fields
            ) //woocommerce configuration
        ) //sections -> woocommerce
    );  //woocommerce
}