<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
wp_enqueue_script('owlcarousel');

global $post, $product;
$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
$image_title       = get_post_field( 'post_excerpt', $post_thumbnail_id );
$placeholder       = has_post_thumbnail() ? 'with-images' : 'without-images';
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . $placeholder,
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );
?>

<div class="images">
	<?php
	$attributes = array(
		'id'					  => 'sp_mainimage',
		'title'                   => $image_title,
		'data-src'                => $full_size_image[0],
		'data-large_image'        => $full_size_image[0],
		'data-large_image_width'  => $full_size_image[1],
		'data-large_image_height' => $full_size_image[2],
	);
	if ( has_post_thumbnail() ) {
		$attachment_count = count( $product->get_gallery_image_ids() );
		if ( $attachment_count > 0 ) {
			$gallery = '[product-gallery]';
		} else {
			$gallery = '';
		}
		
		$html  = '<div class="mainimage-wrap">';
		$html .= '<div data-thumb="' . get_the_post_thumbnail_url( $post->ID, 'shop_thumbnail' ) . '" class="woocommerce-product-gallery__image"><a class="woocommerce-main-image zoom" data-rel="prettyPhoto' . $gallery . '" href="' . esc_url( $full_size_image[0] ) . '">';
		$html .= get_the_post_thumbnail( $post->ID, 'shop_single', $attributes );
		$html .= '</a></div>';
		$html .= '<div class="popup-btn-wrap">
					<a class="btn sns-btn-popup" data-rel="prettyPhoto[product-gallery]" href="#" data-toggle="tooltip" data-original-title="'.esc_html__( 'Zoom','snssimen' ).'"><i class="fa fa-search"></i></a>';
		if(  get_post_meta( $post->ID, 'snssimen_product_video', true ) ):
		$html .= '<a class="btn sns-btn-popupvideo" data-rel="prettyPhoto[product-gallery]" href="'.get_post_meta( $post->ID, 'snssimen_product_video', true ).'" data-toggle="tooltip" data-original-title="'.esc_html__( 'Video','snssimen' ).'"><i class="fa fa-youtube-play"></i></a>';
		endif;
		$html .= '</div>';
		$html .= '</div>';
	} else {
		$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
		$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'snssimen' ) );
		$html .= '</div>';
	}
	echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );
	?>
	<div class="sns-thumbnails handle-preload">
		<div id="sns_thumbs" class="thumbnails">
		<?php
		if ( has_post_thumbnail() ) {
			$image_thumb       = wp_get_attachment_image( get_post_thumbnail_id(), 'shop_thumbnail' );
			echo( '<div data-thumb="' . esc_url( $full_size_image[0] ) . '" class="woocommerce-product-gallery__image"><a href="'.$full_size_image[0].'" class="elevatezoom-gallery zoom active cloned" title="'. $image_title .'" data-image="'.$full_size_image[0].'" data-zoom-image="'.$full_size_image[0].'" data-rel="prettyPhoto[product-gallery]">'.$image_thumb.'</a></div>' );
		}
			do_action( 'woocommerce_product_thumbnails' ); 
		?>
		</div>
		<div class="navslider">
			<span class="prev"><i class="fa fa-long-arrow-right"></i></span>
			<span class="next"><i class="fa fa-long-arrow-left"></i></span>
		</div>
	</div>
	<script type="text/javascript">
		jQuery(document).ready(function(){
			// Lightbox
			jQuery('.sns-thumbnails').append('<div id="sns_thumbs_clone" style="display:none">'+jQuery('.sns-thumbnails #sns_thumbs').html()+'</div>');
			elements = "#sns_thumbs_clone a.zoom:not(.cloned)";
			if( jQuery('.sns_main_products .sns-btn-popup').length && jQuery('.sns_main_products a.woocommerce-main-image').length ){
				jQuery('.sns_main_products .sns-btn-popup').attr('href', jQuery('.sns_main_products a.woocommerce-main-image').attr('href') );
				elements = elements + ", .sns_main_products .sns-btn-popup";
				jQuery('.sns_main_products a.woocommerce-main-image').click(function(){
					return false;
				});
			}
			<?php if(  get_post_meta( $post->ID, 'snssimen_product_video', true ) ) : ?>
			elements = elements + ", .sns_main_products .sns-btn-popupvideo";
			<?php endif; ?>
			jQuery(elements).prettyPhoto({
				hook: 'data-rel',
				social_tools: false,
				theme: 'pp_woocommerce',
				horizontal_padding: 20,
				opacity: 0.8,
				deeplinking: false
			});
			// Carousel Gallery
			<?php //if ( $attachment_count >= 2) : ?>
			jQuery('.sns-thumbnails #sns_thumbs').owlCarousel({
				items: 4,
				responsive : {
				    0 : { items: 1 },
				    480 : { items: 3 },
				    768 : { items: 2 },
				    992 : { items: 4 },
				    1200 : { items: 4 }
				},
				//loop:true,
	            dots: false,
	            onInitialized: callback,
	            slideSpeed : 800
			});
			function callback(event) {
				console.log(this._items.length);
				console.log(this.options.items);
	   			if(this._items.length > this.options.items){
			        jQuery('.sns-thumbnails .navslider').show();
			    }else{
			        jQuery('.sns-thumbnails .navslider').hide();
			    }
			    
			}
			jQuery('.sns-thumbnails .prev').on('click', function(e){
				e.preventDefault();
				jQuery('.sns-thumbnails .thumbnails').trigger('prev.owl.carousel');
			});
			jQuery('.sns-thumbnails .next').on('click', function(e){
				e.preventDefault();
				jQuery('.sns-thumbnails .thumbnails').trigger('next.owl.carousel');
			});
			<?php //endif; ?>
		});
		<?php if ( snssimen_get_option('woo_usecloudzoom') ) : 
			$woo_zoomtype = get_post_meta( get_the_id(), 'snssimen_woo_zoomtype', true );
			if($woo_zoomtype == '')
				$woo_zoomtype = snssimen_get_option('woo_zoomtype');
		?>
		jQuery(window).load(function(){
			jQuery('#sp_mainimage').elevateZoom({
				zoomType : "<?php echo $woo_zoomtype ?>",
				<?php if ( $woo_zoomtype == 'lens' ): ?>
				lensShape : "round", lensSize : 200,
				<?php endif; ?>
				<?php if ( $woo_zoomtype == 'inner' ): ?>
				cursor: "crosshair",
				<?php endif; ?>
				zoomWindowWidth: 500,
				zoomWindowHeight: 550,
				zoomWindowOffetx: 1,
				zoomWindowOffety: -0.5,
				gallery:'sns_thumbs',
				galleryActiveClass: 'active',
				imageCrossfade: true,
				responsive:true
				
			});
		});
		<?php endif; ?>
		<?php if ( !snssimen_get_option('woo_usecloudzoom') ) : ?>
			jQuery('#sns_thumbs .zoom').bind('touchstart click', function(e) {

				jQuery('#sns_thumbs .zoom').removeClass('active');
				jQuery(this).addClass('active');
				//stop any link on the a tag from working
				e.preventDefault();

				var img_to = jQuery(this).data("zoom-image");
				if ( jQuery('.sns_main_products .sns-btn-popup').length ){
					jQuery('.sns_main_products .sns-btn-popup').attr('href', img_to);
				}

				setTimeout( function() {
					jQuery('#sp_mainimage').attr('src', img_to).attr('srcset', '');
				}, 600);

				return false;
			});
		<?php endif; ?>
	</script>
</div>
