/**
 * This file adds some LIVE to the Theme Customizer live preview. To leverage
 * this, set your custom settings to 'postMessage' and then add your handling
 * here. Your javascript should grab settings from customizer controls, and 
 * then make any necessary changes to the page using jQuery.
 */
( function( $ ) {

	// Main layout style
	wp.customize( 'main_layout_style', function( value ) {
		value.bind( function( newval ) {
			if ( ! newval ) {
				$( 'body' ).addClass( 'full-width' );
			} else {
				$( 'body' ).removeClass( 'full-width-main-layout' ).removeClass( 'boxed-main-layout' );
				$( 'body' ).addClass( newval + '-main-layout' );
				$( 'body' ).removeClass( 'footer-has-reveal' );
			}
		} );
	} );

	// Boxed shadow
	wp.customize( 'boxed_dropdshadow', function( value ) {
		value.bind( function( newval ) {
			if ( false == newval ) {
				$( 'body' ).removeClass( 'wrap-boxshadow' );
			} else {
				$( 'body' ).addClass( 'wrap-boxshadow' );
			}
		} );
	} );

	// Social Sharing
	wp.customize( 'social_share_heading', function( value ) {
		value.bind( function( newval ) {
			$( '.social-share-title span' ).text( newval );
		} );
	} );

	// Breadcrumbs
	wp.customize( 'breadcrumbs_home_title', function( value ) {
		value.bind( function( newval ) {
			$( '.breadcrumb-trail .trail-begin' ).html( newval );
		} );
	} );
	
	// Background color
	wp.customize( 'background_color', function( value ) {
		value.bind( function( newval ) {
			if ( newval ) {
				$( 'body' ).css('background-color', newval );
			} else {
				$( 'body' ).css('background-color', '');
			}
		} );
	} );

	// Styling
	wp.customize("toggle_bar_bg",function(e){e.bind(function(e){if(e){$("#toggle-bar-wrap").css("background-color",e)}else{$("#toggle-bar-wrap").css("background-color","")}})});wp.customize("toggle_bar_color",function(e){e.bind(function(e){if(e){$("#toggle-bar-wrap, #toggle-bar-wrap strong").css("color",e)}else{$("#toggle-bar-wrap, #toggle-bar-wrap strong").css("color","")}})});wp.customize("toggle_bar_btn_color",function(e){e.bind(function(e){if(e){$(".toggle-bar-btn span.fa").css("color",e)}else{$(".toggle-bar-btn span.fa").css("color","")}})});wp.customize("top_bar_bg",function(e){e.bind(function(e){if(e){$("#top-bar-wrap").css("background-color",e)}else{$("#top-bar-wrap").css("background-color","")}})});wp.customize("top_bar_border",function(e){e.bind(function(e){if(e){$("#top-bar-wrap").css("border-color",e)}else{$("#top-bar-wrap").css("border-color","")}})});wp.customize("top_bar_text",function(e){e.bind(function(e){if(e){$("#top-bar-wrap, #top-bar-content strong").css("color",e)}else{$("#top-bar-wrap, #top-bar-content strong").css("color","")}})});wp.customize("top_bar_link_color",function(e){e.bind(function(e){if(e){$("#top-bar-content a, #top-bar-social-alt a").css("color",e)}else{$("#top-bar-content a, #top-bar-social-alt a").css("color","")}})});wp.customize("top_bar_link_color_active",function(e){e.bind(function(e){if(e){$("#top-bar-content a:active, #top-bar-social-alt a:active").css("color",e)}else{$("#top-bar-content a:active, #top-bar-social-alt a:active").css("color","")}})});wp.customize("top_bar_social_color",function(e){e.bind(function(e){if(e){$("#top-bar-social a").css("color",e)}else{$("#top-bar-social a").css("color","")}})});wp.customize("header_background",function(e){e.bind(function(e){if(e){$("#site-header, #searchform-header-replace, .is-sticky #site-header").css("background-color",e)}else{$("#site-header, #searchform-header-replace, .is-sticky #site-header").css("background-color","")}})});wp.customize("logo_color",function(e){e.bind(function(e){if(e){$("#site-logo a").css("color",e)}else{$("#site-logo a").css("color","")}})});wp.customize("logo_icon_color",function(e){e.bind(function(e){if(e){$("#site-logo a .fa").css("color",e)}else{$("#site-logo a .fa").css("color","")}})});wp.customize("search_dropdown_top_border",function(e){e.bind(function(e){if(e){$("#searchform-dropdown").css("border-top-color",e)}else{$("#searchform-dropdown").css("border-top-color","")}})});wp.customize("menu_background",function(e){e.bind(function(e){if(e){$("#site-navigation-wrap, .is-sticky .fixed-nav").css("background-color",e)}else{$("#site-navigation-wrap, .is-sticky .fixed-nav").css("background-color","")}})});wp.customize("menu_borders",function(e){e.bind(function(e){if(e){$("#site-navigation li, #site-navigation a, #site-navigation ul, #site-navigation-wrap").css("border-color",e)}else{$("#site-navigation li, #site-navigation a, #site-navigation ul, #site-navigation-wrap").css("border-color","")}})});wp.customize("menu_link_color",function(e){e.bind(function(e){if(e){$("#site-navigation .dropdown-menu > li > a").css("color",e)}else{$("#site-navigation .dropdown-menu > li > a").css("color","")}})});wp.customize("menu_link_active_background",function(e){e.bind(function(e){if(e){$("#site-navigation .dropdown-menu > .current-menu-item > a").css("background-color",e)}else{$("#site-navigation .dropdown-menu > .current-menu-item > a").css("background-color","")}})});wp.customize("dropdown_menu_background",function(e){e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul").css("background-color",e)}else{$("#site-navigation .dropdown-menu ul").css("background-color","")}})});wp.customize("menu_dropdown_top_border_color",function(e){e.bind(function(e){if(e){$("body #site-navigation-wrap.nav-dropdown-top-border .dropdown-menu > li > ul").css("border-top-color",e)}else{$("body #site-navigation-wrap.nav-dropdown-top-border .dropdown-menu > li > ul").css("border-top-color","")}})});wp.customize("dropdown_menu_borders",function(e){e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul, #site-navigation .dropdown-menu ul li, #site-navigation .dropdown-menu ul li a").css("border-color",e)}else{$("#site-navigation .dropdown-menu ul, #site-navigation .dropdown-menu ul li, #site-navigation .dropdown-menu ul li a").css("border-color","")}})});wp.customize("dropdown_menu_link_color",function(e){e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul > li > a").css("color",e)}else{$("#site-navigation .dropdown-menu ul > li > a").css("color","")}})});wp.customize("dropdown_menu_link_color_active",function(e){e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul > .current-menu-item > a").css("color",e)}else{$("#site-navigation .dropdown-menu ul > .current-menu-item > a").css("color","")}})});wp.customize("mega_menu_title",function(e){e.bind(function(e){if(e){$(".sf-menu > li.megamenu > ul.sub-menu > .menu-item-has-children > a").css("color",e)}else{$(".sf-menu > li.megamenu > ul.sub-menu > .menu-item-has-children > a").css("color","")}})});wp.customize("mobile_menu_icon_color",function(e){e.bind(function(e){if(e){$("#mobile-menu a").css("color",e)}else{$("#mobile-menu a").css("color","")}})});wp.customize("mobile_menu_icon_background",function(e){e.bind(function(e){if(e){$("#mobile-menu a").css("background-color",e)}else{$("#mobile-menu a").css("background-color","")}})});wp.customize("mobile_menu_icon_background_active",function(e){e.bind(function(e){if(e){$("#mobile-menu a:active").css("background-color",e)}else{$("#mobile-menu a:active").css("background-color","")}})});wp.customize("mobile_menu_icon_border",function(e){e.bind(function(e){if(e){$("#mobile-menu a").css("border-color",e)}else{$("#mobile-menu a").css("border-color","")}})});wp.customize("mobile_menu_icon_border_active",function(e){e.bind(function(e){if(e){$("#mobile-menu a:active").css("border-color",e)}else{$("#mobile-menu a:active").css("border-color","")}})});wp.customize("mobile_menu_sidr_background",function(e){e.bind(function(e){if(e){$("#sidr-main, .mobile-toggle-nav").css("background-color",e)}else{$("#sidr-main, .mobile-toggle-nav").css("background-color","")}})});wp.customize("mobile_menu_sidr_borders",function(e){e.bind(function(e){if(e){$("#sidr-main li, #sidr-main ul,.mobile-toggle-nav a").css("border-color",e)}else{$("#sidr-main li, #sidr-main ul,.mobile-toggle-nav a").css("border-color","")}})});wp.customize("mobile_menu_links",function(e){e.bind(function(e){if(e){$("#sidr-main li a, .sidr-class-dropdown-toggle, .mobile-toggle-nav a").css("color",e)}else{$("#sidr-main li a, .sidr-class-dropdown-toggle, .mobile-toggle-nav a").css("color","")}})});wp.customize("mobile_menu_links_active",function(e){e.bind(function(e){if(e){$("#sidr-main li a:active, .sidr-class-dropdown-toggle.active, .mobile-toggle-nav a:active").css("color",e)}else{$("#sidr-main li a:active, .sidr-class-dropdown-toggle.active, .mobile-toggle-nav a:active").css("color","")}})});wp.customize("mobile_menu_sidr_search_color",function(e){e.bind(function(e){if(e){$(".sidr-class-mobile-menu-searchform input").css("color",e)}else{$(".sidr-class-mobile-menu-searchform input").css("color","")}})});wp.customize("mobile_menu_sidr_search_bg",function(e){e.bind(function(e){if(e){$(".sidr-class-mobile-menu-searchform input").css("background-color",e)}else{$(".sidr-class-mobile-menu-searchform input").css("background-color","")}})});wp.customize("footer_background",function(e){e.bind(function(e){if(e){$("#footer").css("background-color",e)}else{$("#footer").css("background-color","")}})});wp.customize("footer_color",function(e){e.bind(function(e){if(e){$("#footer, #footer p, #footer li a:before").css("color",e)}else{$("#footer, #footer p, #footer li a:before").css("color","")}})});wp.customize("footer_borders",function(e){e.bind(function(e){if(e){$("#footer li, #footer #wp-calendar thead th, #footer #wp-calendar tbody td").css("border-color",e)}else{$("#footer li, #footer #wp-calendar thead th, #footer #wp-calendar tbody td").css("border-color","")}})});wp.customize("footer_link_color",function(e){e.bind(function(e){if(e){$("#footer a").css("color",e)}else{$("#footer a").css("color","")}})});wp.customize("footer_link_color_active",function(e){e.bind(function(e){if(e){$("#footer a:active").css("color",e)}else{$("#footer a:active").css("color","")}})});wp.customize("bottom_footer_background",function(e){e.bind(function(e){if(e){$("#footer-bottom").css("background-color",e)}else{$("#footer-bottom").css("background-color","")}})});wp.customize("bottom_footer_color",function(e){e.bind(function(e){if(e){$("#footer-bottom, #footer-bottom p").css("color",e)}else{$("#footer-bottom, #footer-bottom p").css("color","")}})});wp.customize("bottom_footer_link_color",function(e){e.bind(function(e){if(e){$("#footer-bottom a").css("color",e)}else{$("#footer-bottom a").css("color","")}})});wp.customize("bottom_footer_link_color_active",function(e){e.bind(function(e){if(e){$("#footer-bottom a:active").css("color",e)}else{$("#footer-bottom a:active").css("color","")}})});wp.customize("scroll_top_bg",function(e){e.bind(function(e){if(e){$("#site-scroll-top").css("background-color",e)}else{$("#site-scroll-top").css("background-color","")}})});wp.customize("scroll_top_bg_active",function(e){e.bind(function(e){if(e){$("#site-scroll-top:active").css("background-color",e)}else{$("#site-scroll-top:active").css("background-color","")}})});wp.customize("scroll_top_border",function(e){e.bind(function(e){if(e){$("#site-scroll-top").css("border-color",e)}else{$("#site-scroll-top").css("border-color","")}})});wp.customize("scroll_top_border_active",function(e){e.bind(function(e){if(e){$("#site-scroll-top:active").css("border-color",e)}else{$("#site-scroll-top:active").css("border-color","")}})});wp.customize("scroll_top_color",function(e){e.bind(function(e){if(e){$("#site-scroll-top").css("color",e)}else{$("#site-scroll-top").css("color","")}})});wp.customize("scroll_top_color_active",function(e){e.bind(function(e){if(e){$("#site-scroll-top:active").css("color",e)}else{$("#site-scroll-top:active").css("color","")}})});wp.customize("footer_callout_bg",function(e){e.bind(function(e){if(e){$("#footer-callout-wrap").css("background-color",e)}else{$("#footer-callout-wrap").css("background-color","")}})});wp.customize("footer_callout_border",function(e){e.bind(function(e){if(e){$("#footer-callout-wrap").css("border-color",e)}else{$("#footer-callout-wrap").css("border-color","")}})});wp.customize("footer_callout_color",function(e){e.bind(function(e){if(e){$("#footer-callout-wrap").css("color",e)}else{$("#footer-callout-wrap").css("color","")}})});wp.customize("footer_callout_link_color",function(e){e.bind(function(e){if(e){$(".footer-callout-content a").css("color",e)}else{$(".footer-callout-content a").css("color","")}})});wp.customize("footer_callout_link_active",function(e){e.bind(function(e){if(e){$(".footer-callout-content a:active").css("color",e)}else{$(".footer-callout-content a:active").css("color","")}})});wp.customize("footer_callout_button_bg",function(e){e.bind(function(e){if(e){$("#footer-callout .theme-button").css("background-color",e)}else{$("#footer-callout .theme-button").css("background-color","")}})});wp.customize("footer_callout_button_color",function(e){e.bind(function(e){if(e){$("#footer-callout .theme-button").css("color",e)}else{$("#footer-callout .theme-button").css("color","")}})});wp.customize("sidebar_background",function(e){e.bind(function(e){if(e){$("#sidebar").css("background-color",e)}else{$("#sidebar").css("background-color","")}})});wp.customize("sidebar_headings_color",function(e){e.bind(function(e){if(e){$("#sidebar .widget-title, #sidebar .widget-title a").css("color",e)}else{$("#sidebar .widget-title, #sidebar .widget-title a").css("color","")}})});wp.customize("sidebar_text_color",function(e){e.bind(function(e){if(e){$("#sidebar, #sidebar p").css("color",e)}else{$("#sidebar, #sidebar p").css("color","")}})});wp.customize("sidebar_borders_color",function(e){e.bind(function(e){if(e){$("#sidebar li, #sidebar #wp-calendar thead th, #sidebar #wp-calendar tbody td").css("border-color",e)}else{$("#sidebar li, #sidebar #wp-calendar thead th, #sidebar #wp-calendar tbody td").css("border-color","")}})});wp.customize("sidebar_link_color",function(e){e.bind(function(e){if(e){$("#sidebar a").css("color",e)}else{$("#sidebar a").css("color","")}})});wp.customize("sidebar_link_color_active",function(e){e.bind(function(e){if(e){$("#sidebar a:active").css("color",e)}else{$("#sidebar a:active").css("color","")}})});wp.customize("page_header_background",function(e){e.bind(function(e){if(e){$(".page-header").css("background-color",e)}else{$(".page-header").css("background-color","")}})});wp.customize("page_header_title_color",function(e){e.bind(function(e){if(e){$(".page-header-title").css("color",e)}else{$(".page-header-title").css("color","")}})});wp.customize("page_header_top_border",function(e){e.bind(function(e){if(e){$(".page-header, .theme-gaps .page-header-inner").css("border-top-color",e)}else{$(".page-header, .theme-gaps .page-header-inner").css("border-top-color","")}})});wp.customize("page_header_bottom_border",function(e){e.bind(function(e){if(e){$(".page-header, .theme-gaps .page-header-inner").css("border-bottom-color",e)}else{$(".page-header, .theme-gaps .page-header-inner").css("border-bottom-color","")}})});wp.customize("breadcrumbs_text_color",function(e){e.bind(function(e){if(e){$(".site-breadcrumbs").css("color",e)}else{$(".site-breadcrumbs").css("color","")}})});wp.customize("breadcrumbs_seperator_color",function(e){e.bind(function(e){if(e){$(".site-breadcrumbs .sep").css("color",e)}else{$(".site-breadcrumbs .sep").css("color","")}})});wp.customize("breadcrumbs_link_color",function(e){e.bind(function(e){if(e){$(".site-breadcrumbs a").css("color",e)}else{$(".site-breadcrumbs a").css("color","")}})});wp.customize("breadcrumbs_link_color_active",function(e){e.bind(function(e){if(e){$(".site-breadcrumbs a:active").css("color",e)}else{$(".site-breadcrumbs a:active").css("color","")}})});wp.customize("link_color",function(e){e.bind(function(e){if(e){$("a, h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover").css("color",e)}else{$("a, h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover").css("color","")}})});wp.customize("link_color_hover",function(e){e.bind(function(e){if(e){$("a:hover").css("color",e)}else{$("a:hover").css("color","")}})});wp.customize("link_color_active",function(e){e.bind(function(e){if(e){$("a:active").css("color",e)}else{$("a:active").css("color","")}})});wp.customize("theme_button_bg",function(e){e.bind(function(e){if(e){$('.edit-post-link a, #commentform #submit,.wpcf7 .wpcf7-submit,.theme-minimal-graphical #comments .comment-reply-link,.theme-button, .readmore-link,#current-shop-items .buttons a,.woocommerce .button,input[type="submit"],button').css("background-color",e)}else{$('.edit-post-link a, #commentform #submit,.wpcf7 .wpcf7-submit,.theme-minimal-graphical #comments .comment-reply-link,.theme-button, .readmore-link,#current-shop-items .buttons a,.woocommerce .button,input[type="submit"],button').css("background-color","")}})});wp.customize("theme_button_color",function(e){e.bind(function(e){if(e){$('.edit-post-link a, #commentform #submit,.wpcf7 .wpcf7-submit,.theme-minimal-graphical #comments .comment-reply-link,.theme-button, .readmore-link,#current-shop-items .buttons a,.woocommerce .button,,input[type="submit"],button').css("color",e)}else{$('.edit-post-link a, #commentform #submit,.wpcf7 .wpcf7-submit,.theme-minimal-graphical #comments .comment-reply-link,.theme-button, .readmore-link,#current-shop-items .buttons a,.woocommerce .button,,input[type="submit"],button').css("color","")}})});wp.customize("onsale_bg",function(e){e.bind(function(e){if(e){$("ul.products li.product .onsale, .single-product .onsale").css("background-color",e)}else{$("ul.products li.product .onsale, .single-product .onsale").css("background-color","")}})});wp.customize("onsale_color",function(e){e.bind(function(e){if(e){$("ul.products li.product .onsale, .single-product .onsale").css("color",e)}else{$("ul.products li.product .onsale, .single-product .onsale").css("color","")}})});wp.customize("woo_product_title_link_color",function(e){e.bind(function(e){if(e){$(".product-entry-title a").css("color",e)}else{$(".product-entry-title a").css("color","")}})});wp.customize("woo_product_title_link_color_hover",function(e){e.bind(function(e){if(e){$(".product-entry-title a:hover").css("color",e)}else{$(".product-entry-title a:hover").css("color","")}})});wp.customize("woo_product_entry_price_color",function(e){e.bind(function(e){if(e){$(".product-entry .amount").css("color",e)}else{$(".product-entry .amount").css("color","")}})});wp.customize("woo_single_price_color",function(e){e.bind(function(e){if(e){$("div.product p.price").css("color",e)}else{$("div.product p.price").css("color","")}})});wp.customize("woo_stars_color",function(e){e.bind(function(e){if(e){$(".star-rating span").css("color",e)}else{$(".star-rating span").css("color","")}})});wp.customize("woo_single_tabs_active_border_color",function(e){e.bind(function(e){if(e){$("div.product .woocommerce-tabs ul.tabs li.active a").css("border-color",e)}else{$("div.product .woocommerce-tabs ul.tabs li.active a").css("border-color","")}})});wp.customize("vcex_text_separator_two_border_color",function(e){e.bind(function(e){if(e){$("body .vc_text_separator_two span").css("border-color",e)}else{$("body .vc_text_separator_two span").css("border-color","")}})});wp.customize("vcex_text_tab_two_bottom_border",function(e){e.bind(function(e){if(e){$("body .wpb_tabs.tab-style-alternative-two .wpb_tabs_nav li.ui-tabs-active a").css("border-color",e)}else{$("body .wpb_tabs.tab-style-alternative-two .wpb_tabs_nav li.ui-tabs-active a").css("border-color","")}})});wp.customize("vcex_pricing_featured_default",function(e){e.bind(function(e){if(e){$(".vcex-pricing.featured .vcex-pricing-header h5").css("background-color",e)}else{$(".vcex-pricing.featured .vcex-pricing-header h5").css("background-color","")}})});wp.customize("vcex_grid_filter_active_color",function(e){e.bind(function(e){if(e){$(".vcex-pricing.featured .vcex-pricing-header h5").css("background-color",e)}else{$(".vcex-pricing.featured .vcex-pricing-header h5").css("background-color","")}})});wp.customize("vcex_recent_news_date_bg",function(e){e.bind(function(e){if(e){$(".vcex-recent-news-date span.month").css("background-color",e)}else{$(".vcex-recent-news-date span.month").css("background-color","")}})});wp.customize("vcex_recent_news_date_color",function(e){e.bind(function(e){if(e){$(".vcex-recent-news-date span.month").css("color",e)}else{$(".vcex-recent-news-date span.month").css("color","")}})})

	// Typography
	wp.customize("body_typography[font-weight]",function(e){$currentVal=$("body").css("font-weight");e.bind(function(e){if(e){$("body").css("font-weight",e)}else{$("body").css("font-weight","")}})});wp.customize("body_typography[font-style]",function(e){$currentVal=$("body").css("font-style");e.bind(function(e){if(e){$("body").css("font-style",e)}else{$("body").css("font-style","")}})});wp.customize("body_typography[font-size]",function(e){$currentVal=$("body").css("font-size");e.bind(function(e){if(e){$("body").css("font-size",parseInt(e,10)+"px")}else{$("body").css("font-size","")}})});wp.customize("body_typography[color]",function(e){$currentVal=$("body").css("color");e.bind(function(e){if(e){$("body").css("color",e)}else{$("body").css("color","")}})});wp.customize("body_typography[line-height]",function(e){$currentVal=$("body").css("line-height");e.bind(function(e){if(e){$("body").css("line-height",e)}else{$("body").css("line-height","")}})});wp.customize("body_typography[letter-spacing]",function(e){$currentVal=$("body").css("letter-spacing");e.bind(function(e){if(e){$("body").css("letter-spacing",parseInt(e,10)+"px")}else{$("body").css("letter-spacing","")}})});wp.customize("body_typography[text-transform]",function(e){$currentVal=$("body").css("text-transform");e.bind(function(e){if(e){$("body").css("text-transform",e)}else{$("body").css("text-transform","")}})});wp.customize("logo_typography[font-weight]",function(e){$currentVal=$("#site-logo a").css("font-weight");e.bind(function(e){if(e){$("#site-logo a").css("font-weight",e)}else{$("#site-logo a").css("font-weight","")}})});wp.customize("logo_typography[font-style]",function(e){$currentVal=$("#site-logo a").css("font-style");e.bind(function(e){if(e){$("#site-logo a").css("font-style",e)}else{$("#site-logo a").css("font-style","")}})});wp.customize("logo_typography[font-size]",function(e){$currentVal=$("#site-logo a").css("font-size");e.bind(function(e){if(e){$("#site-logo a").css("font-size",parseInt(e,10)+"px")}else{$("#site-logo a").css("font-size","")}})});wp.customize("logo_typography[color]",function(e){$currentVal=$("#site-logo a").css("color");e.bind(function(e){if(e){$("#site-logo a").css("color",e)}else{$("#site-logo a").css("color","")}})});wp.customize("logo_typography[line-height]",function(e){$currentVal=$("#site-logo a").css("line-height");e.bind(function(e){if(e){$("#site-logo a").css("line-height",e)}else{$("#site-logo a").css("line-height","")}})});wp.customize("logo_typography[letter-spacing]",function(e){$currentVal=$("#site-logo a").css("letter-spacing");e.bind(function(e){if(e){$("#site-logo a").css("letter-spacing",parseInt(e,10)+"px")}else{$("#site-logo a").css("letter-spacing","")}})});wp.customize("logo_typography[text-transform]",function(e){$currentVal=$("#site-logo a").css("text-transform");e.bind(function(e){if(e){$("#site-logo a").css("text-transform",e)}else{$("#site-logo a").css("text-transform","")}})});wp.customize("top_menu_typography[font-weight]",function(e){$currentVal=$("#top-bar-content").css("font-weight");e.bind(function(e){if(e){$("#top-bar-content").css("font-weight",e)}else{$("#top-bar-content").css("font-weight","")}})});wp.customize("top_menu_typography[font-style]",function(e){$currentVal=$("#top-bar-content").css("font-style");e.bind(function(e){if(e){$("#top-bar-content").css("font-style",e)}else{$("#top-bar-content").css("font-style","")}})});wp.customize("top_menu_typography[font-size]",function(e){$currentVal=$("#top-bar-content").css("font-size");e.bind(function(e){if(e){$("#top-bar-content").css("font-size",parseInt(e,10)+"px")}else{$("#top-bar-content").css("font-size","")}})});wp.customize("top_menu_typography[color]",function(e){$currentVal=$("#top-bar-content").css("color");e.bind(function(e){if(e){$("#top-bar-content").css("color",e)}else{$("#top-bar-content").css("color","")}})});wp.customize("top_menu_typography[line-height]",function(e){$currentVal=$("#top-bar-content").css("line-height");e.bind(function(e){if(e){$("#top-bar-content").css("line-height",e)}else{$("#top-bar-content").css("line-height","")}})});wp.customize("top_menu_typography[letter-spacing]",function(e){$currentVal=$("#top-bar-content").css("letter-spacing");e.bind(function(e){if(e){$("#top-bar-content").css("letter-spacing",parseInt(e,10)+"px")}else{$("#top-bar-content").css("letter-spacing","")}})});wp.customize("top_menu_typography[text-transform]",function(e){$currentVal=$("#top-bar-content").css("text-transform");e.bind(function(e){if(e){$("#top-bar-content").css("text-transform",e)}else{$("#top-bar-content").css("text-transform","")}})});wp.customize("menu_typography[font-weight]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("font-weight");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("font-weight",e)}else{$("#site-navigation .dropdown-menu a").css("font-weight","")}})});wp.customize("menu_typography[font-style]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("font-style");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("font-style",e)}else{$("#site-navigation .dropdown-menu a").css("font-style","")}})});wp.customize("menu_typography[font-size]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("font-size");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("font-size",parseInt(e,10)+"px")}else{$("#site-navigation .dropdown-menu a").css("font-size","")}})});wp.customize("menu_typography[color]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("color");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("color",e)}else{$("#site-navigation .dropdown-menu a").css("color","")}})});wp.customize("menu_typography[line-height]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("line-height");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("line-height",e)}else{$("#site-navigation .dropdown-menu a").css("line-height","")}})});wp.customize("menu_typography[letter-spacing]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("letter-spacing");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("letter-spacing",parseInt(e,10)+"px")}else{$("#site-navigation .dropdown-menu a").css("letter-spacing","")}})});wp.customize("menu_typography[text-transform]",function(e){$currentVal=$("#site-navigation .dropdown-menu a").css("text-transform");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu a").css("text-transform",e)}else{$("#site-navigation .dropdown-menu a").css("text-transform","")}})});wp.customize("menu_dropdown_typography[font-weight]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("font-weight");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("font-weight",e)}else{$("#site-navigation .dropdown-menu ul a").css("font-weight","")}})});wp.customize("menu_dropdown_typography[font-style]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("font-style");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("font-style",e)}else{$("#site-navigation .dropdown-menu ul a").css("font-style","")}})});wp.customize("menu_dropdown_typography[font-size]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("font-size");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("font-size",parseInt(e,10)+"px")}else{$("#site-navigation .dropdown-menu ul a").css("font-size","")}})});wp.customize("menu_dropdown_typography[color]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("color");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("color",e)}else{$("#site-navigation .dropdown-menu ul a").css("color","")}})});wp.customize("menu_dropdown_typography[line-height]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("line-height");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("line-height",e)}else{$("#site-navigation .dropdown-menu ul a").css("line-height","")}})});wp.customize("menu_dropdown_typography[letter-spacing]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("letter-spacing");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("letter-spacing",parseInt(e,10)+"px")}else{$("#site-navigation .dropdown-menu ul a").css("letter-spacing","")}})});wp.customize("menu_dropdown_typography[text-transform]",function(e){$currentVal=$("#site-navigation .dropdown-menu ul a").css("text-transform");e.bind(function(e){if(e){$("#site-navigation .dropdown-menu ul a").css("text-transform",e)}else{$("#site-navigation .dropdown-menu ul a").css("text-transform","")}})});wp.customize("page_title_typography[font-weight]",function(e){$currentVal=$(".page-header-title").css("font-weight");e.bind(function(e){if(e){$(".page-header-title").css("font-weight",e)}else{$(".page-header-title").css("font-weight","")}})});wp.customize("page_title_typography[font-style]",function(e){$currentVal=$(".page-header-title").css("font-style");e.bind(function(e){if(e){$(".page-header-title").css("font-style",e)}else{$(".page-header-title").css("font-style","")}})});wp.customize("page_title_typography[font-size]",function(e){$currentVal=$(".page-header-title").css("font-size");e.bind(function(e){if(e){$(".page-header-title").css("font-size",parseInt(e,10)+"px")}else{$(".page-header-title").css("font-size","")}})});wp.customize("page_title_typography[color]",function(e){$currentVal=$(".page-header-title").css("color");e.bind(function(e){if(e){$(".page-header-title").css("color",e)}else{$(".page-header-title").css("color","")}})});wp.customize("page_title_typography[line-height]",function(e){$currentVal=$(".page-header-title").css("line-height");e.bind(function(e){if(e){$(".page-header-title").css("line-height",e)}else{$(".page-header-title").css("line-height","")}})});wp.customize("page_title_typography[letter-spacing]",function(e){$currentVal=$(".page-header-title").css("letter-spacing");e.bind(function(e){if(e){$(".page-header-title").css("letter-spacing",parseInt(e,10)+"px")}else{$(".page-header-title").css("letter-spacing","")}})});wp.customize("page_title_typography[text-transform]",function(e){$currentVal=$(".page-header-title").css("text-transform");e.bind(function(e){if(e){$(".page-header-title").css("text-transform",e)}else{$(".page-header-title").css("text-transform","")}})});wp.customize("breadcrumbs_typography[font-weight]",function(e){$currentVal=$(".site-breadcrumbs").css("font-weight");e.bind(function(e){if(e){$(".site-breadcrumbs").css("font-weight",e)}else{$(".site-breadcrumbs").css("font-weight","")}})});wp.customize("breadcrumbs_typography[font-style]",function(e){$currentVal=$(".site-breadcrumbs").css("font-style");e.bind(function(e){if(e){$(".site-breadcrumbs").css("font-style",e)}else{$(".site-breadcrumbs").css("font-style","")}})});wp.customize("breadcrumbs_typography[font-size]",function(e){$currentVal=$(".site-breadcrumbs").css("font-size");e.bind(function(e){if(e){$(".site-breadcrumbs").css("font-size",parseInt(e,10)+"px")}else{$(".site-breadcrumbs").css("font-size","")}})});wp.customize("breadcrumbs_typography[color]",function(e){$currentVal=$(".site-breadcrumbs").css("color");e.bind(function(e){if(e){$(".site-breadcrumbs").css("color",e)}else{$(".site-breadcrumbs").css("color","")}})});wp.customize("breadcrumbs_typography[line-height]",function(e){$currentVal=$(".site-breadcrumbs").css("line-height");e.bind(function(e){if(e){$(".site-breadcrumbs").css("line-height",e)}else{$(".site-breadcrumbs").css("line-height","")}})});wp.customize("breadcrumbs_typography[letter-spacing]",function(e){$currentVal=$(".site-breadcrumbs").css("letter-spacing");e.bind(function(e){if(e){$(".site-breadcrumbs").css("letter-spacing",parseInt(e,10)+"px")}else{$(".site-breadcrumbs").css("letter-spacing","")}})});wp.customize("breadcrumbs_typography[text-transform]",function(e){$currentVal=$(".site-breadcrumbs").css("text-transform");e.bind(function(e){if(e){$(".site-breadcrumbs").css("text-transform",e)}else{$(".site-breadcrumbs").css("text-transform","")}})});wp.customize("headings_typography[font-weight]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-weight");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-weight",e)}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-weight","")}})});wp.customize("headings_typography[font-style]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-style");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-style",e)}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-style","")}})});wp.customize("headings_typography[font-size]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-size");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-size",parseInt(e,10)+"px")}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("font-size","")}})});wp.customize("headings_typography[color]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("color");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("color",e)}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("color","")}})});wp.customize("headings_typography[line-height]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("line-height");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("line-height",e)}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("line-height","")}})});wp.customize("headings_typography[letter-spacing]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("letter-spacing");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("letter-spacing",parseInt(e,10)+"px")}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("letter-spacing","")}})});wp.customize("headings_typography[text-transform]",function(e){$currentVal=$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("text-transform");e.bind(function(e){if(e){$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("text-transform",e)}else{$("h1,h2,h3,h4,h5,h6,.theme-heading,.heading-typography,.widget-title,.wpex-widget-recent-posts-title,.comment-reply-title").css("text-transform","")}})});wp.customize("sidebar_widget_title_typography[font-weight]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("font-weight");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("font-weight",e)}else{$(".sidebar-widget .widget-title").css("font-weight","")}})});wp.customize("sidebar_widget_title_typography[font-style]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("font-style");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("font-style",e)}else{$(".sidebar-widget .widget-title").css("font-style","")}})});wp.customize("sidebar_widget_title_typography[font-size]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("font-size");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("font-size",parseInt(e,10)+"px")}else{$(".sidebar-widget .widget-title").css("font-size","")}})});wp.customize("sidebar_widget_title_typography[color]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("color");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("color",e)}else{$(".sidebar-widget .widget-title").css("color","")}})});wp.customize("sidebar_widget_title_typography[line-height]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("line-height");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("line-height",e)}else{$(".sidebar-widget .widget-title").css("line-height","")}})});wp.customize("sidebar_widget_title_typography[letter-spacing]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("letter-spacing");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("letter-spacing",parseInt(e,10)+"px")}else{$(".sidebar-widget .widget-title").css("letter-spacing","")}})});wp.customize("sidebar_widget_title_typography[text-transform]",function(e){$currentVal=$(".sidebar-widget .widget-title").css("text-transform");e.bind(function(e){if(e){$(".sidebar-widget .widget-title").css("text-transform",e)}else{$(".sidebar-widget .widget-title").css("text-transform","")}})});wp.customize("entry_h2_typography[font-weight]",function(e){$currentVal=$(".entry h2").css("font-weight");e.bind(function(e){if(e){$(".entry h2").css("font-weight",e)}else{$(".entry h2").css("font-weight","")}})});wp.customize("entry_h2_typography[font-style]",function(e){$currentVal=$(".entry h2").css("font-style");e.bind(function(e){if(e){$(".entry h2").css("font-style",e)}else{$(".entry h2").css("font-style","")}})});wp.customize("entry_h2_typography[font-size]",function(e){$currentVal=$(".entry h2").css("font-size");e.bind(function(e){if(e){$(".entry h2").css("font-size",parseInt(e,10)+"px")}else{$(".entry h2").css("font-size","")}})});wp.customize("entry_h2_typography[color]",function(e){$currentVal=$(".entry h2").css("color");e.bind(function(e){if(e){$(".entry h2").css("color",e)}else{$(".entry h2").css("color","")}})});wp.customize("entry_h2_typography[line-height]",function(e){$currentVal=$(".entry h2").css("line-height");e.bind(function(e){if(e){$(".entry h2").css("line-height",e)}else{$(".entry h2").css("line-height","")}})});wp.customize("entry_h2_typography[letter-spacing]",function(e){$currentVal=$(".entry h2").css("letter-spacing");e.bind(function(e){if(e){$(".entry h2").css("letter-spacing",parseInt(e,10)+"px")}else{$(".entry h2").css("letter-spacing","")}})});wp.customize("entry_h2_typography[text-transform]",function(e){$currentVal=$(".entry h2").css("text-transform");e.bind(function(e){if(e){$(".entry h2").css("text-transform",e)}else{$(".entry h2").css("text-transform","")}})});wp.customize("entry_h3_typography[font-weight]",function(e){$currentVal=$(".entry h3").css("font-weight");e.bind(function(e){if(e){$(".entry h3").css("font-weight",e)}else{$(".entry h3").css("font-weight","")}})});wp.customize("entry_h3_typography[font-style]",function(e){$currentVal=$(".entry h3").css("font-style");e.bind(function(e){if(e){$(".entry h3").css("font-style",e)}else{$(".entry h3").css("font-style","")}})});wp.customize("entry_h3_typography[font-size]",function(e){$currentVal=$(".entry h3").css("font-size");e.bind(function(e){if(e){$(".entry h3").css("font-size",parseInt(e,10)+"px")}else{$(".entry h3").css("font-size","")}})});wp.customize("entry_h3_typography[color]",function(e){$currentVal=$(".entry h3").css("color");e.bind(function(e){if(e){$(".entry h3").css("color",e)}else{$(".entry h3").css("color","")}})});wp.customize("entry_h3_typography[line-height]",function(e){$currentVal=$(".entry h3").css("line-height");e.bind(function(e){if(e){$(".entry h3").css("line-height",e)}else{$(".entry h3").css("line-height","")}})});wp.customize("entry_h3_typography[letter-spacing]",function(e){$currentVal=$(".entry h3").css("letter-spacing");e.bind(function(e){if(e){$(".entry h3").css("letter-spacing",parseInt(e,10)+"px")}else{$(".entry h3").css("letter-spacing","")}})});wp.customize("entry_h3_typography[text-transform]",function(e){$currentVal=$(".entry h3").css("text-transform");e.bind(function(e){if(e){$(".entry h3").css("text-transform",e)}else{$(".entry h3").css("text-transform","")}})});wp.customize("footer_widget_title_typography[font-weight]",function(e){$currentVal=$(".footer-widget .widget-title").css("font-weight");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("font-weight",e)}else{$(".footer-widget .widget-title").css("font-weight","")}})});wp.customize("footer_widget_title_typography[font-style]",function(e){$currentVal=$(".footer-widget .widget-title").css("font-style");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("font-style",e)}else{$(".footer-widget .widget-title").css("font-style","")}})});wp.customize("footer_widget_title_typography[font-size]",function(e){$currentVal=$(".footer-widget .widget-title").css("font-size");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("font-size",parseInt(e,10)+"px")}else{$(".footer-widget .widget-title").css("font-size","")}})});wp.customize("footer_widget_title_typography[color]",function(e){$currentVal=$(".footer-widget .widget-title").css("color");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("color",e)}else{$(".footer-widget .widget-title").css("color","")}})});wp.customize("footer_widget_title_typography[line-height]",function(e){$currentVal=$(".footer-widget .widget-title").css("line-height");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("line-height",e)}else{$(".footer-widget .widget-title").css("line-height","")}})});wp.customize("footer_widget_title_typography[letter-spacing]",function(e){$currentVal=$(".footer-widget .widget-title").css("letter-spacing");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("letter-spacing",parseInt(e,10)+"px")}else{$(".footer-widget .widget-title").css("letter-spacing","")}})});wp.customize("footer_widget_title_typography[text-transform]",function(e){$currentVal=$(".footer-widget .widget-title").css("text-transform");e.bind(function(e){if(e){$(".footer-widget .widget-title").css("text-transform",e)}else{$(".footer-widget .widget-title").css("text-transform","")}})});wp.customize("copyright_typography[font-weight]",function(e){$currentVal=$("#copyright").css("font-weight");e.bind(function(e){if(e){$("#copyright").css("font-weight",e)}else{$("#copyright").css("font-weight","")}})});wp.customize("copyright_typography[font-style]",function(e){$currentVal=$("#copyright").css("font-style");e.bind(function(e){if(e){$("#copyright").css("font-style",e)}else{$("#copyright").css("font-style","")}})});wp.customize("copyright_typography[font-size]",function(e){$currentVal=$("#copyright").css("font-size");e.bind(function(e){if(e){$("#copyright").css("font-size",parseInt(e,10)+"px")}else{$("#copyright").css("font-size","")}})});wp.customize("copyright_typography[color]",function(e){$currentVal=$("#copyright").css("color");e.bind(function(e){if(e){$("#copyright").css("color",e)}else{$("#copyright").css("color","")}})});wp.customize("copyright_typography[line-height]",function(e){$currentVal=$("#copyright").css("line-height");e.bind(function(e){if(e){$("#copyright").css("line-height",e)}else{$("#copyright").css("line-height","")}})});wp.customize("copyright_typography[letter-spacing]",function(e){$currentVal=$("#copyright").css("letter-spacing");e.bind(function(e){if(e){$("#copyright").css("letter-spacing",parseInt(e,10)+"px")}else{$("#copyright").css("letter-spacing","")}})});wp.customize("copyright_typography[text-transform]",function(e){$currentVal=$("#copyright").css("text-transform");e.bind(function(e){if(e){$("#copyright").css("text-transform",e)}else{$("#copyright").css("text-transform","")}})});wp.customize("footer_menu_typography[font-weight]",function(e){$currentVal=$("#footer-bottom-menu").css("font-weight");e.bind(function(e){if(e){$("#footer-bottom-menu").css("font-weight",e)}else{$("#footer-bottom-menu").css("font-weight","")}})});wp.customize("footer_menu_typography[font-style]",function(e){$currentVal=$("#footer-bottom-menu").css("font-style");e.bind(function(e){if(e){$("#footer-bottom-menu").css("font-style",e)}else{$("#footer-bottom-menu").css("font-style","")}})});wp.customize("footer_menu_typography[font-size]",function(e){$currentVal=$("#footer-bottom-menu").css("font-size");e.bind(function(e){if(e){$("#footer-bottom-menu").css("font-size",parseInt(e,10)+"px")}else{$("#footer-bottom-menu").css("font-size","")}})});wp.customize("footer_menu_typography[color]",function(e){$currentVal=$("#footer-bottom-menu").css("color");e.bind(function(e){if(e){$("#footer-bottom-menu").css("color",e)}else{$("#footer-bottom-menu").css("color","")}})});wp.customize("footer_menu_typography[line-height]",function(e){$currentVal=$("#footer-bottom-menu").css("line-height");e.bind(function(e){if(e){$("#footer-bottom-menu").css("line-height",e)}else{$("#footer-bottom-menu").css("line-height","")}})});wp.customize("footer_menu_typography[letter-spacing]",function(e){$currentVal=$("#footer-bottom-menu").css("letter-spacing");e.bind(function(e){if(e){$("#footer-bottom-menu").css("letter-spacing",parseInt(e,10)+"px")}else{$("#footer-bottom-menu").css("letter-spacing","")}})});wp.customize("footer_menu_typography[text-transform]",function(e){$currentVal=$("#footer-bottom-menu").css("text-transform");e.bind(function(e){if(e){$("#footer-bottom-menu").css("text-transform",e)}else{$("#footer-bottom-menu").css("text-transform","")}})});

} )( jQuery );