/**
 * $.include - script inclusion jQuery plugin
 * Based on idea from http://www.gnucitizen.org/projects/jquery-include/
 * @author Tobiasz Cudnik
 * @link http://meta20.net/.include_script_inclusion_jQuery_plugin
 * @license MIT
 */
// overload jquery's onDomReady
if ( jQuery.browser.mozilla || jQuery.browser.opera ) {
	document.removeEventListener( "DOMContentLoaded", jQuery.ready, false );
	document.addEventListener( "DOMContentLoaded", function(){ jQuery.ready(); }, false );
}
jQuery.event.remove( window, "load", jQuery.ready );
jQuery.event.add( window, "load", function(){ jQuery.ready(); } );
jQuery.extend({
	includeStates: {},
	include: function(url, callback, dependency){
		if ( typeof callback != 'function' && ! dependency ) {
			dependency = callback;
			callback = null;
		}
		url = url.replace('\n', '');
		jQuery.includeStates[url] = false;
		var script = document.createElement('script');
		script.type = 'text/javascript';
		script.onload = function () {
			jQuery.includeStates[url] = true;
			if ( callback )
				callback.call(script);
		};
		script.onreadystatechange = function () {
			if ( this.readyState != "complete" && this.readyState != "loaded" ) return;
			jQuery.includeStates[url] = true;
			if ( callback )
				callback.call(script);
		};
		script.src = url;
		if ( dependency ) {
			if ( dependency.constructor != Array )
				dependency = [dependency];
			setTimeout(function(){
				var valid = true;
				$.each(dependency, function(k, v){
					if (! v() ) {
						valid = false;
						return false;
					}
				})
				if ( valid )
					document.getElementsByTagName('head')[0].appendChild(script);
				else
					setTimeout(arguments.callee, 10);
			}, 10);
		}
		else
			document.getElementsByTagName('head')[0].appendChild(script);
		return function(){
			return jQuery.includeStates[url];
		}
	},
	readyOld: jQuery.ready,
	ready: function () {
		if (jQuery.isReady) return;
		imReady = true;
		$.each(jQuery.includeStates, function(url, state) {
			if (! state)
				return imReady = false;
		});
		if (imReady) {
			jQuery.readyOld.apply(jQuery, arguments);
		} else {
			setTimeout(arguments.callee, 10);
		}
	}
});

///// include js files ////////////
<!-- superfish menu begin -->
$.include('js/hoverIntent.js');
$.include('js/superfish.js');

<!-- superfish menu end -->

<!-- prettyPhoto begin -->
$.include('js/jquery.prettyPhoto.js');
<!-- prettyPhoto end-->


$(document).ready(function(){
	if ($("a[rel^='prettyPhoto']").length) {
		$(document).ready(function() {
					// prettyPhoto
					$("a[rel^='prettyPhoto']").prettyPhoto({theme:'facebook'});
				});
	}
});

var btnDoctorDataClik=0;
$("#btnDoctorData").click(function(e) {
	var right=$(".datos_medico .data");
	var width=$(".datos_medico .data").width();
	if (right==undefined || right==null) {
		right=-370;
	}

	if (btnDoctorDataClik % 2 == 0) {
		// open
		$(".datos_medico .button").css({
			right:0
		})
		.animate({
			"right": (width+30)+"px"
		},"slow",function() {
			$(".datos_medico .button img").attr("src","images/letters-bg_d.png");
			$(".datos_medico .button> button").addClass("icon2");
			$(".datos_medico .button> button").removeClass("icon1");
		});

		$(".datos_medico .data").css({
			right:right
		})
		.animate({
			"right":"0"
		}, "slow",function() {
			btnDoctorDataClik++;
		});
	}else{
		//close
		$(".datos_medico .button").css({
			right:(width+30)
		})
		.animate({
			"right": "0"
		},"slow",function() {
			$(".datos_medico .button img").attr("src","images/letters-bg.png");
			$(".datos_medico .button> button").addClass("icon1");
			$(".datos_medico .button> button").removeClass("icon2");
		});

		$(".datos_medico .data").css({
			right:"0"
		})
		.animate({
			"right":"-370px"
		}, "slow",function() {
			btnDoctorDataClik++;
		});
	}

});