<!DOCTYPE html>
<html lang="es-MX">
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>Grupo CAMIC - Servicios contables, fiscales y legales</title>	

		<meta name="keywords" content="contabilidad, despacho contable, analisis contable, asesoría contable, control sobre las finanzas, asesoria contable, problemas con hacienda, disposiciones fiscales, olvide los problemas con hacienda, problemas con hacienda, contabilidad para personas morales, grupo camic, servicios contables, servicios fiscales, servicios legales, anaalisis de estados financieros, interpretacion de estados financieros, consultoria contable, area contable, capacitacion contable, interpretacion de disposiciones fiscales, disposiciones fiscales, analisis contables, contabilidad electronica, carta de confidencialidad, contable, fiscal, legal, asesoria y capacitacion fiscal, situacion tributaria , disposiciones fiscales vigentes , asesorias fiscales , servicios fiscales, obligaciones tributarias , situacion fiscal, planeacion y blindaje fiscal, diagnostico y asesoria fiscal, reingenieria fiscal, impuestos y declaraciones, impuestos internacionales, compensaciones y devoluciones de impuestos, impuestos, estudio de precios de transferencia, estudios fiscales , nuevas disposiciones fiscales , la mejor asesoria fiscal." />
		<meta name="description" content="En Grupo CAMIC brindamos servicios Contables, Fiscales y Legales a la medida de sus necesidades y las de su negocio.">
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
		<link rel="manifest" href="archivos/favicon/site.webmanifest">
		<link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Fonts Camic -->
		<link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700&display=swap" rel="stylesheet">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.min.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

		<!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">

		<!-- Current Page CSS -->
		<link rel="stylesheet" href="vendor/rs-plugin/css/settings.css">
		<link rel="stylesheet" href="vendor/rs-plugin/css/layers.css">
		<link rel="stylesheet" href="vendor/rs-plugin/css/navigation.css">
		
		<!-- Demo CSS -->
		<link rel="stylesheet" href="css/demos/demo-business-consulting.css">

		<!-- Skin CSS -->
		<!-- <link rel="stylesheet" href="css/skins/skin-business-consulting.css">  -->

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

	</head>
	<body>

		<div class="body">
			<?php 
				include ("header.php");
			?>

			<div role="main" class="main">
				
				<!-- Slider -->
				<div class="slider-container rev_slider_wrapper" style="height: 100vh;">
					<div id="revolutionSlider" class="slider rev_slider" data-version="5.4.8" data-plugin-revolution-slider data-plugin-options="{'sliderLayout': 'fullscreen', 'delay': 15000, 'gridwidth': [1240, 1024, 778, 480], 'gridheight': [400, 768, 960, 720], 'disableProgressBar': 'on', 'responsiveLevels': [1240, 1024, 778, 480], 'parallax': { 'type': 'scroll', 'origo': 'enterpoint', 'speed': 15000, 'levels': [2,3,4,5,6,7,8,9,12,50], 'disable_onmobile': 'on' }, 'navigation' : {'arrows': { 'enable': false }, 'bullets': {'enable': true, 'style': 'bullets-style-1', 'h_align': 'center', 'v_align': 'bottom', 'space': 7, 'v_offset': 70, 'h_offset': 0}}}">
						<ul>
							<li data-transition="fade" class="slide1">
								<img src="archivos/slider/expertos-en-contabilidad.jpg"  
									alt="DESPACHO CONTABLE EN CDMX"
									data-bgposition="center center" 
									data-bgfit="cover" 
									data-bgrepeat="no-repeat" 
									class="rev-slidebg">

								<p class="tp-caption w-space-pre l-blanca title-slide w-500"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:1.5;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','60']"
									data-paddingleft="['0','0','0','20']"
									data-paddingright="['0','0','0','20']"
									data-y="center" data-voffset="['-40','-40','-40','-45']"
									data-width="['880','880','880','480']"
									data-height="['auto', 'auto', 'auto', 'auto']"
									data-whitespace="['normal','normal','normal','normal']"
									data-textAlign="['left','left','left','center']"
									data-fontsize="['35','35','35','30']"
									data-responsive_offset="on"
									data-lineheight="['45','45', '45','35']">PONGA SU CONTABILIDAD 
									<span class="w-600">EN MANOS DE LOS EXPERTOS</span></p>

								<p class="tp-caption l-blanca w-500"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:1.5;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','60']"
									data-paddingleft="['0','0','0','20']"
									data-paddingright="['0','0','0','20']"
									data-y="center" data-voffset="['35','35','55','55']"
									data-width="['850','850','850','480']"
									data-height="['auto', 'auto', 'auto', 'auto']"
									data-whitespace="['normal','normal','normal','normal']"
									data-textAlign="['left','left','left','center']"
									data-fontsize="['25','25','25','20']"
									data-responsive_offset="off"
									data-lineheight="['55','55','55','35']">¡Contáctenos y conozca nuestros planes a la medida!</p>

								<a class="tp-caption w-500 btn-slide w-400 scroll"
									href="servicios-contables.php"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"y:50%;opacity:0;","to":"y:0;o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'center', 'center']" data-hoffset="['60','60','0','0']"
									data-y="center" data-voffset="['105','105','105','170']"
									data-paddingtop="['15','15','15','10']"
									data-paddingbottom="['15','15','15','10']"
									data-paddingleft="['33','33','33','40']"
									data-paddingright="['33','33','33','40']"
									data-textAlign="['center','center','center','center']"
									data-fontsize="['20','20','20','18']"
									data-lineheight="['20','20','20','20']">Saber más</a>
							</li>
							<li data-transition="fade" class="slide2">
								<img src="archivos/slider/despacho-fiscal-contable.jpg"  
									alt="OLVIDE LOS PROBLEMAS CON HACIENDA"
									data-bgposition="center center" 
									data-bgfit="cover" 
									data-bgrepeat="no-repeat" 
									class="rev-slidebg">

								<p class="tp-caption w-space-pre l-blanca title-slide w-500"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:1.5;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','60']"
									data-paddingleft="['0','0','0','20']"
									data-paddingright="['0','0','0','20']"
									data-y="center" data-voffset="['-40','-40','-40','-45']"
									data-width="['880','880','880','480']"
									data-height="['auto', 'auto', 'auto', 'auto']"
									data-whitespace="['normal','normal','normal','normal']"
									data-textAlign="['left','left','left','center']"
									data-fontsize="['35','35','35','30']"
									data-responsive_offset="on"
									data-lineheight="['45','45', '45','35']">¡OLVIDE LOS PROBLEMAS
									<span class="w-600">CON HACIENDA!</span></p>

								<p class="tp-caption l-blanca w-500"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:1.5;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','60']"
									data-paddingleft="['0','0','0','20']"
									data-paddingright="['0','0','0','20']"
									data-y="center" data-voffset="['35','35','55','55']"
									data-width="['950','950','950','480']"
									data-height="['auto', 'auto', 'auto', 'auto']"
									data-whitespace="['normal','normal','normal','normal']"
									data-textAlign="['left','left','left','center']"
									data-fontsize="['25','25','25','20']"
									data-responsive_offset="off"
									data-lineheight="['55','55','55','35']">Regularice su situación fiscal y blinde su empresa</p>

								<a class="tp-caption w-500 btn-slide w-400 scroll"
									href="servicios-fiscales.php"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"y:50%;opacity:0;","to":"y:0;o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','0']"
									data-y="center" data-voffset="['105','105','105','170']"

									data-paddingtop="['15','15','15','10']"
									data-paddingbottom="['15','15','15','10']"
									data-paddingleft="['33','33','33','40']"
									data-paddingright="['33','33','33','40']"
									data-textAlign="['center','center','center','center']"
									data-fontsize="['20','20','20','18']"
									data-lineheight="['20','20','20','20']">Saber más</a>
							</li>
							<li data-transition="fade" class="slide3">
								<img src="archivos/slider/servicios-legales-cdmx.jpg"  
									alt="DESPACHO LEGAL CDMX"
									data-bgposition="center center" 
									data-bgfit="cover" 
									data-bgrepeat="no-repeat" 
									class="rev-slidebg">

								<h2 class="tp-caption w-space-pre l-blanca title-slide w-500"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:1.5;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','60']"
									data-paddingleft="['0','0','0','20']"
									data-paddingright="['0','0','0','20']"
									data-y="center" data-voffset="['-40','-40','-40','-45']"
									data-width="['880','880','880','480']"
									data-height="['auto', 'auto', 'auto', 'auto']"
									data-whitespace="['normal','normal','normal','normal']"
									data-textAlign="['left','left','left','center']"
									data-fontsize="['35','35','35','30']"
									data-responsive_offset="on"
									data-lineheight="['45','45', '45','35']">ASESORÍA Y   
									<span class="w-600">REPRESENTACIÓN LEGAL</span></h2>

								<p class="tp-caption l-blanca w-500"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:1.5;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','60']"
									data-paddingleft="['0','0','0','20']"
									data-paddingright="['0','0','0','20']"
									data-y="center" data-voffset="['35','35','55','55']"
									data-width="['1050','1050','1050','480']"
									data-height="['auto', 'auto', 'auto', 'auto']"
									data-whitespace="['normal','normal','normal','normal']"
									data-textAlign="['left','left','left','center']"
									data-fontsize="['25','25','25','20']"
									data-responsive_offset="off"
									data-lineheight="['55','55','55','35']">Consiga la mejor representación legal y resuelva su conflicto</p>

								<a class="tp-caption w-500 btn-slide w-400 scroll"
									href="servicios-legales.php"
									data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"y:50%;opacity:0;","to":"y:0;o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
									data-x="['left', 'left', 'left', 'center']" data-hoffset="['60','60','60','0']"
									data-y="center" data-voffset="['105','105','105','170']"

									data-paddingtop="['15','15','15','10']"
									data-paddingbottom="['15','15','15','10']"
									data-paddingleft="['33','33','33','40']"
									data-paddingright="['33','33','33','40']"
									data-textAlign="['center','center','center','center']"
									data-fontsize="['20','20','20','18']"
									data-lineheight="['20','20','20','20']">Saber más</a>
							</li>
						</ul>
					</div>
				</div>
				<!-- end -->

				<!-- Call to action 1 -->
				<section class="bckgd-azul-f p-tb40">
					<div class="container">
						<div class="row flex-center">
							<div class="col-md-9 text-center-small">
								<p class="l-blanca fs-25 w-400 p-no-margin m-b30-small lh-normal arrow-large">Consiga asesoría contable, fiscal y legal ¡ahora mismo!</p>
							</div>
							<div class="col-md-3 text-right text-center-small">
								<a class="btn-azul-large l-blanca-force scroll block-button" href="#contacto">Contactar</a>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->


				<!-- Acerca de -->
				<section class="p-tb80" id="nosotros">
					<div class="container">
						<div class="row">
							<div class="col-md-6 col-lg-5">
								<h1 class="w-space-pre w-space-normal-small w-400 l-azul-c fs-35 lh-normal">Contabilidad para 
								<span class="w-700 l-azul-f">Personas Morales</span></h1>
								<p class="l-gris justi-p">En <span class="w-700">Grupo CAMIC</span> estamos comprometidos con el bienestar empresarial y personal de nuestros clientes, ya que sabemos que están estrechamente relacionados, por lo que brindamos servicios <span class="w-700">contables, fiscales y legales</span> a la medida de sus necesidades y las de su negocio.</p>
							</div>
							<div class="col-md-6 col-lg-7">
								<div class="content-grid custom-content-grid">
									<div class="row content-grid-row">
										<div class="content-grid-item col-lg-6 bg-color-light p-4">
											<div class="counters">
												<div class="counter custom-sm-counter-style">
													<img class="counter-icon" src="archivos/icons/clientes-satisfechos.svg" alt="clientes satisfechos" />
													<strong class="l-azul" data-to="230" data-prepend="+">0</strong>
													<label class="l-azul-f w-600 w-space-pre w-space-normal-small">CLIENTES 
													SATISFECHOS</label>
												</div>
											</div>	
										</div>
										<div class="content-grid-item col-lg-6 p-4">
											<div class="counters">
												<div class="counter margin-style-2 custom-sm-counter-style">
													<img class="counter-icon" src="archivos/icons/experiencia-acumulada.svg" alt=años de experiencia"" />
													<strong class="l-azul" data-to="33">0</strong>
													<label class="l-azul-f w-600 w-space-pre w-space-normal-small">AÑOS DE EXPERIENCIA 
													ACUMULADA</label>
												</div>
											</div>	
										</div>
									</div>
									<div class="row content-grid-row">
										<div class="content-grid-item col-lg-6 p-4">
											<div class="counters">
												<div class="counter custom-sm-counter-style">
													<img class="counter-icon" src="archivos/icons/horas-de-asesoria.svg" alt="horas de asesoría" />
													<strong class="l-azul" data-to="12000" data-prepend="+">0</strong>
													<label class="l-azul-f w-600 w-space-pre w-space-normal-small">HORAS DE 
													ASESORÍA</label>
												</div>
											</div>	
										</div>
										<div class="content-grid-item col-lg-6 bg-color-light p-4">
											<div class="counters">
												<div class="counter margin-style-2 custom-sm-counter-style">
													<img class="counter-icon" src="archivos/icons/regularizaciones-ante-el-sat.svg" alt="regularizaciones ante el sat" />
													<strong class="l-azul" data-to="90" data-prepend="+">0</strong>
													<label class="l-azul-f w-600 w-space-pre w-space-normal-small">CLIENTES REGULARIZADOS 
													ANTE EL SAT</label>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- Servicios -->
				<section class="p-t40 bckgd-gris">
					<div class="container-fluid bckgd-gris">
						<div class="row">
							<div class="col-md-12 text-center m-b40">
								<p class="l-azul w-400 fs-35 p-no-margin lh-normal">Nuestros <span class="l-azul-f w-700">SERVICIOS</span></p>
							</div>
						</div>
						<div class="row box-center-services">
							<div class="col-lg-6 p-0">
								<section class="parallax section section-parallax custom-parallax-bg-pos-left custom-sec-left h-100 m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5, 'horizontalPosition': '100%'}" data-image-src="archivos/home/servicios-contables.jpg" style="min-height: 315px;">
								</section>
							</div>
							<div class="col-lg-6 p-0">
								<section class="p-tb50 section-no-border m-0">
									<div class="row m-0">
										<div class="col-half-section col-half-section-left">
											<p class="l-azul-f w-700 fs-25 lh-normal p-no-margin">SERVICIOS CONTABLES</p>
											<p class="l-azul w-700 fs-20 lh-normal">Análisis y consultoría contable</p>
											<p class="l-gris w-500 fs-15">Conozca nuestros servicios contables y tenga sus finanzas empresariales y personales en orden.</p>
											<a href="servicios-contables.php" class="btn btn-azul-outline fs-16 w-700">Ver más</a>
										</div>
									</div>
								</section>
							</div>
						</div>
						<div class="row box-center-services">
							<div class="col-lg-6 order-2 order-lg-1 p-0">
								<section class="p-tb50 section-no-border m-0">
									<div class="row justify-content-end m-0">
										<div class="col-half-section col-half-section-right custom-text-align-right text-right">
											<p class="l-azul-f w-700 fs-25 lh-normal p-no-margin">SERVICIOS FISCALES</p>
											<p class="l-azul w-700 fs-20 lh-normal">Análisis y blindaje fiscal</p>
											<p class="l-gris w-500 fs-15">Brindamos la mejor asesoría fiscal personalizada para obtener una estrategia fiscal sólida.</p>
											<a href="servicios-fiscales.php" class="btn btn-azul-outline fs-16 w-700">Ver más</a>
										</div>
									</div>
								</section>
							</div>
							<div class="col-lg-6 order-1 order-lg-2 p-0">
								<section class="parallax section section-parallax h-100 m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5, 'horizontalPosition': '100%'}" data-image-src="archivos/home/servicios-fiscales.jpg" style="min-height: 315px;">
								</section>
							</div>
						</div>
						<div class="row box-center-services">
							<div class="col-lg-6 p-0">
								<section class="parallax section section-parallax custom-parallax-bg-pos-left custom-sec-left h-100 m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5, 'horizontalPosition': '100%'}" data-image-src="archivos/home/servicios-legales.jpg" style="min-height: 315px;">
								</section>
							</div>
							<div class="col-lg-6 p-0">
								<section class="p-tb50 section-no-border m-0">
									<div class="row m-0">
										<div class="col-half-section col-half-section-left">
											<p class="l-azul-f w-700 fs-25 lh-normal p-no-margin">SERVICIOS LEGALES</p>
											<p class="l-azul w-700 fs-20 lh-normal">Asesoría y representación legal</p>
											<p class="l-gris w-500 fs-15">Cuente con una representación legal experimentada en distintas ramas del derecho.</p>
											<a href="servicios-legales.php" class="btn btn-azul-outline fs-16 w-700">Ver más</a>
										</div>
									</div>
								</section>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- Call to action testimonios-->
				<section class="bckgd-azul-f p-tb40">
					<div class="container">
						<div class="row">
							<div class="col-md-12 text-center">
								<p class="l-blanca fs-30 fs-25-small w-400 w-space-pre w-space-normal-small p-no-margin lh-normal">Nuestros clientes hablan por nosotros, 
								conozca algunos de sus testimonios</p>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- testimonios -->
				<section id="testimonios" class="parallax section-parallax section-center mt-0 mb-0" data-plugin-parallax data-plugin-options="{'speed': 1.5}" data-image-src="archivos/home/nuestros-clientes-hablan-por-nosotros.jpg">
					<div class="container">
						<div class="row justify-content-center">
							<div class="col-lg-10">
								<div class="owl-carousel owl-theme nav-bottom rounded-nav" data-plugin-options="{'items': 1, 'loop': true, 'autoplay': true}">
									<div>
										<div class="testimonial testimonial-style-2 testimonial-with-quotes mb-0">
											<div class="testimonial-author">
												<img src="archivos/home/icon-testimonio.png" class="img-fluid" alt="ICKCALL"> 
											</div>
											<blockquote>
												<p class="l-blanca-force fs-20 fs-16-small m-b40">La experiencia trabajando con GRUPO CAMIC ha sido muy provechosa para mí empresa. Siempre tiene el respaldo de contar oportunamente con la asesoría profesional y ética de sus colaboradores. Además, con sus estrategias administrativas he podido emprender y dar alcance a los objetivos y metas que me demanda mi empresa.”</p>
											</blockquote>
											<div class="m-t25-small">
												<p class="l-azul-c w-600 p-no-margin lh-normal">ISAIAS JORGE SANCHEZ URIBE</p>
												<p class="l-blanca w-500 fs-13 p-no-margin lh-normal">CEO - ICKALL MARKENTING</p>
											</div>
										</div>
									</div>
									<div>
										<div class="testimonial testimonial-style-2 testimonial-with-quotes mb-0">
											<div class="testimonial-author">
												<img src="archivos/home/icon-testimonio.png" class="img-fluid" alt="BLECK"> 
											</div>
											<blockquote>
												<p class="l-blanca-force fs-20 fs-16-small m-b40">Tanto el servicio como la calidad prestada por GRUPO CAMIC son excelentes, mis solicitudes fueron atendidas de manera inmediata por un equipo profesional con sobresaliente actitud.</p>
											</blockquote>
											<div class="m-t25-small">
												<p class="l-azul-c w-600 p-no-margin lh-normal">JUAN DIAZ GONZALEZ MERCADO</p>
												<p class="l-blanca w-500 fs-13 p-no-margin lh-normal">CEO - BLECK INGENIERIA </p>
											</div>
										</div>
									</div>
									<div>
										<div class="testimonial testimonial-style-2 testimonial-with-quotes mb-0">
											<div class="testimonial-author">
												<img src="archivos/home/icon-testimonio.png" class="img-fluid" alt="TCMP"> 
											</div>
											<blockquote>
												<p class="l-blanca-force fs-20 fs-16-small m-b40">A lo largo de estos 3 años, he tenido el placer de establecer lazos importantes con GRUPO CAMIC el trabajo realizado por este grupo de personas me ha complacido, su profesionalismo y seriedad queda demostrado, muchas gracias.</p>
											</blockquote>
											<div class="m-t25-small">
												<p class="l-azul-c w-600 p-no-margin lh-normal">ROBERTO MAURO RESENDIZ CORTES</p>
												<p class="l-blanca w-500 fs-13 p-no-margin lh-normal">CEO - TCMP SA DE C</p>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- Como Iniciar -->
				<section class="p-tb80" id="como-iniciar">
					<div class="container">
						<div class="row">
							<div class="col-md-12">
								<p class="l-azul w-400 fs-35 m-b40 lh-normal">Cómo <span class="l-azul-f w-700">INICIAR</span></p>
							</div>
							<div class="row process process-connecting-line">
								<div class="connecting-line appear-animation" data-appear-animation="fadeIn"></div>
								<div class="process-step col-lg-4 m-b40-small appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
									<div class="cont-hexagono">
										<span class="process-step-circle-content fs-30 w-700 l-azul-f">1</span>
										<img class="icon-hexagono-iniciar" src="archivos/icons/hexagono.svg">
									</div>
									<div class="process-step-content">
										<h4 class="l-azul w-500 m-b10">Contacto</h4>
										<p class="l-gris w-500 fs-15 p-no-margin justi-p">Contáctenos por cualquiera de nuestros medios para poder conocer su empresa y decirle cómo podemos ayudarlo.</p>
									</div>
								</div>
								<div class="process-step col-lg-4 m-b40-small appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="800">
									<div class="cont-hexagono">
										<span class="process-step-circle-content fs-30 w-700 l-azul-f">2</span>
										<img class="icon-hexagono-iniciar" src="archivos/icons/hexagono.svg">
									</div>
									<div class="process-step-content">
										<h4 class="l-azul w-500 m-b10">Conozcámonos</h4>
										<p class="l-gris w-500 fs-15 p-no-margin justi-p">Es muy importante para nosotros conocerlo para entender su empresa y ofrecerle la mejor propuesta de servicio.</p>
									</div>
								</div>
								<div class="process-step col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="1000">
									<div class="cont-hexagono">
										<span class="process-step-circle-content fs-30 w-700 l-azul-f">3</span>
										<img class="icon-hexagono-iniciar" src="archivos/icons/hexagono.svg">
									</div>
									<div class="process-step-content">
										<h4 class="l-azul w-500 m-b10">Contratación</h4>
										<p class="l-gris w-500 fs-15 p-no-margin justi-p">Para Grupo CAMIC su tranquilidad es lo principal, por eso firmamos una carta de confidencialidad y el contrato de prestación de servicios.</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
				<!-- End -->

				<?php 
					include ('contact.php');
				?>

				<!-- Contacto -->
				<section id="" class="">
					<div class="container-fluid">
						<div class="row flex-contacto bckgd-azul-f">
							<div class="col-lg-6 p-0 box-map">
								<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3760.9603259280693!2d-99.13261358497061!3d19.50034264356371!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85d1f9b9161bb9f9%3A0xd689c739e9b1c701!2sSierravista%20406%2C%20Lindavista%2C%2007300%20Ciudad%20de%20M%C3%A9xico%2C%20CDMX!5e0!3m2!1ses!2smx!4v1570034652927!5m2!1ses!2smx" width="100%" height="600" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
							</div>
							<div id="contacto" class="col-lg-6 p-0 p-tb40-small p-lr15-small">
								<img class="ghost-img-contacto" src="archivos/home/icono-contacto.svg" alt="Grupo Camic">
								<div class="text-center">
									<p class="l-azul-c w-700 fs-25 p-no-margin lh-normal">ESCRÍBANOS</p>
									<p class="l-blanca w-400 fs-18 p-no-margin lh-normal">Y un asesor se pondrá en contacto con usted</p>
								</div>
								<form id="" class="contact-form custom-contact-form-style-1">
									<div class="form-row">
										<div class="form-group col-md-6 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-user icons l-azul-c"></i>
												<input type="text" class="form-control l-blanca" name="name" placeholder="Nombre*">
											</div>
										</div>
										<div class="form-group col-md-6 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-envelope icons l-azul-c"></i>
												<input type="email" class="form-control l-blanca" name="mail" placeholder="E-mail*">
											</div>
										</div>
									</div>
									<div class="form-row">
										<div class="form-group col-md-6 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-phone icons l-azul-c"></i>
												<input type="text" class="form-control l-blanca" name="phone" placeholder="Teléfono*">
											</div>
										</div>
										<div class="form-group col-md-6 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-book-open icons l-azul-c"></i>
												<select name="service" class="form-control l-blanca">
													<option disabled selected value="">Seleccione un servicio</option>
													<option class="l-azul" value="Servicio Contable">Servicio Contable</option>
													<option class="l-azul" value="Servicio Legal">Servicio Legal</option>
													<option class="l-azul" value="Servicio Fiscal">Servicio Fiscal</option>
												</select>
											</div>
										</div>
									</div>
									<div class="form-row">
										<div class="form-group col-md-12">
											<div class="custom-input-box">
												<i class="icon-bubble icons l-azul-c"></i>
												<textarea maxlength="5000" rows="10" class="form-control l-blanca" style="resize: none;" name="message" placeholder="Mensaje*"></textarea>
											</div>
										</div>
									</div>
									<div class="form-row">
										<div class="form-group col m-b0">
											<div onClick="gtag('event', 'clicks', { 'event_category': 'form', 'event_action':'click'});" class="btn-enviar2 l-blanca-force lh-normal">ENVIAR</div>	
											<div class="mensajes-form"></div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

			</div> 

			<?php  
				include ('footer.php');
			?>

		</div>

		<?php  
			include ('contact-icons.php');
		?>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/popper/umd/popper.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="vendor/common/common.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.lazyload/jquery.lazyload.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>
		
		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>
		
		<!-- Current Page Vendor and Views -->
		<script src="vendor/rs-plugin/js/jquery.themepunch.tools.min.js"></script>
		<script src="vendor/rs-plugin/js/jquery.themepunch.revolution.min.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>
		
		<!-- Demo -->
		<script src="js/demos/demo-business-consulting.js"></script>
		
		<!-- Theme Custom -->
		<script src="js/custom.js"></script>
		
		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>


	</body>
</html>
