<!DOCTYPE html>
<html lang="es-MX">
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>Servicios Legales - Grupo CAMIC</title>	
		
		<meta name="description" content="Asesoría legal y representación Legal Grupo CAMIC, nos enfocamos en asesorarlo y representarlo en distintas ramas del derecho.>
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
		<link rel="manifest" href="archivos/favicon/site.webmanifest">
		<link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Fonts Camic -->
		<link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700&display=swap" rel="stylesheet">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.min.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

		<!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">

		<!-- Current Page CSS -->
		<link rel="stylesheet" href="vendor/rs-plugin/css/settings.css">
		<link rel="stylesheet" href="vendor/rs-plugin/css/layers.css">
		<link rel="stylesheet" href="vendor/rs-plugin/css/navigation.css">
		
		<!-- Demo CSS -->
		<link rel="stylesheet" href="css/demos/demo-business-consulting.css">

		<!-- Skin CSS -->
		<!-- <link rel="stylesheet" href="css/skins/skin-business-consulting.css">  -->

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

	</head>
	<body>

		<div class="body">
			<?php 
				include ("header.php");
			?>

			<div role="main" class="main">
				
				<!-- Header-sections -->
				<section class="p-t100">
					<div class="box-header-sections">
						<img class="img-fluid header-legales" src="archivos/servicios-legales/servicios-legales.jpg" alt="SERVICIOS LEGALES">
						<p class="l-blanca fs-35 fs-25-small w-500 p-no-margin">SERVICIOS LEGALES</p>
					</div>
				</section>
				<!-- end -->

				<!-- Acerca de -->
				<section class="p-tb80" id="">
					<div class="container">
						<div class="row flex-service-description">
							<div class="col-md-6 col-lg-6">
								<p class="w-400 l-azul-c fs-25 lh-normal">Asesoría y representación <span class="w-700 l-azul-f">Legal</span></p>
								<p class="l-gris justi-p">En <span class="w-700">Grupo CAMIC</span> nos enfocamos en conocer sus necesidades en materia legal para asesorarlo y representarlo de la mejor manera, nuestros servicios en distintas ramas del derecho le permitirán resolver cualquier conflicto que enfrente.</p>
							</div>
							<div class="col-md-6 col-lg-6 text-center">
								<img class="img-fluid img-service-description" src="archivos/servicios-legales/asesoria-legal.jpg" alt="ASESORÍA LEGAL">
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- Call to action 1-->
				<section class="bckgd-azul p-tb40">
					<div class="container">
						<div class="row">
							<div class="col-md-12 text-center">
								<p class="l-blanca fs-25 w-400 w-space-pre w-space-normal-small p-no-margin lh-normal">Nos comprometemos con su caso para dar una solución 
								a sus necesidades en materia legal.</p>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- Que hacemos -->
				<section class="p-t80 p-b50 p-b40-small bckgd-blanco" id="que-hacemos" style="position: relative;">
					<img class="ghost-img-que-hacemos" src="archivos/home/bg-beneficios.svg" alt="Grupo Camic">
					<div class="container">
						<div class="row">
							<div class="col-md-12 text-center">
								<p class="l-azul-c w-400 fs-35 lh-normal m-b30">Ramas del <span class="l-azul-f w-700">DERECHO</span></p>
								<p class="l-azul-f w-400 m-b40">Conozca las ramas del derecho en las que estamos especializados para representación legal.</p>
							</div>	
						</div>
						<div class="row">
							<div class="col-lg-4 text-center m-b40">
								<img class="icon-beneficios m-b20" src="archivos/servicios-legales/derecho-fiscal.svg">
								<h2 class="l-azul fs-16 w-400 p-no-margin lh-normal">Derecho <span class="l-azul w-700">Fiscal</span></h2>
							</div>
							<div class="col-lg-4 text-center m-b40">
								<img class="icon-beneficios m-b20" src="archivos/servicios-legales/derecho-laboral.svg">
								<h2 class="l-azul fs-16 w-400 p-no-margin lh-normal">Derecho <span class="l-azul w-700">Laboral</span></h2>
							</div>
							<div class="col-lg-4 text-center m-b40">
								<img class="icon-beneficios m-b20" src="archivos/servicios-legales/derecho-mercantil.svg">
								<h2 class="l-azul fs-16 w-400 p-no-margin lh-normal">Derecho <span class="l-azul w-700">Mercantil</span></h2>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-4 text-center m-b40">
								<img class="icon-beneficios m-b20" src="archivos/servicios-legales/derecho-penal.svg">
								<h2 class="l-azul fs-16 w-400 p-no-margin lh-normal">Derecho <span class="l-azul w-700">Penal</span></h2>
							</div>
							<div class="col-lg-4 text-center m-b40">
								<img class="icon-beneficios m-b20" src="archivos/servicios-legales/propiedad-industrial.svg">
								<h2 class="l-azul fs-16 w-700 p-no-margin lh-normal">Propiedad <span class="l-azul w-700">Industrial</span></h2>
							</div>
							<div class="col-lg-4 text-center m-b40">
								<img class="icon-beneficios m-b20" src="archivos/servicios-legales/derecho-civil.svg">
								<h2 class="l-azul fs-16 w-400 p-no-margin lh-normal">Derecho <span class="l-azul w-700">Civil</span></h2>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->

				<!-- Call to action 1-->
				<section class="bckgd-azul-f p-tb40">
					<div class="container">
						<div class="row">
							<div class="col-md-12 text-center">
								<p class="l-blanca fs-25 w-400 w-space-pre w-space-normal-small p-no-margin lh-normal">Consiga un <span class="w-700">descuento</span> del total del costo de la <span class="w-700">asesoría legal</span> al 
								contratar cualquier servicio legal con <span class="w-700">Grupo CAMIC.</span></p>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->
				


				<?php 
					include ('contact.php');
				?>
				<!-- Contacto -->
				<section id="" class="">
					<div class="container-fluid">
						<div class="row flex-contacto bckgd-azul-f">
							<div class="col-lg-6 p-0 box-map">
								<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3760.9603259280693!2d-99.13261358497061!3d19.50034264356371!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85d1f9b9161bb9f9%3A0xd689c739e9b1c701!2sSierravista%20406%2C%20Lindavista%2C%2007300%20Ciudad%20de%20M%C3%A9xico%2C%20CDMX!5e0!3m2!1ses!2smx!4v1570034652927!5m2!1ses!2smx" width="100%" height="600" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
							</div>
							<div id="contacto" class="col-lg-6 p-0 p-tb40-small p-lr15-small">
								<img class="ghost-img-contacto" src="archivos/home/icono-contacto.svg" alt="Grupo Camic">
								<div class="text-center">
									<p class="l-azul-c w-700 fs-25 m-b10 lh-normal">ESCRÍBANOS</p>
									<p class="l-blanca w-400 fs-18 p-no-margin lh-normal">Y un asesor se pondrá en contacto con usted</p>
								</div>
								<form id="" class="contact-form custom-contact-form-style-1">
									<div class="form-row">
										<div class="form-group col-md-12 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-user icons l-azul-c"></i>
												<input type="text" class="form-control l-blanca" name="name" placeholder="Nombre*">
											</div>
										</div>
									</div>
									<div class="form-row">
										<div class="form-group col-md-6 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-envelope icons l-azul-c"></i>
												<input type="email" class="form-control l-blanca" name="mail" placeholder="E-mail*">
											</div>
										</div>
										<div class="form-group col-md-6 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-phone icons l-azul-c"></i>
												<input type="text" class="form-control l-blanca" name="phone" placeholder="Teléfono*">
											</div>
										</div>
									</div>
									<div class="form-row">
										<div class="form-group col-md-12 col-sm-12">
											<div class="custom-input-box">
												<i class="icon-bubble icons l-azul-c"></i>
												<textarea maxlength="5000" rows="10" class="form-control l-blanca" style="resize: none;" name="message" placeholder="Mensaje*"></textarea>
											</div>
										</div>
									</div>
									<div class="form-row">
										<div class="form-group col m-b0">
											<div onClick="gtag('event', 'clicks', { 'event_category': 'form', 'event_action':'click'});" class="btn-enviar l-blanca-force lh-normal">ENVIAR</div>	
											<div class="mensajes-form"></div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</section>
				<!-- end -->
			</div> 

			<?php  
				include ('footer.php');
			?>

		</div>

		<?php  
			include ('contact-icons.php');
		?>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/popper/umd/popper.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="vendor/common/common.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.lazyload/jquery.lazyload.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>
		
		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>
		
		<!-- Current Page Vendor and Views -->
		<script src="vendor/rs-plugin/js/jquery.themepunch.tools.min.js"></script>
		<script src="vendor/rs-plugin/js/jquery.themepunch.revolution.min.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>
		
		<!-- Demo -->
		<script src="js/demos/demo-business-consulting.js"></script>
		
		<!-- Theme Custom -->
		<script src="js/custom.js"></script>
		
		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>


	</body>
</html>
