window.scwAjaxFormPlugin = window.scwAjaxFormPlugin || {};

window.SEMICOLON_ajaxFormInit = function( $ajaxForm ){

	$ajaxForm = $ajaxForm.filter(':not(.customjs)');

	if( $ajaxForm.length < 1 ){
		return true;
	}

	$ajaxForm.each( function(){
		let element		= $(this),
			$body		= $('body'),
			elForm		= element.find('form'),
			elFormId	= elForm.attr('id'),
			elAlert		= element.attr('data-alert-type'),
			elLoader	= element.attr('data-loader'),
			elResult	= element.find('.form-result'),
			elRedirect	= element.attr('data-redirect'),
			defButton, alertType;

		if( !elAlert ) { elAlert = 'notify'; }

		if( elFormId ) {
			$body.addClass( elFormId + '-ready' );
		}

		element.find('form').validate({
			errorPlacement: function(error, elementItem) {
				if( elementItem.parents('.form-group').length > 0 ) {
					error.appendTo( elementItem.parents('.form-group') );
				} else {
					error.insertAfter( elementItem );
				}
			},
			focusCleanup: true,
			submitHandler: function(form) {

				elResult.hide();

				if( elLoader == 'button' ) {
					defButton = $(form).find('button');
					defButtonText = defButton.html();

					defButton.html('<i class="icon-line-loader icon-spin m-0"></i>');
				} else {
					$(form).find('.form-process').fadeIn();
				}

				if( elFormId ) {
					$body.removeClass( elFormId + '-ready ' + elFormId + '-complete ' + elFormId + '-success ' + elFormId + '-error' ).addClass( elFormId + '-processing' );
				}

				$(form).ajaxSubmit({
					target: elResult,
					dataType: 'json',
					success: function( data ) {
						if( elLoader == 'button' ) {
							defButton.html( defButtonText );
						} else {
							$(form).find('.form-process').fadeOut();
						}

						if( data.alert != 'error' && elRedirect ){
							window.location.replace( elRedirect );
							return true;
						}

						if( elAlert == 'inline' ) {
							if( data.alert == 'error' ) {
								alertType = 'alert-danger';
							} else {
								alertType = 'alert-success';
							}

							elResult.removeClass( 'alert-danger alert-success' ).addClass( 'alert ' + alertType ).html( data.message ).slideDown( 400 );
						} else if( elAlert == 'notify' ) {
							elResult.attr( 'data-notify-type', data.alert ).attr( 'data-notify-msg', data.message ).html('');
							SEMICOLON.widget.notifications({ el: elResult });
						}

						if( data.alert != 'error' ) {
							$(form).resetForm();
							$(form).find('.btn-group > .btn').removeClass('active');

							if( (typeof tinyMCE != 'undefined') && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden() ){
								tinymce.activeEditor.setContent('');
							}

							let rangeSlider = $(form).find('.input-range-slider');
							if( rangeSlider.length > 0 ) {
								rangeSlider.each( function(){
									let range = $(this).data('ionRangeSlider');
									range.reset();
								});
							}

							let ratings = $(form).find('.input-rating');
							if( ratings.length > 0 ) {
								ratings.each( function(){
									$(this).rating('reset');
								});
							}

							let selectPicker = $(form).find('.selectpicker');
							if( selectPicker.length > 0 ) {
								selectPicker.each( function(){
									$(this).selectpicker('val', '');
									$(this).selectpicker('deselectAll');
								});
							}

							$(form).find('.input-select2,select[data-selectsplitter-firstselect-selector]').change();

							$(form).trigger( 'formSubmitSuccess' );
							$body.removeClass( elFormId + '-error' ).addClass( elFormId + '-success' );
						} else {
							$(form).trigger( 'formSubmitError' );
							$body.removeClass( elFormId + '-success' ).addClass( elFormId + '-error' );
						}

						if( elFormId ) {
							$body.removeClass( elFormId + '-processing' ).addClass( elFormId + '-complete' );
						}

						if( $(form).find('.g-recaptcha').children('div').length > 0 ) { grecaptcha.reset(); }
					}
				});
			}
		});

	});

};

