<!DOCTYPE html>
<html lang="es">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
	<meta name="description" content="">
	<meta name="author" content="">
	<meta name="format-detection" content="telephone=no">
	<title>Cirugía Bariátrica | Dr. Enrique Hernández</title>
	<!-- Stylesheets -->
	<?php include('module-head.php'); ?>
	<style>
		.interiorPage .hiddenForm{
			display: none;
		}
	</style>

</head>

<body class="shop-page interiorPage">
	<!--header-->
	<?php include('module-header-interior.php'); ?>
	<!--//header-->
	<div class="page-content">
		<!--section slider-->
		<div class="section mt-0" id="slideBariatrica">
			<div id="mainSliderWrapper">
				<div class="loading-content">
					<div class="inner-circles-loader"></div>
				</div>
				<div class="main-slider mb-0 arrows-white" id="mainSlider" data-slick='{"arrows": true, "responsive":[{"breakpoint": 768,"settings":{"arrows": false, "dots": true }}]}'>
					<div class="slide">
						<div class="img--holder" data-animation="kenburns" data-bg="files/cirugia-para-bajar-de-peso.webp"></div>
						<div class="slide-content center">
							<div class="vert-wrap container">
								<div class="vert">
									<div class="container">
										<h1 class="slide-txt1" data-animation="fadeInDown" data-animation-delay="1s">Baja de peso
											<br><b>de manera segura</b></h1>
										<div class="slide-txt2" data-animation="fadeInUp" data-animation-delay="1.5s">Cirugía bariátrica, Manga gástrica y Bypass</div>
										<div class="slide-btn"><a aria-label="Más información" href="#cirugia-bariatrica_proc" class="btn btn-white btnSlide" data-animation="fadeInUp" data-animation-delay="2s">MÁS INFORMACIÓN</a></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section slider-->
        <!--Cirugia bariatrica-->
		<div id="cirugia-bariatrica" class="section">
			<div class="container">
                <div class="title-wrap text-center">
                    <div class="subtitle">Cirugía Bariátrica</div>
					<h2 class="h1 title">Baja de peso de manera segura</h2>
					<div class="h-decor"></div>
				</div>
				<div class="row">
					<div class="col-lg-6">
						<img src="files/cirugia-de-la-obesidad-cdmx.webp" alt="Cirugía de la obesidad cdmx" class="img-fluid">
                        <div class="row">
                            <div class="col-6 col-md-6 mt-40">
                                <img class="img-fluid" src="files/cirugia-bariatrica-en-cdmx.webp" alt="Cirugía bariátrica cdmx">
                            </div>
                            <div class="col-6 col-md-6 mt-40">
                                <img class="img-fluid" src="files/cirugia-para-bajar-de-peso-cdmx.webp" alt="Cirugía para bajar de peso">
                            </div>
                        </div>
					</div>
					<div class="col-lg-6">
						<div class="text-left mt-3 mt-sm-0">
							<p class="p-lg text">El bypass gástrico y la manga gástrica, son cirugías de pérdida de peso (conocidas colectivamente como cirugía bariátrica) consisten en hacer cambios en el sistema digestivo para ayudarte a perder peso. La cirugía bariátrica se realiza cuando la dieta y el ejercicio no han funcionado o cuando tienes problemas graves de salud debido a tu peso. Algunos procedimientos limitan cuánto puedes comer.</p>
                            <p class="text smallTitle">¿Soy candidato a una cirugía bariátrica?</p>
                            <p class="text">No todas las personas son candidatas a realizarse una Cirugía bariátrica, estos son algunos a los que se les recomienda: </p>
                            <ul class="list">
                                <li><i class="fa fa-check"></i>En caso de que su índice de masa corporal (IMC) sea de 40 o más (obesidad extrema)</li>
                                <li><i class="fa fa-check"></i>Su IMC está entre 35 a 39.9 (obesidad) y tiene graves problemas de salud, como diabetes tipo 2, presión arterial alta o apnea del sueño grave.</li>
                            </ul>
                        </div>
					</div>
				</div>
			</div>
		</div>
        <!--  -->
        <!-- IMC -->
        <section id="calculadora-imc" class="section">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 offset-md-6">
                        <div class="title-wrap text-left">
                            <h2 class="h1 title">Calculadora del IMC</h2>
                            <div class="h-decor text-left"></div>
                            <p class="description">Calcula tu índice de masa corporal de manera rápida.</p>
                        </div>
                        <div class="boxCalculadora">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="divcell">
                                        <label for="meters"><strong>Estatura :</strong> Metros</label>
                                        <input class="dates" placeholder="Estatura: Metros" id="meters" maxlength="6" name="meters" size="1" tabindex="1" type="text">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="divcell">
                                        <label for="kilograms"><strong>Peso :</strong> Kilogramos:</label>
                                        <input class="dates" placeholder="Peso: kilogramos" id="kilograms" maxlength="6" name="kilograms" size="6" tabindex="3" type="text">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="divcell">
                                        <input class="select-box specialLinkIconLeft btnCalc" id="calc" name="calc" tabindex="4" type="button" value="Calcular">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="divcell">
                                        <p class="imcResult">Tu IMC es: <strong class="bmiNum"></strong></p>
                                    </div>
                                </div>
                            </div>
                        </div>
						<div class="boxesResults">
							<div class="box box1">
								<p class="text boldT">18.5-24.9</p>
								<p class="text">Normal</p>
							</div>
							<div class="box box2">
								<p class="text boldT">25-29.9</p>
								<p class="text">Sobrepeso</p>
							</div>
							<div class="box box3">
								<p class="text boldT">30-34.9</p>
								<p class="text">Obesidad I</p>
							</div>
							<div class="box box4">
								<p class="text boldT">35-39.9</p>
								<p class="text">Obesidad II</p>
							</div>
							<div class="box box5">
								<p class="text boldT">>40</p>
								<p class="text">Obesidad III</p>
							</div>
						</div>
                        <div id="results">
                            <div class="w-md-col11">
                                <div class="card mb-3">
                                    <div class="card-header h4">Calculadora del IMC para adultos - Resultados</div>
                                    <div class="card-body bg-white">
                                        <div class="row" style="padding: 20px !important;">
                                            <div class="col-md-12">
                                                <div id="error" class="bmiresults">
                                                    <p><strong>Por favor verifique la exactitud de la información que ha introducido:</strong></p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                </div>
                                                <div id="underweight" class="bmiresults">
                                                    <p style="font-weight: 700;">Para la información que ingresó:</p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                    <p>Su IMC es <strong class="bmiNum">&nbsp;</strong>, lo que indica que su peso esta en la categoría de <strong class="bmi_type">&nbsp;</strong> para adultos de su estatura. El IMC es una medida de detección y no para diagnosticar enfermedades o padecimientos. Para obtener más información, visite <a aria-label="Más información" href="https://www.cdc.gov/healthyweight/spanish/assessing/bmi/adult_bmi/index.html">Acerca del índice de masa corporal para adultos</a>.</p>
                                                </div>
                                                <div id="normal" class="bmiresults">
                                                    <p style="font-weight: 700;">Para la información que ingresó:</p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                    <p>Su IMC es <strong class="bmiNum">&nbsp;</strong>, lo que indica que su peso esta en la categoría de <strong class="bmi_type">&nbsp;</strong> para adultos de su estatura. El IMC es una medida de detección y no para diagnosticar enfermedades o padecimientos. Para obtener más información, visite <a aria-label="Más información" href="https://www.cdc.gov/healthyweight/spanish/assessing/bmi/adult_bmi/index.html">Acerca del índice de masa corporal para adultos</a>.</p>
                                                    <p>Mantener un peso dentro del rango saludable de IMC es importante para la salud general a medida que envejece. Para obtener más información sobre como incorporar hábitos saludables, visite <a href="https://www.cdc.gov/healthyweight/spanish/index.html">Peso, nutrición y actividad física saludables</a>.</p>
                                                </div>
                                                <div id="overweight" class="bmiresults">
                                                    <p style="font-weight: 700;">Para la información que ingresó:</p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                    <p>Su IMC es <strong class="bmiNum">&nbsp;</strong>, lo que indica que su peso esta en la categoría de <strong class="bmi_type">&nbsp;</strong> para adultos de su estatura. El IMC es una medida de detección y no para diagnosticar enfermedades o padecimientos. Para obtener más información, visite <a aria-label="Más información" href="https://www.cdc.gov/healthyweight/spanish/assessing/bmi/adult_bmi/index.html">Acerca del índice de masa corporal para adultos</a>.</p>
                                                </div>
                                                <div id="obese" class="bmiresults">
                                                    <p style="font-weight: 700;">Para la información que ingresó:</p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                    <p>Su IMC es <strong class="bmiNum">&nbsp;</strong>, lo que indica que su peso esta en la categoría de <strong class="bmi_type">&nbsp;</strong> para adultos de su estatura. El IMC es una medida de detección y no para diagnosticar enfermedades o padecimientos. Para obtener más información, visite <a aria-label="Más información" href="https://www.cdc.gov/healthyweight/spanish/assessing/bmi/adult_bmi/index.html">Acerca del índice de masa corporal para adultos</a>.</p>
                                                </div>
												<div id="obese2" class="bmiresults">
                                                    <p style="font-weight: 700;">Para la información que ingresó:</p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                    <p>Su IMC es <strong class="bmiNum">&nbsp;</strong>, lo que indica que su peso esta en la categoría de <strong class="bmi_type">&nbsp;</strong> para adultos de su estatura. El IMC es una medida de detección y no para diagnosticar enfermedades o padecimientos. Para obtener más información, visite <a aria-label="Más información" href="https://www.cdc.gov/healthyweight/spanish/assessing/bmi/adult_bmi/index.html">Acerca del índice de masa corporal para adultos</a>.</p>
                                                </div>
												<div id="obese3" class="bmiresults">
                                                    <p style="font-weight: 700;">Para la información que ingresó:</p>
                                                    <p class="hResults"><span class="tBold">Estatura: </span></p>
                                                    <p class="wResults"><span class="tBold">Peso: </span></p>
                                                    <p>Su IMC es <strong class="bmiNum">&nbsp;</strong>, lo que indica que su peso esta en la categoría de <strong class="bmi_type">&nbsp;</strong> para adultos de su estatura. El IMC es una medida de detección y no para diagnosticar enfermedades o padecimientos. Para obtener más información, visite <a aria-label="Más información" href="https://www.cdc.gov/healthyweight/spanish/assessing/bmi/adult_bmi/index.html">Acerca del índice de masa corporal para adultos</a>.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end -->
		<!-- Beneficios -->
		<div id="beneficios-bariatrica" class="">
			<img class="ghostImage" src="files/cirugia-bariatrica-en-cdmx-beneficios.svg" alt="Beneficios de cirugía bariátrica ícono">
			<div class="container">
				<div class="row">
					<div class="col-md-6">
						<div class="title-wrap text-left">
                            <h2 class="h1 title">Beneficios de la <br><span>Cirugía Bariátrica</span></h2>
                        </div>
						<ul class="list">
							<li><i class="fa fa-check"></i>Mejora de la salud cardiovascular</li>
							<li><i class="fa fa-check"></i>Alivio de la depresión</li>
							<li><i class="fa fa-check"></i>Elimina la Apnea obstructiva del sueño</li>
							<li><i class="fa fa-check"></i>Alivio del dolor articular</li>
							<li><i class="fa fa-check"></i>Mejora la fertilidad</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<!-- end -->
		<!-- Procedimientos section -->
		<section id="cirugia-bariatrica_proc" class="">
			<div class="title-wrap text-center">
				<div class="ghostText">Manga Gástrica y Bypass</div>
				<h2 class="h1 title">Manga gástrica y Bypass</h2>
				<div class="h-decor"></div>
			</div>
			<div class="container">
				<div id="accordion" data-children=".surgery-item">
					<div class="row">
						<div class="col-md-6">
							<a class="boxSelectTab surgery-item" data-toggle="collapse" data-parent="#accordion" href="#tabMangaGastrica" aria-expanded="true" aria-label="Más información">
								<!-- Generator: Adobe Illustrator 25.4.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
								<svg class="iconTab active" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
									viewBox="0 0 60 65" style="enable-background:new 0 0 60 65;" xml:space="preserve">
									<style type="text/css">
										.st3{fill:#FFFFFF;}
										.st1{fill:#00E5FF;}
									</style>
									<g>
										<g>
											<g>
												<path class="st3" d="M27.1,65c-0.5,0-0.9-0.4-0.9-0.9l0-0.5c0-2.9,0-4.8-1.1-6c-1.4-1.3-4.6-1.9-11.3-1.9
													c-4.2,0-7.8-1.4-10.3-4.1c-2.2-2.4-3.5-5.6-3.5-9c0-6.2,4.3-12.9,13.8-12.9c4.9,0,8.4-1.3,10.4-3.9c2.7-3.5,2-8.5,1.7-10.2
													c-4.8-0.1-8.4-1.6-10.6-4.2c-3.6-4.4-2.1-10.5-2-10.8c0.1-0.5,0.6-0.8,1.1-0.6c0.5,0.1,0.8,0.6,0.7,1.1c0,0.1-1.3,5.5,1.7,9.3
													c1.9,2.4,5.2,3.6,9.8,3.6h0.7l0.2,0.6c0.1,0.3,2.1,7.4-1.8,12.4c-2.4,3-6.3,4.6-11.8,4.6c-8.2,0-12,5.8-12,11.2
													c0,5.5,3.7,11.3,12,11.3c7.4,0,10.8,0.6,12.5,2.4c1.7,1.6,1.7,4,1.7,7.2l0,0.5C28,64.6,27.6,65,27.1,65z"/>
											</g>
											<g>
												<path class="st3" d="M35.1,65c-0.5,0-0.9-0.4-0.9-0.9c0-6.8-2.9-14.7-11.1-14.7H12.9c-1.8,0-3.2-0.7-4.2-1.9
													c-0.8-1.1-1.3-2.5-1.3-4.1c0-3.2,1.9-6.6,5.5-6.6h13.5c9.2,0,14.2-7.9,14.2-15.3c0-3.5-1.1-6.8-3.2-9.1c-2.3-2.6-5.8-4-10-4
													c-3.2,0-5.1-0.4-6.1-1.5c-1.2-1.1-1.1-2.8-1.1-4.8c0-0.4,0-0.9,0-1.3c0-0.5,0.4-0.9,0.9-0.9c0.5,0,0.9,0.4,0.9,0.9
													c0,0.5,0,0.9,0,1.4c0,1.7-0.1,2.9,0.6,3.5c0.6,0.6,2.2,0.9,4.8,0.9c4.7,0,8.7,1.6,11.3,4.6c2.3,2.6,3.6,6.3,3.6,10.2
													c0,8.3-5.6,17-16,17H12.9c-2.4,0-3.7,2.5-3.7,4.8c0,1.2,0.3,2.2,0.9,3c0.6,0.8,1.6,1.2,2.8,1.2h10.2C32,47.7,36,55.9,36,64.1
													C36,64.6,35.6,65,35.1,65z"/>
											</g>
										</g>
										<g>
											<path class="st1" d="M36.2,47.1c-12.7,0-14.7-4.5-14.8-5l-0.4-1.2h1.3c8.5,0,22.8-3.9,22.8-18.3C45.1,8.6,32.9,5,32.8,5l-1.6-0.5
												l1.3-1.1C34,2.1,40-2,48.4,1.2c7.8,3,11.6,9.7,11.6,20.6c0,5.8-2.6,12.2-7,17.1C48.3,44.1,42.2,47.1,36.2,47.1z M24.1,42.6
												c1.5,1.1,4.8,2.7,12.1,2.7c12.2,0,22-12.9,22-23.5c0-10.2-3.3-16.2-10.5-18.9c-6-2.3-10.5-0.4-12.8,1.1c3.6,1.6,12,6.6,12,18.7
												C46.9,37.4,33.4,42.1,24.1,42.6z"/>
										</g>
									</g>
								</svg>
								<h4 class="titleTab">Manga Gástrica</h4>
							</a>
						</div>
						<div class="col-md-6">
							<a class="boxSelectTab collapsed surgery-item" data-toggle="collapse" data-parent="#accordion" href="#tabBypassGastrico" aria-expanded="false" aria-label="Más información">
								<!-- Generator: Adobe Illustrator 25.4.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
								<svg class="iconTab" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
									viewBox="0 0 60 65" style="enable-background:new 0 0 60 65;" xml:space="preserve">
									<style type="text/css">
										.st0{fill:none;}
										.st1{fill:#00E5FF;}
										.st2{fill:#0277BD;}
									</style>
									<g>
										<path class="st0" d="M36.5,41.7c4.4-0.7,9.2-2.3,13-5.2h-7.1C39.6,36.5,36.5,37.9,36.5,41.7z"/>
										<path class="st0" d="M17.3,38.3c-1.9-0.2-5.9-0.1-7,1.7c-0.8,1.3-1.2,3.4-0.3,5c1,1.6,3.3,2.5,6.7,2.5h7c0.4,0,2-0.1,3.6,0.8v-5
											C21.2,42.3,18.2,39.3,17.3,38.3z"/>
										<path class="st0" d="M55.9,16.4C54.6,9.4,50.7,5.8,43.4,4.8c2.8,1.7,5.8,4.8,5.8,9.7c0,0.1,0,0.2,0,0.2h1.1
											C52.5,14.8,54.4,15.4,55.9,16.4z"/>
										<g>
											<path class="st1" d="M22.3,53.9h-9.5c-7.6,0-11-5.8-11-11.2c0-5.5,3.4-11.4,11-11.4h5.8c4.1,0,7.8-4.6,9.2-6.4
												c1.6,1,5.2,3.1,8.9,3.1c2.8,0,6.3-1.3,8.9-3.9h-2.7c-2,1.5-4.3,2.2-6.2,2.2c-4.1,0-8.5-3.2-8.6-3.3c-0.2-0.2-0.5-0.2-0.7-0.2
												c-0.3,0-0.5,0.2-0.6,0.4c-1.1,1.8-4.8,6.4-8.2,6.4h-5.8c-3.9,0-7.3,1.4-9.6,4.2C1.1,36,0,39.2,0,42.6c0,6.3,4,13,12.8,13h9.5
												c4.9,0,5,4.9,5,5.1v-2.3c0-0.5,0.4-0.9,0.9-0.9c0.1,0,0.1,0,0.2,0C27.5,55.7,25.7,53.9,22.3,53.9z"/>
											<path class="st1" d="M53.4,7.3c-3.2-3.1-7.8-4.5-14.7-4.5c-0.5,0-0.8,0.3-0.9,0.8c-0.1,0.4,0.2,0.8,0.7,1c0.1,0,9,2.3,9,10.1
												c0,0.1,0,0.2,0,0.2h1.8c0-0.1,0-0.2,0-0.2c0-5-3-8-5.8-9.7c7.3,1,11.2,4.6,12.5,11.6c0.8,0.6,1.5,1.3,2.1,2.1
												C57.5,13.5,56,9.8,53.4,7.3z"/>
											<path class="st1" d="M49.5,36.5c-3.8,2.8-8.6,4.5-13,5.2c0,0,0,0,0,0v1.8c4.5-0.6,8.9-2.2,12.4-4.4c1.3-0.8,2.5-1.8,3.6-2.8
												c-0.7,0.1-1.4,0.2-2.1,0.2H49.5z"/>
											<path class="st1" d="M28.2,51.2c-0.5,0-0.9-0.4-0.9-0.9v-2c-1.5-0.9-3.2-0.8-3.6-0.8h-7c-3.4,0-5.7-0.9-6.7-2.5
												c-0.9-1.6-0.5-3.6,0.3-5c1.1-1.8,5.1-1.9,7-1.7c0.9,1,3.9,4,10,5.1v-1.8c-6.1-1.2-8.7-4.4-8.8-4.6c-0.1-0.2-0.4-0.3-0.6-0.4
												c-0.7-0.1-7.2-0.7-9.1,2.6c-1,1.7-1.7,4.4-0.3,6.7c0.9,1.5,3.1,3.4,8.3,3.4H24c0.1,0,0.1,0,0.2,0c0.7,0,2.3,0.1,3.2,1.7
												c0.2,0.4,0.8,0.6,1.2,0.4c0.3-0.2,0.5-0.5,0.5-0.9C29,50.9,28.7,51.2,28.2,51.2z"/>
										</g>
										<g>
											<path class="st2" d="M49,30.4c2.8,0,4.3-2.1,4.3-4.2c0-1-0.4-2-1.1-2.7c-0.5-0.6-1.6-1.3-3.2-1.3h-2h-2.3h-6
												c-3.9,0-6.7-0.9-8.3-2.7c-1.8-2-1.4-4.6-1.4-4.6c0-0.3,0-0.5-0.2-0.7c-0.2-0.2-0.4-0.3-0.7-0.3c-4.6,0-7.9-1-9.9-2.9
												c-2.5-2.5-2.4-6.2-2.3-8.8c0-0.5,0-0.9,0-1.3C16,0.4,15.6,0,15.1,0c-0.5,0-0.9,0.4-0.9,0.9c0,0.4,0,0.8,0,1.2
												c-0.1,2.8-0.3,7.1,2.8,10.1c2.2,2.1,5.6,3.3,10.2,3.4c0,1.2,0.3,3.2,1.8,5c1.9,2.2,5.2,3.3,9.7,3.3h4.1h2.7H49
												c0.8,0,1.4,0.2,1.9,0.7c0.4,0.4,0.6,1,0.6,1.6c0,1.2-0.8,2.4-2.5,2.4h-9.8c-3.6,0-11.9,4-11.9,11.8v1.2v1.8v5v2.3
												c0,0.5,0.4,0.9,0.9,0.9c0.5,0,0.8-0.3,0.9-0.8c0,0,0-0.1,0-0.1v-7v-1.8v-1.5c0-6.9,7.8-10,10.1-10H49z"/>
											<path class="st2" d="M58,18.6c-0.6-0.8-1.3-1.6-2.1-2.1c-1.5-1.1-3.4-1.6-5.6-1.6h-1.1h-1.8h-1.2c-0.5-4.4-4.6-8-9.4-8H26.6
												c-1.2,0-1.9-0.2-2.4-0.6c-0.7-0.7-0.7-2.2-0.6-3.9c0-0.5,0-0.9,0-1.4c0-0.5-0.4-0.9-0.9-0.9c-0.5,0-0.9,0.4-0.9,0.9
												c0,0.5,0,0.9,0,1.4c-0.1,2-0.1,3.9,1.1,5.2c0.8,0.8,2,1.2,3.7,1.2h10.2c4.1,0,7.6,3.3,7.6,7.1c0,0.5,0.4,0.9,0.9,0.9h2h1.8h1.3
												c2.8,0,4.7,1.1,5.9,2.7c1.2,1.5,1.8,3.6,1.9,5.6c0,0.3,0,0.5,0,0.8c0,2.8-0.9,5.6-2.8,7.4c-1,0.9-2.2,1.5-3.8,1.7
												c-0.4,0.1-0.8,0.1-1.2,0.1h-8.1c-3.8,0-7.7,2.1-7.7,6.9v0.2v1.8v20.5c0,0.5,0.4,0.9,0.9,0.9s0.9-0.4,0.9-0.9V43.4v-1.8
												c0,0,0,0,0,0c0-3.8,3-5.2,5.9-5.2h7.1h1c0.7,0,1.4-0.1,2.1-0.2c4.5-0.9,7.4-5,7.4-10.7C60,22.8,59.3,20.4,58,18.6z"/>
											<path class="st2" d="M28.4,57.6c-0.1,0-0.1,0-0.2,0c-0.5,0-0.9,0.4-0.9,0.9v2.3v3.4c0,0.5,0.4,0.9,0.9,0.9s0.9-0.4,0.9-0.9v-3.4
												v-2.3C29.1,58,28.8,57.7,28.4,57.6z"/>
										</g>
									</g>
								</svg>
								<h4 class="titleTab">Bypass Gástrico</h4>
							</a>
						</div>
						<div id="tabMangaGastrica" class="blockTab collapse show" role="tabpanel">
							<div class="row">
								<div class="col-md-6">
									<img class="img-fluid" src="files/manga-gastrica-cdmx.webp" alt="Manga Gástrica Cirugía">
								</div>
								<div class="col-md-6">
									<h4 class="titleBlock">Manga Gástrica</h4>
									<p class="text">La manga gástrica se trata mediante vía laparascópica que consiste en dejar el estómago como un tubo estrecho para toda la vida. Se elimina el 80% del tamaño del estomago aproximadamente.</p>
									<ul class="list">
										<li><i class="fa fa-check"></i>El bypass gástrico es reversible y la manga gástrica no</li>
										<li><i class="fa fa-check"></i>La manga gástrica hara que tengas menos hambre y una mayor sensación de saciedad. Además, se pierde peso de forma más rápida y la cirugía es menos invasiva</li>
										<li><i class="fa fa-check"></i>Con el bypass gástrico se llegan a perder entre 40 y 90 kilos, el doble que con la manga gástrica</li>
										<li><i class="fa fa-check"></i>Otra diferencia se encuentra en el tránsito digestivo. Con la manga gástrica no se sufren cambios, pero con el bypass gástrico si, pues, se conecta al intestino delgado dejando parte del proceso digestivo sin función</li>
									</ul>
								</div>
							</div>
						</div>
						<div id="tabBypassGastrico" class="blockTab collapse" role="tabpanel">
							<div class="row">
								<div class="col-md-6">
									<img class="img-fluid" src="files/bypass-gastrico-cdmx.webp" alt="Bypass Gástrico Cirugía">
								</div>
								<div class="col-md-6">
									<h4 class="titleBlock">Bypass Gástrico</h4>
									<p class="text">La manga gástrica se trata mediante vía laparascópica que consiste en dejar el estómago como un tubo estrecho para toda la vida. Se elimina el 80% del tamaño del estomago aproximadamente.</p>
									<ul class="list">
										<li><i class="fa fa-check"></i>El bypass gástrico es reversible y la manga gástrica no</li>
										<li><i class="fa fa-check"></i>La manga gástrica hara que tengas menos hambre y una mayor sensación de saciedad. Además, se pierde peso de forma más rápida y la cirugía es menos invasiva</li>
										<li><i class="fa fa-check"></i>Con el bypass gástrico se llegan a perder entre 40 y 90 kilos, el doble que con la manga gástrica</li>
										<li><i class="fa fa-check"></i>Otra diferencia se encuentra en el tránsito digestivo. Con la manga gástrica no se sufren cambios, pero con el bypass gástrico si, pues, se conecta al intestino delgado dejando parte del proceso digestivo sin función</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- end -->
		<!-- Candidato -->
		<section id="" class="candidato">
			<div class="container">
				<div class="row">
					<div class="col-md-8">
						<div class="title-wrap text-center">
							<h2 class="h1 title">¿Quiéres saber si eres candidato a una <br><span>cirugía bariátrica?</span></h2>
							<div class="h-decor"></div>
						</div>
						<p class="text">El primer paso es agendar tu cita de valoración en uno de mis consultorios, estoy en el Hospital Ángeles Metropolitano y en el Centro Médico ABC Observatorio, bajo valoración te podré decir si lo ideal para ti es Bypass o Manga Gástrica.</p>
						<div class="ctaBox">
							<p class="textBox">Agenda tu cita llamando al:</p>
							<p class="textBox"><a aria-label="Teléfono" href="tel:5514988820"><i class="fa fa-phone"></i>55 1498 8820</a></p>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- end -->
		<!--section-->
		<?php include('module-contact.php'); ?>
		<!--//section-->
	</div>
	<!--footer-->
	<?php include('module-footer.php'); ?>
	<!--//footer-->
	<div class="backToTop js-backToTop">
		<i class="icon icon-up-arrow"></i>
	</div>
	<!-- Socials -->
	<?php include('module-socials.php'); ?>
	<!-- end -->
	<!-- Vendors -->
	<?php include('module-libs.php'); ?>

</body>

</html>