<!DOCTYPE html>
<html lang="es">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
	<meta name="description" content="">
	<meta name="author" content="">
	<meta name="format-detection" content="telephone=no">
	<title>Dr. Enrique Hernández</title>
	<!-- Stylesheets -->
	<?php include('module-head.php'); ?>
</head>

<body class="shop-page">
	<!--header-->
	<?php include('module-header.php'); ?>
	<!--//header-->
	<div class="page-content">
		<!--section slider-->
		<div class="section mt-0" id="home">
			<div id="mainSliderWrapper">
				<div class="loading-content">
					<div class="inner-circles-loader"></div>
				</div>
				<div class="main-slider mb-0 arrows-white" id="mainSlider" data-slick='{"arrows": true, "responsive":[{"breakpoint": 768,"settings":{"arrows": false, "dots": true }}]}'>
					<div class="slide">
						<div class="img--holder" data-animation="kenburns" data-bg="files/cirugia-de-la-obesidad.webp"></div>
						<div class="slide-content center">
							<div class="vert-wrap container">
								<div class="vert">
									<div class="container">
										<h1 class="slide-txt1" data-animation="fadeInDown" data-animation-delay="1s">MANGA GÁSTRICA
											<br><b>Y BYPASS EN CDMX</b></h1>
										<h3 class="slide-txt2" data-animation="fadeInUp" data-animation-delay="1.5s">Pierde peso de manera rápida y segura con una cirugía bariátrica</h3>
										<div class="slide-btn"><a aria-label="Más información cirugía bariátrica" href="https://wa.me/5561107670?text=Hola%20Dr.%20Enrique%20me%20gustaría%20recibir%20más%20información%20sobre%20cirugía%20bariátrica." target="_blank" class="btn btn-white btnSlide" data-animation="fadeInUp" data-animation-delay="2s">CITA DE VALORACIÓN</a></div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="slide">
						<div class="img--holder" data-animation="kenburns" data-bg="files/cirugia-de-la-tiroides.webp"></div>
						<div class="slide-content center">
							<div class="vert-wrap container">
								<div class="vert">
									<div class="container">
										<h1 class="slide-txt1" data-animation="fadeInDown" data-animation-delay="1s">CIRUGÍA DE TIROIDES
											<br><b>EN CDMX</b></h1>
										<h3 class="slide-txt2" data-animation="fadeInUp" data-animation-delay="1.5s">Se hace para tratar los nódulos tiroides, el cáncer de tiroides y tumores tiroideos</h3>
										<div class="slide-btn"><a aria-label="Más información cirugía endócrina" href="https://wa.me/5561107670?text=Hola%20Dr.%20Enrique%20me%20gustaría%20recibir%20más%20información%20sobre%20cirugía%20de%20tiroides." target="_blank" class="btn btn-white btnSlide" data-animation="fadeInUp" data-animation-delay="2s">CITA DE VALORACIÓN</a></div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="slide">
						<div class="img--holder" data-animation="kenburns" data-bg="files/cirugia-de-hernias.webp"></div>
						<div class="slide-content center">
							<div class="vert-wrap container">
								<div class="vert">
									<div class="container">
										<h1 class="slide-txt1" data-animation="fadeInDown" data-animation-delay="1s">CIRUGÍA DE HERNÍA
											<br><b>UMBILICAL INGUINAL Y HIATAL</b></h1>
										<h3 class="slide-txt2" data-animation="fadeInUp" data-animation-delay="1.5s">Mejore su calidad de vida eliminando los sintomas de dolor y molestias que genera pudiendo hacer vida normal de nuevo</h3>
										<div class="slide-btn"><a aria-label="Más información" href="https://wa.me/5561107670?text=Hola%20Dr.%20Enrique%20me%20gustaría%20recibir%20más%20información%20sobre%20cirugía%20de%20hernia%20umbilical." target="_blank" class="btn btn-white btnSlide" data-animation="fadeInUp" data-animation-delay="2s">CITA DE VALORACIÓN</a></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section slider-->
		<!--Dr Hernández-->
		<div id="dr-enrique-hernandez" class="section">
			<div class="container">
				<div class="row flexRow">
					<div class="col-lg-6 order-sm-2">
						<img src="files/dr-bariatra-enrique-hernandez.webp" alt="Dr Hernández" class="img-fluid">
					</div>
					<div class="col-lg-6 order-sm-1">
						<div class="title-wrap text-center text-lg-left mt-15">
							<h2 class="h1 title">Dr. Guillermo Enrique <br> Hernández Rodríguez</h2>
						</div>
						<div class="text-left mt-3 mt-sm-0">
							<p class="p-lg text">Durante más de 7 años he atendido a mis pacientes en los mejores hospitales de la Ciudad de México, en el Centro Médico ABC y el Hospital Ángeles, realizando cirugías de calidad y excelencia como el Bypass Gástrico, Manga Gástrica, Vesícula Biliar, Apéndice, Tiroides, entre otras; las cuáles todas han tenido éxito y todos los pacientes han quedado satisfechos con los resultados.</p>
							<a aria-label="Más información dr. hernández" href="dr-enrique-hernandez" class="readMore">Leer más<i class="icon-right-arrow"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section welcome-->
		<!--Procedimientos-->
		<div id="procedimientos" class="section">
			<div class="container-fluid px-0">
				<div class="title-wrap text-center">
					<h2 class="h1 title">Procedimientos</h2>
					<div class="h-decor"></div>
				</div>
				<div class="row no-gutters services-box-wrap">
					<div class="col-12">
						<div class="service-box">
							<div class="service-box-image" data-bg="files/cirugia-bariatrica.webp"></div>
							<div class="service-box-caption service-box-left-mb text-center w-50 ml-auto">
								<h3 class="service-box-title titleBox">Cirugía Bariátrica</h3>
								<p class="text">Manga gástrica y Bypass para control y tratamiento de la obesidad. Cirugía que debe ser realizada por un cirujano bariatra. Hoy en día es una cirugía extremadamente segura, realizada por cirugía laparoscópica.</p>
								<div class="btn-wrap"><a aria-label="Más información cirugía bariátrica" href="cirugia-bariatrica" class="btn btn2">Más información</a></div>
							</div>
						</div>
					</div>
					<div class="col-12 col-xl-8">
						<div class="service-box">
							<div class="service-box-image" data-bg="files/cirugia-endocrina.webp"></div>
							<div class="service-box-caption text-center w-50 ml-auto">
								<h3 class="service-box-title titleBox">Cirugía Endócrina</h3>
								<p class="text">Cirugía enfocada a glándulas, como por ejemplo: Glándula tiroidea, páncreas, suprarrenales. Cirugía muy segura que debe ser realizada con el mayor equipo tecnológico para bienestar del paciente.</p>
								<div class="btn-wrap"><a aria-label="Más información cirugía endócrina" href="cirugia-endocrina" class="btn btn2">Más información</a></div>
							</div>
						</div>
					</div>
					<div class="col-12 col-xl-4">
						<div class="service-box-rotator js-service-box-rotator">
							<div class="service-box service-box-greybg service-box--hiddenbtn">
								<div class="service-box-caption text-center bckg3">
									<div class="service-box-icon"><img src="files/cirugia-general.svg" alt="Cirugía general"></div>
									<div class="service-box-icon-bg"><img src="files/cirugia-general.svg" alt="Cirugía general"></div>
									<h3 class="service-box-title titleBox">Cirugía General y Laparoscopía Avanzada</h3>
									<p class="text">Cirugía de vesícula biliar, hernias, cirugía de reflujo, apéndice, entre otras.</p>
									<div class="btn-wrap"><a aria-label="Más información" href="https://wa.me/5561107670?text=Hola%20Dr.%20Enrique%20me%20gustaría%20recibir%20más%20información." target="_blank" class="btn btn2">Más información</a></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section services-->
		<!--Cifras-->
		<div id="cifras" class="section">
			<div class="container">
				<div class="title-wrap text-center">
					<div class="h1 title">La experiencia genera grandes resultados</div>
					<div class="h-decor"></div>
				</div>
				<div class="row d-block js-counter-carousel">
					<div class="col">
						<div class="counter-box">
							<div class="counter-box-icon"><img src="files/bariatra-en-cdmx.svg" alt="Pacientes felices"></div>
							<div class="counter-box-number">+<span class="count" data-to="99" data-speed="1500">0</span></div>
							<div class="decor"></div>
							<div class="counter-box-text">Pacientes felices</div>
						</div>
					</div>
					<div class="col">
						<div class="counter-box">
							<div class="counter-box-icon"><img src="files/cirugia-endocrina-en-cdmx.svg" alt="Años de experiencia"></div>
							<div class="counter-box-number"><span class="count" data-to="7" data-speed="1500">0</span></div>
							<div class="decor"></div>
							<div class="counter-box-text">Años de experiencia</div>
						</div>
					</div>
					<div class="col">
						<div class="counter-box">
							<div class="counter-box-icon"><img src="files/cirujano-bariatra-enrique-hernandez.svg" alt="Títulos y congresos"></div>
							<div class="counter-box-number">+<span class="count" data-to="20" data-speed="1500">0</span></div>
							<div class="decor"></div>
							<div class="counter-box-text">Títulos y congresos</div>
						</div>
					</div>
					<div class="col">
						<div class="counter-box">
							<div class="counter-box-icon"><img src="files/cirujano-endocrino-enrique-hernandez.svg" alt="Hospitales trabajando"></div>
							<div class="counter-box-number"><span class="count" data-to="2" data-speed="1500">0</span></div>
							<div class="decor"></div>
							<div class="counter-box-text">Hospitales trabajando</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section achieved-->
		<!--Call to Action-->
		<div class="section cta">
			<div class="container-fluid px-0">
				<div class="banner-center banner-center--p-sm bg-cover" style="background-image: url(files/cirugia-bariatrica-cdmx.webp)">
					<div class="banner-center-caption text-center">
						<div class="banner-center-text1 title">Baja de peso de forma segura y rápida</div>
						<div class="banner-center-text4 text">Manga gástrica y Bypass</div>
						<a aria-label="Más información" href="https://wa.me/5561107670?text=Hola%20Dr.%20Enrique%20me%20gustaría%20recibir%20más%20información." target="_blank" class="btn btn-white btn2 btn-hover-fill mt-2 mt-sm-3 mt-lg-5">Agenda tu cita de valoración</a>
					</div>
				</div>
			</div>
		</div>
		<!--//section-->
		<!--Videos-->
		<div id="videos" class="section">
			<div class="container">
				<div class="title-wrap text-center">
					<h2 class="h1 title">Videos</h2>
					<div class="h-decor"></div>
				</div>
				<div class="special-carousel js-special-carousel row">
					<div class="col-6">
						<div class="special-card">
							<div class="special-card-photo">
								<img src="files/bypass-gastrico.webp" alt="Bypass gástrico">
								<a aria-label="Más información cirugía" href="https://www.youtube.com/watch?v=na0gpF-1S8A" class="openYtb mfp-iframe"><i class="fa fa-play"></i></a>
							</div>
						</div>
						<div class="content">
							<h4 class="titleBox">Cirugía para la obesidad: Bypass gástrico</h4>
							<p class="text">La obesidad es actualmente un problema de salud pública en México. La cirugía bariátrica es el procedimiento con mayores beneficios a corto y largo plazo sobre la obesidad y enfermedades como diabetes mellitus tipo 2, hipertensión, problemas ortopédicos, entre otros.</p>
						</div>
					</div>
					<div class="col-6">
						<div class="special-card">
							<div class="special-card-photo">
								<img src="files/manga-gastrica.webp" alt="Manga gástrica">
								<a aria-label="Más información cirugía" href="https://www.youtube.com/watch?v=Pebl2lLlxnw" class="openYtb mfp-iframe"><i class="fa fa-play"></i></a>
							</div>
						</div>
						<div class="content">
							<h4 class="titleBox">Cirugía para la obesidad: Manga gástrica.</h4>
							<p class="text">La obesidad es actualmente un problema de salud pública en México. La cirugía bariátrica es el procedimiento con mayores beneficios a corto y largo plazo sobre la obesidad y enfermedades como diabetes mellitus tipo 2, hipertensión, problemas ortopédicos, entre otros.</p>
						</div>
					</div>
					<div class="col-6">
						<div class="special-card">
							<div class="special-card-photo">
								<img src="files/cirugia-endocrina-cdmx.webp" alt="Cirugía Endócrina">
								<a aria-label="Más información cirugía" href="https://www.youtube.com/watch?v=mqfp2mKa-SI" class="openYtb mfp-iframe"><i class="fa fa-play"></i></a>
							</div>
						</div>
						<div class="content">
							<h4 class="titleBox">Cirugía Endócrina</h4>
							<p class="text">La glándula que mayormente padece alguna enfermedad es la glándula tiroidea. En el valle de México 3 de cada 10 pacientes padecen un adenoma tiroideo. Enfermedades como adenomas, cáncer papilar de tiroides, entre otras, pueden resolverse mediante la tiroidectomía.</p>
						</div>
					</div>
					<div class="col-6">
						<div class="special-card">
							<div class="special-card-photo">
								<img src="files/cirugia-de-vesicula-biliar.webp" alt="Cirugía de Vesícula biliar">
								<a aria-label="Más información cirugía" href="https://www.youtube.com/watch?v=cYL0iE8cwB0" class="openYtb mfp-iframe"><i class="fa fa-play"></i></a>
							</div>
						</div>
						<div class="content">
							<h4 class="titleBox">Cirugía Vesicular Biliar</h4>
							<p class="text">La vesícula biliar es un órgano que se encarga de almacenar la bilir que se produce en el hígado. Este órgano puede padecer Litiasis Vesicular (piedras en la vesícula), Disciencia (vaciamiento inadecuado), pólipos, entre otros. La colecistectomía o cirugía de vesícula es el tratamiento indicado y más seguro para la resolución de estas enfermedades.</p>
						</div>
					</div>
					<div class="col-6">
						<div class="special-card">
							<div class="special-card-photo">
								<img src="files/cirugia-de-hernia-inguinal.webp" alt="Cirugía de Hernia inguinal">
								<a aria-label="Más información cirugía" href="https://www.youtube.com/watch?v=enhyEfaj22c" class="openYtb mfp-iframe"><i class="fa fa-play"></i></a>
							</div>
						</div>
						<div class="content">
							<h4 class="titleBox">Cirugía de Hernia Inguinal</h4>
							<p class="text">La hernia inguinal es una padecimiento muy común tanto para hombres como mujeres, su contenido (o en su interior) presentan normalmente intestino el cual puede perforarse en caso de no operarse. Las hernias deben operarse en el momento en el que se diagnostican.</p>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section special offers-->
		<!--Testimonios-->
		<div id="testimonios" class="section py-0">
			<div class="container">
				<div class="row no-gutters">
					<div class="col-md-7 col-lg-6 mt-2 mt-lg-0">
						<div class="reviews-wrap-alt ml-auto d-flex flex-column justify-content-center">
							<div class="title-wrap text-center text-md-right">
								<h2 class="h1 title">Lo que mis <span class="theme-color">pacientes dicen</span></h2>
							</div>
							<div class="js-reviews-carousel reviews-carousel text-center text-md-right">
								<div class="review">
									<div class="star-rating"><span><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i></span></div>
									<p class="review-text">Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio obcaecati minus debitis quo, nobis quisquam eveniet aspernatur officiis laboriosam necessitatibus, voluptates quidem cupiditate! Harum doloribus earum dolorum officiis perspiciatis in quos nihil obcaecati modi. Alias.</p>
									<p class="author">- Author</p>
								</div>
								<div class="review">
									<div class="star-rating"><span><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i></span></div>
									<p class="review-text">Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio obcaecati minus debitis quo, nobis quisquam eveniet aspernatur officiis laboriosam necessitatibus, voluptates quidem cupiditate! Harum doloribus earum dolorum officiis perspiciatis in quos nihil obcaecati modi. Alias.</p>
									<p class="author">- Author</p>
								</div>
								<div class="review">
									<div class="star-rating"><span><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i><i class="icon-star"></i></span></div>
									<p class="review-text">Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio obcaecati minus debitis quo, nobis quisquam eveniet aspernatur officiis laboriosam necessitatibus, voluptates quidem cupiditate! Harum doloribus earum dolorum officiis perspiciatis in quos nihil obcaecati modi. Alias.</p>
									<p class="author">- Author</p>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-5 col-lg-6">
						<div class="centerImg">
							<img class="imgTest" src="files/cirugia-para-bajar-de-peso-testimonios.svg" alt="Testimonios">
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section testimonials-->
		<!--Blog -->
		<div id="blog" class="section">
			<div class="container">
				<div class="title-wrap text-center">
					<h2 class="h1 title">Blog</h2>
					<div class="h-decor"></div>
				</div>
				<div class="blog-grid-full blog-grid-carousel-full js-blog-grid-carousel-full mt-3 mb-0 row">
					<div class="col-md-6 col-lg-4">
						<div class="blog-post">
							<div class="post-image">
								<a aria-label="Más información blog" href="#"><img src="files/cirugia-laparoscopica.webp" alt="Cirugía laparascópica"></a>
							</div>
							<div class="blog-post-info">
								<div class="post-date">26<span>JUN</span></div>
								<div>
									<h2 class="post-title"><a aria-label="Más información blog" href="#">10 ventajas de la cirugía laparascópica</a></h2>
								</div>
							</div>
							<div class="post-teaser">Conoce las ventajas de la cirugía laparascópica y decide realizarte esta cirugía. ¡Agenda tu cita ahora!</div>
							<div class="mt-2"><a aria-label="Más información blog" href="#" class="btn btn-sm btn-hover-fill btn1">Leer más</a></div>
						</div>
					</div>
					<div class="col-md-6 col-lg-4">
						<div class="blog-post">
							<div class="post-image">
								<a aria-label="Más información blog" href="#"><img src="files/tratamiento-de-reflujo-gastroesofagico.webp" alt="Tratamiento de reflujo gastroesofágico"></a>
							</div>
							<div class="blog-post-info">
								<div class="post-date">19<span>JUN</span></div>
								<div>
									<h2 class="post-title"><a aria-label="Más información blog" href="#">¿Qué es el reflujo gastroesofágico</a></h2>
								</div>
							</div>
							<div class="post-teaser">Conoce qué es el reflujo gastroesofágico (ERGE), cuáles son las causas, los síntomas, los tratamientos y más. <br>¡Entra ahora!</div>
							<div class="mt-2"><a aria-label="Más información blog" href="#" class="btn btn-sm btn-hover-fill btn1">Leer más</a></div>
						</div>
					</div>
					<div class="col-md-6 col-lg-4">
						<div class="blog-post">
							<div class="post-image">
								<a aria-label="Más información blog" href="#"><img src="files/hipotiroidismo-e-hipertiroidismo.webp" alt="5 cosas importantes sobre la tiroides"></a>
							</div>
							<div class="blog-post-info">
								<div class="post-date">5<span>JUN</span></div>
								<div>
									<h2 class="post-title"><a aria-label="Más información blog" href="#">5 cosas importantes sobre la tiroides</a></h2>
								</div>
							</div>
							<div class="post-teaser">Descubre cuáles son los síntomas de las enfermedades de la tiroides (hipotirodismo e hipertirodismo) <br>¡Entra ahora!</div>
							<div class="mt-2"><a aria-label="Más información blog" href="#" class="btn btn-sm btn-hover-fill btn1">Leer más</a></div>
						</div>
					</div>
					<div class="col-md-6 col-lg-4">
						<div class="blog-post">
							<div class="post-image">
								<a aria-label="Más información blog" href="#"><img src="https://via.placeholder.com/370x254" alt=""></a>
							</div>
							<div class="blog-post-info">
								<div class="post-date">26<span>JUN</span></div>
								<div>
									<h2 class="post-title"><a aria-label="Más información blog" href="#">10 ventajas de la cirugía laparascópica</a></h2>
								</div>
							</div>
							<div class="post-teaser">Conoce las ventajas de la cirugía laparascópica y decide realizarte esta cirugía. ¡Agenda tu cita ahora!</div>
							<div class="mt-2"><a aria-label="Más información blog" href="#" class="btn btn-sm btn-hover-fill btn1">Leer más</a></div>
						</div>
					</div>
					<div class="col-md-6 col-lg-4">
						<div class="blog-post">
							<div class="post-image">
								<a aria-label="Más información blog" href="#"><img src="https://via.placeholder.com/370x254" alt=""></a>
							</div>
							<div class="blog-post-info">
								<div class="post-date">26<span>JUN</span></div>
								<div>
									<h2 class="post-title"><a aria-label="Más información blog" href="#">10 ventajas de la cirugía laparascópica</a></h2>
								</div>
							</div>
							<div class="post-teaser">Conoce las ventajas de la cirugía laparascópica y decide realizarte esta cirugía. ¡Agenda tu cita ahora!</div>
							<div class="mt-2"><a aria-label="Más información blog" href="#" class="btn btn-sm btn-hover-fill btn1">Leer más</a></div>
						</div>
					</div>
					<div class="col-md-6 col-lg-4">
						<div class="blog-post">
							<div class="post-image">
								<a aria-label="Más información blog" href="#"><img src="https://via.placeholder.com/370x254" alt=""></a>
							</div>
							<div class="blog-post-info">
								<div class="post-date">26<span>JUN</span></div>
								<div>
									<h2 class="post-title"><a aria-label="Más información blog" href="#">10 ventajas de la cirugía laparascópica</a></h2>
								</div>
							</div>
							<div class="post-teaser">Conoce las ventajas de la cirugía laparascópica y decide realizarte esta cirugía. ¡Agenda tu cita ahora!</div>
							<div class="mt-2"><a aria-label="Más información blog" href="#" class="btn btn-sm btn-hover-fill btn1">Leer más</a></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--//section blog posts -->
		<!--section-->
		<?php include('module-contact.php'); ?>
		<!--//section-->
	</div>
	<!--footer-->
	<?php include('module-footer.php'); ?>
	<!--//footer-->
	<div class="backToTop js-backToTop">
		<i class="icon icon-up-arrow"></i>
	</div>
	<!-- Socials -->
	<?php include('module-socials.php'); ?>
	<!-- end -->
	<!-- Vendors -->
	<?php include('module-libs.php'); ?>

</body>

</html>