$(document).ready(function() {

    // Youtube popup
    $('.openYtb').magnificPopup({
        type: 'iframe',
        iframe: {
            markup: '<div class="mfp-iframe-scaler">'+
                '<div class="mfp-close"></div>'+
                '<iframe class="mfp-iframe" frameborder="0" allowfullscreen allow="autoplay *; fullscreen *"></iframe>'+
                '</div>',
            patterns: {
                youtube: {
                    index: 'youtube.com/',
                    id: function(url) {
                        var m = url.match(/[\\?\\&]v=([^\\?\\&]+)/);
                        if ( !m || !m[1] ) return null;
                        return m[1];
                    },
                    src: '//www.youtube.com/embed/%id%?autoplay=1&iframe=true'
                },
            }
        }
    });

    // Change Icon Tab Surgery
    $('.boxSelectTab').click(function(){
        $('.iconTab').removeClass('active');
        $(this).find('.iconTab').addClass('active');
    });
});

/* Raw JS */
$(document).ready(function () {

    //hide all results divs
    $("#results").hide();
    $(".bmiresults").hide();
    $("#bmi_table").hide();
    $("#obese_moreinfo").hide();
    //Do this when Calculate button is clicked	
    $("#calc").click(function() {

        $("#calc_form").hide();
        $("#results").show();

        //get value for height - meters	
        var meters = $("input[name=meters]").val();

        //get value for weight - kilograms
        var kilograms = $("input[name=kilograms]").val();

        //calculate BMI
        var bmi = Math.round(kilograms * 10 / meters / meters) / 10;

        //calculate min weight and max weight for nomral BMI
        var minweight = meters * meters * 18.5;
        var maxweight = meters * meters * 24.9;
        var minweight = Math.round(minweight*10)/10; 
        var maxweight = Math.round(maxweight*10)/10;

        //Append values to specific HTML tags
        $(".hResults").empty().append("<span class='tBold'>Estatura:</span> " + meters + " metros");
        $(".wResults").empty().append("<span class='tBold'>Peso:</span> " + kilograms + " kilogramos");
        $(".bmiNum").empty().append(bmi);
        $(".MinW").empty().append(minweight);
        $(".MaxW").empty().append(maxweight);

        // Active class box
        $('.boxesResults .box').removeClass('active');
        
        //---------Show divs based on BMI value--------	
        if (bmi <= 12) {
            //error
            $(".bmiresults").hide();
            $("#error").show();
            $("#bmi_table").hide();
        }
        else if (bmi > 12 && bmi < 18.5) {
            //underweight
            $(".bmiresults").hide();
            $(".bmi_type").empty().append("Bajo peso");
            $("#underweight").show();
            $('[class^="T_"]').addClass("highlight").not(".T_underweight").removeClass("highlight");
            $("#bmi_table").show();
        }
        else if (bmi >= 18.5 && bmi <25){
            //normal
            $(".bmiresults").hide();
            $(".bmi_type").empty().append("Peso saludable");
            $("#normal").show();
            $('[class^="T_"]').addClass("highlight").not(".T_normal").removeClass("highlight");
            $("#bmi_table").show();
            $('.boxesResults .box1').addClass('active');
            
        }
        else if (bmi >= 25 && bmi <30){
            //overweight
            $(".bmiresults").hide();
            $(".bmi_type").empty().append("Sobrepeso");
            $("#overweight").show();
            $("#obese_moreinfo").show();
            $('[class^="T_"]').addClass("highlight").not(".T_overweight").removeClass("highlight");
            $("#bmi_table").show();
            $('.boxesResults .box2').addClass('active');			
        }
        else if (bmi >=30 && bmi <=34.9) {
            //obese
            $(".bmiresults").hide();
            $(".bmi_type").empty().append("Obesidad I");
            $("#obese").show();
            $("#obese_moreinfo").show();
            $('[class^="T_"]').addClass("highlight").not(".T_obese").removeClass("highlight");
            //$(".T_obese").removeClass().addClass("highlight");
            $("#bmi_table").show();
            $('.boxesResults .box3').addClass('active');
        }
        else if (bmi >=35 && bmi <=39.9) {
            //obese II
            $(".bmiresults").hide();
            $(".bmi_type").empty().append("Obesidad II");
            $("#obese2").show();
            $("#obese_moreinfo_2").show();
            $('[class^="T_"]').addClass("highlight").not(".T_obese_2").removeClass("highlight");
            //$(".T_obese").removeClass().addClass("highlight");
            $("#bmi_table").show();
            $('.boxesResults .box4').addClass('active');
        }
        else if (bmi >=40) {
            //obese II
            $(".bmiresults").hide();
            $(".bmi_type").empty().append("Obesidad III");
            $("#obese3").show();
            $("#obese_moreinfo_3").show();
            $('[class^="T_"]').addClass("highlight").not(".T_obese_3").removeClass("highlight");
            //$(".T_obese").removeClass().addClass("highlight");
            $("#bmi_table").show();
            $('.boxesResults .box5').addClass('active');
        }
        else {
            //error
            $(".bmiresults").hide();
            $("#error").show();
            $("#bmi_table").hide();
        }
        //------------	
        //remove values from input fields
        $('#bmicalculator').find('input:text').val('');
    });
});
/* End Raw JS */

