<!DOCTYPE html>

<html lang="es">

<head>

    <!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Defensa de escuelas particulares, FEDEP, Defensa Escuelas Privadas, Representación de Escuelas Particulares, Asesoría Legal Para Escuelas Particulares, Servicios legales para Escuelas Particulares, Servicio Legal Especializado en Materia Educativa" />
    <meta name="author" content="" />
    <meta name="robots" content="LeadME Internet Marketing" />    
    <meta name="description" content="Reunimos, Asesoramos, Defendemos y Representamos a todas las Escuelas Particulares en la República Mexicana, que requieran de cualquier tipo de asistencia o servicio legal especializado en materia educativa." />
    
    <!-- FAVICONS ICON -->
    <link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
    <link rel="manifest" href="archivos/favicon/site.webmanifest">
    <link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">
    
    <!-- PAGE TITLE HERE -->
    <title>Defensa Legal | FEDEP</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
    <![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <!-- FLATICON STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <!-- ANIMATE STYLE SHEET --> 
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <!-- BOOTSTRAP SELECT BOX STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <!-- LOADER STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/loader.min.css">    
    <!-- MAIN STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <!-- THEME COLOR CHANGE STYLE SHEET -->
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-1.css">
    <!-- CUSTOM  STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/custom.css">

 
</head>

<body>

    <div class="page-wraper">
        	
        <!-- HEADER START -->
        <header id="header-interior" class="site-header header-style-1 ">
        
            <div class="top-bar">
                <div class="container">
                    <div class="row">
                        <div class="wt-topbar-right clearfix">
                            <ul class="social-bx list-inline pull-right social-header">
                                <li><a href="https://www.facebook.com/pg/fedepmexico" target="_blank" class="fa fa-facebook"></a></li>
                                <li><a href="#" target="_blank" class="fa fa-linkedin"></a></li>
                                <li><a href="https://twitter.com/fedep_mexico" target="_blank" class="fa fa-twitter"></a></li>
                            </ul>
                            <ul class="list-unstyled e-p-bx pull-right info-list-header">
                                <li>
                                    <a href="mailto:contacto@fedep.org">
                                        <i class="fa fa-envelope"></i>
                                        contacto@fedep.org
                                    </a>
                                </li>
                                <li>
                                    <a href="tel:5572612117">
                                        <i class="fa fa-phone"></i>
                                        +52 (55) 7261-2117
                                    </a>
                                </li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="sticky-header main-bar-wraper">
                <div class="main-bar bg-white">
                    <div class="container">
                        <div class="logo-header">
                            <a href="index.php">
                                <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP" />
                            </a>
                        </div>
                        <!-- NAV Toggle Button -->
                        <button data-target=".header-nav" data-toggle="collapse" type="button" class="navbar-toggle collapsed">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        
                        <!-- MAIN Vav -->
                        <div class="header-nav navbar-collapse collapse ">
                            <ul class=" nav navbar-nav">
                                <li class="">
                                    <a href="index.php">Inicio</a>
                                </li>
                            
                                <li class="">
                                    <a href="nosotros.php">Nosotros</a>
                                </li>
                                
                                <li class="">
                                    <a href="servicios.php">Servicios</a>
                                </li>
                            
                                <li>
                                    <a href="afiliaciones.php">Afiliaciones</a>
                                </li>
                                
                                <li class="">
                                    <a href="circulares.php">Circulares</a>
                                </li>
                                
                                <li class="">
                                    <a href="publicaciones.php">Publicaciones</a>
                                </li>

                                <li class="">
                                    <a href="prensa.php">Prensa</a>
                                </li>

                                <li class="">
                                    <a class="scroll" href="#contacto">Contacto</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
        </header>
        <!-- HEADER END -->
            
        <!-- CONTENT START -->
        <div class="page-content">
            
            <!-- PAGE BANNER -->
            <div class="wt-bnr-inr overlay-wraper" style="background-image:url(archivos/servicios-interior/fedep-defensa-legal.jpg);">
                <!-- fedep-defensa-legal.jpg -->
                <div class="overlay-main bg-black opacity-04"></div>
                <div class="container">
                    <div class="wt-bnr-inr-entry">
                        <h1 class="text-white">Defensa Legal</h1>
                    </div>
                </div>
            </div>
            <!-- END --> 
            
            <div id="defensa-legal" class="section-full p-tb80">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- 1 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-defensa.svg" alt="">
                                    <p class="title">Impugnación de Oficios, Requerimientos y Sanciones de la SEP</p>
                                </div>
                                <p class="description">Desafortunadamente la Secretaría de Educación Pública, a través de las distintas <strong>Direcciones de Incorporación de Escuelas Particulares</strong>, cada día busca aumentar a cualquier costo el número de alumnos que "egresan" cada año de los respectivos grados escolares, sin importarle realmente la calidad de la educación que los niños y jóvenes reciben, amedrentando más y más a las escuelas particulares con argumentos como "...está estrictamente prohibido negar la inscripción o la reinscripción de cualquier alumno, ya que dicha negativa constituye una violación a la garantía de educación prevista en el artículo 3° de la Constitución...", <strong>argumento totalmente inconstitucional que resulta perfectamente atacable</strong> a través de distintas instancias (Recurso de Revisión, Juicio de Nulidad ante el Tribunal Federal de Justicia Fiscal y Administrativa o ante el Tribunal Contencioso Administrativo Estatal correspondiente, Amparo, etc.)</p>
                                <p class="description">En la FEDEP contamos con más de 15 años de éxito en la impugnación a nivel Estatal y Federal de todo tipo de oficios, requerimientos, amonestaciones y sanciones emitidas por la Secretaría de Educación Pública, a través de la asistencia directa de un Despacho de Abogados especializado en la materia, con reconocimiento internacional y presencia en más de 26 países.</p>
                            </div>
                            <!-- 2 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-defensa.svg" alt="">
                                    <p class="title">Asistencia para Inspecciones de todo tipo de Autoridades</p>
                                </div>
                                <p class="description">Todos los días distintas Autoridades llegan con nuestros Afiliados en todo el País para realizar todo tipo de inspecciones (Protección Civil, Instituto Nacional del Derecho de Autor, Procuraduría Federal del Consumidor, Secretaría del Trabajo y Previsión Social, Secretaría de Hacienda y Crédito Público, Secretaría de Educación Pública, Secretaría de Desarrollo Urbano, Catastro, Comisión Nacional del Agua, y muchas otras Autoridades a nivel Federal, Estatal o Municipal), sin que las escuelas privadas sepan bien cómo defenderse, cómo deben llevarse a cabo dichas inspecciones, ni cuáles son sus derechos... muchas veces esas mismas inspecciones son ilegales y desgraciadamente tienen como única finalidad buscar o inventar una "irregularidad" a fin de extorsionar a los particulares.</p>
                                <p class="description">La mayoría de las instituciones académicas desconocen que toda inspección de Autoridad debe encontrarse debidamente fundada y motivada por escrito, y debe de notificarse de manera previa y con tiempo suficiente a fin de que el particular pueda atender y desahogar la visita como es debido. Las "pesquisas" y todo tipo de "visitas sorpresa" sin notificación previa y por escrito son en el 99% de los casos ilegales y las escuelas están perfectamente legitimadas para negar la entrada a sus instalaciones, siempre y cuando se cuente con los elementos suficientes y se expongan los motivos correctos.</p>
                                <p class="description">En la FEDEP asesoramos en tiempo real a todos nuestros Afiliados para el debido desahogo de todo tipo de inspecciones, incluyendo la asistencia para la legal oposición contra aquellas visitas "sorpresa" que son totalmente ilegales.</p>
                            </div>
                            <!-- 3 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-defensa.svg" alt="">
                                    <p class="title">Procedimientos ante PROFECO</p>
                                </div>
                                <p class="description">Cada día es más común que los Padres de Familia traten de pelear las medidas disciplinarias y de libre actuación de las Escuelas, ya sea ante la SEP o bien ante PROFECO  (o ambas). Es por eso que asistimos a nuestros Afiliados en del debido desahogo de todo tipo de procesos ante la Procuraduría Federal del Consumidor, incluyendo la preparación de informes y extractos, preparación de convenios, contestación de requerimientos, impugnación de multas y sanciones, etc.</p>
                            </div>
                            <!-- 4 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-defensa.svg" alt="">
                                    <p class="title">Secretaría de Desarrollo Urbano y Vivienda y Catastro (y sus símiles en otros Estados)</p>
                                </div>
                                <p class="description">Muchos de nuestros Afiliados experimentan en determinados momentos de algún tipo de problema con la Autoridad relacionado con el levantamiento de nuevas construcciones dentro de sus planteles, el mantenimiento, remodelación o regularización de instalaciones, pagos de impuesto predial, etcétera. Es por esto que asistimos a todas las escuelas privadas que lo requieran en todos y cada uno de los procedimientos ante este tipo de Autoridades, incluyendo estrategias fiscales para la reducción del impuesto predial, levantamiento de clausura de instalaciones, regularización de construcciones, declaración de prescripción de impuestos y contribuciones no pagadas, devolución de pago de derechos, etc.</p>
                            </div>
                            <!-- 5 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-defensa.svg" alt="">
                                    <p class="title">Impugnación de Resoluciones, Requerimientos y Sanciones de todo tipo de Autoridades</p>
                                </div>
                                <p class="description">Contamos con más de 15 años de éxito en materia de Litigio Administrativo, asistiendo de manera integral a todos nuestros Afiliados a fin de llevar a cabo una debida y oportuna defensa contra cualquier acto de Autoridad, ya sea a nivel Federal, Estatal y/o Municipal, en cualquier parte de la República Mexicana (requerimientos, procedimientos administrativos, amonestaciones,  sanciones, multas, clausuras, etc.), a través de todas y cada una de las distintas vías que marca la Ley (Recurso de Revisión, Juicio de Nulidad, Amparo Directo, Amparo Indirecto, Procedimientos de Responsabilidad en contra de Funcionarios Públicos, etcétera).</p>
                            </div>
                            <!-- 6 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-defensa.svg" alt="">
                                    <p class="title">Otros Procedimientos Judiciales (Juicios Civiles, Mercantiles, Laborales, Penales)</p>
                                </div>
                                <p class="description">Todos nuestros Afiliados cuentan con asesoría legal especializada, por peritos en cada materia, integrantes de algunos de los mejores Despachos de Abogados  del País, para la interposición, defensa, ventilación y desahogo de todo tipo de juicios en materia civil, mercantil, laboral y/o penal), en toda la República Mexicana.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            
            

            <?php 
                include('contacto.php');
             ?>
            <!-- END -->  
                    
        </div>
        <!-- CONTENT END -->
        
        <!-- FOOTER START -->
        <?php 
            include('footer.php');
         ?>
        <!-- FOOTER END -->
            
    </div>
    <?php include('subscribe-form.php'); ?>
    
<!-- LOADING AREA START ===== -->
<div class="loading-area">
    <div class="loading-box"></div>
    <div class="loading-pic">
        <div class="cssload-container">
            <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP">
        </div>
    </div>
</div>
<!-- LOADING AREA  END ====== -->
<!-- JAVASCRIPT  FILES ========================================= --> 
<script   src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script   src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->

<script   src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script   src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->

<script   src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->

<script   src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script   src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script   src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->

<script  src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->

<script   src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->

<script   src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script   src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   --> 

<script   src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->
<script   src="js/shortcode.js"></script><!-- SHORTCODE FUCTIONS  -->

</body>

</html>
