<!DOCTYPE html>

<html lang="es">

<head>

    <!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Defensa de escuelas particulares, FEDEP, Defensa Escuelas Privadas, Representación de Escuelas Particulares, Asesoría Legal Para Escuelas Particulares, Servicios legales para Escuelas Particulares, Servicio Legal Especializado en Materia Educativa" />
    <meta name="author" content="" />
    <meta name="robots" content="LeadME Internet Marketing" />    
    <meta name="description" content="Reunimos, Asesoramos, Defendemos y Representamos a todas las Escuelas Particulares en la República Mexicana, que requieran de cualquier tipo de asistencia o servicio legal especializado en materia educativa." />
    
    <!-- FAVICONS ICON -->
    <link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
    <link rel="manifest" href="archivos/favicon/site.webmanifest">
    <link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">
    
    <!-- PAGE TITLE HERE -->
    <title>Preguntas Frecuentes | FEDEP</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
    <![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <!-- FLATICON STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <!-- ANIMATE STYLE SHEET --> 
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <!-- BOOTSTRAP SELECT BOX STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <!-- LOADER STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/loader.min.css">    
    <!-- MAIN STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <!-- THEME COLOR CHANGE STYLE SHEET -->
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-1.css">
    <!-- CUSTOM  STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/custom.css">

 
</head>

<body>

    <div class="page-wraper">
        	
        <!-- HEADER START -->
        <header id="header-interior" class="site-header header-style-1 ">
        
            <div class="top-bar">
                <div class="container">
                    <div class="row">
                        <div class="wt-topbar-right clearfix">
                            <ul class="social-bx list-inline pull-right social-header">
                                <li><a href="https://www.facebook.com/pg/fedepmexico" target="_blank" class="fa fa-facebook"></a></li>
                                <li><a href="#" target="_blank" class="fa fa-linkedin"></a></li>
                                <li><a href="https://twitter.com/fedep_mexico" target="_blank" class="fa fa-twitter"></a></li>
                            </ul>
                            <ul class="list-unstyled e-p-bx pull-right info-list-header">
                                <li>
                                    <a href="mailto:contacto@fedep.org">
                                        <i class="fa fa-envelope"></i>
                                        contacto@fedep.org
                                    </a>
                                </li>
                                <li>
                                    <a href="tel:5572612117">
                                        <i class="fa fa-phone"></i>
                                        +52 (55) 7261-2117
                                    </a>
                                </li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="sticky-header main-bar-wraper">
                <div class="main-bar bg-white">
                    <div class="container">
                        <div class="logo-header">
                            <a href="index.php">
                                <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP" />
                            </a>
                        </div>
                        <!-- NAV Toggle Button -->
                        <button data-target=".header-nav" data-toggle="collapse" type="button" class="navbar-toggle collapsed">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        
                        <!-- MAIN Vav -->
                        <div class="header-nav navbar-collapse collapse ">
                            <ul class=" nav navbar-nav">
                                <li class="">
                                    <a href="index.php">Inicio</a>
                                </li>
                            
                                <li class="">
                                    <a href="nosotros.php">Nosotros</a>
                                </li>
                                
                                <li class="">
                                    <a href="servicios.php">Servicios</a>
                                </li>
                            
                                <li class="">
                                    <a href="afiliaciones.php">Afiliaciones</a>
                                </li>
                                
                                <li class="">
                                    <a href="circulares.php">Circulares</a>
                                </li>
                                
                                <li class="">
                                    <a href="publicaciones.php">Publicaciones</a>
                                </li>

                                <li class="">
                                    <a href="prensa.php">Prensa</a>
                                </li>

                                <li class="">
                                    <a class="scroll" href="#contacto">Contacto</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
        </header>
        <!-- HEADER END -->
            
        <!-- CONTENT START -->
        <div class="page-content">
            
            <!-- PAGE BANNER -->
            <div id="banner-faq" class="wt-bnr-inr overlay-wraper" style="background-image:url(archivos/servicios-interior/fedep-FAQ.jpg);">
                <!-- fedep-FAQ.jpg -->
                <div class="overlay-main bg-black opacity-04"></div>
                <div class="container">
                    <div class="wt-bnr-inr-entry">
                        <h1 class="text-white">Preguntas Frecuentes</h1>
                    </div>
                </div>
            </div>
            <!-- END --> 

            <div id="faq" class="section-full p-tb80">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="wt-accordion acc-bg-gray" id="accordion5">
                                <div class="panel wt-panel">
                                    <div class="acod-head acc-actives">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question open" data-toggle="collapse" href="#collapseOne5" data-parent="#accordion5" >
                                                ¿Cuántos tipos de Afiliaciones existen?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseOne5" class="acod-body collapse in">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">En la FEDEP manejamos 2 distintos tipos de Afiliaciones, cuyas aportaciones se calculan con base en el número de alumnos de cada escuela,  lo que nos permite ofrecer costos accesibles a todas las escuelas del país, independientemente del sector socio-económico al que estén dirigidas o del número de alumnos que tengan.</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseTwo5" data-parent="#accordion5" >
                                                ¿Todas las Afiliaciones incluyen la defensa ante las distintas Autoridades sin costo adicional?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseTwo5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">Es correcto. <strong>El servicio de Defensa en contra de todo tipo de actos de Autoridad, ya sea a nivel Federal, Estatal o Municipal, se encuentra incluido para todos y cada uno de nuestros Afiliados.</strong> El único cargo que hacemos por cada proceso judicial o administrativo que se lleve a cabo, corresponde exclusivamente a gastos (papelería, gastos de transporte a las dependencias o tribunales, envío de documentos por paquetería, etcétera), mediante el cobro de una cuota mensual simbólica durante cada proceso. </p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseThree5" data-parent="#accordion5" >
                                                ¿Cómo funciona la defensa ante las distintas Autoridades? 
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseThree5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">Pedimos a todos nuestros Afiliados que nos informen de manera inmediata y tan pronto lo reciban, cualquier tipo de notificación, sanción o requerimiento de una Autoridad, enviándonos copia escaneada y legible de la misma. Dicho escrito se analiza en un plazo máximo de 2 días hábiles con la finalidad de contactar a la escuela respectiva para solicitar la información y documentación que corresponda.</p>
                                            <p class="answer">En la mayoría de los casos, la propia FEDEP se encarga del ingreso de los recursos y escritos correspondientes ante las Autoridades o Tribunales que correspondan, cuando se trata de Afiliados dentro de la CDMX y Área Metropolitana.</p>
                                            <p class="answer">Para Afiliados en el interior de la República, la FEDEP se encarga del envío de los documentos finales y listos a cada Afiliado, únicamente para que pueda ingresarlos ante las dependencias que correspondan.</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseFour5" data-parent="#accordion5" >
                                                ¿Existe un límite del número de procedimientos que puede llevar la FEDEP sin costo adicional?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseFour5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">No. Todos los procedimientos e instancias de defensa administrativa contra actos de Autoridad para cada uno de nuestros Colegios están incluidos dentro de su Afiliación.</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseFive5" data-parent="#accordion5" >
                                                ¿Qué garantía tienen los servicios de la FEDEP?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseFive5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">La FEDEP es la única organización especializada en la defensa, asistencia y atención integral de escuelas particulares en México con cláusula de garantía en todos y cada uno de los servicios que otorga. Esta cláusula viene dentro de la póliza de suscripción que se manda a cada Afiliado al momento de su inscripción.</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseSix5" data-parent="#accordion5" >
                                                ¿Necesito estar Afiliado para hacer uso de los servicios de la FEDEP?
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseSix5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">Sí. Nuestros servicios se encuentran reservados exclusivamente para todos  nuestros Afiliados.</p>
                                        </div>
                                    </div>
                                </div> 
                                
                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseSeven5" data-parent="#accordion5" >
                                                ¿Qué Estados de la República abarca la FEDEP?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseSeven5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">Nuestros servicios están disponibles para todas las escuelas particulares en cualquier Estado de la República Mexicana.</p>
                                        </div>
                                    </div>
                                </div>    

                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseEight5" data-parent="#accordion5" >
                                                ¿Qué requisitos hay que cubrir para poder inscribirse a la FEDEP?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseEight5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">1. Ser escuela particular con validez de estudios, debidamente reconocida por la SEP, UNAM u otra Autoridad Educativa.</p>
                                            <p class="answer">2. Solicitar la cotización de afiliaciones al correo electrónico <a style="background: transparent;" href="mailto:afiliaciones@fedep.org"><strong>afiliaciones@fedep.org</strong></a>, indicando el número de planteles y alumnos por cada uno de ellos.</p>
                                            <p class="answer">3. Firmar el contrato de afiliación.</p>
                                            <p class="answer">4. Pagar la cuota correspondiente.</p>
                                        </div>
                                    </div>
                                </div> 

                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseNine5" data-parent="#accordion5" >
                                                ¿Cuántas escuelas se encuentran afiliadas actualmente?  
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseNine5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">A junio de 2019 la FEDEP cuenta con 400 escuelas afiliadas aproximadamente, en 22 Estados de la República Mexicana.</p>
                                        </div>
                                    </div>
                                </div> 

                                <div class="panel wt-panel">
                                    <div class="acod-head">
                                        <h6 class="acod-title text-uppercase">
                                            <a class="question" data-toggle="collapse" href="#collapseTen5" data-parent="#accordion5" >
                                                ¿Puedo afiliarme a la FEDEP a la mitad de un ciclo escolar? 
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                            </a>
                                        </h6>
                                    </div>
                                    <div id="collapseTen5" class="acod-body collapse">
                                        <div class="acod-content p-tb15">
                                            <p class="answer">Sí. La inscripción a la FEDEP puede realizarse por cualquier escuela o institución académica privada en cualquier momento del año.</p>
                                        </div>
                                    </div>
                                </div>                                
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <?php 
                include('contacto.php');
             ?>
            <!-- END -->  
                    
        </div>
        <!-- CONTENT END -->
        
        <!-- FOOTER START -->
        <?php 
            include('footer.php');
         ?>
        <!-- FOOTER END -->
            
    </div>
    <?php include('subscribe-form.php'); ?>
    
<!-- LOADING AREA START ===== -->
<div class="loading-area">
    <div class="loading-box"></div>
    <div class="loading-pic">
        <div class="cssload-container">
            <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP">
        </div>
    </div>
</div>
<!-- LOADING AREA  END ====== -->
<!-- JAVASCRIPT  FILES ========================================= --> 
<script   src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script   src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->

<script   src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script   src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->

<script   src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->

<script   src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script   src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script   src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->

<script  src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->

<script   src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->

<script   src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script   src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   --> 

<script   src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->
<script   src="js/shortcode.js"></script><!-- SHORTCODE FUCTIONS  -->
<script>
    $(document).ready(function(){
        $('.question').on('click', function(){
            if ($(this).attr('aria-expanded') === "true") {
                $('.question').css({'background-color': '#f2f2f2', 'color': '#000'});
                $(this).css({'background-color': '#f2f2f2', 'color': '#000'});
            }else if($(this).attr('aria-expanded') === "false"){
                $('.question').css({'background-color': '#f2f2f2', 'color': '#000'});
                $(this).css({'background-color': '#000', 'color': '#cfdb00'});
            }else{
                $('.question').css({'background-color': '#f2f2f2', 'color': '#000'});
                $('.question').removeClass('open');
                $(this).css({'background-color': '#000', 'color': '#cfdb00'});
            }
        }); 
    });
    
</script>

</body>

</html>
