<!DOCTYPE html>

<html lang="es">

<head>

	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Defensa de escuelas particulares, FEDEP, Defensa Escuelas Privadas, Representación de Escuelas Particulares, Asesoría Legal Para Escuelas Particulares, Servicios legales para Escuelas Particulares, Servicio Legal Especializado en Materia Educativa" />
    <meta name="author" content="" />
    <meta name="robots" content="LeadME Internet Marketing" />    
    <meta name="description" content="Reunimos, Asesoramos, Defendemos y Representamos a todas las Escuelas Particulares en la República Mexicana, que requieran de cualquier tipo de asistencia o servicio legal especializado en materia educativa." />
    
    <!-- FAVICONS ICON -->
    <link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
    <link rel="manifest" href="archivos/favicon/site.webmanifest">
    <link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">
    
    <!-- PAGE TITLE HERE -->
    <title>FEDEP – Federación para la Defensa de Escuelas Particulares</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
	<![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <!-- FLATICON STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <!-- ANIMATE STYLE SHEET --> 
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <!-- BOOTSTRAP SELECT BOX STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <!-- LOADER STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/loader.min.css">    
    <!-- MAIN STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <!-- THEME COLOR CHANGE STYLE SHEET -->
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-7.css">
    <!-- CUSTOM  STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/custom.css">
   

    
    <!-- REVOLUTION SLIDER CSS -->
    <link rel="stylesheet" type="text/css" href="plugins/revolution/revolution/css/settings.css">
    <!-- REVOLUTION NAVIGATION STYLE -->
    <link rel="stylesheet" type="text/css" href="plugins/revolution/revolution/css/navigation.css">

</head>

<body>
 
	<div class="page-wraper"> 
       	
        <!-- HEADER START -->
        <header class="site-header header-style-3 ">
			<!-- Search Form -->

            <div class="sticky-header main-bar-wraper">
                <div class="main-bar bg-white">
                    <div class="container">
                        <div class="logo-header">
                            <a href="index.php">
                                <img src="archivos/logo/logo-fedep.svg" alt="FEDEP" />
                            </a>
                        </div>
                        <!-- NAV Toggle Button -->
                        <button data-target=".header-nav" data-toggle="collapse" type="button" class="navbar-toggle collapsed">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <!-- ETRA Nav -->
                        <!-- MAIN Vav -->
                        <div class="header-nav navbar-collapse collapse ">
                            <ul class=" nav navbar-nav">
                                <li class="active">
                                    <a href="index.php">Inicio</a>
                                </li>
                            
                                <li>
                                    <a href="nosotros.php">Nosotros</a>
                                </li>
                                
                                <li>
                                    <a href="servicios.php">Servicios</a>
                                </li>
                            
                                <li>
                                    <a href="afiliaciones.php">Afiliaciones</a>
                                </li>
                                
                                <li class="">
                                    <a href="circulares.php">Circulares</a>
                                </li>
                                
                                <li class="">
                                    <a href="publicaciones.php">Publicaciones</a>
                                </li>

                                <li class="">
                                    <a href="prensa.php">Prensa</a>
                                </li>

                                <li class="">
                                    <a class="scroll" href="#contacto">Contacto</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
        </header>
        <!-- HEADER END -->
        
        <!-- CONTENT START -->
        <div class="page-content">
        

			<div id="rev_slider_149_1_wrapper" class="rev_slider_wrapper fullscreen-container" data-alias="snowaddon1" data-source="gallery" style="background-color:#2d3032;padding:0px;">
                <div id="rev_slider_149_1" class="rev_slider fullscreenbanner" style="display:none;" data-version="5.4.1">
                    <ul>	<!-- SLIDE  -->
                        <li class="slide1" data-index="rs-407" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="2000"  data-thumb="archivos/home/slider/defensa-escuelas-particulares.jpg"  data-rotate="0"  data-fstransition="fade" data-fsmasterspeed="1000" data-fsslotamount="7" data-saveperformance="off"  data-title="One" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                            <!-- MAIN IMAGE -->
                            <img src="archivos/home/slider/defensa-escuelas-particulares.jpg"  alt="DEFENSA DE ESCUELAS PARTICULARES"  data-bgposition="center center" data-kenburns="on" data-duration="20000" data-ease="Linear.easeNone" data-scalestart="130" data-scaleend="100" data-rotatestart="0" data-rotateend="0" data-offsetstart="0 0" data-offsetend="0 0" data-bgparallax="6" class="rev-slidebg" data-no-retina>
                            <!-- defensa-escuelas-particulares.jpg -->
                            <!-- LAYERS -->
                            <div id="rrzm_407" class="rev_row_zone rev_row_zone_middle" style="z-index: 6;">
                    
                            <!-- LAYER NR. 1 -->
                            <div class="tp-caption  " 
                                id="slide-407-layer-14" 
                                data-x="['left','left','left','left']" data-hoffset="['100','100','100','100']" 
                                data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                data-width="none"
                                data-height="none"
                                data-whitespace="nowrap"
                     
                                data-type="row" 
                                data-columnbreak="2" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                                data-responsive="off"
                                data-frames='[{"delay":10,"speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','inherit','inherit']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[100,50,50,50]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[100,50,50,50]"
                    
                                style="z-index: 6; white-space: nowrap; font-size: 20px; line-height: 22px; font-weight: 400; color: rgba(255, 255, 255, 1.00);">
                            <!-- LAYER NR. 2 -->
                            <div class="tp-caption  " 
                                 id="slide-407-layer-15" 
                                 data-x="['left','left','left','left']" data-hoffset="['100','100','100','100']" 
                                 data-y="['top','top','top','top']" data-voffset="['100','100','100','100']" 
                                            data-width="none"
                                data-height="none"
                                data-whitespace="nowrap"
                     
                                data-type="column" 
                                data-responsive_offset="on" 
                                data-responsive="off"
                                data-frames='[{"delay":"+0","speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                     			data-columnwidth="100%"
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['center','center','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 7; width: 100%;">
                            <!-- LAYER NR. 3 -->
                            <h1 class="tp-caption   tp-resizeme title-slide" 
                                 id="slide-407-layer-1" 
                                 data-x="['left','left','center','center']" data-hoffset="['0','0','0','0']" 
                                 data-y="['top','top','top','top']" data-voffset="['0','0','230','110']" 
                                            data-fontsize="['110','90','100','70']"
                                data-lineheight="['100','90','100','70']"
                                data-width="['none','none','697','399']"
                                data-height="none"
                                data-whitespace="['normal','normal','normal','normal']"
                     
                                data-type="text" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                    
                                data-frames='[{"delay": 500,"speed": 300, "from": "opacity: 0", "to": "opacity: 1"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[30,20,30,30]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,40,40]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,40,40]"
                    
                                style="z-index: 8;">FEDERACIÓN PARA LA DEFENSA 
                            DE ESCUELAS PARTICULARES</h1>
                    
                            <!-- LAYER NR. 4 -->
                            <p class="tp-caption   tp-resizeme subtitle-slide" 
                                 id="slide-407-layer-2" 
                                 data-x="['left','left','center','center']" data-hoffset="['0','50','0','0']" 
                                 data-y="['top','top','top','top']" data-voffset="['0','430','460','290']" 
                                            data-fontsize="['30','30','40','25']"
                                data-lineheight="['40','40','50','30']"
                                data-width="['none','100%','100%','100%']"
                                data-height="none"
                                data-whitespace="normal"
                     
                                data-type="text" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                    
                                data-frames='[{"delay":"+890","split":"chars","splitdelay":0.03,"speed":300,"frame":"0","from":"sX:2;sY:2;opacity:0;fb:5px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},
                                {"delay":"wait","speed":1000,"frame":"999","to":"opacity:0;fb:10px;","ease":"Power4.easeOut"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 9;">Asesoría, Defensa, Representación y Soluciones</p>
                                    </div>
                                </div>
                            </div>
                    
                            <!-- LAYER NR. 5 -->
                            <div class="tp-caption tp-shape tp-shapewrapper " 
                                id="slide-407-layer-16" 
                                data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
                                data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                data-width="full"
                                data-height="full"
                                data-whitespace="normal"
                     
                                data-type="shape" 
                                data-basealign="slide" 
                                data-responsive_offset="off" 
                                data-responsive="off"
                                data-frames='[{"delay":10,"speed":2000,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power4.easeOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                                data-textAlign="['inherit','inherit','inherit','inherit']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 5;background-color:rgba(0, 0, 0, 0.35);"> </div>
                        </li>
                        <!-- SLIDE  -->
                        <li class="slide2" data-index="rs-408" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="2000"  data-thumb="archivos/home/slider/blindaje-juridico.jpg"  data-rotate="0"  data-saveperformance="off"  data-title="Two" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                            <!-- MAIN IMAGE -->
                            <img src="archivos/home/slider/blindaje-juridico.jpg"  alt="BLINDAJE JURÍDICO"  data-bgposition="center center" data-kenburns="on" data-duration="20000" data-ease="Linear.easeNone" data-scalestart="130" data-scaleend="100" data-rotatestart="0" data-rotateend="0" data-offsetstart="0 0" data-offsetend="0 0" data-bgparallax="6" class="rev-slidebg" data-no-retina>
                            <!-- blindaje-juridico.jpg -->
                            <!-- LAYERS -->
                            <div id="rrzm_408" class="rev_row_zone rev_row_zone_middle" style="z-index: 6;">
                    
                            <!-- LAYER NR. 6 -->
                            <div class="tp-caption  " 
                                id="slide-408-layer-14" 
                                data-x="['left','left','left','left']" data-hoffset="['100','100','100','100']" 
                                data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                data-width="none"
                                data-height="none"
                                data-whitespace="nowrap"
                     
                                data-type="row" 
                                data-columnbreak="2" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                                data-responsive="off"
                                data-frames='[{"delay":10,"speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','inherit','inherit']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[100,50,40,40]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[100,50,40,40]"
                    
                                style="z-index: 6; white-space: nowrap; font-size: 20px; line-height: 22px; font-weight: 400; color: rgba(255, 255, 255, 1.00);">
                            <!-- LAYER NR. 7 -->
                            <div class="tp-caption  " 
                                id="slide-408-layer-15" 
                                data-x="['left','left','left','left']" data-hoffset="['100','100','100','100']" 
                                data-y="['top','top','top','top']" data-voffset="['100','100','100','100']" 
                                data-width="none"
                                data-height="none"
                                data-whitespace="nowrap"
                     
                                data-type="column" 
                                data-responsive_offset="on" 
                                data-responsive="off"
                                data-frames='[{"delay":"+0","speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                    			data-columnwidth="100%"
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['center','center','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 7; width: 100%;">
                            <!-- LAYER NR. 8 -->
                            <h2 class="tp-caption   tp-resizeme title-slide" 
                                id="slide-408-layer-1" 
                                data-x="['left','left','center','center']" data-hoffset="['0','0','0','0']" 
                                data-y="['top','top','top','top']" data-voffset="['0','0','230','110']" 
                                data-fontsize="['110','90','100','70']"
                                data-lineheight="['100','90','100','70']"
                                data-width="['none','none','697','399']"
                                data-height="none"
                                data-whitespace="['normal','normal','normal','normal']"
                     
                                data-type="text" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                    
                                data-frames='[{"delay": 500,"speed": 300, "from": "opacity: 0", "to": "opacity: 1"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[30,20,30,30]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,40,40]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,40,40]"
                    
                                style="z-index: 8;">EXPERIENCIA DE 
                            MÁS DE UNA DÉCADA</h2>
                    
                            <!-- LAYER NR. 9 -->
                            <p class="tp-caption   tp-resizeme subtitle-slide" 
                                 id="slide-408-layer-2" 
                                 data-x="['left','left','center','center']" data-hoffset="['0','50','0','0']" 
                                 data-y="['top','top','top','top']" data-voffset="['0','430','460','290']" 
                                            data-fontsize="['30','30','40','25']"
                                data-lineheight="['40','40','50','30']"
                                data-width="['none','100%','100%','100%']"
                                data-height="none"
                                data-whitespace="normal"
                     
                                data-type="text" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                    
                                data-frames='[{"delay":"+890","split":"chars","splitdelay":0.03,"speed":300,"frame":"0","from":"sX:2;sY:2;opacity:0;fb:5px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},
                                {"delay":"wait","speed":1000,"frame":"999","to":"opacity:0;fb:10px;","ease":"Power4.easeOut"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 9;">En Blindaje Jurídico para las Escuelas</p>
                                    </div>
                                </div>
                            </div>
                    
                            <!-- LAYER NR. 10 -->
                            <div class="tp-caption tp-shape tp-shapewrapper " 
                                 id="slide-408-layer-16" 
                                 data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
                                 data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                            data-width="full"
                                data-height="full"
                                data-whitespace="normal"
                     
                                data-type="shape" 
                                data-basealign="slide" 
                                data-responsive_offset="off" 
                                data-responsive="off"
                                data-frames='[{"delay":10,"speed":2000,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power4.easeOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                                data-textAlign="['inherit','inherit','inherit','inherit']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 5;background-color:rgba(0, 0, 0, 0.35);"> </div>
                        </li>
                        <!-- SLIDE  -->
                        <li class="slide3" data-index="rs-409" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="2000"  data-thumb="archivos/home/slider/asuntos-fiscales.jpg"  data-rotate="0"  data-saveperformance="off"  data-title="Three" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                            <!-- MAIN IMAGE -->
                            <img src="archivos/home/slider/asuntos-fiscales.jpg"  alt="ASUNTOS FISCALES"  data-bgposition="center center" data-kenburns="on" data-duration="20000" data-ease="Linear.easeNone" data-scalestart="130" data-scaleend="100" data-rotatestart="0" data-rotateend="0" data-offsetstart="0 0" data-offsetend="0 0" data-bgparallax="6" class="rev-slidebg" data-no-retina>
                            <!-- asuntos-fiscales.jpg -->
                            <!-- LAYERS -->
                            <div id="rrzm_409" class="rev_row_zone rev_row_zone_middle" style="z-index: 6;">
                    
                            <!-- LAYER NR. 11 -->
                            <div class="tp-caption  " 
                                id="slide-409-layer-14" 
                                data-x="['left','left','left','left']" data-hoffset="['100','100','100','100']" 
                                data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                data-width="none"
                                data-height="none"
                                data-whitespace="nowrap"
                     
                                data-type="row" 
                                data-columnbreak="2" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                                data-responsive="off"
                                data-frames='[{"delay":10,"speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','inherit','inherit']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[100,50,40,40]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[100,50,40,40]"
                    
                                style="z-index: 6; white-space: nowrap; font-size: 20px; line-height: 22px; font-weight: 400; color: rgba(255, 255, 255, 1.00);">
                            <!-- LAYER NR. 12 -->
                            <div class="tp-caption  " 
                                id="slide-409-layer-15" 
                                data-x="['left','left','left','left']" data-hoffset="['100','100','100','100']" 
                                data-y="['top','top','top','top']" data-voffset="['100','100','100','100']" 
                                data-width="none"
                                data-height="none"
                                data-whitespace="nowrap"
                     
                                data-type="column" 
                                data-responsive_offset="on" 
                                data-responsive="off"
                                data-frames='[{"delay":"+0","speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},
                                {"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                     			data-columnwidth="100%"
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['center','center','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 7; width: 100%;">
                            <!-- LAYER NR. 13 -->
                            <h2 class="tp-caption   tp-resizeme title-slide" 
                                 id="slide-409-layer-1" 
                                 data-x="['left','left','center','center']" data-hoffset="['0','0','0','0']" 
                                 data-y="['top','top','top','top']" data-voffset="['0','0','230','110']" 
                                            data-fontsize="['110','90','100','70']"
                                data-lineheight="['100','90','100','70']"
                                data-width="['none','none','697','399']"
                                data-height="none"
                                data-whitespace="['normal','normal','normal','normal']"
                     
                                data-type="text" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                    
                                data-frames='[{"delay": 500,"speed": 300, "from": "opacity: 0", "to": "opacity: 1"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[30,20,30,30]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,40,40]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,40,40]"
                    
                                style="z-index: 8;">ENFÓCATE EN LA OPERACIÓN 
                            DE TU ESCUELA</h2>
                    
                            <!-- LAYER NR. 14 -->
                            <p class="tp-caption   tp-resizeme subtitle-slide" 
                                 id="slide-409-layer-2" 
                                 data-x="['left','left','center','center']" data-hoffset="['0','50','0','0']" 
                                 data-y="['top','top','top','top']" data-voffset="['0','430','460','290']" 
                                            data-fontsize="['30','30','40','25']"
                                data-lineheight="['40','40','50','30']"
                                data-width="['none','100%','100%','100%']"
                                data-height="none"
                                data-whitespace="normal"
                     
                                data-type="text" 
                                data-basealign="slide" 
                                data-responsive_offset="on" 
                    
                                data-frames='[{"delay":"+890","split":"chars","splitdelay":0.03,"speed":300,"frame":"0","from":"sX:2;sY:2;opacity:0;fb:5px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},
                                {"delay":"wait","speed":1000,"frame":"999","to":"opacity:0;fb:10px;","ease":"Power4.easeOut"}]'
                                data-margintop="[0,0,0,0]"
                                data-marginright="[0,0,0,0]"
                                data-marginbottom="[0,0,0,0]"
                                data-marginleft="[0,0,0,0]"
                                data-textAlign="['inherit','inherit','center','center']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 9;">Nosotros nos encargamos de guiarte en Asuntos Fiscales</p>
                                    </div>
                                </div>
                            </div>
                    
                            <!-- LAYER NR. 15 -->
                            <div class="tp-caption tp-shape tp-shapewrapper " 
                                 id="slide-409-layer-16" 
                                 data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
                                 data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                            data-width="full"
                                data-height="full"
                                data-whitespace="normal"
                     
                                data-type="shape" 
                                data-basealign="slide" 
                                data-responsive_offset="off" 
                                data-responsive="off"
                                data-frames='[{"delay":10,"speed":2000,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]'
                                data-textAlign="['inherit','inherit','inherit','inherit']"
                                data-paddingtop="[0,0,0,0]"
                                data-paddingright="[0,0,0,0]"
                                data-paddingbottom="[0,0,0,0]"
                                data-paddingleft="[0,0,0,0]"
                    
                                style="z-index: 5;background-color:rgba(0, 0, 0, 0.35);"> </div>
                        </li>
                    </ul>
                    
                    <div class="tp-bannertimer" style="height: 10px; background-color: rgba(255, 255, 255, 0.25);"></div>	
                </div>
            </div>
		
        
            
            <!-- About home -->
            <div id="about-home" class="section-full p-tb80 p-tb40-sm">
                <div class="container ">
                    <div class="section-content about4-section">
                    	<div class="row flex-col">
                        	<div class="col-md-5 col-sm-5">
                            	<div class="about4-section-pic">
                                	<div class="wt-media">
                                    	<img src="archivos/home/auditoria-instituciones-educativas.jpg" alt="AUDITORÍA DE INSTITUCIONES EDUCATIVAS">
                                    	<!-- auditoria-instituciones-educativas.jpg -->
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-7 col-sm-7">
                            	<div class="about4-content contentBx">
                                    <h2 class="title">PROTEGEMOS A 
                                    LAS ESCUELAS PRIVADAS</h2>
                                    <p class="subtitle">Operación, evaluación y auditoría de todo tipo de instituciones educativas privadas en todo el país</p>
                                    <p class="description">La Federación Para la Defensa de Escuelas Particulares, está integrada por profesionistas líderes en su campo, en más de 15 áreas de práctica, con experiencia de más de una década. Nuestro principal interés es ser un punto de encuentro para las escuelas. Proveemos soluciones y beneficios integrales.</p>    
                                </div>
                            </div>
                        </div>
                    </div>	
                </div>
            </div>   
            <!-- END -->

            <!-- services -->
            <div id="services" class="section-full p-tb80 p-t40-sm p-b80-sm">
                <div class="container ">
                    <div class="section-head text-center contentBx">
                        <h2 class="title">SOLUCIONES 360° PARA LAS ESCUELAS</h2>
                        <p class="subtitle">Al contar con nuestro apoyo, puedes enfocarte en la operación y desarrollo de tu escuela</p>
                    </div>
                    <div id="services-explain" class="section-content circle-block-outer" data-toggle="tab-hover">
                        <div class="row">
                        
                            <div class="col-md-4 col-sm-12 m-b30">
                                <div class="wt-icon-box-wraper right p-a10 m-b20" data-target="#tab1" data-toggle="tab">
                                    <div class="icon-md text-primary radius">
                                        <span class="icon-cell  text-primary"><img src="archivos/home/Home-Defensa.svg" alt=""></span>
                                    </div>
                                    <div class="icon-content contentBx">
                                        <h2 class="wt-tilte">DEFENSA</h2>
                                        <p>A nivel Federal, Estatal o Municipal, en cualquier parte de la República Mexicana</p>
                                    </div>
                                </div> 
                                <div class="wt-icon-box-wraper right p-a10 m-r30 m-b20" data-target="#tab1" data-toggle="tab">
                                    <div class="icon-md text-primary radius">
                                        <span class="icon-cell  text-primary"><img src="archivos/home/Home-Area-Legal-Externa.svg" alt=""></span>
                                    </div>
                                    <div class="icon-content contentBx">
                                        <h2 class="wt-tilte">ÁREA LEGAL EXTERNA</h2>
                                        <p>Asistencia en todos los aspectos legales de tu operación cotidiana</p>
                                    </div>
                                </div>
                                <div class="wt-icon-box-wraper right p-a10 m-b20" data-target="#tab1" data-toggle="tab">
                                    <div class="icon-md text-primary radius">
                                        <span class="icon-cell  text-primary"><img src="archivos/home/Home-Seguros.svg" alt=""></span>
                                    </div>
                                    <div class="icon-content contentBx">
                                        <h2 class="wt-tilte">SEGUROS</h2>
                                        <p>Exclusivos para todos nuestros colegios afiliados</p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-12 m-b30 d-none-mobile">
                                <div class="circle-content-pic tab-content ">
                                	<div id="tab1" class="tab-pane active">
                                    	<div class="wt-box">
                                            <div class="wt-media text-primary m-b20 ">
                                                <img src="archivos/home/desarrollo-escuelas.jpg" class="radius-bx" alt="Desarrollo escuelas">
                                            </div>
                                        </div>
                                    </div>
                                </div>  
                            </div>
                            
                            <div class="col-md-4 col-sm-12 m-b30">
                                <div class="wt-icon-box-wraper left p-a10 m-b20" data-target="#tab1" data-toggle="tab">
                                    <div class="icon-md text-primary radius">
                                        <span class="icon-cell  text-primary"><img src="archivos/home/Home-Reduccion-de-contribuciones.svg" alt=""></span>
                                    </div>
                                    <div class="icon-content contentBx">
                                        <h2 class="wt-tilte">REDUCCIÓN DE CONTRIBUCIONES</h2>
                                        <p>Obtención de hasta el 100% en algunos tipos de condonaciones</p>
                                    </div>
                                </div> 
                                <div class="wt-icon-box-wraper left p-a10 m-l30 m-b20" data-target="#tab1" data-toggle="tab">
                                    <div class="icon-md text-primary radius">
                                        <span class="icon-cell  text-primary"><img src="archivos/home/Home-Compras.svg" alt=""></span>
                                    </div>
                                    <div class="icon-content contentBx">
                                        <h2 class="wt-tilte">COMPRAS</h2>
                                        <p>Apoyo para la adquisición de todo tipo de insumos y activos</p>
                                    </div>
                                </div>
                                <div class="wt-icon-box-wraper left p-a10 m-b20" data-target="#tab1" data-toggle="tab">
                                    <div class="icon-md text-primary radius">
                                        <span class="icon-cell  text-primary"><img src="archivos/home/Home-Mas-Servicios.svg" alt=""></span>
                                    </div>
                                    <div class="icon-content contentBx">
                                        <h2 class="wt-tilte">MÁS SERVICIOS</h2>
                                        <p>Ayudamos en la prestación de gran variedad de servicios</p>
                                    </div>
                                </div>                                
                            </div>
                            <div class="col-md-12 text-center">
                            	<a class="btn-transparent" href="servicios.php">
                            		CONOCER TODOS LOS SERVICIOS
                            	</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>   
            <!-- END -->  

            <!-- clients -->
            <?php 
                include('clientes.php');
             ?>
            <!-- END -->  

            <!-- circulares-->
            <div id="circulares-home" class="section-full latest-blog p-tb80">
                <div class="container">

                    <div class="section-head text-center contentBx">
                        <h2 class="title">ÚLTIMAS CIRCULARES</h2>
                        <p class="subtitle">Mantente enterado de la última información en material legal educativa</p>
                    </div>
                    
                    <div class="section-content ">
                        <div class="row equal-wraper">
                            <!-- COLUMNS 1 -->
                            <div class="col-md-6 col-sm-12">
                            
                                <div class="blog-post latest-blog-3 blog-md date-style-1 clearfix">
                                    <div class="wt-post-media wt-img-effect zoom-slow">
                                        <a href="#" download><img src="archivos/home/ultimas-circulares_2.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-post-info">
                                        <div class="wt-post-title ">
                                            <p class="post-title font-weight-800"><a href="#" download>2020 FEDEP Líder en Temas 
                                            Legales - Educativos (pdf)</a></p>
                                        </div>
                                        <div class="wt-post-text">
                                            <p>#26</p> 
                                        </div>
                                        
                                    </div>
                                </div>
                                
                                <div class="blog-post latest-blog-3 blog-md date-style-1 clearfix">
                                    <div class="wt-post-media wt-img-effect zoom-slow">
                                        <a href="#" download><img src="archivos/home/ultimas-circulares_2.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-post-info">
                                        <div class="wt-post-title ">
                                            <p class="post-title font-weight-800"><a href="#" download>2020 FEDEP Líder en Temas 
                                            Legales - Educativos (pdf)</a></p>
                                        </div>
                                        <div class="wt-post-text">
                                            <p>#26</p> 
                                        </div>
                                        
                                    </div>
                                </div>
                                
                                <div class="blog-post latest-blog-3 blog-md date-style-1 clearfix">
                                    <div class="wt-post-media wt-img-effect zoom-slow">
                                        <a href="#" download><img src="archivos/home/ultimas-circulares_2.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-post-info">
                                        <div class="wt-post-title ">
                                            <p class="post-title font-weight-800"><a href="#" download>2020 FEDEP Líder en Temas 
                                            Legales - Educativos (pdf)</a></p>
                                        </div>
                                        <div class="wt-post-text">
                                            <p>#26</p> 
                                        </div>
                                        
                                    </div>
                                </div>
                                
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="blog-post latest-blog-3 overlay-wraper post-overlay date-style-1 bg-cover bg-no-repeat bg-top-center"  style="background-image:url(archivos/home/ultimas-circulares_1.jpg);">
                                	
                                    <div class="wt-post-info p-a30 p-b20 text-white">
                                    	<div class="post-overlay-position">
                                            <div class="wt-post-title ">
                                                <p class="post-title white"><a href="#" download class="">2020 FEDEP Líder en Temas 
                                            Legales - Educativos (pdf)</a></p>
                                            </div> 
                                            <div class="wt-post-text">
                                                <p>#26</p> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                            
                        </div>
                    </div>
                    <div class="col-md-12 text-center">
                    	<a class="btn-transparent" href="circulares.php">
                    		VER MÁS CIRCULARES
                    	</a>
                    </div>
                </div>
            </div>
            <!-- END -->   
            
            <!-- Subscribe home -->
            <?php 
                include('subscribe-home.php');
             ?>
            <!-- end -->
                               
            <!-- CONTACT  --> 
			<?php 
                include('contacto.php');
             ?>
            <!-- END  -->                         
             
        </div>
        <!-- CONTENT END -->
        
        <!-- FOOTER START -->
        <?php
            include('footer.php');
        ?>
        <!-- FOOTER END -->
        
    </div>

    <?php include('subscribe-form.php'); ?>
 
<!-- LOADING AREA START ===== -->
<div class="loading-area">
    <div class="loading-box"></div>
    <div class="loading-pic">
        <div class="cssload-container">
            <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP">
        </div>
    </div>
</div>
<!-- LOADING AREA  END ====== -->
<!-- JAVASCRIPT  FILES ========================================= --> 
<script   src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script   src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->

<script   src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script   src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->

<script   src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->

<script   src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script   src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script   src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->

<script  src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->

<script   src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->

<script   src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script   src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   -->

<script   src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->
<script   src="js/shortcode.js"></script><!-- SHORTCODE FUCTIONS  -->


<!-- REVOLUTION JS FILES -->

<script  src="plugins/revolution/revolution/js/jquery.themepunch.tools.min.js"></script>
<script  src="plugins/revolution/revolution/js/jquery.themepunch.revolution.min.js"></script>

<!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->	
<script  src="plugins/revolution/revolution/js/extensions/revolution-plugin.js"></script>

<!-- REVOLUTION SLIDER FUNCTION  ===== -->
<script   src="js/rev-script-5.js"></script>


<!-- <script>
$('.circle-block-outer[data-toggle="tab-hover"] div').hover( function(){
    $(this).tab('show');
});
</script> -->

</body>

</html>
