<!DOCTYPE html>

<html lang="es">

<head>

    <!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Defensa de escuelas particulares, FEDEP, Defensa Escuelas Privadas, Representación de Escuelas Particulares, Asesoría Legal Para Escuelas Particulares, Servicios legales para Escuelas Particulares, Servicio Legal Especializado en Materia Educativa" />
    <meta name="author" content="" />
    <meta name="robots" content="LeadME Internet Marketing" />    
    <meta name="description" content="Reunimos, Asesoramos, Defendemos y Representamos a todas las Escuelas Particulares en la República Mexicana, que requieran de cualquier tipo de asistencia o servicio legal especializado en materia educativa." />
    
    <!-- FAVICONS ICON -->
    <link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
    <link rel="manifest" href="archivos/favicon/site.webmanifest">
    <link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">
    
    <!-- PAGE TITLE HERE -->
    <title>Reducción de Contribuciones | FEDEP</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
    <![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <!-- FLATICON STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <!-- ANIMATE STYLE SHEET --> 
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <!-- BOOTSTRAP SELECT BOX STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <!-- LOADER STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/loader.min.css">    
    <!-- MAIN STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <!-- THEME COLOR CHANGE STYLE SHEET -->
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-1.css">
    <!-- CUSTOM  STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/custom.css">

 
</head>

<body>

    <div class="page-wraper">
        	
        <!-- HEADER START -->
        <header id="header-interior" class="site-header header-style-1 ">
        
            <div class="top-bar">
                <div class="container">
                    <div class="row">
                        <div class="wt-topbar-right clearfix">
                            <ul class="social-bx list-inline pull-right social-header">
                                <li><a href="https://www.facebook.com/pg/fedepmexico" target="_blank" class="fa fa-facebook"></a></li>
                                <li><a href="#" target="_blank" class="fa fa-linkedin"></a></li>
                                <li><a href="https://twitter.com/fedep_mexico" target="_blank" class="fa fa-twitter"></a></li>
                            </ul>
                            <ul class="list-unstyled e-p-bx pull-right info-list-header">
                                <li>
                                    <a href="mailto:contacto@fedep.org">
                                        <i class="fa fa-envelope"></i>
                                        contacto@fedep.org
                                    </a>
                                </li>
                                <li>
                                    <a href="tel:5572612117">
                                        <i class="fa fa-phone"></i>
                                        +52 (55) 7261-2117
                                    </a>
                                </li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="sticky-header main-bar-wraper">
                <div class="main-bar bg-white">
                    <div class="container">
                        <div class="logo-header">
                            <a href="index.php">
                                <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP" />
                            </a>
                        </div>
                        <!-- NAV Toggle Button -->
                        <button data-target=".header-nav" data-toggle="collapse" type="button" class="navbar-toggle collapsed">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        
                        <!-- MAIN Vav -->
                        <div class="header-nav navbar-collapse collapse ">
                            <ul class=" nav navbar-nav">
                                <li class="">
                                    <a href="index.php">Inicio</a>
                                </li>
                            
                                <li class="">
                                    <a href="nosotros.php">Nosotros</a>
                                </li>
                                
                                <li class="">
                                    <a href="servicios.php">Servicios</a>
                                </li>
                            
                                <li>
                                    <a href="afiliaciones.php">Afiliaciones</a>
                                </li>
                                
                                <li class="">
                                    <a href="circulares.php">Circulares</a>
                                </li>
                                
                                <li class="">
                                    <a href="publicaciones.php">Publicaciones</a>
                                </li>

                                <li class="">
                                    <a href="prensa.php">Prensa</a>
                                </li>

                                <li class="">
                                    <a class="scroll" href="#contacto">Contacto</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
        </header>
        <!-- HEADER END -->
            
        <!-- CONTENT START -->
        <div class="page-content">
            
            <!-- PAGE BANNER -->
            <div class="wt-bnr-inr overlay-wraper" style="background-image:url(archivos/servicios-interior/fedep-impuestos.jpg);">
                <!-- fedep-impuestos.jpg -->
                <div class="overlay-main bg-black opacity-04"></div>
                <div class="container">
                    <div class="wt-bnr-inr-entry">
                        <h1 class="text-white">Reducción / Condonación de Impuestos</h1>
                    </div>
                </div>
            </div>
            <!-- END --> 
            
            <div id="reduccion-contribuciones" class="section-full p-tb80 p-b0-sm">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- 1 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-reduccion-de-contribuciones.svg" alt="">
                                    <p class="title">Servicios para Reducción de Impuestos</p>
                                </div>
                                <p class="description">Gracias a la gestión de nuestro equipo multidisciplinario de trabajo, hemos logrado para más del 90% de nuestros Afiliados en la CDMX, una reducción de hasta el 100% de la totalidad de los  impuestos locales (Predial, Agua, ISAI) que pagan año con año, acumulando a lo largo de los últimos 5 años un monto total de reducciones fiscales superior a los 90 millones de pesos. Condonación de impuestos escuelas, reducción predial CDMX, exención predial y agua.</p>
                            </div>
                            <!-- 2 -->
                            <div class="contentBx">
                                <div class="box-title">
                                    <img src="archivos/servicios/Servicios-reduccion-de-contribuciones.svg" alt="">
                                    <p class="title">Impuestos Sujetos a Reducción</p>
                                </div>
                                <ul class="list-reduccion">
                                    <li>
                                        <p>Impuesto Predial</p>
                                        <p>El Impuesto Predial se calcula con base en la ubicación, el valor catastral y en el uso de suelo permitido que tiene cada inmueble. A través de distintas estrategias fiscales, hemos obtenido durante los últimos tres años, tan solo para uno solo de nuestros Afiliados, una reducción anual superior a los 3.5 millones de pesos.</p>
                                    </li>
                                    <li>
                                        <p>Derechos por Servicios de Agua</p>
                                        <p>La totalidad de Derechos que se pagan bimestre con bimestre por servicio de Agua son objeto de reducción fiscal una vez implementadas las estrategias fiscales adecuadas, logrando reducciones superiores inclusive a 1.2 millones de pesos en 2016 por este concepto, tan solo en el caso de uno de nuestros Afiliados.</p>
                                    </li>
                                    <li>
                                        <p>Impuesto Sobre Adquisición de Inmuebles (ISAI)</p>
                                        <p>Toda adquisición de inmuebles dentro de la CDMX se encuentra sujeta FORZOSAMENTE al pago de un Impuesto Local por el traslado de dominio o propiedad. Dicho impuesto en el DF recibe el nombre de ISAI y equivale aproximadamente a un 4%-5% del valor más alto entre: 1) El Valor Catastral, 2) Valor Comercial o de Avalúo Fiscal, y 3) Precio de Adquisición.</p>
                                        <p>Gracias a las arduas gestiones e innovadoras estrategias fiscales de nuestro equipo de especialistas, en 2016 logramos obtener para uno de nuestros Colegios una reducción de 9.3 millones de pesos de ISAI, por la adquisición de un inmueble en el DF con un valor superior a los 186 MDP.</p>
                                    </li>
                                    <li>
                                        <p>Derechos por Construcciones</p>
                                        <p>A partir de las reformas de 2009 a la Ley de Desarrollo Urbano y al Reglamento de Construcciones del DF, prácticamente toda construcción en la CDMX requiere la tramitación de una Licencia (hoy día llamada Manifestación de Construcción), la cual conlleva el pago de una cuota de Derechos que se calcula con base en la extensión y el valor de la obra a realizar, siendo los montos a pagar por construcciones importantes bastante altos (remodelaciones integrales, auditorios, canchas, salones o aulas, etc.)</p>
                                        <p>Una vez que hemos implementado los esquemas fiscales adecuados dentro de la operatividad cotidiana de nuestros Afiliados, hemos logrado conseguir reducciones en este rubro por montos superiores a los 2.5 millones de pesos, tan solo para uno de nuestros Afiliados en un ejercicio fiscal (2014).</p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            
            

            <?php 
                include('contacto.php');
             ?>
            <!-- END -->  
                    
        </div>
        <!-- CONTENT END -->
        
        <!-- FOOTER START -->
        <?php 
            include('footer.php');
         ?>
        <!-- FOOTER END -->
            
    </div>
    <?php include('subscribe-form.php'); ?>
    
<!-- LOADING AREA START ===== -->
<div class="loading-area">
    <div class="loading-box"></div>
    <div class="loading-pic">
        <div class="cssload-container">
            <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP">
        </div>
    </div>
</div>
<!-- LOADING AREA  END ====== -->
<!-- JAVASCRIPT  FILES ========================================= --> 
<script   src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script   src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->

<script   src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script   src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->

<script   src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->

<script   src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script   src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script   src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->

<script  src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->

<script   src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->

<script   src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script   src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   --> 

<script   src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->
<script   src="js/shortcode.js"></script><!-- SHORTCODE FUCTIONS  -->

</body>

</html>
