<!DOCTYPE html>

<html lang="es">

<head>

    <!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Defensa de escuelas particulares, FEDEP, Defensa Escuelas Privadas, Representación de Escuelas Particulares, Asesoría Legal Para Escuelas Particulares, Servicios legales para Escuelas Particulares, Servicio Legal Especializado en Materia Educativa" />
    <meta name="author" content="" />
    <meta name="robots" content="LeadME Internet Marketing" />    
    <meta name="description" content="Reunimos, Asesoramos, Defendemos y Representamos a todas las Escuelas Particulares en la República Mexicana, que requieran de cualquier tipo de asistencia o servicio legal especializado en materia educativa." />
    
    <!-- FAVICONS ICON -->
    <link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
    <link rel="manifest" href="archivos/favicon/site.webmanifest">
    <link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">
    
    <!-- PAGE TITLE HERE -->
    <title>Servicios | FEDEP</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
    <![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <!-- FLATICON STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <!-- ANIMATE STYLE SHEET --> 
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <!-- BOOTSTRAP SELECT BOX STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <!-- LOADER STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/loader.min.css">    
    <!-- MAIN STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <!-- THEME COLOR CHANGE STYLE SHEET -->
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-1.css">
    <!-- CUSTOM  STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/custom.css">

 
</head>

<body>

    <div class="page-wraper">
        	
        <!-- HEADER START -->
        <header id="header-interior" class="site-header header-style-1 ">
        
            <div class="top-bar">
                <div class="container">
                    <div class="row">
                        <div class="wt-topbar-right clearfix">
                            <ul class="social-bx list-inline pull-right social-header">
                                <li><a href="https://www.facebook.com/pg/fedepmexico" target="_blank" class="fa fa-facebook"></a></li>
                                <li><a href="#" target="_blank" class="fa fa-linkedin"></a></li>
                                <li><a href="https://twitter.com/fedep_mexico" target="_blank" class="fa fa-twitter"></a></li>
                            </ul>
                            <ul class="list-unstyled e-p-bx pull-right info-list-header">
                                <li>
                                    <a href="mailto:contacto@fedep.org">
                                        <i class="fa fa-envelope"></i>
                                        contacto@fedep.org
                                    </a>
                                </li>
                                <li>
                                    <a href="tel:5572612117">
                                        <i class="fa fa-phone"></i>
                                        +52 (55) 7261-2117
                                    </a>
                                </li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="sticky-header main-bar-wraper">
                <div class="main-bar bg-white">
                    <div class="container">
                        <div class="logo-header">
                            <a href="index.php">
                                <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP" />
                            </a>
                        </div>
                        <!-- NAV Toggle Button -->
                        <button data-target=".header-nav" data-toggle="collapse" type="button" class="navbar-toggle collapsed">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        
                        <!-- MAIN Vav -->
                        <div class="header-nav navbar-collapse collapse ">
                            <ul class=" nav navbar-nav">
                                <li class="">
                                    <a href="index.php">Inicio</a>
                                </li>
                            
                                <li class="">
                                    <a href="nosotros.php">Nosotros</a>
                                </li>
                                
                                <li class="active">
                                    <a href="servicios.php">Servicios</a>
                                </li>
                            
                                <li>
                                    <a href="afiliaciones.php">Afiliaciones</a>
                                </li>
                                
                                <li class="">
                                    <a href="circulares.php">Circulares</a>
                                </li>
                                
                                <li class="">
                                    <a href="publicaciones.php">Publicaciones</a>
                                </li>

                                <li class="">
                                    <a href="prensa.php">Prensa</a>
                                </li>

                                <li class="">
                                    <a class="scroll" href="#contacto">Contacto</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
        </header>
        <!-- HEADER END -->
            
        <!-- CONTENT START -->
        <div class="page-content">
            
            <!-- PAGE BANNER -->
            <div id="banner-servicios" class="wt-bnr-inr overlay-wraper" style="background-image:url(archivos/servicios/fedep-servicios.jpg);">
                <!-- fedep-servicios.jpg -->
                <div class="overlay-main bg-black opacity-04"></div>
                <div class="container">
                    <div class="wt-bnr-inr-entry">
                        <h1 class="text-white">Soluciones 360° para las escuelas</h1>
                    </div>
                </div>
            </div>
            <!-- END --> 

            <!-- asesoria y defensa -->
            <div id="asesoria-y-defensa" class="section-full p-tb80 p-tb50-sm">
            	<div class="container">
            		<div class="row">
            			<div class="col-md-12 text-center">
            				<h2 class="title">ASESORÍA, DEFENSA, REPRESENTACIÓN Y SOLUCIONES</h2>
            				<img src="archivos/servicios/Servicios-asesoria-defensa-representacion-soluciones.svg" alt="">
            			</div>
            		</div>
            	</div>
            </div>
            <!-- end -->

            <!-- services -->
            <div id="servicios-interior" class="section-full p-t80 p-b50 p-b0-sm p-t40-sm bckgd-1">
                <div class="bg-service-team">
                    <div class="container">
                        <div class="section-content m-b50 m-b40-sm">
                            <div class="row">
                                <!-- COLUMNS 1 -->
                                <div class="col-md-4 col-sm-6 m-tb20  col-services">
                                    <div class="wt-icon-box-wraper center">
                                        <div class="wt-icon-box-sm radius bdr-2 m-b20 circle-green">
                                            <a href="defensa-legal.php" class="icon-cell"><img src="archivos/servicios/Servicios-defensa.svg" alt=""></a>
                                        </div>
                                        <div class="icon-content contentBx">
                                            <h3 class="title">DEFENSA</h3>
                                            <p class="description">Nos especializamos en la defensa de Escuelas Particulares contra todo tipo de autoridades a nivel Federal, Estatal o Municipal, en cualquier parte de la República Mexicana.</p>
                                            <a href="defensa-legal.php" class="btn-transparent m-r15">LEER MÁS</a>
                                        </div>
                                    </div>
                                </div>
                                <!-- COLUMNS 2 -->
                                <div class="col-md-4 col-sm-6 m-tb20  col-services">
                                    <div class="wt-icon-box-wraper center">
                                        <div class="wt-icon-box-sm radius bdr-2 m-b20 circle-green">
                                            <a href="area-legal-externa.php" class="icon-cell"><img src="archivos/servicios/Servicios-area-legal-externa.svg" alt=""></a>
                                        </div>
                                        <div class="icon-content contentBx">
                                            <h3 class="title">ÁREA LEGAL EXTERNA</h3>
                                            <p class="description">Asistimos  también de manera integral a nuestros Afiliados en todos los aspectos legales de su operación cotidiana (problemas con padres de familia, contratos con proveedores, permisos, licencias, consultoría laboral, asambleas, sesiones de consejo, poderes,  contratos de prestación de servicios escolares, transporte escolar, trámites, etc.).</p>
                                            <a href="area-legal-externa.php" class="btn-transparent m-r15">LEER MÁS</a>
                                        </div>
                                    </div>
                                </div>
                                <!-- COLUMNS 3 -->
                                <div class="col-md-4 col-sm-6 m-tb20  col-services">
                                    <div class="wt-icon-box-wraper center">
                                        <div class="wt-icon-box-sm radius bdr-2 m-b20 circle-green">
                                            <a href="reduccion-contribuciones.php" class="icon-cell"><img src="archivos/servicios/Servicios-reduccion-de-contribuciones.svg" alt=""></a>
                                        </div>
                                        <div class="icon-content contentBx">
                                            <h3 class="title">REDUCCIÓN DE CONTRIBUCIONES</h3>
                                            <p class="description">Apoyamos a todas las escuelas particulares en la CDMX que cumplan con los requisitos y procedimientos legales y contables para optar por la posibilidad de obtener hasta un 100% de reducción en el pago de distintas contribuciones locales (Predial, Agua, Impuesto Sobre Adquisición de Inmuebles y Derechos por Licencias de Construcción).</p>
                                            <a href="reduccion-contribuciones.php" class="btn-transparent m-r15">LEER MÁS</a>
                                        </div>
                                    </div>
                                </div>
                                <!-- COLUMNS 4 -->
                                <div class="col-md-4 col-sm-6 m-tb20  col-services">
                                    <div class="wt-icon-box-wraper center">
                                        <div class="wt-icon-box-sm radius bdr-2 m-b20 circle-green">
                                            <a href="compras.php" class="icon-cell"><img src="archivos/servicios/Servicios-compras.svg" alt=""></a>
                                        </div>
                                        <div class="icon-content contentBx">
                                            <h3 class="title">COMPRAS</h3>
                                            <p class="description">Apoyamos a múltiples Colegios a nivel nacional en la adquisición de todo tipo de insumos y activos con costos mucho más competitivos que los precios ordinarios del mercado.</p>
                                            <a href="compras.php" class="btn-transparent m-r15">LEER MÁS</a>
                                        </div>
                                    </div>
                                </div>
                                <!-- COLUMNS 5 -->
                                <div class="col-md-4 col-sm-6 m-tb20  col-services">
                                    <div class="wt-icon-box-wraper center">
                                        <div class="wt-icon-box-sm radius bdr-2 m-b20 circle-green">
                                            <a href="mas-servicios.php" class="icon-cell"><img src="archivos/servicios/Servicios-mas-servicios.svg" alt=""></a>
                                        </div>
                                        <div class="icon-content contentBx">
                                            <h3 class="title">MÁS SERVICIOS</h3>
                                            <p class="description">Asistimos día a día a todos nuestros Afiliados con la prestación de todo tipo de servicios, gracias al equipo multidisciplinario de proveedores especialistas con los que contamos (valuación inmobiliaria, auditorías legales, auditorías fiscales, contabilidad, levantamientos topográficos, construcción, etc.)</p>
                                            <a href="mas-servicios.php" class="btn-transparent m-r15">LEER MÁS</a>
                                        </div>
                                    </div>
                                </div>
                                <!-- COLUMNS 6 -->
                                <div class="col-md-4 col-sm-6 m-tb20  col-services">
                                    <div class="wt-icon-box-wraper center">
                                        <div class="wt-icon-box-sm radius bdr-2 m-b20 circle-green">
                                            <a class="icon-cell"><img src="archivos/servicios/Servicios-seguros.svg" alt=""></a>
                                        </div>
                                        <div class="icon-content contentBx">
                                            <h3 class="title">SEGUROS</h3>
                                            <p class="description">Gracias al volumen de Escuelas afiliadas, la FEDEP tiene el privilegio de contar con Seguros exclusivos para todos nuestros Colegios, con primas más bajas y prestaciones mucho más altas que las ordinarias en el mercado, como es la devolución de primas o dividendos para Colegios con baja siniestralidad (sujeto a condiciones).</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>               
                    </div>
                </div>
            </div>
            <!-- end -->

            <?php 
                include('contacto.php');
             ?>
            <!-- END -->  
                    
        </div>
        <!-- CONTENT END -->
        
        <!-- FOOTER START -->
        <?php 
            include('footer.php');
         ?>
        <!-- FOOTER END -->
            
    </div>
    <?php include('subscribe-form.php'); ?>
    
<!-- LOADING AREA START ===== -->
<div class="loading-area">
    <div class="loading-box"></div>
    <div class="loading-pic">
        <div class="cssload-container">
            <img src="archivos/logo/logo-fedep-black.svg" alt="FEDEP">
        </div>
    </div>
</div>
<!-- LOADING AREA  END ====== -->
<!-- JAVASCRIPT  FILES ========================================= --> 
<script   src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script   src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->

<script   src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script   src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->

<script   src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->

<script   src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script   src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script   src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->

<script  src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->

<script   src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->

<script   src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script   src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   --> 

<script   src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->
<script   src="js/shortcode.js"></script><!-- SHORTCODE FUCTIONS  -->

</body>

</html>
