<!DOCTYPE html>
<html class="light">
	<head>
		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	
		<title>FEDEP - Testamentos</title>	
		<meta name="description" content="Uno de los principales problemas al momento del fallecimiento cuando se tienen hijos menores de edad, es el cuidado y manutención de los niños, la cual, cuando no hay testamento, queda en el “aire” y a criterio del juez correspondiente. Conoce como FEDEP puede ayudarte a estar preparado.">
		<meta name="author" content="LeadME Intentet Marketing">
		<meta name="keywords" content="FEDEP, testamentos, gestión de testamentos, porqué es importante tener un testamento, qué es un apoderado, qué es un tutor, qué incluir en mi testamento">
		<!-- Head -->
		<?php include('head.php')?>
	</head>
	<body>
		<div class="body">
			<header id="header" class="h-auto header-effect-shrink" data-plugin-options="{'stickyEnabled': true, 'stickyEffect': 'shrink', 'stickyEnableOnBoxed': true, 'stickyEnableOnMobile': true, 'stickyChangeLogo': false, 'stickyStartAt': 1, 'stickyHeaderContainerHeight': 100}">
				<div class="header-body border-top-0 bg-color-dark box-shadow-none">
					<div class="topHeader">
                        <div class="container">
                            <div class="content">
                                <p class="phraseTop">Trámite válido para realizarse en la CDMX y solicitarlo hasta el 31 de julio. Si resides en otro estado y puedes venir a la firma en la CDMX, puedes realizar el proceso. Si tienes alguna duda adicional o vives en otro entidad federativa envíanos un correo electrónico a  <a href="mailto:testamentos@fedep.org">testamentos@fedep.org</a></p>
                            </div>
                        </div>
                    </div>
					<div class="header-container container h-auto">
						<div class="header-row">
							<div class="header-column header-column-logo">
								<div class="header-row">
									<div class="header-logo">
										<a href="index">
											<img alt="FEDEP" title="FEDEP" src="archivos/logo-fedep.svg">
										</a>
									</div>
								</div>
							</div>
							<div class="header-column header-column-nav-menu justify-content-end w-100">
								<div class="header-row">
									<div class="header-nav header-nav-links header-nav-light-text order-2 order-lg-1">
										<div class="header-nav-main header-nav-main-mobile-dark header-nav-main-square header-nav-main-effect-2 header-nav-main-sub-effect-1">
											<nav class="collapse">
												<ul class="nav nav-pills" id="mainNav">
													<li class="">
														<a class="" href="index">
															Inicio
														</a>
													</li>
													<li class="">
														<a class="" href="nosotros">
															Nosotros
														</a>
													</li>
													<li class="">
														<a class="" data-hash data-hash-offset="0" data-hash-offset-lg="168" href="#instrucciones">
															Instrucciones para tu testamento
														</a>
													</li>
													<li class="">
														<a class="" href="llenado-testamento">
															Llena tu testamento
														</a>
													</li>
													<li class="">
														<a class="" data-hash data-hash-offset="0" data-hash-offset-lg="80" href="#terms">
															Preguntas frecuentes
														</a>
													</li>
													<li class="">
														<a class="" data-hash data-hash-offset="0" data-hash-offset-lg="80" href="#footer">
															Contacto
														</a>
													</li>
												</ul>
											</nav>
										</div>
										<button class="btn header-btn-collapse-nav" data-bs-toggle="collapse" data-bs-target=".header-nav-main nav">
											<i class="fas fa-bars"></i>
										</button>
									</div>
								</div>
							</div>
							<div class="header-column justify-content-end d-none d-lg-flex">
								<div class="header-row">
									<ul class="header-social-icons social-icons social-icons-clean social-icons-icon-light social-icons-big d-lg-flex m-0 ms-lg-2">
										<li class=""><a href="http://www.instagram.com/" target="_blank" class="text-4" title="Instagram"><i class="fab fa-instagram"></i></a></li>
										<li class=""><a href="https://www.facebook.com/fedepmexico.oficial" target="_blank" class="text-4" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</header>


			<div role="main" class="main">

				<section id="headerPageHome" class="section custom-circles-container section-angled bg-dark border-0 m-0" style="background-image: url(archivos/home/FEDEP-Home-Banner.jpg); background-size: cover; background-position: center;">
					<span class="custom-circle custom-circle-1 bg-color-light custom-circle-blur appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100" data-plugin-options="{'forceAnimation': true}"></span>
					<span class="custom-circle custom-circle-2 bg-color-primary appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="zoomIn" data-appear-animation-delay="200" data-plugin-options="{'forceAnimation': true}"></span>
					<span class="custom-circle custom-circle-3 bg-color-primary appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="zoomIn" data-appear-animation-delay="300" data-plugin-options="{'forceAnimation': true}"></span>
					<span class="custom-circle custom-circle-1 bg-color-light custom-circle-blur appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="400" data-plugin-options="{'forceAnimation': true}"></span>
					<span class="custom-circle custom-circle-2 bg-color-primary appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="zoomIn" data-appear-animation-delay="500" data-plugin-options="{'forceAnimation': true}"></span>
					<span class="custom-circle custom-circle-3 bg-color-primary appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="zoomIn" data-appear-animation-delay="600" data-plugin-options="{'forceAnimation': true}"></span>
					<div class="section-angled-layer-bottom section-angled-layer-increase-angle bg-dark"></div>
					<div class="section-angled-content h-100">
						<div class="container">
							<div class="row">
								<div class="col-lg-9">
									<div class="boxText">
										<h1 class="custom-title-with-icon mb-0 appear-animation titleSlide titulo-responsive-slider" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInUpShorterPlus" data-appear-animation-delay="850">Te ayudamos a poner todo en orden
											<span class="white">para que heredes a tus</span> 
											<span class="green">seres amados sin complicaciones</span>
										</h1>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>

				<section id="phraseHome">
					<div class="container">
						<div class="row">
							<div class="col-md-12 appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="500">
								<h2 class="title">La forma mas simple, accesible y economica <span>de hacer tu testamento</span></h2>
							</div>
						</div>
					</div>
				</section>

				<section id="terms" class="our-services p-relative py-5 my-3 pt_0 desktopTerms">
					<span class="custom-circle custom-circle-2 bg-color-quaternary appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="zoomIn" data-appear-animation-delay="100"></span>
					<div class="container">
						<div class="row justify-content-center">
							<h4 class="custom-text-10 title text-center custom-title-with-icon-center custom-title-with-icon custom-title-with-icon-primary pb-5 mb-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200">Conoce y comprende bien los términos relacionados 
							 	<span>para solicitar tu testamento</span></h4>
						</div>
						<div class="row">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
								<a href="que-es-un-testamento" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un testamento?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="300">
								<a href="por-que-es-importante-tener-testamento" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Por qué es tan importante tenerlo?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
								<a href="que-tipo-de-testamento-debo-otorgar" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué tipo de testamento debo otorgar?</p>
									</div>
								</a>
							</div>
						</div>
						<div class="row">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="500">
								<a href="donde-es-valido-mi-testamento" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Es válido mi testamento en toda la república y en todos los países?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
								<a href="que-es-un-heredero" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un heredero?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="700">
								<a href="que-es-un-legatario" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué es un legatario?</p>
									</div>
								</a>
							</div>
						</div>
						<div class="row">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="800">
								<a href="quien-puede-ser-heredero-o-legatario" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Quién puede ser heredero o legatario?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="900">
								<a href="que-es-albacea" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué es un albacea?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="1000">
								<a href="que-es-un-tutor" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un tutor?</p>
									</div>
								</a>
							</div>
						</div>
						<div class="row">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
								<a href="que-es-un-curador" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un curador?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="300">
								<a href="que-bienes-entran-en-un-testamento" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué bienes son los que entran en un testamento?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
								<a href="tengo-que-heredar-aguien-en-particular" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Tengo forzosamente que heredar a alguien en particular?</p>
									</div>
								</a>
							</div>
						</div>
						<div class="row">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="500">
								<a href="vigencia-del-testamento" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué vigencia tiene el testamento?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
								<a href="cambios-en-el-testamento" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-dark text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué pasa si ya tengo un testamento y le quiero cambiar algo?</p>
									</div>
								</a>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="700">
								<a href="importancia-del-usufructo-y-nuda-propiedad" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué importancia tiene el usufructo y nuda propiedad en los testamentos?</p>
									</div>
								</a>
							</div>
						</div>
						<div class="row justify-content-center">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="700">
								<a href="que-es-la-herencia-en-vida" class="text-decoration-none">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué es la herencia en vida?</p>
									</div>
								</a>
							</div>
						</div>
					</div>
				</section>

				<section id="terms" class="our-services p-relative py-5 my-3 pt_0 mobileTerms">
					<span class="custom-circle custom-circle-2 bg-color-quaternary appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="zoomIn" data-appear-animation-delay="100"></span>
					<div class="container">
						<div class="row justify-content-center">
							<h4 class="custom-text-10 title text-center custom-title-with-icon-center custom-title-with-icon custom-title-with-icon-primary pb-5 mb-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200">Conoce y comprende bien los términos relacionados 
							 	<span>para solicitar tu testamento</span></h4>
						</div>
						<div id="accordionQuest" class="row">
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest1" aria-expanded="false" aria-controls="quest1">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un testamento?</p>
									</div>
								</a>
								<div id="quest1" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">El testamento es la disposición idónea y 100% efectiva para reglamentar todos los temas patrimoniales y de cuidado de hijos menores de edad, después de la muerte del de cujus (persona fallecida).</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="300">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest2" aria-expanded="false" aria-controls="quest2">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Por qué es tan importante tenerlo?</p>
									</div>
								</a>
								<div id="quest2" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Toda persona mayor de edad, a partir de que tenga bienes, y más importante aún, a partir de que tenga hijos, debe tener un testamento, ya que es la única forma 100% válida de designar qué destino tendrán los bienes al momento de la muerte (es decir, cómo y a quién se van a repartir), y aún más relevante, qué persona será la encargada de cuidar a sus hijos (tutor), y qué persona será la encargada de vigilar los gastos y cuidados de dicha persona (curador).</p>
									<p class="textAnswer">No dejar testamento al momento del fallecimiento genera problemas muy serios: (i) es mucho más rápido llevar una sucesión con testamento que una sin testamento; (ii) la disposición del dinero, la entrega de bienes y el nombramiento de los tutores y curadores es muchísimo más rápida cuando se deja testamento; (iii) evita problemas, burocracia y pleitos familiares.</p>
									<p class="textAnswer">Uno de los principales problemas al momento del fallecimiento cuando se tienen hijos menores de edad, es el cuidado y manutención de los niños, la cual, cuando no hay testamento, queda en el “aire” y a criterio del juez correspondiente.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest3" aria-expanded="false" aria-controls="quest3">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué tipo de testamento debo otorgar?</p>
									</div>
								</a>
								<div id="quest3" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Existen varios tipos de testamento, sin embargo el mejor de todos es el testamento público abierto, el cual debe forzosamente hacerse ante un Notario Público. Es muy importante aclarar que ninguna carta o documento privado, ni video, ni grabación, ni ninguna otra instrucción es realmente válida para después de la muerte, legalmente hablando, más que el testamento.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="500">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest4" aria-expanded="false" aria-controls="quest4">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Es válido mi testamento en toda la república y en todos los países?</p>
									</div>
								</a>
								<div id="quest4" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">El testamento público abierto (TPA) es plenamente válido no sólo en toda la República Mexicana sino en todo el mundo.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest5" aria-expanded="false" aria-controls="quest5">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un heredero?</p>
									</div>
								</a>
								<div id="quest5" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Es la persona que recibirá de forma genérica determinado porcentaje de los bienes del testador (persona que otorga el testamento). Puede ser un solo heredero con el 100%, o bien más de uno determinando a favor de cada heredero X porcentaje a libre elección.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="700">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest6" aria-expanded="false" aria-controls="quest6">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué es un legatario?</p>
									</div>
								</a>
								<div id="quest6" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">A diferencia del heredero, el legatario no adquiere un porcentaje de los bienes en general (masa hereditaria), sino que adquiere un bien en específico, por ejemplo, dejar en favor de X persona “la casa ubicada en xxxxxxxx” o “el reloj marca xxxxxxxxx modelo xxxxxxxx”.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="800">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest7" aria-expanded="false" aria-controls="quest7">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Quién puede ser heredero o legatario?</p>
									</div>
								</a>
								<div id="quest7" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Cualquier persona puede ser heredero o legatario, con la única condición de que haya nacido y esté viva al momento del fallecimiento del testador. No es necesario entonces que el heredero o legatario ya exista al momento de hacerse el testamento, sólo al momento del fallecimiento. Por esto muchas veces la herencia se deja “por partes iguales a los hijos que pueda tener el testador, al momento de su fallecimiento”. De esta forma, si una persona al hacer su testamento no tiene hijos, pero al fallecer ya tiene 4, la herencia se dividirá en 4 partes de 25% cada una a favor de cada hijo.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="900">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest8" aria-expanded="false" aria-controls="quest8">
									<div class="service-card mb-4 bg-color-dark w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué es un albacea?</p>
									</div>
								</a>
								<div id="quest8" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Albacea es la persona encargada de llevar a cabo todo el proceso sucesorio y de administrar los bienes hasta que sean adjudicados a los herederos/legatarios. Debe ser forzosamente una persona de mucha confianza mayor de edad.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="1000">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest9" aria-expanded="false" aria-controls="quest9">
									<div class="service-card mb-4 bg-color-tertiary text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un tutor?</p>
									</div>
								</a>
								<div id="quest9" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Es una de las personas más importantes en un testamento, ya que es la persona encargada del cuidado y manutención de los hijos menores de edad que deje el testador al momento de su fallecimiento. Su cargo durará hasta la mayoría de edad de los menores. Debe ser forzosamente una persona de muchísima confianza mayor de edad, que esté dispuesta a hacerse cargo de los menores.</p>
									<p class="textAnswer">Este cargo es aplicable únicamente cuando fallecen tanto padre como madre, y es muy importante designarlo al momento de hacer testamento siempre que se tengan hijos menores de edad.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest10" aria-expanded="false" aria-controls="quest10">
									<div class="service-card mb-4 bg-color-dark text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué es un curador?</p>
									</div>
								</a>
								<div id="quest10" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Es la persona encargada de “vigilar” el comportamiento y el desempeño del tutor, y de ver por el bienestar de los menores. Debe ser forzosamente una persona de alta confianza mayor de edad, que no tenga ningún tipo de parentesco con el tutor.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="300">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest11" aria-expanded="false" aria-controls="quest11">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué bienes son los que entran en un testamento?</p>
									</div>
								</a>
								<div id="quest11" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Todos los bienes tanto inmuebles como muebles, tangibles o intangibles, entran en un testamento, siempre y cuando tengan valor o relevancia económica (propiedades, vehículos, arte, joyas, acciones en empresas, partes sociales, marcas, derechos de autor, etcétera).</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest12" aria-expanded="false" aria-controls="quest12">
									<div class="service-card mb-4 bg-color-dark text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Tengo forzosamente que heredar a alguien en particular?</p>
									</div>
								</a>
								<div id="quest12" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">No, en México todos somos libres de heredar a quien queramos, sin importar si existe o no parentesco con esa u otras personas. No es obligatorio heredar a hijos o a cónyuge.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="500">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest13" aria-expanded="false" aria-controls="quest13">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué vigencia tiene el testamento?</p>
									</div>
								</a>
								<div id="quest13" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">El testamento otorgado ante Notario Público en México es permanente, y tiene vigencia hasta el momento de la muerte, o bien hasta que sea reemplazado por otro testamento posterior otorgado ante Notario.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest14" aria-expanded="false" aria-controls="quest14">
									<div class="service-card mb-4 bg-color-dark text-color-hover-light w-100 font-weight-semibold custom-text-6 line-height-6 text-color-dark p-relative">
										<p>¿Qué pasa si ya tengo un testamento y le quiero cambiar algo?</p>
									</div>
								</a>
								<div id="quest14" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Se debe forzosamente otorgar un nuevo testamento que reemplace enteramente al anterior. No pueden existir 2 testamentos vigentes.</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="700">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest15" aria-expanded="false" aria-controls="quest15">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué importancia tiene el usufructo y nuda propiedad en los testamentos?</p>
									</div>
								</a>
								<div id="quest15" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Esta figura es importante sobre todo para personas con hijos. El usufructo es una figura que permite dejar el “uso” de uno o más bienes a una persona “X” mientras dicha persona viva, siendo la contraparte, es decir “nuda propiedad”, de otra persona distinta. De esta forma la propiedad normal se divide en 2 partes, usufructo y nuda propiedad. Así, mientras viva el usufructuario, el nudo propietario si bien es dueño no puede disponer de los bienes en cuestión, es decir no puede venderlos ni sacar al usufructuario de la casa por ejemplo. De esta forma, es muy común disponer en los testamentos que se “designa como usufructuaria de mis bienes a mi esposa de nombre xxxxxxxxxxxxxxxxxx, y como nudos propietarios por partes iguales a los hijos que tenga al momento de mi fallecimiento”, de esta forma, la esposa en este ejemplo ocuparía y usaría los bienes mientras viva (v.gr. la casa), sin que los hijos puedan quitársela o venderla sin su consentimiento, hasta el momento de fallecimiento de dicha esposa, momento en el cual los “nudos propietarios” se convertirán automáticamente en propietarios “plenos”, sin necesidad de gastar en una nueva escritura de adjudicación, ni de pagar un nuevo Impuesto Sobre Adquisición de Inmuebles (ISAI).</p>
								</div>
							</div>
							<div class="col-xl-4 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="700">
								<a class="text-decoration-none collapsed" data-bs-toggle="collapse" data-bs-target="#quest16" aria-expanded="false" aria-controls="quest16">
									<div class="service-card mb-4 bg-color-tertiary w-100 font-weight-semibold custom-text-6 line-height-6 text-color-light p-relative">
										<p>¿Qué es la herencia en vida?</p>
									</div>
								</a>
								<div id="quest16" class="collapse" data-bs-parent="#accordionQuest">
									<p class="textAnswer">Esta figura está mal entendida y mal empleada. En realidad no existe la herencia en vida. Lo que algunas personas hacen, es donar a sus hijos o personas allegadas algunos de sus bienes mientras viven. No es necesario hacerlo si se tiene un testamento adecuado, e independientemente de que se donen bienes, hay una diferencia muy importante: la donación de un bien sólo se puede hacer mientras viva el donante y sobre bienes que ya existan, mientras que el testamento abarca todos los bienes que tenga el testador “al momento de su muerte”. Usted podría donar su casa actual, pero no sabe si el día de mañana pueda tener otro bien económicamente relevante, de ahí que siempre se recomiende un testamento.</p>
									<p class="textAnswer">Además de lo anterior, la donación no implica ningún tipo de designación sobre quién cuidará a los hijos menores de edad, lo cual sólo puede hacerse en México mediante el Testamento.</p>
								</div>
							</div>
						</div>	
					</div>
				</section>

				<!-- Steps -->
				<?php include('steps.php') ?>

				<!-- Call to action 1 -->
				<?php include('call-to-action-1.php')?>

			</div>
			<!-- Footer -->
			<?php include('footer2.php') ?>

		</div>
		<!-- Libs -->
		<?php include('libs.php')?>
		<!-- Scripts -->
        <!-- <script>
            $(document).ready(function(){
                $('.phraseTop').html('');
                $('.phraseTop').html('Válido por el momento en la CDMX y para aplicar durante todo el mes de junio. Si resides en otro estado, por favor, envíanos un correo a <a href="mailto:testamentos@fedep.org">testamentos@fedep.org</a>');
            });
        </script> -->

	</body>
</html>