<!DOCTYPE html>
<html class="light" lang="es-MX">
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	
		<title>FEDEP - Llena tu testamento</title>	
		<meta name="description" content="Uno de los principales problemas al momento del fallecimiento cuando se tienen hijos menores de edad, es el cuidado y manutención de los niños, la cual, cuando no hay testamento, queda en el “aire” y a criterio del juez correspondiente. Conoce como FEDEP puede ayudarte a estar preparado.">
		<meta name="author" content="LeadME Intentet Marketing">
		<meta name="keywords" content="FEDEP, testamentos, gestión de testamentos, porqué es importante tener un testamento, qué es un apoderado, qué es un tutor, qué incluir en mi testamento">

		<!-- Head -->
		<?php include ('head.php')?>
        <link rel="stylesheet" href="paypal/style.css">

	</head>

	<body>
		<div id="successBefore" class="body" style="position: relative;">
			<!-- Header Secciones -->
			<?php include('header-interior.php')?>

			<div role="main" class="main">

				<section id="header-page-interior" class="page-header page-header-modern page-header-background p-relative z-index-1 lazyload" data-bg-src="archivos/llenado-testamento/Fedep-Llena-tu-Testamento-Banner.jpg">
					<span class="custom-circle custom-circle-1 bg-color-light custom-circle-blur appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="400"></span>
					<span class="custom-circle custom-circle-2 bg-color-primary appear-animation" data-appear-animation="zoomIn" data-appear-animation-delay="500"></span>
					<span class="custom-circle custom-circle-3 bg-color-primary appear-animation" data-appear-animation="zoomIn" data-appear-animation-delay="600"></span>
					<div class="container">
						<div class="row">
							<div class="col">
                                <div class="boxText">
                                    <h1 class="titleHeader">Llena el formato para 
                                    <span>crear tu testamento</span></h1>
                                </div>
							</div>
						</div>
					</div>
				</section>

				<section id="formato" class="mt-3 mt-xl-0 py-5 p-relative z-index-2">
					<div class="container">
						<div class="row">
                            <div class="col-xl-12">
								<div class="aviso appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="800">
                                    <span>!</span>
                                    <p>Antes de llenar tu formato, es importante que hayas aclarado todas tus dudas en la sección de <a href="index#terms">“Preguntas frecuentes”.</a> <br>Por favor, verifica los datos que ingresas en el formato, ya que una vez que se envíe a la notaría no se podrán realizar cambios. Adicional, recuerda que el acto de testamento es solemne y personalísimo por lo que solamente el títular puede ir a firmar el documento*</p>
								</div>
							</div>
							<div class="col-lg-12">
                                <div class="pb-5 appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="800">
                                    <form id="formTestamento" class="formTest needs-validation" novalidate>
                                        <!-- <div class="contact-form-success alert alert-success d-none mt-4">
                                            <strong>Success!</strong> Your message has been sent to us.
                                        </div>
                                        <div class="contact-form-error alert alert-danger d-none mt-4">
                                            <strong>Error!</strong> There was an error sending your message.
                                            <span class="mail-error-message text-1 d-block"></span>
                                        </div> -->
                                        <!-- Datos generales -->
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <p class="titleData">Datos generales</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Nombres*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombre1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>

                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Apellido paterno*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="apellidoP1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Apellido materno*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="apellidoM1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            
                                            <div class="form-group col-lg-6">
                                                <p class="importantNote">Nota importante: <span>En caso de ser mujer y estar casada anotar los apellidos de soltera</span></p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Lugar de nacimiento*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="lNacimiento1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <span class="hidden-lg-date">Fecha de naciemiento</span>
                                                <input type="text" onmouseenter="(this.type='date')" onblur="(this.type='text')" placeholder="Fecha de nacimiento*" min="1920-01-01" max="2022-12-12" value="" data-msg-required="El campo es requerido" class="form-control text-3 h-auto py-2 datefield" name="fNacimiento1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    Ingresa una fecha válida
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-4">
                                                <input type="number" placeholder="Teléfono celular de contacto*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="telefono1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <input id="emailCheck" type="email" placeholder="Correo electrónico de contacto*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="correo1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <input id="emailRepeat" type="email" placeholder="Valida tu correo electrónico*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="correo2" required onblur="verify()" onfocus="verify()">
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El correo debe coincidir
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-2">
                                                <input type="text" placeholder="Nacionalidad*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nacionalidad1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-7 position-relative">
                                                <input type="text" placeholder="Estado Civil:*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                <div class="absoluteRadios">
                                                    <input type="radio" id="solter@" name="eCivil1" data-msg-required="El campo es requerido" value="Solter@" class="" required><label for="solter@">Solter@</label>
                                                    <input type="radio" id="casad@" name="eCivil1" data-msg-required="El campo es requerido" value="Casad@" class="" required><label for="casad@">Casad@</label>
                                                    <input type="radio" id="sociedad-conyugal" name="eCivil1" data-msg-required="El campo es requerido" value="Sociedad conyugal" class="" required><label for="sociedad-conyugal">Sociedad conyugal</label>
                                                    <input type="radio" id="Separacion-bienes" name="eCivil1" data-msg-required="El campo es requerido" value="Separación de bienes" class="" required><label for="Separacion-bienes">Separación de bienes</label>
                                                    <div class="invalid-feedback">
                                                        Por favor seleccione una opción
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <input type="text" placeholder="Ocupación*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="ocup1" required>
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6 position-relative">
                                                <input type="text" placeholder="Puede y sabe firmar:*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                <div class="absoluteRadios">
                                                    <input type="radio" id="siFirm" name="firma1" value="Si" data-msg-required="El campo es requerido" onclick="whatSelect()" required><label for="siFirm">Sí</label>
                                                    <input type="radio" id="noFirm" name="firma1" value="No" data-msg-required="El campo es requerido" onclick="whatSelect()" required><label for="noFirm">No</label>
                                                    <div class="invalid-feedback">
                                                        Por favor seleccione una opción
                                                    </div>
                                                </div>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                            </div>
                                            <div class="form-group col-lg-6 position-relative">
                                                <input type="text" placeholder="Sabe leer y escribir:*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                <div class="absoluteRadios">
                                                    <input type="radio" id="siEsc" name="lEscribi1" value="Si" data-msg-required="El campo es requerido" onclick="whatSelect()" required><label for="siEsc">Sí</label>
                                                    <input type="radio" id="noEsc" name="lEscribi1" value="No" data-msg-required="El campo es requerido" onclick="whatSelect()" required><label for="noEsc">No</label>
                                                    <div class="invalid-feedback">
                                                        Por favor seleccione una opción
                                                    </div>
                                                </div>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                            </div>
                                        </div>
                                        <!-- Domicilio -->
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <p class="titleData">Domicilio completo</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-4">
                                                <input type="text" placeholder="Calle*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="calle1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <input type="number" placeholder="Número exterior*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nExterior1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <input type="number" placeholder="Número interior" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nInterior1">
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Colonia*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="colonia1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Alcaldía*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="alcaldia1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-4">
                                                <input type="number" placeholder="Código postal*" value="" data-msg-required="El campo es requerido" maxlength="10" class="form-control text-3 h-auto py-2" name="cp1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <input type="text" placeholder="Ciudad*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="ciudad1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <input type="text" placeholder="País*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="pais1" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Padre del testador -->
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <p class="titleData">Padre del testador</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" placeholder="Nombre completo del padre del Testador*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreTP" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4 position-relative">
                                                <input type="text" placeholder="¿Vive actualmente?*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                <div class="absoluteRadios">
                                                    <input type="radio" id="siVivP" name="viveTP" value="Sí" data-msg-required="El campo es requerido" required><label for="siVivP">Sí</label>
                                                    <input type="radio" id="noVivP" name="viveTP" value="No" data-msg-required="El campo es requerido" required><label for="noVivP">No</label>
                                                    <div class="invalid-feedback">
                                                        Por favor seleccione una opción
                                                    </div>
                                                </div>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Nacionalidad del padre*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nacionalidadTP" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Madre del testador -->
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <p class="titleData">Madre del testador</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" placeholder="Nombre completo de la madre del Testador*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreTM" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4 position-relative">
                                                <input type="text" placeholder="¿Vive actualmente?*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                <div class="absoluteRadios">
                                                    <input type="radio" id="siVivM" name="viveTM" value="Sí" data-msg-required="El campo es requerido" required><label for="siVivM">Sí</label>
                                                    <input type="radio" id="noVivM" name="viveTM" value="No" data-msg-required="El campo es requerido" required><label for="noVivM">No</label>
                                                    <div class="invalid-feedback">
                                                        Por favor seleccione una opción
                                                    </div>
                                                </div>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <input type="text" placeholder="Nacionalidad de la madre*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nacionalidadTM" required>
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Herederos -->
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <p class="titleData" style="margin-bottom: 10px;">Herederos</p>
                                                <p class="smallText">Puedes elegir herederos, legatarios o ambos. Para asignar el porcentaje de cada heredero, por favor considera que entre todos no excedan el 100% de la cantidad.</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" id="fillHeredero" placeholder="Nombre completo*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreH1">
                                                <!-- <div class="valid-feedback">
                                                    El campo es valido
                                                </div> -->
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4" style="position: relative;">
                                                <input type="number" placeholder="Porcentaje*" value="0" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 percentage" name="porcentajeH1">
                                                <span class="elementPercentage">%</span>
                                                <div class="invalid-feedback">
                                                    El campo es requerido
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" placeholder="Nombre completo*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreH2">
                                            </div>
                                            <div class="form-group col-lg-4" style="position: relative;">
                                                <input type="number" placeholder="Porcentaje*" value="0" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 percentage" name="porcentajeH2">
                                                <span class="elementPercentage">%</span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" placeholder="Nombre completo*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreH3">
                                            </div>
                                            <div class="form-group col-lg-4" style="position: relative;">
                                                <input type="number" placeholder="Porcentaje*" value="0" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 percentage" name="porcentajeH3">
                                                <span class="elementPercentage">%</span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" placeholder="Nombre completo*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreH4">
                                            </div>
                                            <div class="form-group col-lg-4" style="position: relative;">
                                                <input type="number" placeholder="Porcentaje*" value="0" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 percentage" name="porcentajeH4">
                                                <span class="elementPercentage">%</span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-lg-8">
                                                <input type="text" placeholder="Nombre completo*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreH5">
                                            </div>
                                            <div class="form-group col-lg-4" style="position: relative;">
                                                <input type="number" placeholder="Porcentaje*" value="0" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 percentage" name="porcentajeH5">
                                                <span class="elementPercentage">%</span>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12 text-center">
                                                <a class="btn btn-outline custom-btn-outline btn-continue rounded-0 px-6 py-2 custom-text-5 line-height-5 appear-animation hide-me" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600" data-bs-toggle="collapse" href="#collapseForm" role="button" aria-expanded="false" aria-controls="collapseForm">
                                                    Continuar
                                                </a>
                                            </div>
                                        </div>
                                        
                                        <div class="collapse" id="collapseForm">
                                            <!-- Herederos sustitutos -->
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <p class="titleData">Herederos sustitutos <span>(no es necesario designarlos): </span></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <p class="subtitleData">En caso de faltar</p>
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 my-2" name="nombreLost1">
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 my-2" name="nombreLost2">
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 my-2" name="nombreLost3">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <p class="subtitleData">Se heredará a</p>
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 my-2" name="nombreSubstitute1">
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 my-2" name="nombreSubstitute2">
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 my-2" name="nombreSubstitute3">
                                                </div>
                                            </div>
                                            <!-- Legatarios -->
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <p class="titleData" style="margin-bottom: 10px;">Legatarios <span> (no es necesario designarlos)</span></p>
                                                    <p class="smallText">Puedes elegir herederos, legatarios o ambos. En el caso de designar un legatario, por favor, indica el bien material que dejas como legado.</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Nombre completo" id="fillLegatario" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreleg1">
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Bien legado" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="leg1">
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreleg2" >
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Bien legado" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="leg2" >
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Nombre completo" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="nombreleg3" >
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Bien legado" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="leg3" >
                                                </div>
                                            </div>
                                            <!-- Albacea -->
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <p class="titleData" style="margin-bottom: 10px;">Albacea</p>
                                                    <p class="smallText">Por favor, indica el nombre de la persona que estará a cargo de llevar a cabo todo el proceso sucesorio y de administrar los bienes hasta que sean adjudicados</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Albacea tutor*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="albacea1" required>
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Albacea sustituto*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="albaceaSub1" required>
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Tutor o tutriz -->
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <p class="titleData">Tutor o tutriz</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Tutor*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="tutor1" required>
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Tutor sustituto*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="tutorSub1" required>
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Curador o curadora -->
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <p class="titleData" style="margin-bottom: 10px;">Curador o curadora</p>
                                                    <p class="smallText">Por favor, indica el nombre de la persona que estará encargada de “vigilar” el comportamiento y el desempeño del tutor. Y recuerde que el curador no puede ser pariente de ninguna forma del Tutor.</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Curador*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="curad1" required>
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" placeholder="Curador sustituto*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="curadSub1" required>
                                                    <!-- <div class="valid-feedback">
                                                        El campo es valido
                                                    </div> -->
                                                    <div class="invalid-feedback">
                                                        El campo es requerido
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="collapse" id="moreFields">
                                                <!-- Testigos No1 -->
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <p class="titleData">Testigos</p>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <div class="aviso appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="800" data-plugin-options="{'forceInit': true}">
                                                            <span>!</span>
                                                            <p>*El siguiente apartado aplica únicamente para aquellas personas que no sepan o no puedan leer, escribir, ver, oír o que no sepan o no puedan firmar, en cuyo caso deberán ser asistidos por 2 testigos que no tengan parentesco con el testador, herederos y legatarios.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Nombre de testigo 1*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="nomtest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Apellido paterno*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="apptest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Apellido materno" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="apmtest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <p class="importantNote">Nota importante: <span>En caso de ser mujer y estar casada anotar los apellidos de soltera</span></p>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Lugar de nacimiento*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="lnactest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" onmouseenter="(this.type='date')" onfocus="(this.type='date')" onblur="(this.type='text')" placeholder="Fecha de nacimiento*" min="1920-01-01" max="2022-12-12" value="" data-msg-required="El campo es requerido" class="form-control text-3 h-auto py-2 setRequired datefield" name="fnactest1">
                                                        <div class="invalid-feedback">
                                                            Ingresa una fecha válida
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-2">
                                                        <input type="text" placeholder="Nacionalidad*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="nactest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-7 position-relative">
                                                        <input type="text" placeholder="Estado Civil:*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                        <div class="absoluteRadios">
                                                            <input type="radio" id="solter@test1" name="eCiviltest1" data-msg-required="El campo es requerido" value="Solter@" class="setRequired"><label for="solter@test1">Solter@</label>
                                                            <input type="radio" id="casad@test1" name="eCiviltest1" data-msg-required="El campo es requerido" value="Casad@" class="setRequired"><label for="casad@test1">Casad@</label>
                                                            <input type="radio" id="sociedad-conyugaltest1" name="eCiviltest1" data-msg-required="El campo es requerido" value="Sociedad conyugal" class="setRequired"><label for="sociedad-conyugaltest1">Sociedad conyugal</label>
                                                            <input type="radio" id="Separacion-bienestest1" name="eCiviltest1" data-msg-required="El campo es requerido" value="Separación de bienes" class="setRequired"><label for="Separacion-bienestest1">Separación de bienes</label>
                                                            <div class="invalid-feedback">
                                                                El campo es requerido
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-3">
                                                        <input type="text" placeholder="Ocupación*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="octest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Domicilio completo -->
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <p class="titleData">Domicilio completo</p>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-4">
                                                        <input type="text" placeholder="Calle*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="caltest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="number" placeholder="Número exterior*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="numEtest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="number" placeholder="Número interior" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="numItest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Colonia*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="coltest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Alcaldía*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="altest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-4">
                                                        <input type="number" placeholder="Código postal*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="cptest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="text" placeholder="Ciudad*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="ciutest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="text" placeholder="País*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="paitest1">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Nombre de testigo 2*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="nomtest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Apellido paterno*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="apptest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Apellido materno" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="apmtest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <p class="importantNote">Nota importante: <span>En caso de ser mujer y estar casada anotar los apellidos de soltera</span></p>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Lugar de nacimiento*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="lnactest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" onmouseenter="(this.type='date')" onfocus="(this.type='date')" onblur="(this.type='text')" placeholder="Fecha de nacimiento*" min="1920-01-01" max="2022-12-12" value="" data-msg-required="El campo es requerido" class="form-control text-3 h-auto py-2 setRequired datefield" name="fnactest2">
                                                        <div class="invalid-feedback">
                                                            Ingresa una fecha válida
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-2">
                                                        <input type="text" placeholder="Nacionalidad*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="nactest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-7 position-relative">
                                                        <input type="text" placeholder="Estado Civil:*" class="form-control text-3 h-auto py-2" name="" disabled>
                                                        <div class="absoluteRadios">
                                                            <input type="radio" id="solter@test2" name="eCiviltest2" data-msg-required="El campo es requerido" value="Solter@" class="setRequired"><label for="solter@test2">Solter@</label>
                                                            <input type="radio" id="casad@test2" name="eCiviltest2" data-msg-required="El campo es requerido" value="Casad@" class="setRequired"><label for="casad@test2">Casad@</label>
                                                            <input type="radio" id="sociedad-conyugaltest2" name="eCiviltest2" data-msg-required="El campo es requerido" value="Sociedad conyugal" class="setRequired"><label for="sociedad-conyugaltest2">Sociedad conyugal</label>
                                                            <input type="radio" id="Separacion-bienestest2" name="eCiviltest2" data-msg-required="El campo es requerido" value="Separación de bienes" class="setRequired"><label for="Separacion-bienestest2">Separación de bienes</label>
                                                            <div class="invalid-feedback">
                                                                El campo es requerido
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-3">
                                                        <input type="text" placeholder="Ocupación*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="octest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Domicilio completo 2-->
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <p class="titleData">Domicilio completo</p>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-4">
                                                        <input type="text" placeholder="Calle*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="caltest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="number" placeholder="Número exterior*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="numEtest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="number" placeholder="Número interior" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2" name="numItest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Colonia*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="coltest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <input type="text" placeholder="Alcaldía*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="altest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group col-lg-4">
                                                        <input type="number" placeholder="Código postal*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="cptest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="text" placeholder="Ciudad*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="ciutest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <input type="text" placeholder="País*" value="" data-msg-required="El campo es requerido" maxlength="100" class="form-control text-3 h-auto py-2 setRequired" name="paitest2">
                                                        <div class="invalid-feedback">
                                                            El campo es requerido
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col text-center">
                                                    <!-- <input type="submit" value="Finalizar y pagar" class="btn btn-outline custom-btn-outline btn-form rounded-0 px-6 py-2 custom-text-5 line-height-5 custom-btn-with-arrow appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600" data-loading-text="Loading..."> -->
                                                    <!-- <a id="btnValidate" class="btn btn-outline custom-btn-outline btn-continue rounded-0 px-6 py-2 custom-text-5 line-height-5 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600" data-bs-toggle="collapse" href="#payment" role="button" aria-expanded="false" aria-controls="payment"> -->
                                                    <a id="btnValidate" class="btn btn-outline custom-btn-outline btn-continue rounded-0 px-6 py-2 custom-text-5 line-height-5 appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600">
                                                        Finalizar y pagar
                                                    </a>
                                                    <p id="messageFieldsRequired"></p>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
						    </div>
						</div>
					</div>

                    <div class="collapse" id="payment">
                        <div class="cart-main">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="flex align-items-center">
                                            <!-- <div class="img text-center">
                                                <img src="https://via.placeholder.com/200" alt="">
                                            </div> -->
                                            <div class="title">
                                                <h3>1 Testamento</h3>
                                                <div class="price">
                                                    <h4 class="text-red">$2,650 MXN</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="subtotal text-center">
                                            <h3>Detalles</h3>
                                            <ul>
                                                <hr>
                                                <li class="flex justify-content-between">
                                                    <label for="price">Precio : </label>
                                                    <span class="text-red font-title">$2,650 MXN</span>
                                                </li>
                                            </ul>
                                            <div id="smart-button-container">
                                                <div style="text-align: center;">
                                                    <div id="paypal-button-container"></div>
                                                </div>
                                            </div>
                                            <script src="https://www.paypal.com/sdk/js?client-id=AducXWdY4ykXAsKkIIcWmsct5htSLtJrZ6rIZg_ssezWiIZ6wPwJcRcstTDQXjNLfDZp01epdAVk_J6B&locale=es_MX&enable-funding=venmo&currency=MXN" data-sdk-integration-source="button-factory"></script>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
				</section>
                
			</div>
			<!-- Footer -->
			<?php include('footer.php') ?>

            <!-- Success -->
            <div id="successPayWindow" class="hiddenWindow">
                <div class="boxMessage">
                    <span class="closeMessage">X</span>
                    <img src="archivos/check.png" alt="Success">
                    <p class="title">Compra realizada con éxito. Por favor, revisa en tu correo electrónico las indicaciones que te enviamos.</p>
                    <a class="btn btn-outline custom-btn-outline btn-success-window rounded-0 px-6 py-2 custom-text-5 line-height-5 closeMessageRedirect appear-animation" data-plugin-options="{'forceInit': true}" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600" href="schedule" target="_blank">Agendar cita para firma con notario</a>
                </div>
            </div>
		</div>
		<!-- Libs -->
		<?php include('libs.php') ?> 
        <script src="paypal/pay.js"></script>
        <script src="js/unsave.js"></script>
        <script src="js/validate.js"></script>
        <script>
            // (function() {
            // 'use strict';
            // window.addEventListener('load', function() {
            //     var formCheckEmail = document.getElementsByClassName('needs-validation');
            //     var btnValidate = document.getElementById('btnValidate');
            //     var validation = Array.prototype.filter.call(formCheckEmail, function(formCheck) {
            //         formCheck.addEventListener('click', function(event) {
            //             if (formCheck.checkValidity() === false) {
            //             event.preventDefault();
            //             event.stopPropagation();
            //             }
            //             formCheck.classList.add('was-validated');
            //         }, false);
            //     });
            // }, false);
            // })();
            // function check() { 
            //     var email = document.getElementById('emailCheck');
            //     var emailRepeat = document.getElementById('emailRepeat');

            //     if (email.value != emailRepeat.value) { 
            //         emailRepeat.setCustomValidity('Los dos correos deben ser los mismos.'); 
            //     } else { 
            //         // input is valid -- reset the error message 
            //         emailRepeat.setCustomValidity(''); 
            //     } 
            // } 
            // Verify email
            function verify(){
                var email = document.getElementById('emailCheck');
                var emailRepeat = document.getElementById('emailRepeat');
                if(email.value != emailRepeat.value) {
                    emailRepeat.classList.add('is-invalid');
                }
            }
            // Set required and show input
            function whatSelect(){
                var more_fields = document.getElementById('moreFields');
                var checked_firma = document.querySelector('input[name = "firma1"]:checked');
                var checked_escribir = document.querySelector('input[name = "lEscribi1"]:checked');
                var set_required = document.querySelectorAll('.setRequired');

                var activ_value = checked_firma.value
                var activ_value2 = checked_escribir.value
                console.log(activ_value)
                console.log(activ_value2)
                if(activ_value ==  'No' || activ_value2 == 'No'){  
                    more_fields.classList.add('show');
                    for (let i = 0; i < set_required.length; i++) {
                        set_required[i].setAttribute('required', '');
                    }	
                } else{
                    more_fields.classList.remove('show');
                    for (let i = 0; i < set_required.length; i++) {
                        set_required[i].removeAttribute('required');
                    }
                }
            }

            // Max day
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; 
            var yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }     
            today = yyyy + '-' + mm + '-' + dd;
            maxDate = document.querySelectorAll('.datefield');
            for (let k = 0; k < maxDate.length; k++){
                maxDate[k].setAttribute('max', today);
            }

            
            $(document).ready(function(){
                // Remove Message
                $('.closeMessage, .closeMessageRedirect').on('click', function(){
                    $('#successBefore').removeClass('valide');
                    $('#successPayWindow').addClass('hiddenWindow');
                })
            });

            

        </script>
	</body>
</html>

