<!DOCTYPE html>
<html dir="ltr" lang="es-MX">
<head>

<!-- Meta Tags -->
<meta name="viewport" content="width=device-width,initial-scale=1.0"/>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<meta name="description" content="Clínica Dental GALHEZ Metepec cuenta con Servicios de Ortodoncia, Estética Dental, Prótesis Dentales, Rehabilitación Oral, y el mejor servicio para recuperar y conservar tu Salud Oral y la de tu familia." />
<meta name="keywords" content="ortodoncia, rehabilitacion bucal, protesis dental, estética dental, limpieza dental, extracciones dentales, resinas dentales, endodoncia, cirugia de extraccion de muela del juicio, clinica dental, consultorio dental metepec toluca, implante dental, implantes dentales metepec, dentista, odontopediatra, endodoncista, odontopediatria, tratamientos dentales esteticos, estetica dental, brackets, blanqueamiento dental, dientes blancos, brackets autoligables, autoligado, odontogeriatria, odontogeriatra, carillas dentales, diseño de sonrisa, endodoncia, odontologia integral, periodoncia, rehabilitacion oral, dentista para niños, puentes dentales, coronas dentales, terceros molares, muela del juicio." />
<meta name="author" content="Strave" />

<!-- Page Title -->
<title>Dental Galhez</title>

<?php
  include('head.php');
?>
</head>
<body class="has-side-panel side-panel-right fullwidth-page side-push-panel">
<div class="body-overlay"></div>

<div id="wrapper" class="clearfix home">
  <!-- preloader -->
  <div id="preloader">
    <div id="spinner">
      <div class="preloader-dot-loading">
        <div class="cssload-loading"><i></i><i></i><i></i><i></i></div>
      </div>
    </div>
    <div id="disable-preloader" class="btn btn-default btn-sm">Disable Preloader</div>
  </div>
  
  <!-- Header -->
  <header id="header" class="header">
    <div class="bkgnd-verde sm-text-center">
      <div class="container">
        <div class="row">
          <div class="col-md-9">
            <div class="widget no-border m-0">
              
              <ul class="list-inline pull-right flip sm-pull-none sm-text-center mt-5 mb-5">
                <li class="m-0 pl-10 pr-10"> 
                  <a class="text-white " href="mailto:contacto@dentalgalhez.com"><i class="fa fa-envelope-o l-blanca mr-5"></i> <span class="info-header">contacto@dentalgalhez.com</span></a> 
                </li>
                <li class="m-0 pl-10 pr-10">  
                  <a class="text-white " href="tel:7226156711" onclick="gtag('event', 'clicks', { 'event_category': 'call', 'event_action':'click'});"><i class="fa fa-phone l-blanca mr-5"></i><span class="info-header">72 2615 6711</span></a> 
                </li>
              </ul>
            </div>
          </div>
          <div class="col-md-3 whatsapp">
            <div class="sm-display-block mt-sm-10 mb-sm-10 ">
              <a class="p-5 " href="https://web.whatsapp.com/send?phone=5217226156711" onclick="gtag('event', 'clicks', { 'event_category': 'whatsapp', 'event_action':'click'});"><i class="fa fa-whatsapp fs-25 mr-10"></i> Contáctanos vía WhatsApp</a>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="header-nav">
      <div class="header-nav-wrapper navbar-scrolltofixed bkgnd-blanco">
        <div class="container">
          <nav id="menuzord-right" class="menuzord blue bkgnd-blue2">
            <a class="menuzord-brand pull-left flip" href="index.php">
              <img src="archivos/logos/logo.png" alt="Clínica Dental Galhez">
            </a>
            <ul class="menuzord-menu dropdown">
              <li class="active"><a class="l-gris" href="#home">HOME</a></li>
              <li><a class="l-gris" href="ortodoncia.php">ORTODONCIA</a></li>
              <li><a class="l-gris" href="rehabilitacion-oral.php">REHABILITACIÓN ORAL</a></li>
              <li><a class="l-gris" href="protesis-dental.php">PRÓTESIS</a></li>
              <li><a class="l-gris" href="estetica-dental.php">ESTÉTICA</a></li>
              <li class="onepage-nav"><a class="l-gris" href="#contact">CONTACTO</a></li>
            </ul>
          </nav>
        </div>
      </div>
    </div>
  </header>
  
  <!-- Start main-content -->
  <div class="main-content">
    <!-- Section: home -->
    <section id="home" class="divider">
      <div class="container-fluid p-0">
        
        <!-- Slider Revolution Start -->
        <div class="rev_slider_wrapper">
          <div class="rev_slider" data-version="5.0">
            <ul>
              <li data-index="rs-1" data-transition="random" data-slotamount="7"  data-easein="default" data-easeout="default" data-masterspeed="1000"  data-thumb="archivos/slider/paquete-anual-dental.jpg"  data-rotate="0"  data-fstransition="fade" data-fsmasterspeed="1500" data-fsslotamount="7" data-saveperformance="off"  data-title="Intro" data-description="">
                <img src="archivos/slider/paquete-anual-dental.jpg"  alt="PAQUETE ANUAL DENTAL"  data-bgposition="center top" data-bgfit="cover" data-bgrepeat="no-repeat" class="rev-slidebg" data-bgparallax="6" data-no-retina>

                <div class="tp-caption tp-resizeme text-uppercase text-white bkgnd-gris pl-15 pr-15"
                  id="rs-3-layer-1"

                  data-x="['right']"
                  data-hoffset="['30']"
                  data-y="['middle']"
                  data-voffset="['-110']" 
                  data-fontsize="['30']"
                  data-lineheight="['50']"

                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1000" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 7; white-space: nowrap;"><h2 class="l-blanca txt-small-slide">TU TRATAMIENTO</h2>

                </div>

                <div class="tp-caption tp-resizeme text-uppercase text-white bkgnd-verde pl-15 pr-15"
                  id="rs-3-layer-2"

                  data-x="['right']"
                  data-hoffset="['30']"
                  data-y="['middle']"
                  data-voffset="['-45']" 
                  data-fontsize="['48']"
                  data-lineheight="['70']"

                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1000" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 7; white-space: nowrap;"><h2 class="l-blanca txt-big-slide">DE ORTODONCIA</h2> 
                </div>

                <!-- LAYER NR. 3 -->
                <div class="tp-caption tp-resizeme text-right l-blanca" 
                  id="rs-3-layer-3"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['30','40','50']"
                  data-fontsize="['21','21','24']"
                  data-lineheight="['28']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:0px; font-weight:400; text-shadow: 0px 0px 4px #000;">Completo por <span class="bold">$600</span> MXN mensuales 
                </div>

                <!-- LAYER NR. 4 -->
                <div class="tp-caption tp-resizeme text-right l-blanca" 
                  id="rs-3-layer-3"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['60','70','80']"
                  data-fontsize="['21','21','24']"
                  data-lineheight="['28']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:0px; font-weight:400; text-shadow: 0px 0px 4px #000;">Incluye consultas, extracciones, aparatos, limpiezas y más...
                </div>

                <!-- LAYER NR. 5 -->
                <div class="tp-caption tp-resizeme" 
                  id="rs-3-layer-4"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['110','150','150']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;"
                  data-transform_in="y:[100%];z:0;rX:0deg;rY:0;rZ:0;sX:1;sY:1;skX:0;skY:0;opacity:0;s:2000;e:Power4.easeInOut;" 
                  data-transform_out="y:[100%];s:1000;e:Power2.easeInOut;s:1000;e:Power2.easeInOut;" 
                  data-mask_in="x:0px;y:[100%];s:inherit;e:inherit;" 
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:1px;"><a class="btn btn-colored btn-lg btn-verde pl-20 pr-20 ancla" href="#paquetes">¡Conócelo! </a> 
                </div>
              </li>
              <li data-index="rs-2" data-transition="random" data-slotamount="7"  data-easein="default" data-easeout="default" data-masterspeed="1000"  data-thumb="archivos/slider/paquetes-de-salud-dental.jpg"  data-rotate="0"  data-fstransition="fade" data-fsmasterspeed="1500" data-fsslotamount="7" data-saveperformance="off"  data-title="Intro" data-description="">
                <img src="archivos/slider/paquetes-de-salud-dental.jpg"  alt="PAQUETES DE SALUD DENTAL"  data-bgposition="center top" data-bgfit="cover" data-bgrepeat="no-repeat" class="rev-slidebg" data-bgparallax="6" data-no-retina>

                <div class="tp-caption tp-resizeme text-uppercase text-white bkgnd-gris pl-15 pr-15"
                  id="rs-3-layer-1"

                  data-x="['right']"
                  data-hoffset="['30']"
                  data-y="['middle']"
                  data-voffset="['-110']" 
                  data-fontsize="['30']"
                  data-lineheight="['50']"

                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1000" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 7; white-space: nowrap;">PAQUETES INDIVIDUALES 

                </div>

                <div class="tp-caption tp-resizeme text-uppercase text-white bkgnd-verde pl-15 pr-15"
                  id="rs-3-layer-2"

                  data-x="['right']"
                  data-hoffset="['30']"
                  data-y="['middle']"
                  data-voffset="['-35']" 
                  data-fontsize="['48']"
                  data-lineheight="['70']"

                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1000" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 7; white-space: nowrap;">Y FAMILIARES
                </div>

                <!-- LAYER NR. 3 -->
                <div class="tp-caption tp-resizeme text-right l-blanca" 
                  id="rs-3-layer-3"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['30','40','50']"
                  data-fontsize="['21','21','24']"
                  data-lineheight="['28']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:0px; font-weight:400; text-shadow: 0px 0px 4px #000;">Una hermosa y sana sonrisa para cada integrante de tu familia
                </div>

                <!-- LAYER NR. 4 -->
                <div class="tp-caption tp-resizeme" 
                  id="rs-3-layer-4"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['80','120','140']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;"
                  data-transform_in="y:[100%];z:0;rX:0deg;rY:0;rZ:0;sX:1;sY:1;skX:0;skY:0;opacity:0;s:2000;e:Power4.easeInOut;" 
                  data-transform_out="y:[100%];s:1000;e:Power2.easeInOut;s:1000;e:Power2.easeInOut;" 
                  data-mask_in="x:0px;y:[100%];s:inherit;e:inherit;" 
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:1px;"><a class="btn btn-colored btn-lg btn-verde pl-20 pr-20 ancla" href="#paquetes">¡Conoce más! </a> 
                </div>
              </li>
              <li data-index="rs-3" data-transition="random" data-slotamount="7"  data-easein="default" data-easeout="default" data-masterspeed="1000"  data-thumb="archivos/slider/estetica.jpg"  data-rotate="0"  data-fstransition="fade" data-fsmasterspeed="1500" data-fsslotamount="7" data-saveperformance="off"  data-title="Intro" data-description="">
                <img src="archivos/slider/estetica.jpg"  alt="Estética dental"  data-bgposition="center top" data-bgfit="cover" data-bgrepeat="no-repeat" class="rev-slidebg" data-bgparallax="6" data-no-retina>

                <div class="tp-caption tp-resizeme text-uppercase text-white bkgnd-gris pl-15 pr-15"
                  id="rs-3-layer-1"

                  data-x="['right']"
                  data-hoffset="['30']"
                  data-y="['middle']"
                  data-voffset="['-110']" 
                  data-fontsize="['30']"
                  data-lineheight="['50']"

                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1000" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 7; white-space: nowrap;">CONSIGUE LA SONRISA

                </div>

                <div class="tp-caption tp-resizeme text-uppercase text-white bkgnd-verde pl-15 pr-15"
                  id="rs-3-layer-2"

                  data-x="['right']"
                  data-hoffset="['30']"
                  data-y="['middle']"
                  data-voffset="['-35']" 
                  data-fontsize="['48']"
                  data-lineheight="['70']"

                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1000" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 7; white-space: nowrap;">QUE SIEMPRE SOÑASTE
                </div>

                <!-- LAYER NR. 3 -->
                <div class="tp-caption tp-resizeme text-right l-blanca" 
                  id="rs-3-layer-3"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['30','40','50']"
                  data-fontsize="['21','21','24']"
                  data-lineheight="['28']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;s:500"
                  data-transform_in="y:100;scaleX:1;scaleY:1;opacity:0;"
                  data-transform_out="x:left(R);s:1000;e:Power3.easeIn;s:1000;e:Power3.easeIn;"
                  data-mask_in="x:0px;y:0px;s:inherit;e:inherit;"
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:0px; font-weight:400; text-shadow: 0px 0px 4px #000;">Blanqueamiento dental, carillas dentales y Diseño de sonrisas
                </div>

                <!-- LAYER NR. 4 -->
                <div class="tp-caption tp-resizeme" 
                  id="rs-3-layer-4"

                  data-x="['right']"
                  data-hoffset="['35']"
                  data-y="['middle']"
                  data-voffset="['80','120','140']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-transform_idle="o:1;"
                  data-transform_in="y:[100%];z:0;rX:0deg;rY:0;rZ:0;sX:1;sY:1;skX:0;skY:0;opacity:0;s:2000;e:Power4.easeInOut;" 
                  data-transform_out="y:[100%];s:1000;e:Power2.easeInOut;s:1000;e:Power2.easeInOut;" 
                  data-mask_in="x:0px;y:[100%];s:inherit;e:inherit;" 
                  data-mask_out="x:inherit;y:inherit;s:inherit;e:inherit;"
                  data-start="1400" 
                  data-splitin="none" 
                  data-splitout="none" 
                  data-responsive_offset="on"
                  style="z-index: 5; white-space: nowrap; letter-spacing:1px;"><a class="btn btn-colored btn-lg btn-verde pl-20 pr-20" href="estetica-dental.php">¡Conozca más! </a> 
                </div>
              </li>
            </ul>
          </div><!-- end .rev_slider -->
        </div>
        <!-- end .rev_slider_wrapper -->
        <script>
          $(document).ready(function(e) {
            var revapi = $(".rev_slider").revolution({
              sliderType:"standard",
              sliderLayout: "auto",
              dottedOverlay: "none",
              delay: 5000,
              navigation: {
                  keyboardNavigation: "off",
                  keyboard_direction: "horizontal",
                  mouseScrollNavigation: "off",
                  onHoverStop: "off",
                  touch: {
                      touchenabled: "on",
                      swipe_threshold: 75,
                      swipe_min_touches: 1,
                      swipe_direction: "horizontal",
                      drag_block_vertical: false
                  },
                  arrows: {
                      style: "zeus",
                      enable: true,
                      hide_onmobile: true,
                      hide_under:600,
                      hide_onleave: true,
                      hide_delay: 200,
                      hide_delay_mobile: 1200,
                      tmp:'<div class="tp-title-wrap">    <div class="tp-arr-imgholder"></div> </div>',
                      left: {
                          h_align: "left",
                          v_align: "center",
                          h_offset: 30,
                          v_offset: 0
                      },
                      right: {
                          h_align: "right",
                          v_align: "center",
                          h_offset: 30,
                          v_offset: 0
                      }
                  },
                    bullets: {
                    enable: true,
                    hide_onmobile: true,
                    hide_under: 600,
                    style: "hebe",
                    hide_onleave: false,
                    direction: "horizontal",
                    h_align: "center",
                    v_align: "bottom",
                    h_offset: 0,
                    v_offset: 30,
                    space: 5,
                    tmp: '<span class="tp-bullet-image"></span><span class="tp-bullet-imageoverlay"></span><span class="tp-bullet-title"></span>'
                }
              },
              responsiveLevels: [1240, 1024, 778],
              visibilityLevels: [1240, 1024, 778],
              gridwidth: [1170, 1024, 778, 480],
              gridheight: [680, 500, 400, 400],
              lazyType: "none",
              parallax: {
                  origo: "slidercenter",
                  speed: 1000,
                  levels: [5, 10, 15, 20, 25, 30, 35, 40, 45, 46, 47, 48, 49, 50, 100, 55],
                  type: "scroll"
              },
              shadow: 0,
              spinner: "off",
              stopLoop: "on",
              stopAfterLoops: 0,
              stopAtSlide: -1,
              shuffle: "off",
              autoHeight: "off",
              fullScreenAutoWidth: "off",
              fullScreenAlignForce: "off",
              fullScreenOffsetContainer: "",
              fullScreenOffset: "0",
              hideThumbsOnMobile: "off",
              hideSliderAtLimit: 0,
              hideCaptionAtLimit: 0,
              hideAllCaptionAtLilmit: 0,
              debugMode: false,
              fallbacks: {
                  simplifyAll: "off",
                  nextSlideOnWindowFocus: "off",
                  disableFocusListener: false,
              }
            });
          });
        </script>
        <!-- Slider Revolution Ends -->

      </div>
    </section>


    <section id="paquetes" class="bkgnd-gris">
      <div class="container">
        <div class="section-centent">
          <div class="row">
            <div class="col-md-12">
            	<p class="l-blanca fs-35">PROMOCIONES</p>
              <div class="services-tab bg-white">
                <ul class="nav nav-tabs">
                  <li class="active"><a href="#tab11" data-toggle="tab"><i class="icon-paquete-ortodoncia"></i><span>ORTODONCIA</span></a></li>
                  <li><a href="#tab12" data-toggle="tab"><i class="icon-paquete-familiar"></i><span>PAQUETE FAMILIAR</span></a></li>
                  <li><a href="#tab13" data-toggle="tab"><i class="icon-paquete-individual"></i><span>PAQUETE INDIVIDUAL</span></a></li>
                </ul>
                <div class="tab-content">
                  <div class="tab-pane fade in active" id="tab11">
                    <div class="row flex-paquetes">
                      <div class="col-md-7">
                        <div class="service-content ml-20 ml-sm-0">
                          <h2 class="title mt-0 l-verde">ORTODONCIA</h2>
                          <p class="lead l-gris">Este paquete integral de ortodoncia incluye todos los servicios y aparatos necesarios para conseguir la sonrisa que deseas.</p>
                          <p class="lead l-gris">Acompañado del seguimiento profesional necesario con consultas periódicas.</p>
                          <p class="mt-30 mb-5 lead l-gris">Este paquete incluye:</p>
                          <div class="row mb-10">
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Rehabilitación Oral incluida</li>
                              <li class="mb-10 l-gris">Brakets arcos y ligas</li>
                              <li class="mb-10 l-gris">Citas de colocación y seguimiento por especialista</li>
                              <li class="mb-10 l-gris">Hasta 12 resinas</li>
                            </ul>
                           </div>
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Hasta 4 extracciones</li>
                              <li class="mb-10 l-gris">Todas las limpiezas necesarias</li>
                              <li class="mb-10 l-gris">Retenedores al final del tratamiento</li>
                              <li class="mb-10 l-gris">30% de descuento en tratamientos ajenos al paquete</li>
                            </ul>
                           </div>
                          </div>
                          <p class="big-prices l-verde">$600 MXN mensuales. Sin pago inicial.</p>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="thumb">
                          <img class="img-fullwidth" src="archivos/paquetes/paquetes-ortodoncia.jpg" alt="PAQUETES DE ORTODONCIA">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="tab-pane fade" id="tab12">
                    <div class="row flex-paquetes">
                      <div class="col-md-7">
                        <div class="service-content ml-20 ml-sm-0">
                          <h2 class="title mt-0 l-verde">PAQUETE FAMILIAR</h2>
                          <p class="lead l-gris">Con este paquete familiar de rehabilitación oral, puedes estar seguro de que la salud de tu familia estará en las mejores manos. Contando con limpiezas, extracciones, resinas para cada integrante, consultas de seguimiento y rehabilitación con nuestros especialistas.</p>
                          <p class="mb-0 lead l-gris">Un solo pago cubre todo un año de servicio para los integrantes de su familia.</p>
                          <div class="row mb-10">
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">4 personas</li>
                              <li class="mb-10 l-gris">Todas las limpiezas</li>
                              <li class="mb-10 l-gris">Hasta 12 Extracciones entre los 4 pacientes</li>
                              <li class="mb-10 l-gris">Hasta 32 resinas entre los 4 pacientes</li>
                            </ul>
                           </div>
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Consultas de seguimiento y rehabilitación</li>
                              <li class="mb-10 l-gris">30% de descuento en tratamientos ajenos al paquete</li>
                            </ul>
                           </div>
                          </div>
                          <p class="big-prices l-verde">Pago único de $10,000 MXN.</p>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="thumb">
                          <img class="img-fullwidth" src="archivos/paquetes/paquete-familiar.jpg" alt="PAQUETE FAMILIAR">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="tab-pane fade" id="tab13">
                    <div class="row flex-paquetes">
                      <div class="col-md-7">
                        <div class="service-content ml-20 ml-sm-0">
                          <h2 class="title mt-0 l-verde">PAQUETE INDIVIDUAL</h2>
                          <p class="lead l-gris">Con este paquete podrás gozar de servicio completo para la salud bucal, contando con limpiezas, extracciones, consultas de seguimiento y rehabilitación con nuestros especialistas.</p>
                          <p class="lead l-gris">Un solo pago cubre todo un año de servicio para un paciente.</p>
                          <p class="mt-30 mb-5 lead l-gris">Este paquete incluye:</p>
                          <div class="row mb-10">
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Todas las limpiezas</li>
                              <li class="mb-10 l-gris">Hasta 3 Extracciones</li>
                              <li class="mb-10 l-gris">Hasta 12 resinas</li>
                            </ul>
                           </div>
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Consultas de seguimiento y rehabilitación</li>
                              <li class="mb-10 l-gris">30% de descuento en tratamientos ajenos al paquete</li>
                            </ul>
                           </div>
                          </div>
                          <p class="big-prices l-verde">Pago único de $5,000 MXN.</p>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="thumb">
                          <img class="img-fullwidth" src="archivos/paquetes/paquete-individual.jpg" alt="PAQUETE INDIVIDUAL">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>


    <!-- Section: about -->
    <section id="acerca-de">
      <div class="container pt-0 pb-0">
        <div class="row flex-acerca-de">
          <div class="col-md-7 pr-35">
            <p class="l-gris mt-0 mb-0 fs-25 lh-normal">Acerca de</p>
            <h2 class="mt-0 mb-0 l-verde fs-30">CLINICA DENTAL GALHEZ</h2>
            <p class="mt-50 mt-sm-30 text-justify l-gris fs-19">Con más de 4 años de trayectoria, Dental Galez ha ofrecido sus servicios de salud bucal a cientos de paciente satisfechos con sus resultados y servicio.
            </p>
            <p class="text-justify l-gris fs-19">
           	Nuestro equipo de experimentados especialistas están comprometidos con brindar un servicio atento y claro a todos sus pacientes ayudándolos no solo con su expertiz en los servicios que brindan, sino en explicarles también como pueden mejorar su salud bucal en su día a día.
            </p>
          </div>
          <div class="col-md-5">
            <img src="archivos/acerca-de/dental-galhez.jpg" alt="Clínica Dental Galhez Metepec">
          </div>
        </div>
      </div>
    </section>

    <!-- Section: Contact -->
    <section id="contact" class="bkgnd-verde">
      <div class="container">
        <div class="section-content">
          <div class="row">
            <div class="col-md-12 wow fadeInRight mt-10" data-wow-duration="1.4s">
              <h3 class="title line-height-1 mt-0 mb-30 l-blanca">Contáctanos para agendar una cita</h3>          
              <!-- Contact Form -->
              <form id="contact-form" name="contact_form">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group mb-20">
                      <input name="name" class="form-control" type="text" placeholder="Nombre" required>
                    </div>
                    <div class="row">
                      <div class="col-sm-12">
                        <div class="form-group mb-20">
                          <input name="tel" class="form-control" type="text" placeholder="Teléfono" required>
                        </div>
                      </div>  
                      <div class="col-sm-12">
                        <div class="form-group mb-20">
                          <input name="email" class="form-control" type="email" placeholder="E-mail" required>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="form-group mb-30">
                          	<select class="form-control l-gris" name="servicio" id="" required>
                          		<option class="l-gris" value="Servicio" selected disabled>-Servicio-</option>
                          		<option class="l-gris" value="Ortodoncia">Ortodoncia</option>
                          		<option class="l-gris" value="Rehabilitación Oral">Rehabilitación Oral</option>
                          		<option class="l-gris" value="Prótesis Dental">Prótesis Dental</option>
                          		<option class="l-gris" value="Estética Dental">Estética Dental</option>
                          	</select>
                        </div>
                      </div>
                    </div>
                    
                  </div>
                  <div class="col-md-6">
                    <div class="form-group mb-20">
                      <textarea name="msj" class="form-control" rows="5" placeholder="Mensaje" required></textarea>
                    </div>
                    <div class="form-group">
                      <div class="btn btn-flat btn-theme-colored text-uppercase mt-0 w-100" id="btn-send" onclick="gtag('event', 'clicks', { 'event_category': 'form', 'event_action':'click'});">Enviar</div>
                      <div class="mensajes-form"></div>
                    </div>
                  </div>
                </div>
              </form>
              <!-- Contact Form Validation-->
              <script type="text/javascript">
                $("#contact_form").validate({
                  submitHandler: function(form) {
                    var form_btn = $(form).find('button[type="submit"]');
                    var form_result_div = '#form-result';
                    $(form_result_div).remove();
                    form_btn.before('<div id="form-result" class="alert alert-success" role="alert" style="display: none;"></div>');
                    var form_btn_old_msg = form_btn.html();
                    form_btn.html(form_btn.prop('disabled', true).data("loading-text"));
                    $(form).ajaxSubmit({
                      dataType:  'json',
                      success: function(data) {
                        if( data.status == 'true' ) {
                          $(form).find('.form-control').val('');
                        }
                        form_btn.prop('disabled', false).html(form_btn_old_msg);
                        $(form_result_div).html(data.message).fadeIn('slow');
                        setTimeout(function(){ $(form_result_div).fadeOut('slow') }, 6000);
                      }
                    });
                  }
                });
              </script>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="container-fluid pt-0 pb-0">
        <div class="row">
          <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1883.105940022847!2d-99.58975074191441!3d19.273150028631807!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85cd8aff425d49b1%3A0x3307f0632e3e685!2sDENTAL+GALHEZ+METEPEC!5e0!3m2!1ses-419!2smx!4v1557263447837!5m2!1ses-419!2smx" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>
        </div>
      </div>
    </section>
  </div>
  <!-- end main-content -->
  
  <?php
      include('footer.php');
  ?>
</div>
<!-- end wrapper -->

<!-- Footer Scripts -->
<!-- JS | Custom script for all pages -->
<script src="js/custom.js"></script>

<!-- SLIDER REVOLUTION 5.0 EXTENSIONS  
      (Load Extensions only on Local File Systems ! 
       The following part can be removed on Server for On Demand Loading) -->
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.actions.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.carousel.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.kenburn.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.layeranimation.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.migration.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.navigation.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.parallax.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.slideanims.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.video.min.js"></script>


</body>
</html>