<!DOCTYPE html>
<html dir="ltr" lang="es-MX">
<head>

<!-- Meta Tags -->
<meta name="viewport" content="width=device-width,initial-scale=1.0"/>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<meta name="description" content="Contamos con distintos tipos de ortodoncia de acuerdo a tus tiempos y necesidades, olvídate de esos dientes desalineados y luce una sonrisa perfecta." />
<meta name="keywords" content="ortodoncia, odontologia, dientes alineados, consultorio dental metepec toluca, dentista, odontopediatra, endodoncista, odontopediatria, brackets, brackets autoligables, autoligado." />
<meta name="author" content="Strave" />

<!-- Page Title -->
<title>Ortodoncia | Dental Galhez</title>

<?php
  include('head.php');
?>
</head>
<body class="has-side-panel side-panel-right fullwidth-page side-push-panel">
<div class="body-overlay"></div>

<div id="wrapper" class="clearfix especialidades">
  <!-- preloader -->
  <div id="preloader">
    <div id="spinner">
      <div class="preloader-dot-loading">
        <div class="cssload-loading"><i></i><i></i><i></i><i></i></div>
      </div>
    </div>
    <div id="disable-preloader" class="btn btn-default btn-sm">Disable Preloader</div>
  </div>
  
  <!-- Header -->
  <header id="header" class="header">
    <div class="bkgnd-verde sm-text-center">
      <div class="container">
        <div class="row">
          <div class="col-md-9">
            <div class="widget no-border m-0">
              
              <ul class="list-inline pull-right flip sm-pull-none sm-text-center mt-5 mb-5">
                <li class="m-0 pl-10 pr-10"> 
                  <a class="text-white " href="mailto:contacto@dentalgalhez.com"><i class="fa fa-envelope-o l-blanca mr-5"></i> <span class="info-header">contacto@dentalgalhez.com</span></a> 
                </li>
                <li class="m-0 pl-10 pr-10">  
                  <a class="text-white " href="tel:7226156711" onclick="gtag('event', 'clicks', { 'event_category': 'call', 'event_action':'click'});"><i class="fa fa-phone l-blanca mr-5"></i><span class="info-header">72 2615 6711</span></a> 
                </li>
              </ul>
            </div>
          </div>
          <div class="col-md-3 whatsapp">
            <div class="sm-display-block mt-sm-10 mb-sm-10 ">
              <a class="p-5 " href="https://web.whatsapp.com/send?phone=5217226156711" onclick="gtag('event', 'clicks', { 'event_category': 'whatsapp', 'event_action':'click'});"><i class="fa fa-whatsapp fs-25 mr-10"></i> Contáctanos vía WhatsApp</a>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="header-nav">
      <div class="header-nav-wrapper navbar-scrolltofixed bkgnd-blanco">
        <div class="container">
          <nav id="menuzord-right" class="menuzord blue bkgnd-blue2">
            <a class="menuzord-brand pull-left flip" href="index.php">
              <img src="archivos/logos/logo.png" alt="Clínica Dental Galhez">
            </a>
            <ul class="menuzord-menu  dropdown">
              <li><a class="l-gris" href="index.php">HOME</a></li>
              <li class="active"><a class="l-gris" href="ortodoncia.php">ORTODONCIA</a></li>
              <li><a class="l-gris" href="rehabilitacion-oral.php">REHABILITACIÓN ORAL</a></li>
              <li><a class="l-gris" href="protesis-dental.php">PRÓTESIS</a></li>
              <li><a class="l-gris" href="estetica-dental.php">ESTÉTICA</a></li>
              <li class="onepage-nav"><a class="l-gris last-menu" href="#contact">CONTACTO</a></li>
            </ul>
          </nav>
        </div>
      </div>
    </div>
  </header>
  
  <!-- Start main-content -->
  <div class="main-content">

    <section class="inner-header divider bkgnd-gris">
      <div class="container pt-20 pb-20">
        <!-- Section Content -->
        <div class="section-content">
          <div class="row"> 
            <div class="col-md-12 xs-text-center">
              <h1 class="title l-blanca">ORTODONCIA <i class="icon-paquete-ortodoncia"></i></h1>

            </div>
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="container">
        <div class="row mtli-row-clearfix">
          <div class="col-sm-6 col-md-8 col-lg-8">
            <div class="campaign maxwidth500 mb-sm-30">
              <div class="thumb">
                <img src="archivos/ortodoncia/ortodoncia.jpg" alt="Servicios de ortodoncia" class="img-fullwidth">
                <div class="campaign-overlay"></div>
              </div>
            </div>
            
          </div>
          <div class="col-sm-6 col-md-4 col-lg-4">
            <div class="sidebar sidebar-right mt-sm-30">
              <div class="widget">
                <h5 class="widget-title l-verde fs-30 mb-40">Nuestras especialidades</h5>
                <ul class="list-divider list-border list check mt-0">
                  <li><a class="l-verde bold" href="ortodoncia.php">ORTODONCIA</a></li>
                  <li><a class="l-gris" href="rehabilitacion-oral.php">REHABILITACIÓN ORAL</a></li>
                  <li><a class="l-gris" href="protesis-dental.php">PRÓTESIS</a></li>
                  <li><a class="l-gris" href="estetica-dental.php">ESTÉTICA</a></li>
                </ul>
              </div>
            </div>
          </div>
          <div class="col-sm-12">
            <div class="event-details mt-50">
              <p class="mb-20 fs-30 l-verde">¿QUÉ ES LA ORTODONCIA?</p>
              <p class="mb-20 l-gris text-justify">La <span class="bold">ortodoncia</span> es la especialidad de la <span class="bold">odontología</span> dedicada a mantener tus dientes alineados o corregir su alineación. La corrección con aparatos llamados brackets ayuda a tus dientes a conseguir una mordida y apariencia ideal.</p>
              <p class="mb-0 l-gris text-justify">Contamos con el tratamiento ortodóncico de acuerdo a tus tiempos y necesidades:</p>
              <ul class="list-services mb-20">
                <li class=""><h2 class="fs-17 l-gris m-0">Arcos metálicos</h2></li>
                <li class=""><h2 class="fs-17 l-gris m-0">Brackets autoligables</h2></li>
                <li class=""><h2 class="fs-17 l-gris m-0">Por aparato retenedor removible</h2></li>
              </ul>
              <p class="bold l-verde text-justify">¡Olvídate de esos dientes desalineados y luce una sonrisa perfecta!</p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section id="paquetes" class="bkgnd-gris">
      <div class="container">
        <div class="section-centent">
          <div class="row">
            <div class="col-md-12">
              <p class="l-blanca fs-35">PROMOCIONES</p>
              <div class="services-tab bg-white">
                <ul class="nav nav-tabs">
                  <li class="active"><a href="#tab11" data-toggle="tab"><i class="icon-paquete-ortodoncia"></i><span>ORTODONCIA</span></a></li>
                  <li><a href="#tab12" data-toggle="tab"><i class="icon-paquete-familiar"></i><span>PAQUETE FAMILIAR</span></a></li>
                  <li><a href="#tab13" data-toggle="tab"><i class="icon-paquete-individual"></i><span>PAQUETE INDIVIDUAL</span></a></li>
                </ul>
                <div class="tab-content">
                  <div class="tab-pane fade in active" id="tab11">
                    <div class="row flex-paquetes">
                      <div class="col-md-7">
                        <div class="service-content ml-20 ml-sm-0">
                          <h2 class="title mt-0 l-verde">ORTODONCIA</h2>
                          <p class="lead l-gris">Este paquete integral de ortodoncia incluye todos los servicios y aparatos necesarios para conseguir la sonrisa que deseas.</p>
                          <p class="lead l-gris">Acompañado del seguimiento profesional necesario con consultas periódicas.</p>
                          <p class="mt-30 mb-5 lead l-gris">Este paquete incluye:</p>
                          <div class="row mb-10">
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Rehabilitación Oral incluida</li>
                              <li class="mb-10 l-gris">Brakets arcos y ligas</li>
                              <li class="mb-10 l-gris">Citas de colocación y seguimiento por especialista</li>
                              <li class="mb-10 l-gris">Hasta 12 resinas</li>
                            </ul>
                           </div>
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Hasta 4 extracciones</li>
                              <li class="mb-10 l-gris">Todas las limpiezas necesarias</li>
                              <li class="mb-10 l-gris">Retenedores al final del tratamiento</li>
                              <li class="mb-10 l-gris">30% de descuento en tratamientos ajenos al paquete</li>
                            </ul>
                           </div>
                          </div>
                          <p class="big-prices l-verde">$600 MXN mensuales. Sin pago inicial.</p>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="thumb">
                          <img class="img-fullwidth" src="archivos/paquetes/paquetes-ortodoncia.jpg" alt="PAQUETES DE ORTODONCIA">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="tab-pane fade" id="tab12">
                    <div class="row flex-paquetes">
                      <div class="col-md-7">
                        <div class="service-content ml-20 ml-sm-0">
                          <h2 class="title mt-0 l-verde">PAQUETE FAMILIAR</h2>
                          <p class="lead l-gris">Con este paquete familiar de rehabilitación oral, puedes estar seguro de que la salud de tu familia estará en las mejores manos. Contando con limpiezas, extracciones, resinas para cada integrante, consultas de seguimiento y rehabilitación con nuestros especialistas.</p>
                          <p class="mb-0 lead l-gris">Un solo pago cubre todo un año de servicio para los integrantes de su familia.</p>
                          <div class="row mb-10">
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">4 personas</li>
                              <li class="mb-10 l-gris">Todas las limpiezas</li>
                              <li class="mb-10 l-gris">Hasta 12 Extracciones entre los 4 pacientes</li>
                              <li class="mb-10 l-gris">Hasta 32 resinas entre los 4 pacientes</li>
                            </ul>
                           </div>
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Consultas de seguimiento y rehabilitación</li>
                              <li class="mb-10 l-gris">30% de descuento en tratamientos ajenos al paquete</li>
                            </ul>
                           </div>
                          </div>
                          <p class="big-prices l-verde">Pago único de $10,000 MXN.</p>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="thumb">
                          <img class="img-fullwidth" src="archivos/paquetes/paquete-familiar.jpg" alt="PAQUETE FAMILIAR">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="tab-pane fade" id="tab13">
                    <div class="row flex-paquetes">
                      <div class="col-md-7">
                        <div class="service-content ml-20 ml-sm-0">
                          <h2 class="title mt-0 l-verde">PAQUETE INDIVIDUAL</h2>
                          <p class="lead l-gris">Con este paquete podrás gozar de servicio completo para la salud bucal, contando con limpiezas, extracciones, consultas de seguimiento y rehabilitación con nuestros especialistas.</p>
                          <p class="lead l-gris">Un solo pago cubre todo un año de servicio para un paciente.</p>
                          <p class="mt-30 mb-5 lead l-gris">Este paquete incluye:</p>
                          <div class="row mb-10">
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Todas las limpiezas</li>
                              <li class="mb-10 l-gris">Hasta 3 Extracciones</li>
                              <li class="mb-10 l-gris">Hasta 12 resinas</li>
                            </ul>
                           </div>
                           <div class="col-sm-6">
                            <ul class="mt-10 list-services">
                              <li class="mb-10 l-gris">Consultas de seguimiento y rehabilitación</li>
                              <li class="mb-10 l-gris">30% de descuento en tratamientos ajenos al paquete</li>
                            </ul>
                           </div>
                          </div>
                          <p class="big-prices l-verde">Pago único de $5,000 MXN.</p>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="thumb">
                          <img class="img-fullwidth" src="archivos/paquetes/paquete-individual.jpg" alt="PAQUETE INDIVIDUAL">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Section: Contact -->
    <section id="contact" class="bkgnd-verde">
      <div class="container">
        <div class="section-content">
          <div class="row">
            <div class="col-md-12 wow fadeInRight mt-10" data-wow-duration="1.4s">
              <h3 class="title line-height-1 mt-0 mb-30 l-blanca">Contáctanos para agendar una cita</h3>          
              <!-- Contact Form -->
              <form id="contact-form" name="contact_form">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group mb-20">
                      <input name="name" class="form-control" type="text" placeholder="Nombre" required>
                    </div>
                    <div class="row">
                      <div class="col-sm-12">
                        <div class="form-group mb-20">
                          <input name="tel" class="form-control" type="text" placeholder="Teléfono" required>
                        </div>
                      </div>  
                      <div class="col-sm-12">
                        <div class="form-group mb-20">
                          <input name="email" class="form-control" type="email" placeholder="E-mail" required>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="form-group mb-30">
                            <select class="form-control l-gris" name="servicio" id="" required>
                              <option class="l-gris" value="Servicio" selected disabled>-Servicio-</option>
                              <option class="l-gris" value="Ortodoncia">Ortodoncia</option>
                              <option class="l-gris" value="Rehabilitación Oral">Rehabilitación Oral</option>
                              <option class="l-gris" value="Prótesis Dental">Prótesis Dental</option>
                              <option class="l-gris" value="Estética Dental">Estética Dental</option>
                            </select>
                        </div>
                      </div>
                    </div>
                    
                  </div>
                  <div class="col-md-6">
                    <div class="form-group mb-20">
                      <textarea name="msj" class="form-control" rows="5" placeholder="Mensaje" required></textarea>
                    </div>
                    <div class="form-group">
                      <div class="btn btn-flat btn-theme-colored text-uppercase mt-0 w-100" id="btn-send" onclick="gtag('event', 'clicks', { 'event_category': 'form', 'event_action':'click'});">Enviar</div>
                      <div class="mensajes-form"></div>
                    </div>
                  </div>
                </div>
              </form>
              <!-- Contact Form Validation-->
              <script type="text/javascript">
                $("#contact_form").validate({
                  submitHandler: function(form) {
                    var form_btn = $(form).find('button[type="submit"]');
                    var form_result_div = '#form-result';
                    $(form_result_div).remove();
                    form_btn.before('<div id="form-result" class="alert alert-success" role="alert" style="display: none;"></div>');
                    var form_btn_old_msg = form_btn.html();
                    form_btn.html(form_btn.prop('disabled', true).data("loading-text"));
                    $(form).ajaxSubmit({
                      dataType:  'json',
                      success: function(data) {
                        if( data.status == 'true' ) {
                          $(form).find('.form-control').val('');
                        }
                        form_btn.prop('disabled', false).html(form_btn_old_msg);
                        $(form_result_div).html(data.message).fadeIn('slow');
                        setTimeout(function(){ $(form_result_div).fadeOut('slow') }, 6000);
                      }
                    });
                  }
                });
              </script>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="container-fluid pt-0 pb-0">
        <div class="row">
          <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1883.105940022847!2d-99.58975074191441!3d19.273150028631807!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85cd8aff425d49b1%3A0x3307f0632e3e685!2sDENTAL+GALHEZ+METEPEC!5e0!3m2!1ses-419!2smx!4v1557263447837!5m2!1ses-419!2smx" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>
        </div>
      </div>
    </section>
  </div>
  <!-- end main-content -->
  
  <?php
      include('footer.php');
  ?>
</div>
<!-- end wrapper -->

<!-- Footer Scripts -->
<!-- JS | Custom script for all pages -->
<script src="js/custom.js"></script>

<!-- SLIDER REVOLUTION 5.0 EXTENSIONS  
      (Load Extensions only on Local File Systems ! 
       The following part can be removed on Server for On Demand Loading) -->
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.actions.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.carousel.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.kenburn.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.layeranimation.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.migration.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.navigation.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.parallax.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.slideanims.min.js"></script>
<script type="text/javascript" src="js/revolution-slider/js/extensions/revolution.extension.video.min.js"></script>


</body>
</html>