$(function(){
	"use strict";

	var $document = $(document),
	$window = $(window),
	plugins = {
		waveSlider: $('#sea'),
		waveSliderFooter: $('#footerSea'),
	}
	// wave effect
	function waveEffect(canvas, parent, color) {

		var TAU = Math.PI * 2;
		var density = 1;
		var speed = 1;
		var res = 0.005; // percentage of screen per x segment
		var outerScale = 0.05 / density;
		var inc = 0;
		var c = $(canvas)[0];
		var ctx = c.getContext('2d');
		var grad = ctx.createLinearGradient(0, 0, 0, c.height * 4);

		function onResize() {
			$(canvas).attr({
				width: $(parent).width() + "px",
				height: $(parent).height() + "px",
			});
		}

		onResize();
		loop();
		$window.resize(onResize);

		function loop() {
			inc -= speed;
			drawWave(color);
			requestAnimationFrame(loop);
		}

		function drawWave(color) {
			var w = c.offsetWidth;
			var h = c.offsetHeight;
			var cx = w * 0.5;
			var cy = h * 0.5;
			ctx.clearRect(0, 0, w, h);
			var segmentWidth = w * res;
			ctx.fillStyle = color;
			ctx.beginPath();
			ctx.moveTo(0, cy);
			for (var i = 0, endi = 1 / res; i <= endi; i++) {
				var _y = cy + Math.sin((i + inc) * TAU * res * density) * cy * Math.sin(i * TAU * res * density * outerScale);
				var _x = i * segmentWidth;
				ctx.lineTo(_x, _y);
			}
			ctx.lineTo(w, h);
			ctx.lineTo(0, h);
			ctx.closePath();
			ctx.fill();
		}
	}
	if (plugins.waveSliderFooter.length) {
		waveEffect(plugins.waveSliderFooter, '.page-footer', '#ffffff80'); /*#28bceb*/
	}
	if (plugins.waveSlider.length) {
		waveEffect(plugins.waveSlider, '#slider', '#ffffff');
	}


	// Scroll menu
	$('.scroll').on('click', function(e) {
        console.log("prueba");
        var Ancla = $(this).attr('href');
        if(Ancla.charAt(0) !== "#") {
            return;
        }
        e.preventDefault();

        if ($('html').hasClass('sticky-header-active')) {
            console.log('stiky header');

            $('body,html').stop(true, true).animate({
                scrollTop: $(Ancla).offset().top - 128
            }, 1000);


        } else {
            $('body,html').stop(true, true).animate({
                scrollTop: $(Ancla).offset().top - 97
            }, 1000);

        }

    });
    // 

    // Form Ajax


    $('.btn-form').on('click', function(){
        $.ajax({
            type: "POST",
            data: $(this).closest("form").serialize(),
            url: "process.php",
            success: function (mje) {
                if (mje == 0){
                    $('.mensajes-form').html("<span style='color:#000; font-size: 18px; text-align: center; margin-top:28px; padding-bottom:28px; font-weight:600'>Su mensaje ha sido enviado, en breve lo contactaremos.");
                    $('.contact-form').trigger("reset");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },3000);
                }else if(mje == 1){
                    $('.mensajes-form').html("<span style='color:red; margin: 15px 0; padding-bottom:28px;'>*Todos los campos son requeridos</span>");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },2000);
                }else if(mje == 2){
                    $('.mensajes-form').html("<span style='color:red; margin: 15px 0; padding-bottom:28px;'>Por favor ingrese una dirección de correo valida</span>");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },2000);
                }
            },
        });
    });
    // End
});