(function ($) {
    // USE STRICT
    "use strict";
    // Pop up
    try {
        var imagePopup = $('#popup-gallery');

        imagePopup.each(function (e) {
            $(this).magnificPopup({
              type: 'image',
              delegate: 'a',
              removalDelay: 500, 
              gallery: {
                enabled: true
              },
              callbacks: {
                beforeOpen: function() {
                  // just a hack that adds mfp-anim class to markup 
                   this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
                   this.st.mainClass = this.st.el.attr('data-effect');
                }
              },
              closeOnContentClick: true,
              midClick: true // allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source.
            });
        });

    } catch(err) {
        console.log(err);
    }
    // End

    // Up
    var up = $(window).width();
    if (up < 800) {
      $(window).scroll(function (event) {
          var scroll = $(window).scrollTop();
          if (scroll >= 100) {
              $('.btn-up').css({"opacity": "1"});
          } else if (scroll <= 99) {
              $('.btn-up').css({"opacity": "0"});
          }
      });
    }

    // End

    // Ajax Form

    $('.btn-enviar').on('click', function(){
        $.ajax({
            type: "POST",
            data: $(this).closest("form").serialize(),
            url: "process.php",
            success: function (mje) {
                if (mje == 0){
                    $('.mensajes-form').html("<span style='color:#000; font-size: 18px; text-align: center; margin-top:28px; padding-bottom:28px; font-weight:600'>Su mensaje se envió exitosamente, gracias por contactarnos");
                    $('.form-contact').trigger("reset");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },4000);
                }else if(mje == 1){
                    $('.mensajes-form').html("<span style='color:red; margin: 15px 0; padding-bottom:28px;'>*Todos los campos son requeridos</span>");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },3000);
                }else if(mje == 2){
                    $('.mensajes-form').html("<span style='color:red; margin: 15px 0; padding-bottom:28px;'>Ingrese una dirección de correo valida</span>");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },3000);
                }
            },
        });
    });
    // End

    // 
    $(function(){
      $(".before-after").twentytwenty({
        default_offset_pct: 0.5, // How much of the before image is visible when the page loads
        orientation: 'horizontal', // Orientation of the before and after images ('horizontal' or 'vertical')
        before_label: 'January 2017', // Set a custom before label
        after_label: 'March 2017', // Set a custom after label
        no_overlay: true, //Do not show the overlay with before and after
        move_slider_on_hover: false, // Move slider on mouse hover?
        move_with_handle_only: true, // Allow a user to swipe anywhere on the image to control slider movement. 
        click_to_move: true // Allow a user to click (or tap) anywhere on the image to move the slider to that location.
      });
    });

})(jQuery);