(function($) {
	
	"use strict";
	
	
	//Hide Loading Box (Preloader)
	function handlePreloader() {
		if($('.preloader').length){
			$('.preloader').delay(200).fadeOut(500);
		}
	}
	
	
	//Update Header Style and Scroll to Top
	function headerStyle() {
		if($('.site-header').length){
			var windowpos = $(window).scrollTop();
			var siteHeader = $('.site-header');
			var scrollLink = $('.scroll-to-top');
			if (windowpos >= 200) {
				siteHeader.addClass('fixed-header');
				scrollLink.fadeIn(300);
			} else {
				siteHeader.removeClass('fixed-header');
				scrollLink.fadeOut(300);
			}
		}
	}
	
	headerStyle();
	
	
	//Submenu Dropdown Toggle
	if($('.site-header li.dropdown ul').length){
		$('.main-header li.dropdown').append('<div class="dropdown-btn"></div>');
		
		//Dropdown Button
		$('.main-header li.dropdown .dropdown-btn').on('click', function() {
			$(this).prev('ul').slideToggle(500);
		});
		
		//Disable dropdown parent link
		$('.site-header .navigation li.dropdown > a,.hidden-bar .side-menu li.dropdown > a').on('click', function(e) {
			e.preventDefault();
		});
	}
	
	
	//Add Scroll Page nav Home Page Three
	if($('.scroll-nav').length) {
		$('.scroll-nav ul').onePageNav();
	}
	
	// Scroll to Navigation
	if($('.scroll-to-navigation').length){
		
		$(".scroll-to-navigation > li > a").on('click', function(e) {
			
			var targetSection = $(this).attr('href');
				
			e.preventDefault();
			var outerParent = $('.scroll-to-navigation > li');
			var targetParent = $(this).parent('li');
			
		   // animate
		   $('html, body').animate({
			   scrollTop: $(targetSection).offset().top
			}, 1000);
			
			outerParent.removeClass('current');
			targetParent.addClass('current');

		});
	}
	
	
	//Popup Navigation Hide Show
	if ($('.header-style-three').length) {
		//Add Custom Scrollbar
		$('.popup-navigation').mCustomScrollbar();
		
		//Hide Sidebar / Popup Navigation
		$('.header-style-three .nav-toggler,.popup-navigation .navigation > li > a').on('click', function (e) {
			e.preventDefault();
			$('body').toggleClass('popup-nav-visible');
		});
	}
	
	
	//Adjust popup navigation height
	function adjustPopupNav() {
		var winDowHeight = $(window).height();
		$('.popup-navigation .navigation-table').css('height',winDowHeight-200);
	}
	
	adjustPopupNav();
	
	
	//Sidebar Nav Header
	if ($('.sidebar-header .nav-outer').length) {
		//Add Custom Scrollbar
		$('.sidebar-header .nav-outer').mCustomScrollbar();
		
		//Sidebar Navigation Dropdown Toggle
		$('.sidebar-header li.dropdown > a').on('click', function() {
			$(this).parent('li').toggleClass('active');
			$(this).next('ul').slideToggle(500);
		});
		
		//Open Sidebar
		$('.sidebar-header .hidden-bar-btn').on('click', function () {
			$('body').toggleClass('visible-sidebar');
		});
	}
	
	
	//Hidden Bar Menu Config
	function hiddenBarMenuConfig() {
		var menuWrap = $('.hidden-bar .side-menu');
		// appending expander button
		menuWrap.find('.dropdown').children('a').append(function () {
			return '<button type="button" class="btn expander"><i class="icon fa fa-angle-down"></i></button>';
		});
		// hidding submenu 
		menuWrap.find('.dropdown').children('ul').hide();
		// toggling child ul
		menuWrap.find('.btn.expander').each(function () {
			$(this).on('click', function () {
				$(this).parent() // return parent of .btn.expander (a) 
					.parent() // return parent of a (li)
						.children('ul').slideToggle();
	
				// adding class to expander container
				$(this).parent().toggleClass('current');
				// toggling arrow of expander
				$(this).find('i').toggleClass('fa-angle-up fa-angle-down');
	
				return false;
	
			});
		});
	}
	
	hiddenBarMenuConfig();
	
	//Hidden Sidebar
	if ($('.hidden-bar').length) {
		var hiddenBar = $('.hidden-bar');
		var hiddenBarOpener = $('.hidden-bar-opener');
		var hiddenBarCloser = $('.hidden-bar-closer');
		$('.hidden-bar-wrapper').mCustomScrollbar();
		
		//Show Sidebar
		hiddenBarOpener.on('click', function () {
			hiddenBar.addClass('visible-sidebar');
		});
		
		//Hide Sidebar
		hiddenBarCloser.on('click', function () {
			hiddenBar.removeClass('visible-sidebar');
		});
		
	}
	
	
	//Revolution Slider
	if($('.main-slider .tp-banner').length){

		jQuery('.main-slider .tp-banner').show().revolution({
			dottedOverlay:"yes",
			delay:10000,
			startwidth:1200,
			startheight:770,
			hideThumbs:600,
			
			thumbWidth:80,
			thumbHeight:50,
			thumbAmount:5,
			
			navigationType:"bullet",
			navigationArrows:"0",
			navigationStyle:"preview4",
			
			touchenabled:"on",
			onHoverStop:"off",
			
			swipe_velocity: 0.7,
			swipe_min_touches: 1,
			swipe_max_touches: 1,
			drag_block_vertical: false,
			
			parallax:"mouse",
			parallaxBgFreeze:"on",
			parallaxLevels:[7,4,3,2,5,4,3,2,1,0],
			
			keyboardNavigation:"off",
			
			navigationHAlign:"center",
			navigationVAlign:"bottom",
			navigationHOffset:0,
			navigationVOffset:20,
			
			soloArrowLeftHalign:"left",
			soloArrowLeftValign:"center",
			soloArrowLeftHOffset:20,
			soloArrowLeftVOffset:0,
			
			soloArrowRightHalign:"right",
			soloArrowRightValign:"center",
			soloArrowRightHOffset:20,
			soloArrowRightVOffset:0,
			
			shadow:0,
			fullWidth:"on",
			fullScreen:"on",
			
			spinner:"spinner1",
			
			stopLoop:"off",
			stopAfterLoops:-1,
			stopAtSlide:-1,
			
			shuffle:"off",
			
			autoHeight:"on",
			forceFullWidth:"on",
			
			hideThumbsOnMobile:"on",
			hideNavDelayOnMobile:1500,
			hideBulletsOnMobile:"on",
			hideArrowsOnMobile:"on",
			hideThumbsUnderResolution:0,
			
			hideSliderAtLimit:0,
			hideCaptionAtLimit:0,
			hideAllCaptionAtLilmit:0,
			startWithSlide:0,
			videoJsPath:"",
			fullScreenOffsetContainer: ""
	  });
	}
	
	
	// Fact Counter
	function factCounter() {
		if($('.fact-counter').length){
			$('.fact-counter .counter-column.animated').each(function() {
		
				var $t = $(this),
					n = $t.find(".count-text").attr("data-stop"),
					p = $t.find(".count-text").attr("data-prepend"),
					r = parseInt($t.find(".count-text").attr("data-speed"), 10);
				if (!$t.hasClass("counted")) {
					$t.addClass("counted");
					$({
						countNum: $t.find(".count-text").text()
					}).animate({
						countNum: n
					}, {
						duration: r,
						easing: "linear",
						step: function() {
							$t.find(".count-text").text(Math.floor(this.countNum));
						},
						complete: function() {
							$t.find(".count-text").text(p+this.countNum);
						}
					});
				}
				
			});
		}
	}
	
	
	//Project with Scroller
	if ($('.scroller-container .portfolio-outer').length) {
		//Add Custom Scrollbar
		$('.scroller-container .portfolio-outer').mCustomScrollbar({
			axis:"x",
			advanced:{autoExpandHorizontalScroll:true}
		});
	}
	
	
	//Project Carousel
	// if ($('.project-section .latest-project-carousel').length) {
	// 	$('.project-section .latest-project-carousel').owlCarousel({
	// 		loop:true,
	// 		margin:20,
	// 		nav:true,
	// 		dots: false,
	// 		autoplayHoverPause:true,
	// 		autoplay: false,
	// 		smartSpeed: 700,
	// 		mouseDrag: false,
	// 		touchDrag: false,
	// 		navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
	// 		responsive:{
	// 			0:{
	// 				items:1
	// 			},
	// 			600:{
	// 				items:1,
	// 				dots:false
	// 			},
	// 			760:{
	// 				items:2
	// 			},
	// 			1024:{
	// 				items:3
	// 			},
	// 			1100:{
	// 				items:3
	// 			}
	// 		}
	// 	});    		
	// }

	//Project Carousel
	if ($('.project-item .project-box').length) {
		$('.project-item .project-box').owlCarousel({
			loop:true,
			margin:20,
			nav:true,
			dots: false,
			autoplayHoverPause:false,
			autoplay: true,
			smartSpeed: 700,
			navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
			responsive:{
				0:{
					items:1

				},
				600:{
					items:1,
					nav:true

				},
				760:{
					items:1

				},
				1024:{
					items:1

				},
				1100:{
					items:1

				}
			}
		});    		
	}
	
	//Project Carousel Two
	if ($('.project-section .latest-project-carousel-two').length) {
		$('.project-section .latest-project-carousel-two').owlCarousel({
			loop:true,
			margin:10,
			nav:true,
			autoplayHoverPause:false,
			autoplay: true,
			smartSpeed: 700,
			navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:2
				},
				1024:{
					items:3
				},
				1100:{
					items:3
				}
			}
		});    		
	}
	
	//Testimonial Carousel Slider / Three Column
	if ($('.testimonail-carousel').length) {
		$('.testimonail-carousel').owlCarousel({
			loop:true,
			margin:65,
			nav:true,
			autoplayHoverPause:false,
			autoplay: true,
			smartSpeed: 700,
			navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:2
				},
				1024:{
					items:3
				},
				1100:{
					items:3
				}
			}
		});    		
	}
	
	//Sponsors Carousel
	if ($('.sponsors-carousel').length) {
		$('.sponsors-carousel').owlCarousel({
			loop:true,
			margin:40,
			nav:true,
			smartSpeed: 500,
			autoplay: 5000,
			navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:3
				},
				800:{
					items:4
				},
				1024:{
					items:5
				},
				1200:{
					items:5
				}
			}
		});    		
	}
	
	//News Carousel
	if ($('.news-carousel').length) {
		$('.news-carousel').owlCarousel({
			loop:true,
			margin:48,
			nav:true,
			smartSpeed: 500,
			autoplay: 5000,
			navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				800:{
					items:2
				},
				1024:{
					items:2
				},
				1200:{
					items:2
				}
			}
		});		
	}
	
	
	//Testimonial Slider / Master Slider
	if($('#testimonial-slider').length){
		var slider = new MasterSlider();

		slider.control('arrows');

		slider.setup('testimonial-slider' , {
			width:550,
			//height:300,
			space:0,
			autoHeight:true,
			wheel:true,
			true:true,
			loop:true,
			view:'flow',
			autoplay: true,
			speed:17,
			layout:'partialview'
		});
	}
	
	
	//Single Item Slider
	if ($('.single-item-carousel').length) {
		$('.single-item-carousel').owlCarousel({
			loop:true,
			margin:0,
			nav:true,
			smartSpeed: 700,
			autoplay: 4000,
			navText: [ '<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				1200:{
					items:1
				}
			}
		});    		
	}
	
	//Projects Style Three
	if ($('.project-section-three .latest-project-carousel').length) {
		$('.project-section-three .latest-project-carousel').owlCarousel({
			loop:true,
			margin:5,
			nav:true,
			autoplayHoverPause:false,
			autoplay: true,
			smartSpeed: 700,
			navText: [ '<span class="fa fa-long-arrow-left"></span> PREV', 'NEXT <span class="fa fa-long-arrow-right"></span>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:2
				},
				1024:{
					items:4
				},
				1100:{
					items:4
				}
			}
		});    		
	}
	
	
	//Progress Bar / Levels
	if($('.skill-progress .progress-box .bar-fill').length){
		$(".progress-box .bar-fill").each(function() {
			var progressWidth = $(this).attr('data-percent');
			$(this).css('width',progressWidth+'%');
		});
	}
	
	
	//Mixitup Gallery
	if($('.filter-list').length){
		$('.filter-list').mixItUp({});
	}
	
	
	//Sortable Masonary with Filters
	function enableMasonry() {
		if($('.sortable-masonry').length){
	
			var winDow = $(window);
			// Needed variables
			var $container=$('.sortable-masonry .items-container');
			var $filter=$('.filter-btns');
	
			$container.isotope({
				filter:'*',
				 masonry: {
					columnWidth : 1 
				 },
				animationOptions:{
					duration:1000,
					easing:'linear'
				}
			});
			
	
			// Isotope Filter 
			$filter.find('li').on('click', function(){
				var selector = $(this).attr('data-filter');
	
				try {
					$container.isotope({ 
						filter	: selector,
						animationOptions: {
							duration: 1000,
							easing	: 'linear',
							queue	: false
						}
					});
				} catch(err) {
	
				}
				return false;
			});
	
	
			winDow.bind('resize', function(){
				var selector = $filter.find('li.active').attr('data-filter');

				$container.isotope({ 
					filter	: selector,
					animationOptions: {
						duration: 1000,
						easing	: 'linear',
						queue	: false
					}
				});
			});
	
	
			var filterItemA	= $('.filter-btns li');
	
			filterItemA.on('click', function(){
				var $this = $(this);
				if ( !$this.hasClass('active')) {
					filterItemA.removeClass('active');
					$this.addClass('active');
				}
			});
		}
	}
	
	enableMasonry();
	
	
	//LightBox / Fancybox
	if($('.lightbox-image').length) {
		$('.lightbox-image').fancybox({
			openEffect  : 'fade',
			closeEffect : 'fade',
			helpers : {
				media : {}
			}
		});
	}
	
	
	//Contact Form Validation
	if($('#contact-form').length){
		$('#contact-form').validate({
			rules: {
				username: {
					required: true
				},
				email: {
					required: true,
					email: true
				},
				phone: {
					required: true
				},
				subject: {
					required: true
				},
				message: {
					required: true
				}
			}
		});
	}
	
	
	// Scroll to a Specific Div
	if($('.scroll-to-target').length){
		$(".scroll-to-target").on('click', function() {
			var target = $(this).attr('data-target');
		   // animate
		   $('html, body').animate({
			   scrollTop: $(target).offset().top
			 }, 1500);
	
		});
	}
	
	
	// Elements Animation
	if($('.wow').length){
		var wow = new WOW(
		  {
			boxClass:     'wow',      // animated element css class (default is wow)
			animateClass: 'animated', // animation css class (default is animated)
			offset:       0,          // distance to the element when triggering the animation (default is 0)
			mobile:       true,       // trigger animations on mobile devices (default is true)
			live:         true       // act on asynchronously loaded content (default is true)
		  }
		);
		wow.init();
	}


/* ==========================================================================
   When document is Scrollig, do
   ========================================================================== */
	
	$(window).on('scroll', function() {
		headerStyle();
		factCounter();
	});
	
/* ==========================================================================
   When document is loading, do
   ========================================================================== */
	
	$(window).on('load', function() {
		handlePreloader();
		enableMasonry();
	});
	
/* ==========================================================================
   When Window resizes
   ========================================================================== */
	
	$(window).on('resize', function() {
		adjustPopupNav();
	});

	// Form Send
	$('.btn-form').on('click', function(){
        $.ajax({
            type: "POST",
            data: $(this).closest("form").serialize(),
            url: "process.php",
            success: function (mje) {
                if (mje == 0){
                    $('.mensajes-form').html("<span style='color:#414141; font-size: 18px; text-align: center; margin-top:28px; padding-bottom:28px; font-weight:600'>GRACIAS POR CONTACTARNOS</span>");
                    $('.form-contact').trigger("reset");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },3000);
                }else if(mje == 1){
                    $('.mensajes-form').html("<span style='color:red; margin: 15px 0; padding-bottom:28px;'>*TODOS LOS CAMPOS SON REQUERIDOS</span>");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },2000);
                }else if(mje == 2){
                    $('.mensajes-form').html("<span style='color:red; margin: 15px 0; padding-bottom:28px;'>INGRESE UNA DIRECCIÓN DE CORREO VALIDA</span>");
                    setTimeout(function(){
                        $('.mensajes-form').html("");
                    },2000);
                }
            },
        });
    });

	// Scroll animation click
	$('.scroll').on('click', function(e) {
        var Ancla = $(this).attr('href');
        if(Ancla.charAt(0) !== "#") {
            return;
        }
        e.preventDefault();
        if ($('header').hasClass('fixed-header')) {
            $('body,html').stop(true, true).animate({
                scrollTop: $(Ancla).offset().top - 108
            }, 1000);
        } else {
            $('body,html').stop(true, true).animate({
                scrollTop: $(Ancla).offset().top - 80
            }, 1000);

        }

    });

    // hidden menu movil on click
    $('.hidden-menu-click').on('click', function(){
    	$('.hidden-bar').removeClass('visible-sidebar');
    });

})(window.jQuery);