<!DOCTYPE html>
<html>
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>Martha Herrera – Comunicación y Alianzas para transformar al mundo</title>	

		<meta name="keywords" content="Onu, agenda 2030, objetivos de desarrollo sostenible, ODS, cambiar al mundo, desarrollo sustentable, Visionarios 2030, metas de desarrollo sostenible, gobierno de México, organización de las naciones unidas, " />
		<meta name="description" content="Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.">
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Favicon -->
		<link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon" />
		<link rel="apple-touch-icon" href="img/apple-touch-icon.png">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.compat.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

        <!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">

		<!-- Skin CSS -->
		<link id="skinCSS" rel="stylesheet" href="css/skins/skin-corporate-10.css">

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">
		<link rel="stylesheet" href="css/visionarios-person.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

	</head>
	<body class="visionarioChangeFooter" data-plugin-page-transition>
		<div class="body headerWhite">
            <!-- Main header -->
			<?php include('main-header.php')?>
            <!-- End Main Header -->

			<div role="main" class="main">
				<!-- Slide -->
				<section class="section section-with-shape-divider border-0 py-0 m-0" id="slideVisionarioPerson">
					<div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#1c97d4"/>
						</svg>
					</div>
					<div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs nav-style-1 nav-inside nav-inside-plus nav-primary nav-md nav-font-size-md show-nav-hover mb-0" data-plugin-options="{'autoplayTimeout': 9000, 'autoplay': false }" style="height: 100vh;">
						<div class="owl-stage-outer">
							<div class="owl-stage">

								<!-- Carousel Slide 1 -->
								<div class="owl-item position-relative" style="background-image: url(archivos/ficha-experto/Visionarios-2030-Ficha-Experto-VIP-Martha-Herrera-Banner.jpg); background-size: cover; background-position: center; height: 100vh;">
									<div class="container position-relative z-index-3 h-100">
										<div class="row justify-content-center align-items-center h-100">
											<div class="col-lg-9">
												<div class="d-flex flex-column align-items-center">
													<h1 class="position-relative text-color-light text-4 px-4 mb-2 appear-animation smallTitleSlide" data-appear-animation="fadeInDownShorter" data-plugin-options="{'minWindowWidth': 0}">
														<span class="position-absolute right-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
														<span class="">VISIONARIA </span>17.6
														<span class="position-absolute left-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
													</h1>
													<p class="text-4 text-center mb-0 titleSlide azul" ><span class="blanco">Martha </span>Herrera</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Frase -->
				<section id="fraseInicioPersona" class="color3">
					<div class="container">
						<div class="row">
							<div class="col-md-9 mx-md-auto appear-animation maskUp appear-animation-visible" data-appear-animation="maskUp">
								<p class="text text-center"><span class="blanco">«Conecto visiones para activar el</span> 
                                <span class="naranja"> crecimiento personal y colectivo».</span></p>
							</div>
						</div>
					</div>
				</section>
				<!-- End Frase -->

				<!-- Descripción Persona -->
				<section id="descriptionPersonVisionario" class="">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-7">
                                <div class="heading">
                                    <p class="title">MARTHA HERRERA</p>
                                    <p class="subtitle">Visionaria 17.6</p>
                                </div>
                                <div class="description">
                                    <p class="text">Mi principal motivación es ayudar a que las personas crezcan y los proyectos se concreten. De los 25 años que he trabajado en CEMEX lo que más me llena de satisfacción es conectar con la gente de comunidades vulnerables en mi rol de impacto social. Cuando veo para atrás, puedo contar el honor que me da haber liderado 500 alianzas activas globales con gobiernos, universidades, organismos multilaterales, ONGs, ciudadanos y empresas, y por eso se que sí se puede, que sí podemos hacer alianzas para alcanzar objetivos mayores.</p>
                                    <p class="text">Mi pasión es el desarrollo humano y personal, y lo considero la mejor herramienta para crear alianzas estratégicas poderosas.</p>
                                    <p class="text">Mi promesa: Nuevas herramientas de colaboración para acelerar el cambio.</p>
                                    <ul class="list">
                                        <p>Espacios de acción:</p>
                                        <li>Directora de Impacto Social en CEMEX</li>
                                        <li>Presidenta de la red de Pacto Mundial de la ONU</li>
                                        <li>Directora del Centro CEMEX-Tec de Monterrey para el desarrollo de comunidades sostenibles</li>
                                        <li>VP de ARISE global y Presidenta de ARISE MX</li>
                                        <li>¡Entre otros!</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <img src="archivos/ficha-experto/martha-herrera.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </section>
				<!-- End Descripcion Persona -->

                <!-- Trabajo Visionario -->
                <div id="trabajosVisionario" class="curved-border curved-border-top curved-morado">
                    <div class="container container-xl-custom">
                        <div class="row text-center text-lg-start rowProject">
                            <div class="col-lg-7 appear-animation" style="position: relative;" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
                                <p class="smallTitle">OBJETIVOS DE DESARROLLO SONTENIBLE</p>
                                <h2 class="title morado">ODS 17.6 Alianzas para lograr los objetivos</h2>
                                <p class="mb-4 text">Mejorar la Alianza Mundial para el Desarrollo Sostenible, complementada por alianzas entre múltiples interesados que movilicen e intercambien conocimientos, especialización, tecnología y recursos financieros, a fin de apoyar el logro de los Objetivos de Desarrollo Sostenible en todos los países, particularmente los países en desarrollo.</p>
                                <p class="smallTitleText morado">¡Llamado a la acción!</p>
                                <p class="smallText">La colaboración no es un tema de buena voluntad, es una de las habilidades más importantes que necesitamos para el siglo XXI. Necesitamos colaborar entre países, sectores y generaciones. Necesitamos construir un entorno de trabajo colaborativo enfocado en el bienestar global y el desarrollo rumbo al 2030.</p>
								<p class="smallTitleText morado">Desde casa</p>
                                <p class="mb-4 smallText">¡Tú puedes cambiar al mundo; los 17 Objetivos pueden aplicarse en pequeñas, medianas y grandes acciones! <a href="https://www.un.org/sustainabledevelopment/es/wp-content/uploads/sites/3/2018/08/170Actions-web_Sp.pdf" target="_blank">Más detalles aquí.</a></p>
                                <a href="#" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded" style="bottom: -30px;">VER MÁS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
                            </div>
                            <div class="col-md-5 col-lg-5 px-2 mt-3 mt-lg-0 appear-animation boxImgRight" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
                                <img src="archivos/icons/S_SDG_Icons-01-17.jpeg" class="img-fluid work" alt=""/>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End trabajo visionario -->

                <!-- Metas Visionario -->
                <section class="section bg-light section-with-shape-divider border-0 py-0 m-0">
                    <div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#144a6b"/>
						</svg>
					</div>
                    <div class="container metas">
                        <div class="row justify-content-center">
                            <div class="col-lg-8 text-center">
                                <div class="overflow-hidden mb-3">
                                    <h2 class="title appear-animation" data-appear-animation="maskUp">Metas <span class="color3">2030</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center pb-5">
                            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600">
                                    <div class="circular-bar-chart" data-percent="100" data-plugin-options="{'barColor': '#1c97d4'}">
                                        <span class="mt-2 percentNumber">100%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color3">2021</h4>
                                    <p class="px-3 text">Entregar resultados tangibles de los Grupos de Trabajo del Pacto Mundial México.</p>
                                </div>
                            </div>

                            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="400">
                                    <div class="circular-bar-chart" data-percent="50" data-plugin-options="{'barColor': '#1c97d4'}">
                                        <span class="mt-2 percentNumber">50%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color3">2025</h4>
                                    <p class="px-3 text">Ofrecer herramientas sólidas para conectar a los 4 sectores mejorando las conexiones en cantidad y calidad, incidiendo en el avance de los ODS.</p>
                                </div>
                            </div>

                            <div class="col-md-7 col-lg-4">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
                                    <div class="circular-bar-chart" data-percent="25" data-plugin-options="{'barColor': '#1c97d4'}">
                                        <span class="mt-2 percentNumber">25%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color3">2030</h4>
                                    <p class="px-3 text">Metodología colaborativa enfocada en el bienestar personal y global del Siglo XXI.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- End Metas Visionario -->

                <!-- Contacto Visionario -->
                <div id="contactoVisionario" class="" data-spy-offset="15">
                    <div class="">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-6 text-center pb-3 pb-lg-0 mb-5 mb-lg-0 border-right">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="row pb-5 mb-5">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'top', 'speed': 0.2, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-twitter icon color3"></i>
                                                        <h4 class="mb-0 titleLink">Twitter</h4>
                                                        <a href="https://twitter.com/mherrera68" target="_blank" class="mb-0 link">@mherrera68</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.2, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-facebook-f icon color3"></i>
                                                        <h4 class=" mb-0 titleLink">Facebook</h4>
                                                        <a href="https://www.facebook.com/marthapatricia.herrera" target="_blank" class="mb-0 link">facebook.com/marthapatricia.herrera</a>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 pt-5">
                                            <div class="row pb-5 mb-5">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.1, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-linkedin-in icon color3"></i>
                                                        <h4 class="mb-0 titleLink">Linkedin</h4>
                                                        <a href="https://www.linkedin.com/in/martha-herrera-gonzalez/" target="_blank" class="mb-0 link">martha-herrera-gonzalez</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.1, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-instagram icon color3"></i>
                                                        <h4 class="mb-0 titleLink">Instagram</h4>
                                                        <a href="https://www.instagram.com/martha_rse/" target="_blank" class="mb-0 link">@martha_rse</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 ps-lg-5 flexBox">
                                    <div class="heading">
                                        <p class="smallTitle">COMUNÍCATE</p>
                                        <p class="title">Contacto</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Contacto Visionario -->

			</div>

			<?php include('footer.php')?>
		</div>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.gmap/jquery.gmap.min.js"></script>
		<script src="vendor/lazysizes/lazysizes.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>

		<!-- Theme Custom -->
		<script src="js/custom.js"></script>

		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>

	</body>
</html>
