<!DOCTYPE html>
<html>
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>VISIONARIOS 2030 – Comunicación y Alianzas para transformar al mundo</title>	

		<meta name="keywords" content="Onu, agenda 2030, objetivos de desarrollo sostenible, ODS, cambiar al mundo, desarrollo sustentable, Visionarios 2030, metas de desarrollo sostenible, gobierno de México, organización de las naciones unidas, " />
		<meta name="description" content="Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.">
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Favicon -->
		<link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon" />
		<link rel="apple-touch-icon" href="img/apple-touch-icon.png">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.compat.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

		<!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">
		<link rel="stylesheet" href="css/theme-blog.css">
		<link rel="stylesheet" href="css/theme-shop.css">

		<!-- Skin CSS -->
		<link id="skinCSS" rel="stylesheet" href="css/skins/skin-corporate-10.css">

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

	</head>
	<body data-plugin-page-transition>
		<div class="body">
			<!-- Main header -->
			<?php include('main-header.php')?>
            <!-- End Main Header -->

			<div role="main" class="main">
				<!-- Slide -->
				<section class="section section-with-shape-divider border-0 py-0 m-0">
					<div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#ffffff"/>
						</svg>
					</div>
					<div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs nav-style-1 nav-inside nav-inside-plus nav-primary nav-md nav-font-size-md show-nav-hover mb-0" data-plugin-options="{'autoplayTimeout': 9000, 'autoplay': false }" style="height: 100vh;">
						<div class="owl-stage-outer">
							<div class="owl-stage">

								<!-- Carousel Slide 1 -->
								<div class="owl-item position-relative" style="background-image: url(archivos/home/Visionarios-2030-Home-Banner.jpg); background-size: cover; background-position: center; height: 100vh;">
									<div class="container position-relative z-index-3 h-100">
										<div class="row justify-content-center align-items-center h-100">
											<div class="col-lg-8">
												<div class="d-flex flex-column align-items-center">
													<h1 class="position-relative text-4 px-4 mb-2 appear-animation smallTitleSlide" data-appear-animation="fadeInDownShorter" data-plugin-options="{'minWindowWidth': 0}">
														<span class="position-absolute right-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
														<span class="">ALIANZAS Y COMUNICACIÓN</span><br>
														PARA CAMBIAR EL MUNDO
														<span class="position-absolute left-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
													</h1>
													<p class="text-4 text-center mb-0 titleSlide" ><span>Y tú, </span> ¿qué tipo de 
														visionario eres?</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Video -->
				<div class="container my-5" id="videoHome">
					<div class="row py-5">
						<div class="col">
							<div class="row align-items-center">
								<div class="col-lg-5">
									<div class="featured-boxes featured-boxes-modern-style-1">
										<div class="featured-box overlay overlay-show overlay-op-9 border-radius border-0">
											<div class="featured-box-background" style="background-image: url(img/gallery/gallery-11.jpg); background-size: cover; background-position: center;"></div>
											<div class="box-content px-lg-4 px-xl-5 py-lg-5">
												<div class="py-5 my-4">
													<a class="text-decoration-none lightbox" href="https://www.youtube.com/watch?v=MCKH5xk8X-g" data-plugin-options="{'type':'iframe'}">
														<img class="icon-animated" width="60" src="vendor/linea-icons/linea-music/icons/play-button.svg" alt="" data-icon data-plugin-options="{'color': '#FFF', 'animated': true, 'delay': 600, 'strokeBased': true}" />
													</a>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-7 text-center text-lg-start content">
									<h1 class="mt-4 mt-lg-0 title">¿Qué es la <span class="">Agenda 2030</span> 
									y por qué es tan importante?</h1>
									<p class="description">El 25 de septiembre de 2015 más de 150 líderes mundiales asistieron a la Cumbre de las Naciones Unidas sobre el Desarrollo Sostenible en Nueva York con el fin de aprobar la Agenda para el Desarrollo Sostenible. El documento final, titulado “Transformar Nuestro Mundo: la Agenda 2030 para el Desarrollo Sostenible”, fue adoptado por los 193 Estados Miembros de las Naciones Unidas. Dicho documento incluye los 17 Objetivos del Desarrollo Sostenible cuyo objetivo poner fin a la pobreza, luchar contra la desigualdad y la injusticia, y hacer frente al cambio climático sin que nadie quede rezagado para el 2030.</p>
									<a href="ods.php" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER OBJETIVOS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
								</div>
							</div>
						</div>
					</div>
				</div>

				<!-- Objetivos -->
				<div class="curved-border curved-border-top" id="objetivosHome">
					<div class="container pt-3 mt-5">
						<div class="row justify-content-center mb-5">
							<div class="col-lg-10 col-xl-10 text-end">
								<div class="overflow-hidden mb-3">
									<h1 class="mb-0 appear-animation title" data-appear-animation="maskUp" data-appear-animation-delay="400">¿Qué y cuáles son los <span>Objetivos de Desarrollo Sostenible?</span></h1>
								</div>
								<p class="mb-4 appear-animation description" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">“Los ODS son mecanismos apropiados que permitirán a la población y a sus dirigentes de forma conjunta, participar en la búsqueda de consensos sociales y disminuir las brechas.”</p>
								<p class="appear-animation author" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Amina J. Mohammed, </p>
								<p class="mb-4 appear-animation company" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Vicesecretaria General de las Naciones Unidas</p>
								<a href="ods.php" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER OBJETIVOS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
							</div>
							<div class="col-md-12">
								<div class="iconsContent">
									<img src="archivos/icons/S_SDG_Icons-01-01.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-02.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-03.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-04.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-05.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-06.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-07.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-08.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-09.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-10.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-11.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-12.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-13.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-14.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-15.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-16.jpeg" alt="">
									<img src="archivos/icons/S_SDG_Icons-01-17.jpeg" alt="">
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<!-- Que hacemos -->
				<section class="section section-height-3 border-0 mt-0 mb-0" id="que-hacemos-home" style="position: relative;">
					<div class="container">
						<div class="row">
							<div class="col">
								<div class="row align-items-center appear-animation" data-appear-animation="fadeInRightShorter">
									<div class="col-md-7 mb-md-0">
										<h1 class="font-weight-normal text-6 mb-3 title">¿Qué hacemos en <span>Visionarios 2030?</span></h1>
										<p class="description">Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.</p>
										<div class="list">
											<p>Creemos que:</p>
											<ul>
												<li>Lo que no se comunica <span>no existe.</span></li>
												<li>Lo que aprendiste ayer, <span>probablemente mañana ya no sirva.</span></li>
												<li>Nadie puede solo; <span>juntos podemos llegar más rápido en menos tiempo.</span></li>
											</ul>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<img class="hands" src="archivos/home/que-hacemos-home.jpg" alt="">
				</section>	

				<!-- Box Colors -->
				<div class="container-fluid" id="boxColors">
					<div class="row featured-boxes-full featured-boxes-full-scale">
						<div class="col-lg-4 featured-box-full box1">
							<img src="archivos/home/Visionarios-2030-Home-Iconos_Comunicamos.svg" alt="Comunicamos">
							<h4>Comunicamos</h4>
						</div>
						<div class="col-lg-4 featured-box-full box2">
							<img src="archivos/home/Visionarios-2030-Home-Iconos_Capacitamos.svg" alt="Capactitamos">
							<h4>Capacitamos</h4>
						</div>
						<div class="col-lg-4 featured-box-full box3">
							<img src="archivos/home/Visionarios-2030-Home-Iconos_Alianzas-Locales.svg" alt="Alianzas Locales">
							<h4>Promovemos alianzas locales</h4>
						</div>
					</div>
				</div>

				<!-- Call To Action News -->
				<section class="call-to-action content-align-center" id="callToActionNews">
					<div class="container">
						<div class="row">
							<div class="col-md-8 offset-md-1 col-lg-8">
								<div class="call-to-action-content text">
									<p class="mb-0"><span>Cada líder ha elegido una meta 2030</span> y nosotros 
									somos la <span class="cursive">Sala de Difusión</span> que ofrece noticias 
									reportadas por sus propios líderes</p>
								</div>
							</div>
							<div class="col-md-2 col-lg-2">
								<div class="call-to-action-btn">
									<a href="#" target="_blank" class="btn text-color-light px-4 py-2 mt-5 btn-py-2 text-1 rounded">VER NOTICIAS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a><span class="arrow arrow2 hlb d-none d-md-block" data-appear-animation="rotateInUpLeft" style="top: -90px; left: 70%;"></span>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Clients -->
				<div class="container container-xl-custom" id="clientsHome">
					<div class="row text-center py-4 my-5">
						<div class="col-md-12">
							<h1 class="title">Estos son algunos de <span>nuestros Aliados</span></h1>
						</div>
						<div class="owl-carousel owl-theme carousel-center-active-item mb-0" data-plugin-options="{'responsive': {'0': {'items': 1}, '476': {'items': 1}, '768': {'items': 5}, '992': {'items': 5}, '1200': {'items': 5}}, 'margin': 140, 'autoplay': true, 'autoplayTimeout': 3000, 'dots': false}">
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-Alianza-por-la-inversion.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-sumando-hacemos-mas.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-oxigeno-logo.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-Logo-Yo-tambien.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-La-buena-huella.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-instituto-comunicacion-estrategica-logo.jpg" alt="">
							</div>
						</div>
					</div>
				</div>

				<!-- Newsletter -->
				<?php include('newsletter.php')?>

			</div>

			<?php include('footer.php')?>
		</div>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.gmap/jquery.gmap.min.js"></script>
		<script src="vendor/lazysizes/lazysizes.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>

		<!-- Theme Custom -->
		<script src="js/custom.js"></script>

		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>

	</body>
</html>
