<!DOCTYPE html>
<html>
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>VISIONARIOS 2030 – Comunicación y Alianzas para transformar al mundo</title>	

		<meta name="keywords" content="Onu, agenda 2030, objetivos de desarrollo sostenible, ODS, cambiar al mundo, desarrollo sustentable, Visionarios 2030, metas de desarrollo sostenible, gobierno de México, organización de las naciones unidas, " />
		<meta name="description" content="Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.">
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Domain verification -->
		<meta name="facebook-domain-verification" content="r1yz8bggw9l48cbr35qo3g1kwmnjnn" />

		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
		<link rel="manifest" href="archivos/favicon/site.webmanifest">
		<link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.compat.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

		<!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">
		<link rel="stylesheet" href="css/theme-blog.css">
		<link rel="stylesheet" href="css/theme-shop.css">

		<!-- Skin CSS -->
		<link id="skinCSS" rel="stylesheet" href="css/skins/skin-corporate-10.css">

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

		<!-- Meta Pixel Code -->
		<script>
			!function(f,b,e,v,n,t,s)
			{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
			n.callMethod.apply(n,arguments):n.queue.push(arguments)};
			if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
			n.queue=[];t=b.createElement(e);t.async=!0;
			t.src=v;s=b.getElementsByTagName(e)[0];
			s.parentNode.insertBefore(t,s)}(window, document,'script',
			'https://connect.facebook.net/en_US/fbevents.js');
			fbq('init', '1140806276704330');
			fbq('track', 'PageView');
		</script>
		<noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=1140806276704330&ev=PageView&noscript=1"/></noscript>
		<!-- End Meta Pixel Code -->

		<style>
			#objetivosHome .iconsContent img {
				flex: 0 0 20%;
				width: 20%;
				height: auto;
				padding: 10px;
				max-width: 20%;
			}
			@media screen and (max-width: 640px) {
				#objetivosHome .iconsContent img{
					flex: 0 0 50%;
					max-width: 50%;
					width: 50%;
				}
			}
		</style>

	</head>
	<body data-plugin-page-transition>
		<div class="body">
			<!-- Main header -->
			<?php include('main-header.php')?>
            <!-- End Main Header -->

			<div role="main" class="main">
				<!-- Slide -->
				<section id="slideHome" class="section section-with-shape-divider border-0 py-0 m-0">
					<div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#144a6b"/>
						</svg>
					</div>
					<div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs nav-style-1 nav-inside nav-inside-plus nav-primary nav-md nav-font-size-md show-nav-hover mb-0" data-plugin-options="{'autoplayTimeout': 9000, 'autoplay': false }" style="height: 100vh;">
						<div class="owl-stage-outer">
							<div class="owl-stage">

								<!-- Carousel Slide 1 -->
								<div class="owl-item position-relative overlaySlide" style="background-image: url(archivos/home/visionarios-2030-home-banner.jpg); background-size: cover; background-position: center; height: 100vh;">
									<div class="container position-relative z-index-3 h-100">
										<div class="row justify-content-center align-items-center h-100">
											<div class="col-lg-8">
												<div class="d-flex flex-column align-items-center">
													<h1 class="position-relative text-4 px-4 mb-2 appear-animation smallTitleSlide" data-appear-animation="fadeInDownShorter" data-plugin-options="{'minWindowWidth': 0}">
														<span class="position-absolute right-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
														<span class="">ALIANZAS Y COMUNICACIÓN</span><br>
														PARA CAMBIAR EL MUNDO
														<span class="position-absolute left-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
													</h1>
													<p class="text-4 text-center mb-0 titleSlide" ><span>Potenciamos la voz de los líderes </span>  que están cambiando 
													al mundo</p>
													<a href="guias" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">RESPALDA A UN VISIONARIO 2030 <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Video -->
				<!-- <div class="container my-5" id="videoHome">
					<div class="row py-5">
						<div class="col">
							<div class="row align-items-center">
								<div class="col-lg-5">
									<div class="featured-boxes featured-boxes-modern-style-1">
										<div class="featured-box overlay overlay-show overlay-op-3 border-radius border-0">
											<div class="featured-box-background" style="background-image: url(archivos/home/image-video.jpg); background-size: cover; background-position: center;"></div>
											<div class="box-content px-lg-4 px-xl-5 py-lg-5">
												<div class="py-5 my-4">
													<a class="text-decoration-none lightbox" href="https://www.youtube.com/watch?v=MCKH5xk8X-g" data-plugin-options="{'type':'iframe'}">
														<img class="icon-animated" width="60" src="vendor/linea-icons/linea-music/icons/play-button.svg" alt="" data-icon data-plugin-options="{'color': '#FFF', 'animated': true, 'delay': 600, 'strokeBased': true}" />
													</a>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-7 text-center text-lg-start content">
									<h1 class="mt-4 mt-lg-0 title">¿Qué es la <span class="">Agenda 2030</span> 
									y por qué es tan importante?</h1>
									<p class="description">El 25 de septiembre de 2015 más de 150 líderes mundiales asistieron a la Cumbre de las Naciones Unidas sobre el Desarrollo Sostenible en Nueva York con el fin de aprobar la Agenda para el Desarrollo Sostenible. El documento final, titulado “Transformar Nuestro Mundo: la Agenda 2030 para el Desarrollo Sostenible”, fue adoptado por los 193 Estados Miembros de las Naciones Unidas. Dicho documento incluye los 17 Objetivos del Desarrollo Sostenible cuyo objetivo poner fin a la pobreza, luchar contra la desigualdad y la injusticia, y hacer frente al cambio climático sin que nadie quede rezagado para el 2030.</p>
									<a href="ods.php" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER OBJETIVOS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
								</div>
							</div>
						</div>
					</div>
				</div> -->

				<!-- Objetivos -->
				<div class="" id="objetivosHome">
					<div class="container pt-3 mt-5">
						<div class="row justify-content-center mb-5">
							<div class="col-lg-10 col-xl-10 text-end">
								<div class="overflow-hidden mb-3">
									<h1 class="mb-0 appear-animation title" data-appear-animation="maskUp" data-appear-animation-delay="400">¿Quieres ayudar a construir un mundo mejor <span>y no sabes cómo?</span></h1>
								</div>
								<p class="mb-4 appear-animation description" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">¡Si te faltan objetivos en esta agenda sobran!</p>
								<!-- <p class="appear-animation author" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Amina J. Mohammed, </p>
								<p class="mb-4 appear-animation company" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Vicesecretaria General de las Naciones Unidas</p> -->
								<a href="ods" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER OBJETIVOS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
							</div>
						</div>
					</div>
				</div>

				<!-- Leader -->
				<section id="leader" class="section section-height-3 border-0 mt-0 mb-0">
					<div class="container">
						<div class="row flexRow">
							<div class="col-md-6">
								<div class="contImg">
									<img class="img1 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="400" src="archivos/home/foto-1-visionarios-2030.jpg" alt="Visionarios 2030">
									<img class="img2 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="400" src="archivos/home/foto-2-visionarios-2030.jpg" alt="Visionarios 2030">
								</div>
							</div>
							<div class="col-md-6">
								<h1 class="appear-animation font-weight-normal text-6 mb-3 title" data-appear-animation="maskUp" data-appear-animation-delay="400">Miles de personas trabajan todos los días <span>para mejorar al mundo sin que nadie se entere</span></h1>
								<p class="appear-animation description" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">¿Eres una de ellas?</p>
								<p class="appear-animation description" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">¡Todos tenemos un líder dentro: encuéntralo y levanta la voz!</p>
							</div>
						</div>
					</div>
				</section>

				<!-- Types leader -->
				<section id="typesLeader" class="section section-height-3 border-0 mt-0 mb-0 relative">
					<img class="floatImgLeft appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="400" src="archivos/home/tipos-de-lideres-visionarios-2030.jpg" alt="Visionarios 2030, tipos de líderes">
					<div class="container">
						<div class="row">
							<div class="col-md-6 offset-md-6">
								<div class="contInfo">
									<h1 class="appear-animation font-weight-normal text-6 mb-3 title" data-appear-animation="maskUp" data-appear-animation-delay="400">En este espacio encontrarás a 
										<span>3 tipos de líderes:</span></h1>
									<ul class="listLeader">
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600"><a href="#exploradores" data-hash data-hash-offset="68">Los <span>Exploradores</span></a></li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600"><a href="#micro_influencers" data-hash data-hash-offset="68">Los <span>Micro Influencers</span></a></li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600"><a href="#guias" data-hash data-hash-offset="68">Los <span>Guías</span></a></li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Type leader Guia-->
				<section id="guias" class="section section-height-3 border-0 mt-0 mb-0 relative">
					<img class="floatImgRight appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="400" src="archivos/home/guias-visionarios-2030.jpg" alt="Visionarios 2030 Guías">
					<div class="container">
						<div class="row">
							<div class="col-md-6">
								<div class="contInfo">
									<h1 class="appear-animation font-weight-normal text-6 mb-3 title" data-appear-animation="maskUp" data-appear-animation-delay="400">En el nivel 3 están <span>los Guías:</span></h1>
									<ul class="listLeader">
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Trabajan activamente a favor de una causa</li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Son expertos en su tema</li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Gozan de credibilidad y reconocimiento en la opinión pública</li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Saben que "lo que no se comunica no existe"</li>
									</ul>
									<a href="guias" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">CONÓCELOS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Type leader Micro Influencer-->
				<section id="micro_influencers" class="section section-height-3 border-0 mt-0 mb-0 relative">
					<img class="floatImgLeft appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="400" src="archivos/home/micro-influencers-visionarios-2030.jpg" alt="Visionarios 2030 Micro Influencers">
					<div class="container">
						<div class="row">
							<div class="col-md-6 offset-md-6">
								<div class="contInfo">
									<h1 class="appear-animation font-weight-normal text-6 mb-3 title" data-appear-animation="maskUp" data-appear-animation-delay="400">En el nivel 2 están 
										<span>los Micro Influencers:</span></h1>
									<ul class="listLeader">
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Han creado una comunidad sólida</li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Tienen una tribu que camina con ellos hacia el mismo destino</li>
										<li class="listDescription appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Se han convertido en referentes en su tema</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Type leader Exploradores-->
				<section id="exploradores" class="section section-height-3 border-0 mt-0 mb-0 relative">
					<div class="container">
						<div class="row">
							<div class="col-md-12 text-center">
								<h1 class="appear-animation font-weight-normal text-6 mb-3 title" data-appear-animation="maskUp" data-appear-animation-delay="400">Nivel 1: <span>Exploradores</span></h1>
								<p class="description appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">¿Eres o quieres ser uno? ¡Empieza aquí!</p>
							</div>
							<div class="col-md-4">
								<div class="contInfo">
									<img class="appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="400" src="archivos/home/paso-1-visionarios-2030.jpg" alt="Visionarios 2030 | Encuentra tu propósito">
									<p class="appear-animation font-weight-normal mb-3 titleBox" data-appear-animation="maskUp" data-appear-animation-delay="400"><span>Paso 1:</span> Encuentra tu propósito</p>
									<p class="descriptionBox appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Descubre un propósito que no sólo te mejore a ti, sino que contribuya a una causa mayor.</p>
								</div>
							</div>
							<div class="col-md-4">
								<div class="contInfo">
									<img class="appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="400" src="archivos/home/paso-2-visionarios-2030.jpg" alt="Visionarios 2030 | Diseña un plan">
									<p class="appear-animation font-weight-normal mb-3 titleBox" data-appear-animation="maskUp" data-appear-animation-delay="400"><span>Paso 2:</span> Diseña un Plan 2030</p>
									<p class="descriptionBox appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Elabora un plan paso a paso para alcanzar tus objetivos y sumar a otros en el camino.</p>
								</div>
							</div>
							<div class="col-md-4">
								<div class="contInfo">
									<img class="appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="400" src="archivos/home/paso-3-visionarios-2030.jpg" alt="Visionarios 2030 | Levanta la voz">
									<p class="appear-animation font-weight-normal mb-3 titleBox" data-appear-animation="maskUp" data-appear-animation-delay="400"><span>Paso 3:</span> Levanta la voz</p>
									<p class="descriptionBox appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">Diseña una campaña de comunicación única y personal para subir al siguiente nivel.</p>
								</div>
							</div>
							<div class="col-md-12 text-center">
								<a href="https://visionarios2030.wisboo.com/home" target="_blank" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="600">¡Sí QUIERO! <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
							</div>
						</div>
					</div>
				</section>
				
				<!-- Que hacemos -->
				<section class="section section-height-3 border-0 mt-0 mb-0" id="que-hacemos-home" style="position: relative;">
					<div class="container">
						<div class="row">
							<div class="col">
								<div class="row align-items-center appear-animation" data-appear-animation="fadeInRightShorter">
									<div class="col-md-7 mb-md-0">
										<h1 class="font-weight-normal text-6 mb-3 title">¿Quiénes <span>somos?</span></h1>
										<!-- <p class="description">Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.</p> -->
										<div class="list">
											<p>Apasionados por:</p>
											<ul>
												<li>Los líderes <span>con causa</span></li>
												<li>Las causas <span>sociales</span></li>
												<li>Las nuevas tendencias de <span>vida y comunicación</span></li>
											</ul>
										</div>
										<div class="titleBoxColors">
											<p>Expertos en:</p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<img class="hands" src="archivos/home/quienes-somos-visionarios-2030.jpg" alt="">
				</section>	

				<!-- Box Colors -->
				<div class="container-fluid" id="boxColors">
					<div class="row featured-boxes-full featured-boxes-full-scale">
						<div class="col-lg-4 featured-box-full box1">
							<img src="archivos/home/Visionarios-2030-Home-Iconos_Capacitamos.svg" alt="Liderazgo">
							<h4>Liderazgo</h4>
						</div>
						<div class="col-lg-4 featured-box-full box2">
							<img src="archivos/home/Visionarios-2030-Home-Iconos_Comunicamos.svg" alt="Comunicación">
							<h4>Comunicación</h4>
						</div>
						<div class="col-lg-4 featured-box-full box3">
							<img src="archivos/home/Visionarios-2030-Home-Iconos_Alianzas-Locales.svg" alt="Planeación">
							<h4>Planeación</h4>
						</div>
					</div>
				</div>

				<!-- Call To Action News -->
				<!-- <section class="call-to-action content-align-center" id="callToActionNews">
					<div class="container">
						<div class="row">
							<div class="col-md-8 offset-md-1 col-lg-8">
								<div class="call-to-action-content text">
									<p class="mb-0"><span>Cada líder ha elegido una meta 2030</span> y nosotros 
									somos la <span class="cursive">Sala de Difusión</span> que ofrece noticias 
									reportadas por sus propios líderes</p>
								</div>
							</div>
							<div class="col-md-2 col-lg-2">
								<div class="call-to-action-btn">
									<a href="https://visionarios2030news.com/" target="_blank" class="btn text-color-light px-4 py-2 mt-5 btn-py-2 text-1 rounded">VER NOTICIAS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a><span class="arrow arrow2 hlb d-none d-md-block" data-appear-animation="rotateInUpLeft" style="top: -90px; left: 70%;"></span>
								</div>
							</div>
						</div>
					</div>
				</section> -->

				<!-- Clients -->
				<!-- <div class="container container-xl-custom" id="clientsHome">
					<div class="row text-center py-4 my-5">
						<div class="col-md-12">
							<h1 class="title">Estos son algunos de <span>nuestros Aliados</span></h1>
						</div>
						<div class="owl-carousel owl-theme carousel-center-active-item mb-0" data-plugin-options="{'responsive': {'0': {'items': 1, 'margin': 30}, '476': {'items': 2}, '768': {'items': 5}, '992': {'items': 5}, '1200': {'items': 5}}, 'margin': 140, 'autoplay': true, 'autoplayTimeout': 3000, 'dots': false}">
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-Alianza-por-la-inversion.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-sumando-hacemos-mas.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-oxigeno-logo.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-Logo-Yo-tambien.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-La-buena-huella.jpg" alt="">
							</div>
							<div>
								<img class="img-fluid" src="archivos/home/Logo-Aliados-instituto-comunicacion-estrategica-logo.jpg" alt="">
							</div>
						</div>
					</div>
				</div> -->

				<!-- Newsletter -->
				
			</div>

			<?php include('footer.php')?>
		</div>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.gmap/jquery.gmap.min.js"></script>
		<script src="vendor/lazysizes/lazysizes.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>

		<!-- Theme Custom -->
		<script src="js/custom.js"></script>

		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>

	</body>
</html>
