"use strict";
var CaptchaCallback = function() {
    $('.g-recaptcha').each(function(index, el) {
        grecaptcha.render(el, {
            'sitekey' : '6LfXYx0UAAAAAD3P-CLWRHvn8F7ZCCqyz-DUcvas',
            'size'    : 'compact',
        });
    });
};

(function() {

    // Variables
    // ===================

    var $html = $('html'),
        $document = $(document),
        $window = $(window),
        i = 0;



    // Scripts initialize
    // ===================

    document.write('<script async defer src="//maps.googleapis.com/maps/api/js?key=AIzaSyAYjhWq7DvCwCiRKotPu9_IXQxupSQbhuo" type="text/javascript"></script>');

    $(window).on('load', function () {

        // =======
        // Preloader
        // =======

        var $preloader = $('#page-preloader');
        $preloader.delay(1000).fadeOut('slow');


        // =======
        // Google Map
        // =======
        var map = $(".map");
        if(map.length){
            var mapWrapper = $('#google-map'),
                latlng = new google.maps.LatLng(mapWrapper.data("x-coord"), mapWrapper.data("y-coord")),
                styles =
                    [
                        {
                            "featureType": "all",
                            "elementType": "labels.text.fill",
                            "stylers": [
                                { "saturation": 36 },
                                { "color": "#000000" },
                                { "lightness": 40 }
                            ]
                        },
                        {
                            "featureType": "all",
                            "elementType": "labels.text.stroke",
                            "stylers": [
                                { "visibility": "on" },
                                { "color": "#000000" },
                                { "lightness": 16 }
                            ]
                        },
                        {
                            "featureType": "all",
                            "elementType": "labels.icon",
                            "stylers": [
                                { "visibility": "off" }
                            ]
                        },
                        {
                            "featureType": "administrative",
                            "elementType": "geometry.fill",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 20 }
                            ]
                        },
                        {
                            "featureType": "administrative",
                            "elementType": "geometry.stroke",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 17 },
                                { "weight": 1.2 }
                            ]
                        },
                        {
                            "featureType": "landscape",
                            "elementType": "geometry",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 20 }
                            ]
                        },
                        {
                            "featureType": "poi",
                            "elementType": "geometry",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 21 }
                            ]
                        },
                        {
                            "featureType": "road.highway",
                            "elementType": "geometry.fill",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 17 }
                            ]
                        },
                        {
                            "featureType": "road.highway",
                            "elementType": "geometry.stroke",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 29 },
                                { "weight": 0.2 }
                            ]
                        },
                        {
                            "featureType": "road.arterial",
                            "elementType": "geometry",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 18 }
                            ]
                        },
                        {
                            "featureType": "road.local",
                            "elementType": "geometry",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 16 }
                            ]
                        },
                        {
                            "featureType": "transit",
                            "elementType": "geometry",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 19 }
                            ]
                        },
                        {
                            "featureType": "water",
                            "elementType": "geometry",
                            "stylers": [
                                { "color": "#000000" },
                                { "lightness": 17 }
                            ]
                        }
                    ],
                myOptions = {
                    scrollwheel: false,
                    zoom: 14,
                    center: latlng,
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    disableDefaultUI: true,
                    styles: styles
                },
                map = new google.maps.Map(mapWrapper[0], myOptions),
                marker = new google.maps.Marker({
                    position: {lat: mapWrapper.data("x-coord"), lng: mapWrapper.data("y-coord")},
                    draggable: false,
                    animation: false,
                    map: map,
                    icon: 'img/marker.png'
                }),
                infowindow = new google.maps.InfoWindow({
                    content: mapWrapper.data("text")
                });

            marker.addListener('click', function() {
                infowindow.open(map, marker);
            });
        }
    });

    $(document).on("scroll", function() {
        if($(window).width()<=992 && $(document).scrollTop()<=200){
            var h = $(".logomovil").outerHeight(true)+"px";
            $(".nav-mobile").css({"height":h});
        }
    });
    $(document).on("click",".btnnombre",function(){

        $("#nombresujeto").val($(this).data("nombre"));
    });
    $document.ready(function () {


        $("body").append('\
		<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">\
			<div class="modal-dialog" role="document">\
				<div class="modal-content">\
				<div class="modal-header">\
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>\
					<h3 class="oxygen modal-title font-33" id="myModalLabel">Pide informes aqu&iacute; </h3>\
					<h4 class="oxygen gris font-18">Uno de nuestros asesores se pondr&aacute; en contacto contigo de inmediato</h4>\
				</div>\
				<div class="modal-body">\
					<form class="contact-form js-form" method="POST" action="php/contact.php">\
						<div class="row">\
						<div class="form-group col-md-6">\
							<input autocomplete="off" required type="text" name="name" class="form-control" placeholder="Tu nombre">\
						</div>\
						<div class="form-group col-md-6 mt-20 mt-md-0">\
							<input autocomplete="off" required type="email" name="email" class="form-control" placeholder="Tu email">\
						</div>\
						<div class="form-group col-md-6">\
							<input autocomplete="off" required type="text" name="celular" class="form-control" placeholder="Celular">\
						</div>\
						<div class="form-group col-md-6 mt-20 mt-md-0">\
							<input autocomplete="off" required type="text" name="ubicacion" class="form-control" placeholder="Ubicaci&oacute;n">\
						</div>\
						<div class="form-group col-md-12 mt-20">\
							<textarea required name="message" class="form-control" placeholder="Mensaje o consulta"></textarea>\
						</div>\
						</div>\
						<div class="g-recaptcha" data-sitekey="6LfXYx0UAAAAAD3P-CLWRHvn8F7ZCCqyz-DUcvas"></div>\
						<input type="hidden" id="nombresujeto" name="nombresujeto" >\
						<button type="submit" class="btn btn-lg btn-primary mt-30">Enviar</button>\
					</form>\
				</div>\
				</div>\
			</div>\
		</div>\
		<div id="googleAnalytics" onClick="ga(\'send\', \'event\', \'button\', \'click\');"></div>\
	  ');
        function detectElement(dom) {
            return $window.height() + $window.scrollTop() >= dom.offset().top && $window.scrollTop() <= dom.outerHeight() + dom.offset().top;
        }

        // ==========
        // AJAX form
        // ==========
        var ajaxForm = $('.js-form');
        var jsForm = $('.contact-form');
        var resultPanel = $("body").append("<div class='js-result'></div>").find(".js-result");

        if (jsForm.length) {

            jsForm.each(function(){
                var $form = $(this);

                $form.ajaxForm({
                    success: function(json) {
                        /*var jsJSON = json;
                        console.log(json);*/
                        var jsJSON = JSON.parse(json);
                        resultPanel.text(jsJSON.message);

                        if (jsJSON.valid) {
                            $("#googleAnalytics").trigger("click");
                            resultPanel[0].classList.add("success");

                            setTimeout(function () {
                                resultPanel[0].classList.remove("success");
                                $form.clearForm();
                            }, 3000);

                        } else {

                            resultPanel[0].classList.add("error");

                            setTimeout(function () {
                                resultPanel[0].classList.remove("error");
                            }, 4500);
                        }
                    }
                });

            });
        }

        $(".subscription-form button").on("click",function(e){
            e.preventDefault();
            var form = $(this).parents("form");
            var button = $(this);
            $.ajax({
                url:"php/news.php",
                type:"POST",
                data:{
                    dato:$("#sub-email").val()
                },success:function(e){
                    console.log(e);
                    if(e == 1){
                        $("#googleAnalytics").trigger("click");
                        button.siblings(".js-result").html("Mensaje enviado correctamente");
                        button.siblings(".js-result").css("bottom","4px");
                        setTimeout(function(){
                            button.siblings(".js-result").html("");
                            button.siblings(".js-result").css("bottom","-100px");
                        },5000);
                    }else{
                        setTimeout(function(){
                            button.siblings(".js-result").html("Error al enviar mensaje");
                            button.siblings(".js-result").css("bottom","4px");
                        },800);
                        setTimeout(function(){
                            button.siblings(".js-result").html("");
                            button.siblings(".js-result").css("bottom","-100px");
                        },200);
                    }
                }
            });
        });

        // ==========
        // jQuery ajaxChimp
        // ==========
        /*var chimpForm = $('.subscription-form form');

        chimpForm.ajaxChimp({
          callback: function(){
            var panel = $('.js-result');
            setTimeout(function () {
              panel.removeClass("error").removeClass("success");
            }, 4500);
          },
          language: 'cm',
          url: '//cear-studio.us13.list-manage.com/subscribe/post?u=5c10401fe692f6eddbd86220f&amp;id=b974661486'
          //http://xxx.xxx.list-manage.com/subscribe/post?u=xxx&id=xxx
        });


        $.ajaxChimp.translations.cm = {
          'submit': 'Submitting...',
          0: 'We have sent you a confirmation email',
          1: 'Please enter a value',
          2: 'An email address must contain a single @',
          3: 'The domain portion of the email address is invalid (the portion after the @: )',
          4: 'The username portion of the email address is invalid (the portion before the @: )',
          5: 'This email address looks fake or invalid. Please enter a real email address'
        };*/

        // ==========
        // Responsive Nav
        // ==========
        var responsiveNav = new Navigation({
            initClass: "nav",
            mobileClass: "nav-mobile",
            desktopClass: "nav-desktop",
            checkHeight: false,
            stuck: true,
            stuckOffset: 1,
            onePage: true,
            onePageOffset: 100
        });

        // =======
        // Parallalx.js
        // =======
        var parallax = $('.parallax-bg');

        if (parallax.length > 0) {
            parallax.parallax();
        }

        // ==========
        // Video
        // ==========
        var video = $('.video-section');

        if (video.length) {
            var videoItem = video.find('.video');

            video.on("click", function(){
                video.toggleClass("video-section-play");
                videoItem.get(0).paused ? videoItem.get(0).play() : videoItem.get(0).pause();
            });
        }

        // =======
        // Responsive Tabs
        // =======
        var tabs = $('.responsive-tabs');

        if (tabs.length > 0) {
            var i = 0;
            for (i = 0; i < tabs.length; i++) {
                var $this = $(tabs[i]);
                $this.easyResponsiveTabs({
                    type: $this.attr("data-type"),
                    tabidentify: $this.find(".resp-tabs-list").attr("data-group") || "tab",
                    activate: function() {
                        setTimeout(function() {
                            $('.resp-accordion.resp-tab-active')[0].scrollIntoView();
                        }, 500);
                    }
                });
            };
            $(".resp-tabs-list li").on("click", function(){
                $window.trigger("resize");
            });
        }

        // =======
        // UIToTop
        // =======
        $().UItoTop();

        // =======
        // Owl carousel
        // =======
        var owl2 = $(".owl-2");
        if (owl2.length) {
            owl2.owlCarousel({
                mouseDrag: true,
                nav: true,
                loop: true,
                autoplay: true,
                dots: false,
                items: 1,
                responsiveClass:true,
            });
        }

        var owl1 = $('.owl-1');
        if (owl1.length) {
            owl1.owlCarousel({
                mouseDrag: true,
                nav: true,
                loop: true,
                autoplay: true,
                dots: false,
                items: 6,
                responsiveClass:true,
                responsive:{
                    0:{ items:1, },
                    480:{ items:2, },
                    768:{ items:4, },
                    992:{ items:4, },
                    1200: { items:6, },
                    1800: { items:6, }
                }
            });
        }

        // =======
        // Popover
        // =======
        var popover = $(".popover");
        if(popover.length){
            popover.on("click", function(){
                if($(this).hasClass("ready")){
                    popover.removeClass("open");
                    $(this).toggleClass("open");
                    popover.addClass("ready");
                    $(this).toggleClass("ready");
                } else {
                    popover.removeClass("open");
                    popover.addClass("ready");
                }
            });
        }

        // =======
        // jQuery Count To
        // =======
        var counter = $('.counter');

        if (counter.length) {
            var counterToInit = counter.not(".init");
            $document.on("scroll", function () {
                counterToInit.each(function(){
                    var item = $(this);

                    if ((!item.hasClass("init")) && (detectElement(item))) {
                        item.countTo({
                            refreshInterval: 20,
                            speed: item.attr("data-speed") || 1000
                        });
                        item.addClass('init');
                    }
                });
                $document.trigger("resize");
            });
            $document.trigger("scroll");
        }

        // =======
        // WOW
        // =======
        if ($html.hasClass('desktop')) { new WOW().init(); }

        // =======
        // ISOTOPE
        // =======
        var isotope = $('.iso');

        if (isotope.length) {
            $( function() {
                var $grid;
                $grid = $('.grid').isotope({
                    itemSelector: 'article',
                    layoutMode: 'masonry',
                    masonry: {
                        columnWidth: 1
                    }
                });
                if($(window).width() < 768){
                    $grid = $('.grid').isotope({
                        masonry: {
                            /*columnWidth: 1,*/
                            rowHeight:1
                        }
                    });
                }

                $(window).on("load", function(){
                    $('.filters-button-group .is-checked').trigger('click');
                });
                $(window).on("resize", function(){
                    $('.filters-button-group .is-checked').trigger('click');
                });

                // filter buttons
                $('.filters-button-group').on( 'click', 'button', function() {
                    var filterValue = $( this ).attr('data-filter');
                    $grid.isotope({ filter: filterValue });
                });
                $('.button-group').each( function( i, buttonGroup ) {
                    var $buttonGroup = $( buttonGroup );
                    $buttonGroup.on( 'click', 'button', function() {
                        $buttonGroup.find('.is-checked').removeClass('is-checked');
                        $( this ).addClass('is-checked');
                    });
                });
            });

            // debounce so filtering doesn't happen every millisecond
            function debounce( fn, threshold ) {
                var timeout;
                return function debounced() {
                    if ( timeout ) {
                        clearTimeout( timeout );
                    }
                    function delayed() {
                        fn();
                        timeout = null;
                    }
                    timeout = setTimeout( delayed, threshold || 100 );
                }
            }

            $(window).on("load", function() {
                $('#all').trigger("click");
            });
        }

    });

})();
