(function ($) {
	"use strict";
	
	var litmusApp = {
		/* ---------------------------------------------
		 Header Overlay
		--------------------------------------------- */
		header_overlay:function() {
			var $overlayClose = $('.overlay-close');
			$overlayClose.on('click', function() {
				$(this).parent().slideUp('slow');
			});

			var $searchExtend = $('.header-right .right-menu .search-extend');
			$searchExtend.on('click', function() {
				$overlayClose.parent().slideDown('slow');
			});
		},
		/* ---------------------------------------------
		 One Page Menu Script
		--------------------------------------------- */
		onePageMenu: function() {
			function onePageNav($selector) {
				var $navSelector = $($selector);
				$navSelector
				.not('[href="#"]')
				.not('[href="#0"]')
				.click(function(event) {
				    if ( location.pathname.replace(/^\//, '') === this.pathname.replace(/^\//, '') && location.hostname === this.hostname ) {
				      	var target = $(this.hash);
				      	target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');

				      	$navSelector.removeClass("active");
				      	if( target.length) {
					      	if($(this)[0].hash.slice(1) === target[0].id) {
					      		$(this).addClass("active");
					      	} else {
					      		$(this).removeClass("active");
					      	}
				      	}
				     	
					    if (target.length) {
					        event.preventDefault();
					        $('html, body').animate({
					          	scrollTop: target.offset().top
					        }, 1000);
					    }
				    }
				});

				$navSelector.each(function(event) {
			      	var target = $(this.hash);
			      	if( target.length) {
				      	if(location.hash.slice(1) === target[0].id) {
				      		$(this).addClass("active");
				      	} else if(!location.hash) {
				      		
				      	} else {
				      		$(this).removeClass("active");
				      	}
			      	}
				});

				function onScroll(event){
				    var scrollPos = $(document).scrollTop();
				    $navSelector.each(function () {
				        var currLink = $(this);
		                if(currLink[0].hash !== "" && $(currLink[0].hash).position() !== undefined) {

	                		var $getNavHas = $(currLink).prop('href').split('#')[1],
	                			$getSection = $('#' + $getNavHas); 

	                		$getSection.each(function() {
		                		var $topPos = $(this).offset().top,
		                			$topPosRound = Math.round($topPos - 120 ),
		                			$presentPos = Math.round(scrollPos);

		                		if ($topPosRound <= $presentPos && $topPosRound + $(this).height() > $presentPos) {
		                		    $(currLink).parent().addClass("active"); 
		                		} else {
		                			$(currLink).parent().removeClass("active");
		                		}
	                		});
		                } else {
		                	return false;
		                }
				    });
				}

				$(document).on("scroll", onScroll);	     
			}
			onePageNav('.mainmenu li a');
			onePageNav('.btn-banner');
		},


		/* ---------------------------------------------
		 Litmus Menu
		--------------------------------------------- */
		litmus_menu: function() {
			// Sub Menu Indicator
			var $submenuIndicator = $('ul > li > .sub-menu');
			$submenuIndicator.prev().append('<i class="fa fa-angle-down"></i>');

			//Clone Mobile Menu
			function cloneMobileMenu($cloneItem, $mobileLoc) {
				var $combinedmenu = $($cloneItem).clone();
				$combinedmenu.appendTo($mobileLoc);

				var $submenu = $($mobileLoc).find('li').has('.sub-menu, .dropdown-menu');
				$submenu.prepend("<span class='menu-click'><i class='menu-arrow fa fa-plus'></i></span>");
				var $mobileSubMenuOpen = $(".menu-click");
				$mobileSubMenuOpen.each(function() {

					    var $self = $(this);
					$self.on("click", function(e) {
						e.stopImmediatePropagation();
					    $self.siblings(".sub-menu, .dropdown-menu").slideToggle("slow");
					    $self.children(".menu-arrow").toggleClass("menu-extend");
					});
				});
			}

			cloneMobileMenu(".header-middle .navigation .mainmenu", ".expand-block #mobile-main-menu");

			// Mobile Menu
			function mobileNav($selector, $parentSelector) {
				var $mobileNav = $($selector);
				$mobileNav.on("click", function() {
					$($parentSelector).addClass('slide-left');
					$($parentSelector).parent().addClass('slide-left');
				});

				var $closeButton = $($parentSelector).find(".close-menu");
				$closeButton.each(function(){
					var $self = $(this);
					$self.on("click", function() {
						$self.parent($parentSelector).removeClass('slide-left');
						$self.parent($parentSelector).parent().removeClass('slide-left');
					});
				});

				$(document).on('click', function(e) {
					var $selectorType = $($parentSelector).add($mobileNav);
				    if ($selectorType.is(e.target) !== true && $selectorType.has(e.target).length === 0) {
				        $($parentSelector).removeClass("slide-left");
				        $($parentSelector).parent().removeClass("slide-left");
				    }				   
				});
			}
			mobileNav('.hamburger-menu', '.expand-block');
		},
		/* ---------------------------------------------
		Portfolio / Hover Animation
		 --------------------------------------------- */
		hoverAnimation: function() {
			var $portfolioThumb = $(' .portfolio-thumb ');
			$portfolioThumb.each( function() { $(this).hoverdir(); } );

			var IsoGriddoload = $('.portfolio-grid');
			IsoGriddoload.isotope({
			    itemSelector: '.item',
			    masonryHorizontal: {
			        rowHeight: 100
			    }
			});

			var ProjMli = $('.portfolio-menu .dropdown-menu li a, .portfolio-menu.style-two li a');
			var ProjGrid = $('.portfolio-grid');
			ProjMli.on('click', function(e) {
				e.preventDefault();
			    ProjMli.removeClass("active");
			    $(this).addClass("active");
			    var selector = $(this).attr('data-filter');
			    ProjGrid.isotope({
			        filter: selector,
			        animationOptions: {
			            duration: 750,
			            easing: 'linear',
			            queue: false,
			        }
			    });
			});
		},
		/* ---------------------------------------------
		Individual Select
		 --------------------------------------------- */
		litmus_select: function() {
			var $select = $('select');
			$select.bsm_select();

			//$('.blog-tab-menu a[href="#' + tab + '"]').tab('show');

			//$('#blog-tab-menu a').tab('show');

			$('ul li.nav-item a').click(function (e) {
				e.preventDefault();
			    $('ul li.nav-item a.active').removeClass('active');
			});

			$('.wishlist-btn').on('click', function(e) {
				e.preventDefault();
				$(this).addClass('active');
			});
		},		
		/* ---------------------------------------------
		Coming Soon Timer
		 --------------------------------------------- */
		coming_soon_timer: function() {
			var $selector = $('.commingsoon-count');
			$selector.each(function(){
			    var $this = $(this),
			        data_year = $this.attr('data-year'),
			        data_month = $this.attr('data-month'),
			        data_day = $this.attr('data-day'),
			        data_hour = $this.attr('data-hour'),
			        data_minutes = $this.attr('data-minutes');
			    $this.syotimer({
			        year: data_year,
			        month: data_month,
			        day: data_day,
			        hour: data_hour,
			        minute: data_minutes
			    });    
			});
		},
		/* ---------------------------------------------
		 All Carousel Active Script
		--------------------------------------------- */
		allCarousel: function() {
			var $serviceCarousel = $('.service-slider');
			$serviceCarousel.owlCarousel({
				loop:false,
				items: 3,
				nav: true,
				margin: 30,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items: 1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 3
					}
				}
			});				

			var $blogCarousel = $('.blog-slider');
			$blogCarousel.owlCarousel({
				loop:false,
				items: 3,
				nav: true,
				margin: 30,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items: 1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 3
					}
				}
			});				

			var $teamCarousel = $('.team-slider');
			$teamCarousel.owlCarousel({
				loop:false,
				items: 3,
				nav: true,
				margin: 15,
                //autoHeight:true,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items: 1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 3
					}
				}
			});				

			var $portfolioRelated = $('.portfolio-related-slider');
			$portfolioRelated.owlCarousel({
				loop:false,
				items: 4,
				nav: true,
				margin: 15,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items:1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 4
					}
				}
			});				

			var $portfolioRelated = $('.bestseller-carousel');
			$portfolioRelated.owlCarousel({
				loop:false,
				items: 4,
				nav: true,
				margin: 30,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items:1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 4
					}
				}
			});		

			var $bestSellerTab = $('.resturent-tab-v1 li a');
			$bestSellerTab.on('click', function() {
				var owl = $('.bestseller-carousel').data('owl.carousel');
				owl.onResize();
			});

			var $portfolioRelated = $('.woo-best-seller-slider');
			$portfolioRelated.owlCarousel({
				loop:false,
				items: 4,
				nav: true,
				margin: 30,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items:1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 4
					}
				}
			});		

			var $portfolioRelated = $('.new-arrival-slider');
			$portfolioRelated.owlCarousel({
				loop:false,
				items: 1,
				nav: true,
				margin: 30,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>'],
				responsive:{
					280:{
						items:1
					},
					480 : {
						items: 1
					},
					768 : {
					   items: 1
					},
					1200 : {
					   items: 1
					}
				}
			});			

			var $companyCarousel = $('.company-slider');
			$companyCarousel.owlCarousel({
				loop:false,
				items: 5,
				nav: false,
				margin: 15,
				responsive:{
					280:{
						items:1
					},
					480 : {
						items: 2
					},
					768 : {
					   items: 2
					},
					1200 : {
					   items: 5
					}
				}
			});	

			var $clientCarousel = $('.review-slider');
			$clientCarousel.owlCarousel({
				loop:false,
				items: 1,
				nav: true,
				navText: ['<i class="icon-arrows-slim-left"</i>', '<i class="icon-arrows-slim-right"></i>']
			});	
		},

		/* ---------------------------------------------
		 Progress Bar
		--------------------------------------------- */
		progress_var: function() {
			var $progressBar = $('.skill-progress');
			var $skillBar = $('.skill-bar');
	        $skillBar.each(function() {
	            $(this).find('.progress-content').animate({
	                width: $(this).attr('data-percentage')
	            }, 2150);
	            $(this).find('.progress-mark').animate({
	                left: $(this).attr('data-percentage')
	            }, {
	                duration: 2150,
	                step: function(now, fx) {
	                    var data = Math.round(now);
	                    $(this).find('.percent').html(data + '%');
	                }
	            });
	        });
		},

		/* ---------------------------------------------
		 Service Item Mobile
		--------------------------------------------- */
		service_item_mobile: function() {
			var $aboutItem = $(".policy-xs-slider"),
				$owlOptions = {
					loop: false,
					margin: 0,
					responsive: {
						0:{
							items: 1
						},
						480 : {
							items: 1
						},
						580 : {
							items: 1
						},
						768 : {
						   items: 2
						},
						960 : {
						   items: 2
						}
					}
				};
				if($(window).width() < 992) {
					var $sliderActive = $aboutItem.owlCarousel($owlOptions);
					$aboutItem.addClass("owl-carousel");
				} else {
					$aboutItem.addClass("off");
				}

			$(window).on("resize", function() {
				if($(window).width() < 992) {
					if($(".policy-xs-slider").hasClass("off")) {
						var $sliderActive = $aboutItem.owlCarousel($owlOptions);
						$aboutItem.removeClass("off");
						$aboutItem.addClass("owl-carousel");
					}
				} else {
					if(!$(".policy-xs-slider").hasClass("off")) {
						$aboutItem.removeClass("owl-carousel");
						$aboutItem.addClass("off").trigger("destroy.owl.carousel");
						$aboutItem.find(".owl-stage-outer").children(":eq(0)").unwrap();
					}
				}
			});
		},

		/* ---------------------------------------------
		 Widget Mobile fix
		--------------------------------------------- */
		widget_mobile: function () {
		    function debouncer(func, timeout) {
		        var timeoutID, timeout = timeout || 500;
		        return function () {
		            var scope = this,
		                args = arguments;
		            clearTimeout(timeoutID);
		            timeoutID = setTimeout(function () {
		                func.apply(scope, Array.prototype.slice.call(args));
		            }, timeout);
		        }
		    }
		    function resized() {
		        var getWidgetTitle = $('.widget .widget-title');
		        var getWidgetTitleContent;
		        if ($(window).width() <= 991) {
		            getWidgetTitleContent = $('.widget .widget-title').nextAll().hide();
		            getWidgetTitle.addClass('expand-margin');
		            getWidgetTitle.on('click', function(e) {
		                e.stopImmediatePropagation();
		                $(this).toggleClass('expand');
		                $(this).nextAll().slideToggle();
		                return false;
		            });
		            getWidgetTitle.each(function(){
		                $(this).addClass('mb-widget');
		            });
		        } else {
		            getWidgetTitleContent = $('.widget .widget-title').nextAll().show();
		            getWidgetTitle.removeClass('expand-margin');
		            getWidgetTitle.each(function(){
		                $(this).parent().removeClass('mb-widget');
		            });
		        };
		    }
		    resized();

		    var prevW = window.innerWidth || $(window).width();
		    $(window).resize(debouncer(function (e) {
		        var currentW = window.innerWidth || $(window).width();
		        if (currentW != prevW) {
		            resized();
		        }
		        prevW = window.innerWidth || $(window).width();
		    }));

		    //Mobile Responsive
		    var $extendBtn = $(".extend-btn .extend-icon");
		    $extendBtn.on("click", function(e) {
		        e.preventDefault();
		        var $self = $(this);
		        $self.parent().prev().toggleClass("mobile-extend");
		        $self.parent().toggleClass("extend-btn");
		        $self.toggleClass("up");
		    });
		},
 		/* ---------------------------------------------
		 Date Picker
		 --------------------------------------------- */
		datePicker: function() {
			var $dateSelector = $(".date-selector");
			var $timeSelector = $(".time-selector");
			if($dateSelector.length) {			
				$dateSelector.datetimepicker({
				    yearOffset: 0,
				    lang:'en',
				    timepicker: false,
				    format:'d/m/Y',
				    formatDate:'Y/m/d',
				    minDate: "1"
				});
			}
			if($timeSelector.length) {			
				$timeSelector.datetimepicker({
				    datepicker:false,
				    format:'H:i',
				    step:5
				});
			}
		},
		/* ---------------------------------------------
		 Name Cheep
		--------------------------------------------- */
		ajax_chimp: function() {
			var $actionUrl = 'https://hashkeytechnologies.us14.list-manage.com/subscribe/post?u=5e02cd867c04844407df9e021&amp;id=64d4c641e2';
		    var $newsletterForm = $('.newsletter-form');
	        $newsletterForm.ajaxChimp({
	            callback: mailchimpCallback,
	            url: $actionUrl
	        }); 
	        function mailchimpCallback(resp) {
	             if (resp.result === 'success') {
	                $('.subscription-success').html('<i class="fa fa-check"></i>' + resp.msg).fadeIn(1000);
	                $('.subscription-error').fadeOut(500);
	                
	            } else if(resp.result === 'error') {
	                $('.subscription-error').html('<i class="fa fa-times"></i>' + resp.msg).fadeIn(1000);
	            }  
	        }
		},
		/* ---------------------------------------------
		 Contact From
		--------------------------------------------- */
		contact_form: function() {
			// Function for email address validation
			function isValidEmail(emailAddress) {
			    var pattern = new RegExp(/^(("[\w-\s]+")|([\w-]+(?:\.[\w-]+)*)|("[\w-\s]+")([\w-]+(?:\.[\w-]+)*))(@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][0-9]\.|1[0-9]{2}\.|[0-9]{1,2}\.))((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\.){2}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\]?$)/i);

			    return pattern.test(emailAddress);
			}
			var $contactForm = $("#contactForm");
			$contactForm.on('submit', function (e) {
			    e.preventDefault();
			    var data = {
			        name: $("#name").val(),
			        email: $("#email").val(),
			        message: $("#message").val()
			    };

			    if (isValidEmail(data['email']) && (data['message'].length > 1) && (data['name'].length > 1)) {
			        $.ajax({
			            type: "POST",
			            url: "sendmail.php",
			            data: data,
			            success: function () {
			                $('#contactForm .input-success').delay(500).fadeIn(1000);
			                $('#contactForm .input-error').fadeOut(500);
			            }
			        });
			    } else {
			        $('#contactForm .input-error').delay(500).fadeIn(1000);
			        $('#contactForm .input-success').fadeOut(500);
			    }

			    return false;
			});
		},
		/* ---------------------------------------------
		 Scroll top
		--------------------------------------------- */
	    scroll_top: function () {
	    	//Fixed Navbar
	    	var $fixedHeader = $('.sticky-header');
	    	$(window).on('scroll', function() {
	    		if($(this).scrollTop() >= $(this).height()) {
	    			$fixedHeader
	    			.addClass('sticky-show')
	    			.removeClass('sticky-hide');
	    		} else if($(this).scrollTop() >= 100) {
	    			$fixedHeader
	    			.addClass('sticky-hide')
	    			.removeClass('sticky-show');
	    		} else {
	    			$fixedHeader
	    			.removeClass('sticky-hide');
	    		}
	    	});

	    	//Footer Scroll Top
			$("body").append("<a href='#top' id='scroll-top' class='topbutton btn-hide'><span class='icon-arrows-up'></span></a>");
			
			var $scrolltop = $('#scroll-top');
			$(window).on('scroll', function() {
				if($(this).scrollTop() > $(this).height()) {
					$scrolltop
					.addClass('btn-show')
					.removeClass('btn-hide');
				} else {
					$scrolltop
					.addClass('btn-hide')
					.removeClass('btn-show');
				}
			});
			$("a[href='#top']").on('click', function() {
				$("html, body").animate({
					scrollTop: 0
				}, "normal");
				return false;
			});

		},
		/* ---------------------------------------------
		 function initializ
		 --------------------------------------------- */
		initializ: function() {
			litmusApp.header_overlay();
			litmusApp.onePageMenu();
			litmusApp.litmus_menu();
			litmusApp.litmus_select();
			litmusApp.allCarousel();
			litmusApp.coming_soon_timer();
			litmusApp.progress_var();
			litmusApp.service_item_mobile();
			litmusApp.widget_mobile();
			litmusApp.datePicker();
			litmusApp.ajax_chimp();
			litmusApp.contact_form();
			litmusApp.scroll_top();
		}
	};
	/* ---------------------------------------------
	 Document ready function
	 --------------------------------------------- */
	$(function() {
		litmusApp.initializ();
	});

	$(window).on('load', function() {
		litmusApp.hoverAnimation();
	});
})(jQuery);
