<?php
global $post;
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package fantasy_themes
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php

		if ( is_user_logged_in() ) {
		    $logged = TRUE;
		} else {
		    $logged = FALSE;
		}

		if(empty($_COOKIE['autoroyal_compare_ids'])) {
			$_COOKIE['autoroyal_compare_ids'] = array();
		}

		$MODS = get_theme_mods();
	    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

	    $logo = "";
	    if(strlen($MODS['logo'])>0) {
	        $logo = "<img src='".esc_url($MODS['logo'])."' alt='".esc_html__( 'Logo', 'autoroyal' )."'>";
	    }

	    $logo_white = "";
	    if(strlen($MODS['logo_white'])>0) {
	        $logo_white = "<img src='".esc_url($MODS['logo_white'])."' alt='".esc_html__( 'Logo', 'autoroyal' )."'>";
	    }

	    $show_hide_top_bar = '';
	    if(strlen($MODS['show_hide_top_bar'])>0) {
		    $show_hide_top_bar = $MODS['show_hide_top_bar'];
		}

		$show_fav_in_top_bar = '';
	    if(strlen($MODS['show_fav_in_top_bar'])>0) {
		    $show_fav_in_top_bar = $MODS['show_fav_in_top_bar'];
		}

	    $header_phone_number = "";
	    if(strlen($MODS['header_phone_number'])>0) {
	        $header_phone_number = esc_attr($MODS['header_phone_number']);
	    }

	    $header_working_hours = "";
	    if(strlen($MODS['header_working_hours'])>0) {
	        $header_working_hours = esc_attr($MODS['header_working_hours']);
	    }

	    $header_address = "";
	    if(strlen($MODS['header_address'])>0) {
	        $header_address = esc_attr($MODS['header_address']);
	    }

	    //
        $car_compare_url = get_option("autoroyal_compare_vehicles_page_id");

        $postID = get_the_ID();
		$menu_type = get_post_meta( $postID , 'menu_type' , true );

	?>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

	<div id="big-search-holder" class="modal-container search-modal">
		<div class="modal-content">
			<div class="pos-vertical-center clearfix">
				<div class="col-md-12 text-center">
					<form class="search-form" method="get" id="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
						<div class="input-with-icon">
							<i class="fa fa-search" aria-hidden="true"></i>
							<input type="text" id="big-search-box" name="s" placeholder="<?php esc_attr_e( 'Enter search term...', 'autoroyal' ) ?>">
						</div>
					</form>
				</div>
			</div>
			<div class="close-big-search-holder"></div>
		</div><!--end of modal-content-->
	</div>

	<div class="modal fade bd-example-modal-xl" id="quick-view-block" tabindex="-1" role="dialog" aria-labelledby="quickviewLabel">
		<div class="modal-dialog modal-xl" role="document">
    		<div class="modal-content">

		    	<a href="#" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-close"></i></a>

		    	<div class="quick-view-block-loading">
		    		<i class="fa fa-spinner fa-spin"></i>
		    	</div>

		    	<div class="cs-modal-inner">

		    		
					
		    	</div>
		    </div>
	    </div>
	</div>

	<?php if (function_exists('autoroyal_resrevation_form_func')) { echo do_shortcode( '[autoroyal_resrevation_form]' ); } ?>

	<div id="favorite-mask" class="favorite-mask"></div>
	<div id="rent-select-price-mask" class="rent-select-price-mask"></div>
	<?php if(post_type_exists( 'vehicle' )) { ?>
	<div id="favorite-controller" class="favorite-panel">

		<?php

			if( is_user_logged_in() ) {

		    	$user_id = get_current_user_id();

		    	$search_args = array(
					'post_type'           => 'vehicle',
					'post_status'         => 'publish',
					'posts_per_page'      => -1,
					'orderby'             => 'date', 
			    	'order'               => 'DESC',
			    	'meta_query' => array(
				    	array(
							'key' => 'users_fav',
							'value' => $user_id,
							'compare' => 'LIKE',
						),
					),
			    	'ignore_sticky_posts' => 1

				);

		    } else {

		    	$user_id = autoroyalGetIP();

		    	$search_args = array(
					'post_type'           => 'vehicle',
					'post_status'         => 'publish',
					'posts_per_page'      => -1,
					'orderby'             => 'date', 
			    	'order'               => 'DESC',
			    	'meta_query' => array(
				    	array(
							'key' => 'ips_fav',
							'value' => $user_id,
							'compare' => 'LIKE',
						),
					),
			    	'ignore_sticky_posts' => 1

				);

		    }

			$cars_query = new WP_Query;
			$cars = $cars_query->query( $search_args );

		?>

	    <div class="favorite-panel-header">
	        <i class="close"></i>
	        <h4 class="title"><?php esc_html_e( 'Favorites', 'autoroyal' ) ?></h4>
	        <div class="favorite-separator"></div>
	    </div>
	    
        <div id="favorite-vehicles-basket">
        	<div class="row">

        		<?php 

					if ( $cars ) : 

						foreach ( $cars as $car ) : ?>

						<?php 

							$car_ID = $car->ID;

							$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
							$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
							$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
							$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
							$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
							$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
							$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

							$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
							if(!empty($vehicle_exterior_color)) {
								$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
								$color_id   = $vehicle_exterior_color[0]->term_id;
								$color_name = $vehicle_exterior_color[0]->name;
							} else {
								$color_name = "";
								$color_id   = "";
							}

							$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

							$vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
							$vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
							$vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
							$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

							$vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
							$vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
							$vehicle_image_url = "";

							if(!empty($vehicle_image_gallery[0]['url'])) {

								$vehicle_image_url = $vehicle_image_gallery[0]['url'];

							} elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

								$vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

							}

							$vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
							if(!empty($vehicle_cover_image)) {
								$vehicle_image_url = $vehicle_cover_image;
							}

							$vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
							$vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

							$vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
							$terms_vehicle_drive = $vehicle_drive[0]->name;

							// Cars meta
		                    $vehicle_consumption_urban = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_urban',true));
		                    $vehicle_consumption_highway = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_highway',true));

		                    $terms_vehicle_fuel_type = "";
		                    $terms_vehicle_fuel_type_id = "";
		                    $vehicle_fuel_type = get_the_terms($car_ID, 'vehicle_fuel_type' );
		                    if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
		                        $terms_vehicle_fuel_type = $vehicle_fuel_type[0]->name;
		                        $terms_vehicle_fuel_type_id = $vehicle_fuel_type[0]->term_id;
		                    endif;

		                    $terms_vehicle_transmission = "";
		                    $terms_vehicle_transmission_id = "";
		                    $vehicle_transmission = get_the_terms($car_ID, 'vehicle_transmission' );
		                    if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
		                        $terms_vehicle_transmission = $vehicle_transmission[0]->name;
		                        $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
		                    endif;

		                    $vehicle_name = $vehicle_year . " " . $vehicle_make . " " . $vehicle_model;

		                    $vehicle_condition = esc_attr(get_post_meta($car_ID, 'vehicle_condition',true));

		                    //
		                    $terms_vehicle_body_style = "";
		                    $terms_vehicle_body_style_name = "";
		                    $vehicle_body_style = get_the_terms($car_ID, 'vehicle_body_style' );
		                    if ($vehicle_body_style && ! is_wp_error($vehicle_body_style)) :
		                        $terms_vehicle_body_style = $vehicle_body_style[0]->term_id;
		                        $terms_vehicle_body_style_name = $vehicle_body_style[0]->name;
		                    endif;

		                    $total_photos = autoroyal_count_photos( $car_ID );

		                    //
		                    $vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
		                    if(!empty($vehicle_exterior_color)) {
		                        $color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
		                        $color_id   = $vehicle_exterior_color[0]->term_id;
		                        $color_name = $vehicle_exterior_color[0]->name;
		                        $color_type = get_term_meta( $vehicle_exterior_color[0]->term_id, 'color_type', true );
		                    } else {
		                        $color_type = "";
		                    }

							$vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));

							$vehicle_carfax_link = esc_attr(get_post_meta($car_ID, 'vehicle_carfax_link',true));
							$vehicle_autocheck_link = esc_attr(get_post_meta($car_ID, 'vehicle_autocheck_link',true));
							$vehicle_pre_owned = esc_attr(get_post_meta($car_ID, 'vehicle_pre_owned',true));

						?>

						<div id="favorite-vehicle-<?php echo esc_attr($car_ID); ?>" class="col-lg-6 col-md-6 col-sm-12 autoroyal-vehicle-grid-block"> 

							<div class="autoroyal-vehicle-block autoroyal-block-style-2">
								
								<div class="autoroyal-vehicle-block-image-wrapper">
									
									<?php if(!empty($vehicle_image_url)) { ?>
									
										<a data-open-id="car-gallery-grid-fav-<?php echo esc_attr($car_ID); ?>" class="autoroyal-vehicle-block-image-gallery open-album" href="#"><i class="fa fa-file-image-o" aria-hidden="true"></i><?php if($total_photos['total'] > "0") {?><span><?php echo esc_attr($total_photos['total']); ?></span><?php } ?></a>
									
										<?php foreach ( $total_photos['image'] as $image ) { ?>
											<a rel="car-gallery-grid-fav-<?php echo esc_attr($car_ID); ?>" class="fancybox" href="<?php echo esc_url($image); ?>"></a>
										<?php } ?>

									<?php } ?>

									<?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); ?>
									<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($foto_large); ?>);"></a>
									<?php } else { ?>
									<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
										<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
			c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
			c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
			c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
			s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
			c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
			C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
			c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
			 M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
			c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
			c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
			c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
			c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
			 M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
			C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>

									</a>
									<?php } ?>
								</div>

								<div class="autoroyal-vehicle-block-meta">

									<a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

									<ul class="autoroyal-vehicle-block-specs">

										<?php if(!empty($vehicle_mileage)) { ?>

											<li class="autoroyal-vehicle-transmission">

												<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
				c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
				c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
				c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
				C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
				c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
				c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
				c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
				C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
				c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
				c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
				C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
				c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
				c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>


												<span><?php echo autoroyal_number($vehicle_mileage); ?> <?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?></span>

											</li>

										<?php } else { ?>

											<li class="autoroyal-vehicle-condition">
												<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="48.997px" height="48.998px" viewBox="0 0 48.997 48.998" style="enable-background:new 0 0 48.997 48.998;" xml:space="preserve"><path d="M45.961,18.702c-0.033-0.038-0.061-0.075-0.1-0.112l-1.717-1.657c1.424-0.323,2.957-1.516,2.957-2.74
		c0-1.426-1.979-1.932-3.668-1.932c-1.766,0-1.971,1.21-1.992,2.065l-4.43-4.271c-0.9-0.891-2.607-1.592-3.883-1.592H24.5h-0.002
		h-8.63c-1.275,0-2.981,0.701-3.882,1.592l-4.429,4.271c-0.023-0.855-0.228-2.065-1.992-2.065c-1.691,0-3.669,0.506-3.669,1.932
		c0,1.224,1.534,2.417,2.958,2.74l-1.717,1.657c-0.039,0.037-0.066,0.074-0.1,0.112C1.2,20.272,0,23.184,0,25.297v6.279
		c0,1.524,0.601,2.907,1.572,3.938v2.435c0,1.424,1.192,2.585,2.658,2.585h3.214c1.466,0,2.657-1.159,2.657-2.585v-0.623h14.397
		H24.5h14.396v0.623c0,1.426,1.19,2.585,2.658,2.585h3.213c1.467,0,2.657-1.161,2.657-2.585v-2.435
		c0.972-1.031,1.572-2.414,1.572-3.938v-6.279C48.998,23.184,47.798,20.272,45.961,18.702z M13.613,11.953
		c0.623-0.519,1.712-0.913,2.255-0.913h8.63H24.5h8.63c0.543,0,1.632,0.394,2.255,0.913l5.809,5.63H24.5h-0.002H7.805L13.613,11.953
		z M1.993,24.347c0-1.546,1.21-2.801,2.704-2.801c1.493,0,6.372,2.864,6.372,4.41s-4.879,1.188-6.372,1.188
		C3.203,27.144,1.993,25.894,1.993,24.347z M10.102,34.573H9.587H9.072l-3.055,0.005c-0.848-0.264-1.446-0.572-1.869-0.903
		c-0.214-0.167-0.378-0.341-0.506-0.514c-0.129-0.175-0.223-0.347-0.284-0.519c-0.38-1.074,0.405-2.061,0.405-2.061h5.214
		l3.476,3.99L10.102,34.573L10.102,34.573z M31.996,34.575H24.5h-0.002h-7.496c-1.563,0-2.832-1.269-2.832-2.831h10.328H24.5h10.328
		C34.828,33.308,33.559,34.575,31.996,34.575z M32.654,29.812H24.5h-0.002h-8.154c-1.7,0-3.08-2.096-3.08-4.681h11.234H24.5h11.234
		C35.734,27.717,34.354,29.812,32.654,29.812z M45.641,32.644c-0.062,0.172-0.156,0.344-0.285,0.518
		c-0.127,0.173-0.291,0.347-0.506,0.514c-0.422,0.331-1.021,0.641-1.869,0.903l-3.055-0.005h-0.515h-0.515h-2.353l3.478-3.99h5.213
		C45.234,30.583,46.02,31.568,45.641,32.644z M44.301,27.144c-1.492,0-6.371,0.356-6.371-1.188s4.879-4.41,6.371-4.41
		c1.494,0,2.704,1.255,2.704,2.801C47.005,25.892,45.795,27.144,44.301,27.144z"/></svg>

												<span><?php echo esc_attr($vehicle_condition); ?></span>
											</li>

										<?php } ?>

										<?php if(!empty($terms_vehicle_transmission)) { ?>

											<li class="autoroyal-vehicle-transmission">

												<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"/><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"/><circle cx="70" cy="70" r="4"/></svg>

												<span><?php echo esc_attr($terms_vehicle_transmission); ?></span>

											</li>

										<?php } ?>

									</ul>

									<h4 class="autoroyal-vehicle-block-meta-price"><?php echo autoroyal_price($price); ?></h4>

									<?php 

		                  				$listing_id = $car_ID; 

		                  				if ( ! empty( $cars_in_compare ) and in_array( $listing_id, $cars_in_compare ) ) {
											$car_compare_status       = esc_html__( 'Remove from compare', 'autoroyal' );
											$car_compare_status_class = "added";
										} else {
											$car_compare_status       = esc_html__( 'Add to compare', 'autoroyal' );
											$car_compare_status_class = "";
										}

		              				?>

		                  			<a href="#" class="fav-button btn btn-danger pull-right add-to-compare <?php echo esc_attr($car_compare_status_class); ?>" data-id="<?php echo esc_attr($listing_id); ?>" data-title="<?php echo esc_attr($vehicle_name); ?>" data-toggle="tooltip" data-placement="top"  data-original-title="<?php echo esc_attr($car_compare_status); ?>">
		                  				<svg class="add-to-compare-plus" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve"><path d="M129.2,72.3l-23.1,23.1c-11.2-3.4-23,2.8-26.4,14s2.8,23,14,26.4c11.2,3.4,23-2.8,26.4-14c1.7-5.4,1.1-11.2-1.6-16.2l22-22
			L129.2,72.3z M100,120.7c-2.8,0-5.1-2.3-5.1-5.1s2.3-5.1,5.1-5.1c2.8,0,5.1,2.3,5.1,5.1l0,0C105.1,118.4,102.8,120.7,100,120.7z"/><g><path d="M40.8,30.2c0-5.1,2.2-8,8-8c5.8,0,8,2.9,8,8V54h23.5c4.2,0,8,2.2,8,8c0,5.8-3.8,8-8,8H56.8v23.5c0,5.1-2.2,8-8,8
				c-5.8,0-8-2.9-8-8V70H17.3c-4.2,0-8-2.2-8-8c0-5.8,3.8-8,8-8h23.5V30.2z"/></g><g><path d="M162.6,48c-15.4-15-34.7-23.5-54.6-25.4v15.3c14.2,1.5,27.7,7,38.9,16l-12.2,12.2L146,77.4l12.2-12.2
				c9,11.1,14.5,24.6,16,38.9H157v16h17.2c-1.5,14.2-7,27.7-16,38.9L146,146.8l-11.3,11.3l17.8,17.8c0.1,0.1,0.2,0.3,0.3,0.4
				c3.1,3.1,8.2,3.1,11.3,0c0,0,0,0,0,0C199.1,140.4,198.4,83,162.6,48z"/><path d="M41.8,159c-8.9-11-14.4-24.4-16-38.5H9.7c1.9,20.3,10.6,40.2,26.2,55.8c3.1,3.1,8.2,3.1,11.3,0c0,0,0,0,0,0
				c0.1-0.1,0.2-0.3,0.3-0.4l17.8-17.8L54,146.8L41.8,159z"/></g></svg>
										<svg class="add-to-compare-minus" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve"><path d="M129.2,72.3l-23.1,23.1c-11.2-3.4-23,2.8-26.4,14s2.8,23,14,26.4c11.2,3.4,23-2.8,26.4-14c1.7-5.4,1.1-11.2-1.6-16.2l22-22
			L129.2,72.3z M100,120.7c-2.8,0-5.1-2.3-5.1-5.1s2.3-5.1,5.1-5.1c2.8,0,5.1,2.3,5.1,5.1l0,0C105.1,118.4,102.8,120.7,100,120.7z"/><g><path d="M162.6,48c-15.4-15-34.7-23.5-54.6-25.4v15.3c14.2,1.5,27.7,7,38.9,16l-12.2,12.2L146,77.4l12.2-12.2
				c9,11.1,14.5,24.6,16,38.9H157v16h17.2c-1.5,14.2-7,27.7-16,38.9L146,146.8l-11.3,11.3l17.8,17.8c0.1,0.1,0.2,0.3,0.3,0.4
				c3.1,3.1,8.2,3.1,11.3,0l0,0C199.1,140.4,198.4,83,162.6,48z"/><path d="M41.8,159c-8.9-11-14.4-24.4-16-38.5H9.7c1.9,20.3,10.6,40.2,26.2,55.8c3.1,3.1,8.2,3.1,11.3,0l0,0
				c0.1-0.1,0.2-0.3,0.3-0.4l17.8-17.8L54,146.8L41.8,159z"/></g><path d="M17.3,70.2h23.5v0h16v0h23.5c4.2,0,8-2.2,8-8s-3.8-8-8-8H56.8h-16H17.3c-4.2,0-8,2.2-8,8S13.1,70.2,17.3,70.2z"/></svg>

		                  			</a>

									<?php 

										if( is_user_logged_in() ){

											$user_id = get_current_user_id();
			                				$listing_id = $car_ID;
			                				$user_type = "id";

			                			} else {

			                				$user_id = autoroyalGetIP();
			                				$listing_id = $car_ID;
			                				$user_type = "ip";

			                			}

									?>

									<a href="#" type="button" class="fav-button btn btn-danger pull-right favorited add-to-favorite" data-id="<?php echo esc_attr($listing_id); ?>" data-user-id="<?php echo esc_attr($user_id); ?>" data-user-type="<?php echo esc_attr($user_type); ?>"> 
										<?php if( is_added_to_favorite( $user_type, $user_id, $listing_id ) ){ ?><i class="fa fa-heart"></i><?php } else { ?><i class="far fa-heart"></i><?php } ?>
									</a>

								</div>

							</div>

						</div>

					<?php endforeach; ?>
				<?php endif; ?>
        		
        	</div>
        </div>

	</div>
	<?php } ?>

	<div id="pageloader">

    	<div class="preloader-wrapper">

	      	<div></div>
	      	<div></div>
	      	<div></div>
	      	<div></div>
	      	<div></div>
	      	<div></div>
	      	<div></div>
	      	<div></div>
	      	
	  	</div>

	</div>
	
	<!-- Login / Register -->
	<div id="overlay">
	    <div id="modal">
	    	<div id="modal-inner">

		        <a href="#" class="close"><i class="fa fa-close"></i></a>
		        
		        <div id="login">
			        
			        <h4><?php esc_html_e( 'Log in', 'autoroyal' ) ?></h4>
					<p><?php esc_html_e( "Don't have an account?", 'autoroyal' ) ?> <a class="autoroyal-registration" href="#"><?php esc_html_e( 'Create your account', 'autoroyal' ) ?>,</a> <?php esc_html_e( 'it takes less than a minute', 'autoroyal' ) ?>.</p>
					<div class="clear"></div>

					<div id="autoroyal_account_login_errors"></div>
					
					<form id="autoroyal_login_form" class="autoroyal_form" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">

						<fieldset>

							<label for="autoroyal_user_login"><?php esc_html_e( 'Username', 'autoroyal' ) ?></label>
							<input name="autoroyal_user_login" class="autoroyal_user_login required form-control" type="text">

							<label for="autoroyal_user_pass"><?php esc_html_e( 'Password', 'autoroyal' ) ?></label>
							<input name="autoroyal_user_pass" id="autoroyal_user_pass" class="required form-control" type="password" >

							<div class="clear"></div>

							<input type="hidden" name="action" value="autoroyal_ajax_login">
							<?php wp_nonce_field( 'autoroyal_ajax_login_html', 'autoroyal_ajax_login_nonce' ); ?>

							<button class="btn" id="autoroyal_login_submit" type="submit" value="<?php esc_html_e( 'Login', 'autoroyal' ) ?>">
								<?php esc_html_e( 'Login', 'autoroyal' ) ?><i id="login-progress" class="fa fa-spinner fa-spin fa-fw"></i>
							</button>

						</fieldset>

					</form>
				
					<!--
						wsl_render_auth_widget
						WordPress Social Login 2.3.3.
						http://wordpress.org/plugins/wordpress-social-login/
					-->

					<?php do_action( 'wordpress_social_login' ); ?>

					<!-- wsl_render_auth_widget -->

					<p class="autoroyal-margin-bottom-0"><small><a class="autoroyal-lost-password" href="#" title="<?php esc_html_e( 'Lost your password?', 'autoroyal' ) ?>"><?php esc_html_e( 'Lost your password?', 'autoroyal' ) ?></a></small></p>
			    
			    </div>
		        
		        <div id="register">
						
					<h4><?php esc_html_e( 'Create an account', 'autoroyal' ) ?></h4>
					
					<?php if ( get_option( 'users_can_register' ) ) { ?>

						<p><?php esc_html_e( 'It takes less than a minute. If you already have an account', 'autoroyal' ) ?> <a class="autoroyal-login" href="#"><?php esc_html_e( 'login', 'autoroyal' ) ?></a>.</p>
					
						<div id="autoroyal_account_register_errors"></div>
					
						<form id="autoroyal_registration_form" class="autoroyal_form" action="<?php echo admin_url('admin-ajax.php'); ?>" method="POST">

							<fieldset>

								<div class="row">

									<div class="col-md-12">
										<label for="autoroyal_user_login"><?php esc_html_e( 'Username', 'autoroyal' ) ?></label>
										<input name="autoroyal_user_login" class="autoroyal_user_login required form-control" type="text">
									</div>

									<div class="col-md-12">
										<label for="autoroyal_user_email"><?php esc_html_e( 'Email', 'autoroyal' ) ?></label>
										<input name="autoroyal_user_email" id="autoroyal_user_email" class="required form-control" type="email">
									</div>

									<div class="col-md-6">
										<label for="password"><?php esc_html_e( 'Password', 'autoroyal' ) ?></label>
										<input name="autoroyal_user_pass" id="password" class="required form-control" type="password">
									</div>

									<div class="col-md-6">
										<label for="password_again"><?php esc_html_e( 'Password Again', 'autoroyal' ) ?></label>
										<input name="autoroyal_user_pass_confirm" id="password_again" class="required form-control" type="password">
									</div>

								</div>
								
								<input type="hidden" name="action" value="autoroyal_register">
								<?php wp_nonce_field( 'autoroyal_register_html', 'autoroyal_register_nonce' ); ?>

								<button id="autoroyal_register_submit" class="btn" type="submit" value="<?php esc_html_e( 'Register', 'autoroyal' ) ?>">
									<?php esc_html_e( 'Register', 'autoroyal' ) ?><i id="register-progress" class="fa fa-spinner fa-spin fa-fw"></i>
								</button>

							</fieldset>

						</form>

					<?php } else { ?>

						<p><?php esc_html_e( 'Registration has been disabled', 'autoroyal' ) ?>.</p>

					<?php } ?>

		        </div>

		        <div id="lost-password">
					
					<h4 class=""><?php esc_html_e( 'Lost Password?', 'autoroyal' ) ?></h4>
					<p><?php esc_html_e( "Enter your email address and we'll send you a new password. If remembered password go back to", 'autoroyal' ) ?> <a class="autoroyal-back-login" href="#"><?php esc_html_e( 'login', 'autoroyal' ) ?></a>.</p>

					<div id="autoroyal_account_reset_errors"></div>

					<form id="lostpasswordform" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">
	            		<label for="user_login"><?php esc_html_e( 'Email', 'autoroyal' ) ?>

	            			<input type="text" name="user_login" id="user_login" class="form-control">

	            			<input type="hidden" name="action" value="autoroyal_reset_password">
							<?php wp_nonce_field( 'autoroyal_reset_password_html', 'autoroyal_reset_password_nonce' ); ?>

							<a href="#" id="autoroyal_reset_submit" class="btn">
								<?php esc_html_e( 'Get New Password', 'autoroyal' ) ?><i id="reset-progress" class="fa fa-spinner fa-spin fa-fw"></i>
							</a>

			        	</label>
			       	</form>

		       	</div>
	        </div>
	    </div>
	</div>
	<!-- End Login / Register -->

	<div class="single-add-to-compare">
		<div class="container">
			<div class="row">
				<div class="col-md-9 col-sm-9">
					<div class="single-add-to-compare-left">
						<span class="autoroyal-title h5"></span>
					</div>
				</div>
				<div class="col-md-3 col-sm-3">
					<?php if(!empty($car_compare_url)){ ?>
					<a href="<?php echo get_permalink( $car_compare_url ); ?>" class="compare-fixed-link pull-right heading-font"><?php esc_html_e( 'Compare', 'autoroyal' ) ?></a>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>

	<div id="page" class="site">

		<header id="masthead" class="site-header animated <?php if($menu_type == "white") { ?>white-header<?php } ?>">

			<?php if(!empty($show_hide_top_bar)) { ?>

			<div class="top-navigation d-none d-lg-block py-2">

				<div class="container">

					<div class="row">

						<div class="col-lg-8">

							<?php if(!empty($header_address)) { ?>

							<div class="d-inline-block text-white mr-4">
								<i class="fa fa-map-marker mr-2 op-3" aria-hidden="true"></i>
								<div class="d-inline-block address">
									<span class="heading-font first-line"><?php echo esc_attr($header_address); ?></span>
								</div>
							</div>

							<?php } ?>

							<?php if(!empty($header_phone_number)) { ?>

							<div class="d-inline-block text-white mr-4">
								<i class="fa fa-phone mr-2 op-3" aria-hidden="true"></i>
								<div class="d-inline-block phone">
									<span class="phone-number heading-font"><a href="tel:<?php echo esc_attr($header_phone_number); ?>"><?php echo esc_attr($header_phone_number); ?></a></span>
								</div>
							</div>

							<?php } ?>

							<?php if(!empty($header_working_hours)) { ?>

							<div class="d-inline-block text-white mr-4">
								<i class="fa fa-clock-o mr-2 op-3" aria-hidden="true"></i>
								<div class="d-inline-block phone">
									<span class="phone-number heading-font"><?php echo esc_attr($header_working_hours); ?></span>
								</div>
							</div>

							<?php } ?>

						</div>

						<div class="col-lg-4">

							<?php if( !empty($show_fav_in_top_bar) AND $show_fav_in_top_bar == "yes" ) { ?>

							<ul class="autoroyal-compare-menu navbar-nav main-menu pull-right">
							
								<?php if(post_type_exists( 'vehicle' )) { ?>
								<li class="menu-favorite-button menu-item">
									<a class="favorite-action-button text-white" href="#">
										<span class="menu-label"><?php esc_html_e( 'Favourites', 'autoroyal' ) ?></span>
										<i class="material-icons">favorite_border</i>
									</a>
								</li>
								<?php } ?>

								<?php if(!empty($car_compare_url)){ ?>
									
									<li class="menu-compare-button menu-item">
										<a class="compare-action-button text-white" href="<?php echo get_permalink( $car_compare_url ); ?>">
											<span class="menu-label"><?php esc_html_e( 'Compare', 'autoroyal' ) ?></span>
											<i class="material-icons">compare_arrows</i>
											<?php if(!empty($_COOKIE['autoroyal_compare_ids']) and count($_COOKIE['autoroyal_compare_ids'])){ ?><span class="list-badge"><span class="autoroyal-current-cars-in-compare"><?php echo esc_attr(count($_COOKIE['autoroyal_compare_ids'])); ?></span></span><?php } ?>
										</a>
									</li>

								<?php } ?>

							</ul>

							<?php } ?>

						</div>

					</div>

				</div>

			</div>

			<?php } ?>
			
			<nav id="site-navigation" class="main-navigation navbar navbar-expand-lg sticky-header">
				
				<div class="container">

					<div class="header-nav-wrapper position-relative">

						<div class="site-branding-text">
							<?php 

								if(!empty($logo) OR !empty($logo_white)) {
									if(!empty($logo) OR !empty($logo)) { ?>
									<a class="logo-dark" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo wp_kses($logo, true); ?></a>
									<?php } if(!empty($logo) OR !empty($logo_white)) {?>
									<a class="logo-white" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo wp_kses($logo_white, true); ?></a>
									<?php }
								} else {
							
									if ( is_front_page() && is_home() ) : ?>
					                    <h1 class="site-title h3 mb-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" class="navbar-brand mb-0"><?php bloginfo( 'name' ); ?></a></h1>
					                <?php else : ?>
					                    <h2 class="site-title h3 mb-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" class="navbar-brand mb-0"><?php bloginfo( 'name' ); ?></a></h2>
					                <?php
									endif;

									$description = get_bloginfo( 'description', 'display' );
				                    if ( $description || is_customize_preview() ) : ?>
				                        <p class="site-description"><?php echo esc_html( $description ); ?></p>
				                    <?php
				                    endif;

				                }
							?>
						</div>

						<div id="primary-menu-wrap" class="menu-main-menu-container">

							<ul id="primary-menu" class="navbar-nav main-menu">

								<?php if ( has_nav_menu( 'menu-1' ) ) {
																					
									wp_nav_menu( array( 
									
										'container' => '', 
										'items_wrap' => '%3$s',
										'theme_location' => 'menu-1',
										'walker' => new td_menu_walker()
																	
									) ); } else {
								
									wp_list_pages( array(
									
										'container' => '',
										'title_li' => ''
									
									));
									
								} ?>
								
							</ul>

						</div>
						
						<ul class="autoroyal-compare-menu navbar-nav main-menu pull-right">

							<?php if( empty($show_fav_in_top_bar) OR $show_fav_in_top_bar == "no" ) { ?>

							<?php if(post_type_exists( 'vehicle' )) { ?>
							<li class="menu-favorite-button menu-item">
								<a class="favorite-action-button" href="#">
									<i class="material-icons">favorite_border</i>
								</a>
							</li>
							<?php } ?>

							<?php if(!empty($car_compare_url)){ ?>
								
								<li class="menu-compare-button menu-item">
									<a class="compare-action-button" href="<?php echo get_permalink( $car_compare_url ); ?>">
										<i class="material-icons">compare_arrows</i>
										<?php if(!empty($_COOKIE['autoroyal_compare_ids']) and count($_COOKIE['autoroyal_compare_ids'])){ ?><span class="list-badge"><span class="autoroyal-current-cars-in-compare"><?php echo esc_attr(count($_COOKIE['autoroyal_compare_ids'])); ?></span></span><?php } ?>
									</a>
								</li>

							<?php } ?>

							<?php } ?>

							<?php 

								include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); 
								if( class_exists( 'autoroyal' ) ) {  
									if( !$logged ){ 

							?>
							<li class="menu-login-register-button menu-item">
								<a class="login-button" href="#"><i class="material-icons">exit_to_app</i></a>
							</li>
							<?php } else { 

								global $current_user, $td_user_id, $td_user_info;
								$td_user        = wp_get_current_user();
								$td_user_id     = $td_user->ID; // You can set $td_user_id to any users, but this gets the current users ID.
								$td_user_info   = get_userdata($td_user_id);
								$userName       = $td_user_info->display_name;

								$funds = '';

								$acc_funds = get_option( 'autoroyal_enable_account_funds' );
								if ( $acc_funds == 1 AND !is_woocommerce_active() ) {
								  	if( class_exists('autoroyal_WC_Account_Funds') ) {
										$funds = autoroyal_WC_Account_Funds::get_account_funds();
									}
								}

								// My Listings
	    						$my_listings_page = get_option("autoroyal_inventory_page_id");
	    						$website_type = get_option("autoroyal_webiste_type");
	    						$dashboard_page = get_option("autoroyal_dashboard_page_id");
	    						$my_account_button = '';
	    						if( $website_type != 'rentals' ) {
	    							$my_account_button = $dashboard_page;
	    						} else {
	    							$my_account_button = $my_listings_page;
	    						}

	    						if( !empty($my_account_button) ){ 
	    							$my_listings = "0"; $my_listings = autoroyal_get_total_cars_all_by_user( $td_user_id );

							?>
							<li class="menu-login-register-button menu-item menu-item-has-children">
								<a href="<?php echo get_permalink( $my_account_button ); ?>"><i class="material-icons">account_circle</i><span><?php echo esc_attr($userName); ?></span></a>
								<ul class="sub-menu autoroyal-dashboard-menu">
		                            <?php get_template_part( 'template-parts/my-account-menu' ); ?>
		                        </ul>
							</li>
							<?php } } } ?>

						</ul>	

						<!--Header sidebar menu-->
						<div class="autoroyal-menu-wrapper pull-right">
							<a href="#autoroyal-side-menu" class="autoroyal-trigger icon-mobile-menu " id="mobile-menu">
								<span class="icon-wrap autoroyal-middle-line"></span>
								<span class="icon-wrap autoroyal-top-line"></span>
								<span class="icon-wrap autoroyal-bottom-line"></span>
							</a>
						</div>

					</div>				

				</div>
				
			</nav><!-- #site-navigation -->

		</header><!-- #masthead -->

		<div id="content" class="site-content">
