<?php

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_title_image_options',
array(
    'title' => esc_html__( 'Page Title Image', 'autoroyal' ), //Visible title of section
    'priority' => 35, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize page title image background for autoRoyal Theme.', 'autoroyal'), //Descriptive tooltip
    'panel'  => 'autoroyal_header_options',
    )
);
////////////////////////////////////////////////

// <editor-fold defaultstate="collapsed" desc=" theme_page_title_bag_image ">
$wp_customize->add_setting( 'page_title_bg',
    array(
        'default' => $autoroyal_defaults['page_title_bg'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'page_title_bg', array(
    'label'    => esc_html__('Page Title Image Background', 'autoroyal'),
    'section'  => 'autoroyal_title_image_options',
    'settings' => 'page_title_bg',
    'description' => esc_html__(' ', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" theme_page_title_bag_image ">
$wp_customize->add_setting( 'estate_page_title_bg',
    array(
        'default' => $autoroyal_defaults['estate_page_title_bg'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'estate_page_title_bg', array(
    'label'    => esc_html__('Real Estate Page Title Image Background', 'autoroyal'),
    'section'  => 'autoroyal_title_image_options',
    'settings' => 'estate_page_title_bg',
    'description' => esc_html__(' ', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" theme_page_title_bag_image ">
$wp_customize->add_setting( 'search_page_title_bg',
    array(
        'default' => $autoroyal_defaults['search_page_title_bg'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'search_page_title_bg', array(
    'label'    => esc_html__('Search Page Title Image Background', 'autoroyal'),
    'section'  => 'autoroyal_title_image_options',
    'settings' => 'search_page_title_bg',
    'description' => esc_html__(' ', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" theme_page_title_bag_image ">
$wp_customize->add_setting( 'blog_page_title_bg',
    array(
        'default' => $autoroyal_defaults['blog_page_title_bg'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'blog_page_title_bg', array(
    'label'    => esc_html__('Blog Page Title Image Background', 'autoroyal'),
    'section'  => 'autoroyal_title_image_options',
    'settings' => 'blog_page_title_bg',
    'description' => esc_html__(' ', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" theme_page_title_bag_image ">
$wp_customize->add_setting( 'shop_page_title_bg',
    array(
        'default' => $autoroyal_defaults['shop_page_title_bg'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'shop_page_title_bg', array(
    'label'    => esc_html__('Shop Page Title Image Background', 'autoroyal'),
    'section'  => 'autoroyal_title_image_options',
    'settings' => 'shop_page_title_bg',
    'description' => esc_html__(' ', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" theme_page_title_bag_image ">
$wp_customize->add_setting( 'portfolio_page_title_bg',
    array(
        'default' => $autoroyal_defaults['portfolio_page_title_bg'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'portfolio_page_title_bg', array(
    'label'    => esc_html__('Portfolio Page Title Image Background', 'autoroyal'),
    'section'  => 'autoroyal_title_image_options',
    'settings' => 'portfolio_page_title_bg',
    'description' => esc_html__(' ', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>