<?php

function choice_a_callback( $control ) {
    if ( $control->manager->get_setting('show_hide_top_bar')->value() == true ) {
        return true;
    } else {
        return false;
    }
}

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_social_options',
array(
    'title' => esc_html__( 'Social', 'autoroyal' ), //Visible title of section
    'priority' => 35, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize Social Links for autoRoyal Theme.', 'autoroyal'), //Descriptive tooltip
    'panel'  => 'autoroyal_header_options',
    )
);
////////////////////////////////////////////////

// <editor-fold defaultstate="collapsed" desc=" show_hide_top_bar ">
$wp_customize->add_setting( 'show_hide_top_bar',
array(
    'default' => $autoroyal_defaults['show_hide_top_bar'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'wp_kses',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'refresh', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( 'show_hide_top_bar', array(
    'label' => esc_html__( 'Show top info bar', 'autoroyal' ),
    'section' => 'autoroyal_social_options',
    'settings' => 'show_hide_top_bar',
    'type' => 'checkbox'
) );
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" top_phone_number ">
$wp_customize->add_setting( 'show_fav_in_top_bar',
array(
    'default' => $autoroyal_defaults['show_fav_in_top_bar'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'refresh', //What triggers a postMessage of the setting? 'postMessage' or 'postMessage' (instant)?
    'active_callback' => 'choice_a_callback',
    )
);
$wp_customize->add_control(
    'show_fav_in_top_bar', 
    array(
        'label'    => esc_html__( 'Show favorites icon in top bar', 'autoroyal' ),
        'section'  => 'autoroyal_social_options',
        'type'     => 'radio',
        'choices'  => array(
            'no' => 'No',
            'yes' => 'Yes',
        ),
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" header_address ">
$wp_customize->add_setting( 'header_address',
array(
    'default' => $autoroyal_defaults['header_address'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('header_address', array(
    'settings' => 'header_address',
    'label'    => esc_html__('Header address', 'autoroyal'),
    'section'  => 'autoroyal_social_options',
    'type'     => 'text',
    'active_callback' => 'choice_a_callback',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" header_phone_number ">
$wp_customize->add_setting( 'header_phone_number',
array(
    'default' => $autoroyal_defaults['header_phone_number'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('header_phone_number', array(
    'settings' => 'header_phone_number',
    'label'    => esc_html__('Header phone number', 'autoroyal'),
    'section'  => 'autoroyal_social_options',
    'type'     => 'text',
    'active_callback' => 'choice_a_callback',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" header_working_hours ">
$wp_customize->add_setting( 'header_working_hours',
array(
    'default' => $autoroyal_defaults['header_working_hours'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('header_working_hours', array(
    'settings' => 'header_working_hours',
    'label'    => esc_html__('Header working hours', 'autoroyal'),
    'section'  => 'autoroyal_social_options',
    'type'     => 'text',
    'active_callback' => 'choice_a_callback',
));
// </editor-fold>