<?php

function ct_is_not_activated() {
  return (get_option( 'realestate-7_license_key_status', false) != 'valid');
}

function prefix_theme_updater() {
  require( get_template_directory() . '/admin/updater/theme-updater-admin.php' );
  
  function ct_activation_admin_notices() {
    if(ct_is_not_activated()) {
      
      $link = admin_url( 'themes.php?page=' . 'realestate-7' . '-license' );

      echo '<style>';
        echo '#theme-activation-notice { position: relative;}';
          echo '#theme-activation-notice-col-one { float: left; width: 80%; margin: 0 0 10px 20px;}';
            echo '#theme-activation-notice-col-one h3 { margin-bottom: 0;}';
            echo '#theme-activation-notice-col-one p { margin-bottom: 0;}';
          echo '#theme-activation-btn { position: absolute; top: 23px; right: 20px;}';
          echo '@media only screen and (max-width: 959px) {';
            echo '#theme-activation-btn { top: 26px;}';
          echo '}';
          echo '@media only screen and (max-width: 767px) {';
            echo '#theme-activation-notice-col-one { width: 100%;}';
            echo '#theme-activation-btn { position: relative; left: 20px; top: 0; margin-bottom: 20px;}';
          echo '}';
      echo '</style>';

      echo '<div id="theme-activation-notice" class="updated notice">';
        echo '<div id="theme-activation-notice-col-one">';
              echo '<h3><strong>' . __('Theme requires activation', 'contempo') . '</strong></h3>';
              echo '<p>' . __('Your Themeforest purchase code is required to receive updates and support.', 'contempo') . '</p>';
        echo '</div>';
        echo '<a id="theme-activation-btn" class="button button-primary" href="' . esc_url($link) . '">' 
                . __('Open Theme License Page', 'contempo') . '</a>';
          
          echo '<div class="clear"></div>';
      echo '</div>';

    }
  }

  add_action( 'admin_notices', 'ct_activation_admin_notices', -100 );

  if(is_admin() && get_option( 'ct_redirect_to_activation') === '1') {
    $redirect_url = admin_url( 'themes.php?page=' . 'realestate-7' . '-license' );
    delete_option( 'ct_redirect_to_activation' );
    wp_redirect($redirect_url);
    exit;
  }
}

add_action( 'after_setup_theme', 'prefix_theme_updater' );

// add_filter( 'ct_need_purchase_code', 'ct_need_code', 100);
// function ct_need_code() {
//   return  (get_option( 'realestate-7_license_key_status', false) != 'valid');
// }

function ct_theme_upgrader_process_complete($upgrader_object, $options) {
  if ($options['action'] == 'update' && $options['type'] == 'theme' ) {
    foreach($options['themes'] as $each_plugin) {
      if ($each_plugin == 'realestate-7' && ct_is_not_activated()) {
        $current_version = wp_get_theme()->get('Version');
        if(version_compare('3.0.6', $current_version, '>')) {
          update_option( 'ct_redirect_to_activation', '1');
        }
      }
   }
  }
}

add_action( 'upgrader_process_complete', 'ct_theme_upgrader_process_complete', 1, 2);
