<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Content class.
 */
class autoroyal_Car_Post_Type {

	/**
	 * Constructor
	 */
	public function __construct() {

		add_action( 'init', array( $this, 'register_vehicle_post_type' ), 0 );

		add_filter( 'the_car_description', 'wptexturize'        );
		add_filter( 'the_car_description', 'convert_smilies'    );
		add_filter( 'the_car_description', 'convert_chars'      );
		add_filter( 'the_car_description', 'wpautop'            );
		add_filter( 'the_car_description', 'shortcode_unautop'  );
		add_filter( 'the_car_description', 'prepend_attachment' );
		
		if ( ! empty( $GLOBALS['wp_embed'] ) ) {
			add_filter( 'the_car_description', array( $GLOBALS['wp_embed'], 'run_shortcode' ), 8 );
			add_filter( 'the_car_description', array( $GLOBALS['wp_embed'], 'autoembed' ), 8 );
		}

		add_filter( 'wp_insert_post_data', array( $this, 'fix_car_post_name' ), '99', 2 );
		add_action( 'wp_insert_post', array( $this, 'maybe_add_default_meta_data' ), 10, 2 );

		// Add dealer template.
		add_filter( 'author_template', array( $this, 'autoroyal_dealer_template_include' ), 10, 2 );

		add_action('init', array( $this, 'autoroyal_change_author_base' ), 10, 2);

		// Single car content
		$this->car_content_filter( true );

	}

	public function  autoroyal_dealer_template_include( $template ) {

		// Get queried object, should be a WP_User object.
		$author = get_queried_object();

		// Make sure we have a WP_User object.
		if ( ! $author instanceof WP_User ) {
			return $template;
		}

		// Nicename and ID templates should take priority, so we need to check for their existence.
		$nicename_template = strpos( $template, "author-{$author->user_nicename}.php" );
		$id_template       = strpos( $template, "author-{$author->ID}.php" );

		// If they don't exist, search for a role based template.
		if ( false === $nicename_template && false === $id_template ) {

			$templates = 'autoroyal-author';

			// Check for the template.
			$new_template = get_autoroyal_template_part( $templates, 'dealer' );

			// If we have a role-based template, let's set it to be loaded.
			if ( '' !== $new_template ) {
				$template = $new_template;
			}
		}

		return $template;
	}

	public function autoroyal_change_author_base() {
	    global $wp_rewrite;
	    $author_slug = 'dealer'; // the new slug name
	    $wp_rewrite->author_base = $author_slug;
	}

	/**
	 * register_vehicle_post_type function.
	 *
	 * @access public
	 * @return void
	 */
	public function register_vehicle_post_type() {
		
		if ( post_type_exists( "vehicle" ) )
			return;

		$admin_capability = 'manage_vehicles';

		/**
		* Model
		*/
		$singular  = __( 'Model', 'autoroyal' );
		$plural    = __( 'Models', 'autoroyal' );

		register_taxonomy( "vehicle_model",
			apply_filters( 'register_taxonomy_vehicle_model_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_model_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Year/Maker/Model/Trim', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Year/Maker/Model/Trim', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Year/Maker/Model/Trim', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Year/Maker/Model/Trim:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Year/Maker/Model/Trim', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Year/Maker/Model/Trim', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Year/Maker/Model/Trim', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Year/Maker/Model/Trim Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_model',
                    'with_front' => false,
                ),
	        ) )
	    );

	    // Body Style
	    $singular  = __( 'Body Style', 'autoroyal' );
		$plural    = __( 'Body Style', 'autoroyal' );
		register_taxonomy( "vehicle_body_style",
			apply_filters( 'register_taxonomy_vehicle_body_style_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_body_style_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Body Style', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Body Styles', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Body Style', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Body Style:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Body Style', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Body Style', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Body Style', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Body Style Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_body_style',
                    'with_front' => false,
                ),
	        ) )
	    );

	    // Exterior Color
	    $singular  = __( 'Exterior Color', 'autoroyal' );
		$plural    = __( 'Exterior Colors', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-ext-color', 'vehicle exterior color slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_exterior_color",
			apply_filters( 'register_taxonomy_vehicle_exterior_color_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_exterior_color_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Color', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Color', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Color', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Color:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Color', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Color', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Color', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Color Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    function autoroyal_register_meta() {
		    register_meta( 'term', 'color', 'autoroyal_sanitize_hex' );
		}

		add_action( 'vehicle_exterior_color_add_form_fields', 'ccp_new_term_color_field' );

		function ccp_new_term_color_field() {

		    wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_color_nonce' ); ?>

		    <div class="form-field autoroyal-term-color-wrap">
		        <label for="autoroyal-term-color"><?php esc_html_e( 'Color', 'autoroyal' ); ?></label>
		        <input type="text" name="autoroyal_term_color" id="autoroyal-term-color" value="" class="autoroyal-color-field" data-default-color="#ffffff" />
		    </div>
	
			<div class="form-field autoroyal-term-color-wrap">
				
				<label for="autoroyal-term-color"><?php esc_html_e( 'Color Type', 'autoroyal' ); ?></label>
		    	<input type="radio" name="color_type" value="default" checked> <?php esc_html_e('Default', 'autoroyal' ); ?><br>
	  			<input type="radio" name="color_type" value="combined" > <?php esc_html_e('Combined', 'autoroyal' ); ?><br>
	  			<input type="radio" name="color_type" value="na" > <?php esc_html_e('N/A', 'autoroyal' ); ?>

		  	</div>

		<?php }

		add_action( 'vehicle_exterior_color_edit_form_fields', 'ccp_edit_term_color_field' );

		function ccp_edit_term_color_field( $term ) {

		    $default      = '#ffffff';
		    $color        = autoroyal_get_term_color( $term->term_id, true );
		    $color_type   = get_term_meta( $term->term_id, 'color_type', true );

		    if(empty($color_type)) {
		    	$color_type = "default";
		    }

		    if ( ! $color )
		        $color = $default; ?>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="autoroyal-term-color"><?php esc_html_e( 'Color', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_color_nonce' ); ?>
		            <input type="text" name="autoroyal_term_color" id="autoroyal-term-color" value="<?php echo esc_attr( $color ); ?>" class="autoroyal-color-field" data-default-color="<?php echo esc_attr( $default ); ?>" />
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="autoroyal-term-color"><?php esc_html_e( 'Color Type', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_color_nonce' ); ?>
		            <input type="radio" name="color_type" value="default" <?php if($color_type == "default") { echo "checked"; } ?>> <?php esc_html_e('Default', 'autoroyal' ); ?><br>
		  			<input type="radio" name="color_type" value="combined" <?php if($color_type == "combined") { echo "checked"; } ?>> <?php esc_html_e('Combined', 'autoroyal' ); ?><br>
		  			<input type="radio" name="color_type" value="na" <?php if($color_type == "na") { echo "checked"; } ?>> <?php esc_html_e('N/A', 'autoroyal' ); ?>
		        </td>
		    </tr>

		<?php }

		add_action( 'edited_vehicle_exterior_color', 'autoroyal_save_term_color' );
		add_action( 'create_vehicle_exterior_color', 'autoroyal_save_term_color' );

		function autoroyal_save_term_color( $term_id ) {

		    if ( ! isset( $_POST['autoroyal_term_color_nonce'] ) || ! wp_verify_nonce( $_POST['autoroyal_term_color_nonce'], basename( __FILE__ ) ) )
		        return;

		    $old_color = autoroyal_get_term_color( $term_id );
		    $new_color = isset( $_POST['autoroyal_term_color'] ) ? autoroyal_sanitize_hex( $_POST['autoroyal_term_color'] ) : '';

		    if ( $old_color && '' === $new_color )
		        delete_term_meta( $term_id, 'color' );

		    else if ( $old_color !== $new_color )
		        update_term_meta( $term_id, 'color', $new_color );

		    $color_type = isset( $_POST['color_type'] ) ? esc_attr( $_POST['color_type'] ) : '';
		    update_term_meta( $term_id, 'color_type', $color_type );
		}

		add_filter( 'manage_edit-vehicle_exterior_color_columns', 'autoroyal_edit_term_columns' );

		function autoroyal_edit_term_columns( $columns ) {

		    $columns['color'] = __( 'Color', 'autoroyal' );

		    return $columns;
		}

		// Handle the output for the column
		add_filter( 'manage_vehicle_exterior_color_custom_column', 'autoroyal_manage_term_custom_column', 10, 3 );

		function autoroyal_manage_term_custom_column( $out, $column, $term_id ) {

		    if ( 'color' === $column ) {

		        $color = autoroyal_get_term_color( $term_id, true );

		        if ( ! $color )
		            $color = '#ffffff';

		        $out = sprintf( '<span class="color-block" style="background:%s;">&nbsp;</span>', esc_attr( $color ) );
		    }

		    return $out;
		}

		// Interior Color
	    $singular  = __( 'Interior Color', 'autoroyal' );
		$plural    = __( 'Interior Colors', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-int-color', 'vehicle interior color slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_interior_color",
			apply_filters( 'register_taxonomy_vehicle_interior_color_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_interior_color_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Color', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Color', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Color', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Color:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Color', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Color', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Color', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Color Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

		add_action( 'vehicle_interior_color_add_form_fields', 'ccp_new_term_interior_color_field' );

		function ccp_new_term_interior_color_field() {

		    wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_interior_color_nonce' ); ?>

		    <div class="form-field autoroyal-term-color-wrap">
		        <label for="autoroyal-term-color"><?php esc_html_e( 'Color', 'autoroyal' ); ?></label>
		        <input type="text" name="autoroyal_term_color" id="autoroyal-term-color" value="" class="autoroyal-color-field" data-default-color="#ffffff" />
		    </div>
	
			<div class="form-field autoroyal-term-color-wrap">
				
				<label for="autoroyal-term-color"><?php esc_html_e( 'Color Type', 'autoroyal' ); ?></label>
		    	<input type="radio" name="color_type" value="default" checked> <?php esc_html_e('Default', 'autoroyal' ); ?><br>
	  			<input type="radio" name="color_type" value="combined" > <?php esc_html_e('Combined', 'autoroyal' ); ?><br>
	  			<input type="radio" name="color_type" value="na" > <?php esc_html_e('N/A', 'autoroyal' ); ?>

		  	</div>

		<?php }

		add_action( 'vehicle_interior_color_edit_form_fields', 'ccp_edit_term_interior_color_field' );

		function ccp_edit_term_interior_color_field( $term ) {

		    $default      = '#ffffff';
		    $color        = autoroyal_get_term_color( $term->term_id, true );
		    $color_type   = get_term_meta( $term->term_id, 'color_type', true );

		    if(empty($color_type)) {
		    	$color_type = "default";
		    }

		    if ( ! $color )
		        $color = $default; ?>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="autoroyal-term-color"><?php esc_html_e( 'Color', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_interior_color_nonce' ); ?>
		            <input type="text" name="autoroyal_term_color" id="autoroyal-term-color" value="<?php echo esc_attr( $color ); ?>" class="autoroyal-color-field" data-default-color="<?php echo esc_attr( $default ); ?>" />
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="autoroyal-term-color"><?php esc_html_e( 'Color Type', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_color_nonce' ); ?>
		            <input type="radio" name="color_type" value="default" <?php if($color_type == "default") { echo "checked"; } ?>> <?php esc_html_e('Default', 'autoroyal' ); ?><br>
		  			<input type="radio" name="color_type" value="combined" <?php if($color_type == "combined") { echo "checked"; } ?>> <?php esc_html_e('Combined', 'autoroyal' ); ?><br>
		  			<input type="radio" name="color_type" value="na" <?php if($color_type == "na") { echo "checked"; } ?>> <?php esc_html_e('N/A', 'autoroyal' ); ?>
		        </td>
		    </tr>

		<?php }

		add_action( 'edited_vehicle_interior_color', 'autoroyal_save_term_interior_color' );
		add_action( 'create_vehicle_interior_color', 'autoroyal_save_term_interior_color' );

		function autoroyal_save_term_interior_color( $term_id ) {

		    if ( ! isset( $_POST['autoroyal_term_color_nonce'] ) || ! wp_verify_nonce( $_POST['autoroyal_term_color_nonce'], basename( __FILE__ ) ) )
		        return;

		    $old_color = autoroyal_get_term_color( $term_id );
		    $new_color = isset( $_POST['autoroyal_term_color'] ) ? autoroyal_sanitize_hex( $_POST['autoroyal_term_color'] ) : '';

		    if ( $old_color && '' === $new_color )
		        delete_term_meta( $term_id, 'color' );

		    else if ( $old_color !== $new_color )
		        update_term_meta( $term_id, 'color', $new_color );

		    $color_type = isset( $_POST['color_type'] ) ? esc_attr( $_POST['color_type'] ) : '';
		    update_term_meta( $term_id, 'color_type', $color_type );
		}

		add_filter( 'manage_edit-vehicle_interior_color_columns', 'autoroyal_edit_interior_term_columns' );

		function autoroyal_edit_interior_term_columns( $columns ) {

		    $columns['color'] = __( 'Color', 'autoroyal' );

		    return $columns;
		}

		// Handle the output for the column
		add_filter( 'manage_vehicle_interior_color_custom_column', 'autoroyal_manage_interior_term_custom_column', 10, 3 );

		function autoroyal_manage_interior_term_custom_column( $out, $column, $term_id ) {

		    if ( 'color' === $column ) {

		        $color = autoroyal_get_term_color( $term_id, true );

		        if ( ! $color )
		            $color = '#ffffff';

		        $out = sprintf( '<span class="color-block" style="background:%s;">&nbsp;</span>', esc_attr( $color ) );
		    }

		    return $out;
		}

	    // Interior Materials
	    $singular  = __( 'Interior Material', 'autoroyal' );
		$plural    = __( 'Interior Materials', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-interior-material', 'vehicle interior material slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_interior_material",
			apply_filters( 'register_taxonomy_vehicle_interior_type_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_interior_type_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Interior Material', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Interior Material', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Interior Material', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Interior Material:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Interior Material', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Interior Material', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Interior Material', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Interior Material Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Fuel Type
	    $singular  = __( 'Fuel Type', 'autoroyal' );
		$plural    = __( 'Fuel Types', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-fuel-type', 'vehicle fule type slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_fuel_type",
			apply_filters( 'register_taxonomy_vehicle_fuel_type_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_fuel_type_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Fuel Type', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Fuel Type', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Fuel Type', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Fuel Type:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Fuel Type', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Fuel Type', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Fuel Type', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Fuel Type Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Transmission
	    $singular  = __( 'Transmission', 'autoroyal' );
		$plural    = __( 'Transmissions', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-transmission', 'vehicle transmission slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_transmission",
			apply_filters( 'register_taxonomy_vehicle_transmission_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_transmission_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Transmission', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Transmission', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Transmission', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Transmission:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Transmission', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Transmission', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Transmission', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Transmission Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Drive
	    $singular  = __( 'Drive', 'autoroyal' );
		$plural    = __( 'Drive', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-drive', 'vehicle drive slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_drive",
			apply_filters( 'register_taxonomy_vehicle_drive_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_drive_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Drive', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Drive', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Drive', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Drive:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Drive', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Drive', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Drive', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Drive Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Doors
	    $singular  = __( 'Doors', 'autoroyal' );
		$plural    = __( 'Doors', 'autoroyal' );
		register_taxonomy( "vehicle_doors",
			apply_filters( 'register_taxonomy_vehicle_doors_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_doors_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Doors', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Doors', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Door', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Door:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Door Number', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Door Number', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Door Number', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Door Number', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_doors',
                    'with_front' => false,
                ),
	        ) )
	    );

	    // Seats
	    $singular  = __( 'Seats', 'autoroyal' );
		$plural    = __( 'Seats', 'autoroyal' );
		register_taxonomy( "vehicle_seats",
			apply_filters( 'register_taxonomy_vehicle_seats_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_seats_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Seats', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Seats', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Seats', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Seats:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Seats Number', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Seats Number', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Seats Number', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Seats Number', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_seats',
                    'with_front' => false,
                ),
	        ) )
	    );

	    // Luggages
	    $singular  = __( 'Luggages', 'autoroyal' );
		$plural    = __( 'Luggages', 'autoroyal' );
		register_taxonomy( "vehicle_luggages",
			apply_filters( 'register_taxonomy_vehicle_luggages_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_luggages_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Luggages', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Luggages', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Luggages', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Luggages:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Luggages Number', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Luggages Number', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Luggages Number', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Luggages Number', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_luggages',
                    'with_front' => false,
                ),
	        ) )
	    );

	    // Minimum Rent Age
	    $singular  = __( 'Minimum Rent Age', 'autoroyal' );
		$plural    = __( 'Minimum Rent Age', 'autoroyal' );
		register_taxonomy( "vehicle_rent_age",
			apply_filters( 'register_taxonomy_vehicle_rent_age_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_rent_age_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Minimum Rent Age', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Minimum Rent Age', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Minimum Rent Age', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Minimum Rent Age:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Minimum Rent Age', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Minimum Rent Age', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Minimum Rent Age', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Minimum Rent Age', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_rent_age',
                    'with_front' => false,
                ),
	        ) )
	    );

	    // Safety
	    $singular  = __( 'Safety', 'autoroyal' );
		$plural    = __( 'Safety', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-safety', 'vehicle safety slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_safety",
			apply_filters( 'register_taxonomy_vehicle_safety_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_safety_args', array(
	            'hierarchical' 			=> false,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Safety', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Safety', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Safety', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Safety:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Safety', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Safety', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Safety', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Safety Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Comfort
	    $singular  = __( 'Comfort', 'autoroyal' );
		$plural    = __( 'Comfort', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-comfort', 'vehicle comfort slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_comfort",
			apply_filters( 'register_taxonomy_vehicle_comfort_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_comfort_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Comfort', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Comfort', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Comfort', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Comfort:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Comfort', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Comfort', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Comfort', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Comfort Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Exterior
	    $singular  = __( 'Exterior', 'autoroyal' );
		$plural    = __( 'Exterior', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-exterior', 'vehicle exterior slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_exterior",
			apply_filters( 'register_taxonomy_vehicle_exterior_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_exterior_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Exterior', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Exterior', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Exterior', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Exterior:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Exterior', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Exterior', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Exterior', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Exterior Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Interior
	    $singular  = __( 'Interior', 'autoroyal' );
		$plural    = __( 'Interior', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-interior', 'vehicle interior slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_interior",
			apply_filters( 'register_taxonomy_vehicle_interior_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_interior_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Interior', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Interior', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Interior', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Interior:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Interior', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Interior', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Interior', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Interior Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Multimedia
	    $singular  = __( 'Multimedia', 'autoroyal' );
		$plural    = __( 'Multimedia', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-multimedia', 'vehicle multimedia slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_multimedia",
			apply_filters( 'register_taxonomy_vehicle_multimedia_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_multimedia_args', array(
	            'hierarchical' 			=> false,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Multimedia', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Multimedia', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Multimedia', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Multimedia:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Multimedia', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Multimedia', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Multimedia', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Multimedia Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Rent Pick-up/Return Locations
	    $singular  = __( 'Rent Pick-up Location', 'autoroyal' );
		$plural    = __( 'Rent Pick-up Locations', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-rent-pickup', 'vehicle rent pickup slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => false
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_rent_pickup",
			apply_filters( 'register_taxonomy_vehicle_rent_pickup_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_rent_pickup_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Rent Pick-up Locations', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Rent Pick-up Locations', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Rent Pick-up Locations', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Rent Pick-up Locations:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Rent Pick-up Locations', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Rent Pick-up Locations', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Rent Pick-up Locations', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Rent Pick-up Locations Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Visibility
	    $singular  = __( 'Visibility', 'autoroyal' );
		$plural    = __( 'Visibility', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-visibility', 'vehicle visibility slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_visibility",
			apply_filters( 'register_taxonomy_vehicle_visibility_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_visibility_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Visibility', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Visibility', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Visibility', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Visibility:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Visibility', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Visibility', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Visibility', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Visibility Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Locations
	    $singular  = __( 'Location', 'autoroyal' );
		$plural    = __( 'Locations', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'vehicle-location', 'vehicle location slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "vehicle_location",
			apply_filters( 'register_taxonomy_vehicle_location_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_location_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Location', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Location', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Location', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Location:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Location', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Location', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Location', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Location Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    add_action( 'vehicle_location_add_form_fields', 'ccp_new_term_location_field' );

		function ccp_new_term_location_field() {

		    wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_location_nonce' ); ?>

		    <div class="form-field autoroyal-term-color-wrap">
		        <label for="vehicle_location_name" class="control-label"><?php esc_html_e('Location Name / Company Name', 'autoroyal' ); ?></label>
				<input type="text" id="vehicle_location_name" name="vehicle_location_name" value="" placeholder="">
		    </div>

		  	<div class="form-field autoroyal-term-color-wrap">
				<label for="vehicle_location_phone" class="control-label"><?php esc_html_e('Phone number', 'autoroyal' ); ?></label>
				<input type="text" id="vehicle_location_phone" name="vehicle_location_phone" value="" placeholder="">
		  	</div>

		  	<div class="form-field autoroyal-term-color-wrap">
		  		<label for="vehicle_location_email" class="control-label"><?php esc_html_e('Email', 'autoroyal' ); ?></label>
				<input type="text" id="vehicle_location_email" name="vehicle_location_email" value="" placeholder="">
		  	</div>

		  	<div class="form-field autoroyal-term-color-wrap">
		  		<label for="vehicle_location_address" class="control-label"><?php esc_html_e('Location (Full Address)', 'autoroyal' ); ?></label>
				<input type="text" id="vehicle_location_address" name="vehicle_location_address" value="" placeholder="">

				<input type="hidden" id="vehicle_location_latitude" name="vehicle_location_latitude" value="" />
				<input type="hidden" id="vehicle_location_longitude" name="vehicle_location_longitude" value="" />
		  	</div>

		  	<div class="form-field autoroyal-term-color-wrap">
		  		<div id="map-canvas"></div>
		  	</div>

		<?php }

		add_action( 'vehicle_location_edit_form_fields', 'ccp_edit_term_location_field' );

		function ccp_edit_term_location_field( $term ) {

		    $term_id = $term->term_id;

		    $vehicle_location_name = get_term_meta( $term_id, 'vehicle_location_name', true );
			$vehicle_location_phone = get_term_meta( $term_id, 'vehicle_location_phone', true );
			$vehicle_location_email = get_term_meta( $term_id, 'vehicle_location_email', true );
			$vehicle_location_address = get_term_meta( $term_id, 'vehicle_location_address', true );
			$vehicle_location_latitude = get_term_meta( $term_id, 'vehicle_location_latitude', true );
			$vehicle_location_longitude = get_term_meta( $term_id, 'vehicle_location_longitude', true );

		    ?>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="vehicle_location_name" class="control-label"><?php esc_html_e('Location Name / Company Name', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_location_nonce' ); ?>
		            <input type="text" id="vehicle_location_name" name="vehicle_location_name" value="<?php echo esc_attr($vehicle_location_name); ?>" placeholder="">
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="vehicle_location_phone" class="control-label"><?php esc_html_e('Phone number', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_location_nonce' ); ?>
		            <input type="text" id="vehicle_location_phone" name="vehicle_location_phone" value="<?php echo esc_attr($vehicle_location_phone); ?>" placeholder="">
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="vehicle_location_email" class="control-label"><?php esc_html_e('Email', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_location_nonce' ); ?>
		            <input type="text" id="vehicle_location_email" name="vehicle_location_email" value="<?php echo esc_attr($vehicle_location_email); ?>" placeholder="">
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="vehicle_location_address" class="control-label"><?php esc_html_e('Location (Full Address)', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_location_nonce' ); ?>
		            <input type="text" id="vehicle_location_address" name="vehicle_location_address" value="<?php echo esc_attr($vehicle_location_address); ?>" placeholder="">
					<input type="hidden" id="vehicle_location_latitude" name="vehicle_location_latitude" value="<?php echo esc_attr($vehicle_location_latitude); ?>" />
					<input type="hidden" id="vehicle_location_longitude" name="vehicle_location_longitude" value="<?php echo esc_attr($vehicle_location_longitude); ?>" />
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="vehicle_location_map" class="control-label"><?php esc_html_e('Map', 'autoroyal' ); ?></label></th>
		        <td>
		            <div id="map-canvas"></div>
		        </td>
		    </tr>

		<?php

		}

		add_action( 'edited_vehicle_location', 'autoroyal_save_term_location' );
		add_action( 'create_vehicle_location', 'autoroyal_save_term_location' );

		function autoroyal_save_term_location( $term_id ) {

		    if ( ! isset( $_POST['autoroyal_term_location_nonce'] ) || ! wp_verify_nonce( $_POST['autoroyal_term_location_nonce'], basename( __FILE__ ) ) )
		        return;

		    update_term_meta( $term_id, 'vehicle_location_name', sanitize_text_field($_POST['vehicle_location_name']) );
		    update_term_meta( $term_id, 'vehicle_location_phone', sanitize_text_field($_POST['vehicle_location_phone']) );
		    update_term_meta( $term_id, 'vehicle_location_email', sanitize_text_field($_POST['vehicle_location_email']) );
		    update_term_meta( $term_id, 'vehicle_location_address', sanitize_text_field($_POST['vehicle_location_address']) );
		    update_term_meta( $term_id, 'vehicle_location_latitude', sanitize_text_field($_POST['vehicle_location_latitude']) );
		    update_term_meta( $term_id, 'vehicle_location_longitude', sanitize_text_field($_POST['vehicle_location_longitude']) );
		}

	    // Collections
	    $singular  = __( 'Collection', 'autoroyal' );
		$plural    = __( 'Collections', 'autoroyal' );

		register_taxonomy( "vehicle_collection",
			apply_filters( 'register_taxonomy_vehicle_collection_object_type', array( 'vehicle' ) ),
       	 	apply_filters( 'register_taxonomy_vehicle_collection_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Collection', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Collection', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Collection', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Collection:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Collection', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Collection', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Collection', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Collection Name', 'autoroyal' ),  $singular )
            	),
	            'show_ui' => true,
                'query_var' => true,
                'publicly_queryable' => true,
                'rewrite' => array(
                    'slug' => 'vehicle_collection',
                    'with_front' => false,
                ),
	        ) )
	    );


	    function autoroyal_add_default_term_colors( $term_id, $term_color ) {
		    update_term_meta( $term_id, 'color', $term_color );
		}

		function autoroyal_add_default_term_color_types( $term_id, $term_type ) {
		    update_term_meta( $term_id, 'color_type', $term_type );
		}

	    $taxonomies = array(
			'vehicle_body_style' => array(
				'SUV',
				'Coupe',
				'Sport Utility Vehicle',
				'Hatchback',
				'Covertible',
				'Truck',
				'Station Wagon',
				'Van',
				'Minivan',
				'Sports Cars',
				'Compact Cars',
				'Roadster',
				'Pickup Truck',
				'Full-size car',
				'Luxury Vehicle',
				'Mid-size car',
				'Limousine',
				'Sedan'
			),
			'vehicle_exterior_color' => array(
				'Black',
				'White',
				'Silver',
				'Gray',
				'Beige',
				'Brown',
				'Gold',
				'Yellow',
				'Orange',
				'Red',
				'Pink',
				'Purple',
				'Blue',
				'Green',
				'Combined',
				'N/A'
			),
			'vehicle_interior_color' => array(
				'Black',
				'White',
				'Silver',
				'Gray',
				'Beige',
				'Brown',
				'Combined',
				'N/A'
			),
			'vehicle_fuel_type' => array(
				'Diesel',
				'Petrol',
				'LPG',
				'Hybrid',
				'Electric'
			),
			'vehicle_interior_material' => array(
				'Full Leather',
				'Part Leather',
				'Cloth',
				'Velour',
				'Cloth',
				'Alkantara',
				'Other'
			),
			'vehicle_transmission' => array(
				'Manual',
				'Automatic'
			),
			'vehicle_drive' => array(
				'Front-wheel drive',
				'Rear Wheel Drive',
				'4WD',
				'4x4',
				'AWD'
			),
			'vehicle_safety' => array(
				'ABS',
				'ESP',
				'Traction control',
				'Isofix (child seat anchor points)',
				'Lane Assist',
				'Blind spot monitor',
				'Driver airbag',
				'Knees airbag',
				'Passenger airbag',
				'Side airbags front',
				'Side airbags back',
				'Window curtain airbags',
				'Immobilizer',
				'Alarm/anti-theft system',
				'Night vision system',
				'Down hill assist',
				'Up hill assist',
				'Precolission system',
				'Central locking'
			),
			'vehicle_comfort' => array(
				'Air conditioning' => array(
					'Air conditioning',
					'A/C (man)',
					'Automatic air condition',
					'2 zone climate',
					'3 zone climate',
					'4 zone climate'
				),
				'Cruise control' => array(
					'Cruise control',
					'Standard cruise control',
					'Adaptive cruise control',
				),
				'Automatic parking',
				'Keyless entry',
				'Keyless engine start-stop',
				'Adaptive cruise-control',
				'Active steering wheel',
				'Tire pressure monitoring system',
				'Remote engine start',
				'Front heated seats',
				'Back heated seats',
				'Front ventilated seats',
				'Back ventilated seats',
				'On-board computer',
				'Privacy glass',
				'Power assisted steering' => array(
					'Power assisted steering',
					'Standard power assisted steering',
					'Hydraulic power assisted steering',
					'Electric power assiste steering'
				),
				'Electric steering wheel adjustment',
				'Seats position memory',
				'Electric windows',
				'Suspension' => array(
					'Suspension',
					'Standard suspension',
					'Sport suspension',
					'Air suspension',
					'Hydraulic suspension'
				),
				'Head-up display'
			),
			'vehicle_exterior' => array(
				'Rims Size' => array(
					'Rims Size',
					'12" whell size',
					'13" whell size',
					'14" whell size',
					'15" whell size',
					'16" whell size',
					'17" whell size',
					'17.5" whell size',
					'18" whell size',
					'19" whell size',
					'19.5" whell size',
					'20" whell size',
					'21" whell size',
					'22" whell size',
					'22.5" whell size',
					'23" whell size',
					'24" whell size',
					'25" whell size',
					'26" whell size',
					'28" whell size'
				),
				'Rims material' => array(
					'Rims material',
					'Alloy discs',
					'Steel discs',
					'Aluminium discs',
					'Plastic discs',
					'Stainless steel discs',
					'Metal discs',
					'PVC discs'
				),
				'Tyres' => array(
					'Tyres',
					'Winter tyres',
					'Summer tyres',
					'All seasons tyres'
				),
				'Aerography',
				'Decals / Vinyls',
				'Roof racks',
				'Trailer coupling',
				'Sports package'
			),
			'vehicle_interior' => array(
				'Auxiliary heating',
				'Tilt/telescope steering wheel adjustement' => array(
					'Tilt/telescope steering adjustment',
					'Tilt steering wheel adjustment',
					'Telescope steering wheel adjustment',
					'Tilt/Telescope steering wheel adjustment',
				),
				'Electric seat adjustment',
				'Roof' => array(
					'Roof',
					'Sun roof',
					'Panoramic roof'
				)
			),
			'vehicle_multimedia' => array(
				'AUX',
				'Bluetooth music streaming',
				'USB',
				'12V',
				'TV tuner',
				'CD changer',
				'DVD changer',
				'Navigation',
				'Hand-free kit',
				'MP3 support',
				'Multifunction steering wheel',
				'Wireless charging',
				'Apple car play',
				'Android auto'
			),
			'vehicle_visibility' => array(
				'Lights' => array(
					'Lights',
					'Halogen Lights',
					'Halogen/Xenon Lights',
					'Bi-xenon Lights',
					'Led/Xenon Lights',
					'Led Lights',
					'Laser Lights'
				),
				'Fog lamps',
				'Light sensor',
				'Rain sensor',
				'Adaptive lightning',
				'Auto high beam',
				'Rear-view camera',
				'360 degree camera',
				'Electric mirrors',
				'Heated mirrors',
				'Heated windscreen',
				'Front parking sensors',
				'Back parking sensors'
			),
			'vehicle_collection' => array(
				'Luxury',
				'Electric',
				'Budget'
			),
		);

		//$autoroyal_installed_terms = get_option( 'autoroyal_installed_terms' );
		$autoroyal_installed_terms = "1";

		if( !isset($autoroyal_installed_terms) OR empty($autoroyal_installed_terms) ) {

			foreach ( $taxonomies as $taxonomy => $terms ) {

				foreach ( $terms as $term ) {

					if( is_array( $term ) ) {

						if ( ! get_term_by( 'slug', sanitize_title( $term[0] ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term[0], $taxonomy );

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;

							    foreach ( $term as $sub_term ) {

									if ( ! get_term_by( 'slug', sanitize_title( $sub_term ), $taxonomy ) ) {

										if( $term[0] != $sub_term ) {

											$submit_term = wp_insert_term( $sub_term, $taxonomy, array( 'parent' => $term_id) );

										}

									}

								}
							}

						};

					} else {
						
						if ( ! get_term_by( 'slug', sanitize_title( $term ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term, $taxonomy );

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;
							}

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

							if( $taxonomy == "vehicle_exterior_color" OR $taxonomy == "vehicle_interior_color" ) {

								$term_color = "#ffffff";

								if($term == "White") {
									$term_color = "#ffffff";
									$term_type = "default";
								} elseif($term == "Black") {
									$term_color = "#000000";
									$term_type = "default";
								} elseif($term == "Silver") {
									$term_color = "#cccccc";
									$term_type = "default";
								} elseif($term == "Gray") {
									$term_color = "#949494";
									$term_type = "default";
								} elseif($term == "Beige") {
									$term_color = "#ebdec9";
									$term_type = "default";
								} elseif($term == "Brown") {
									$term_color = "#ab6f49";
									$term_type = "default";
								} elseif($term == "Gold") {
									$term_color = "#ebc458";
									$term_type = "default";
								} elseif($term == "Yellow") {
									$term_color = "#ffea0b";
									$term_type = "default";
								} elseif($term == "Orange") {
									$term_color = "#ff9e13";
									$term_type = "default";
								} elseif($term == "Red") {
									$term_color = "#e33535";
									$term_type = "default";
								} elseif($term == "Pink") {
									$term_color = "#ff4493";
									$term_type = "default";
								} elseif($term == "Purple") {
									$term_color = "#b26ee5";
									$term_type = "default";
								} elseif($term == "Blue") {
									$term_color = "#00a2ff";
									$term_type = "default";
								} elseif($term == "Green") {
									$term_color = "#5cb74d";
									$term_type = "default";
								} elseif($term == "Combined") {
									$term_color = "#666666";
									$term_type = "combined";
								} elseif($term == "N/A") {
									$term_color = "#666666";
									$term_type = "na";
								}
								
								autoroyal_add_default_term_colors( $term_id, $term_color );
								autoroyal_add_default_term_color_types( $term_id, $term_type );
							}
						}

					}

				}

			}

			if( !is_wp_error($submit_term) && isset($submit_term['term_id']) ) {
	            update_option( 'autoroyal_installed_terms', 1 );
	        }

		} 

	    /**
		 * Post types
		 */
		$singular  = __( 'Car', 'autoroyal' );
		$plural    = __( 'Cars', 'autoroyal' );

		if ( current_theme_supports( 'vehicle-manager-templates' ) ) {
			$has_archive = _x( 'Cars', 'Post type archive slug - resave permalinks after changing this', 'autoroyal' );
		} else {
			$has_archive = false;
		}

		$rewrite     = array(
			'slug'       => _x( 'vehicle', 'vehicle permalink - resave permalinks after changing this', 'autoroyal' ),
			'with_front' => false,
			'feeds'      => true,
			'pages'      => false
		);

		register_post_type( "vehicle",
			apply_filters( "register_post_type_car", array(
				'labels' => array(
					'name'			=> $plural,
					'singular_name' 	=> $singular,
					'menu_name'             => __( 'Cars', 'autoroyal' ),
					'all_items'             => sprintf( __( 'Inventory', 'autoroyal' ), $plural ),
					'add_new' 		=> __( 'Add New Car', 'autoroyal' ),
					'add_new_item' 		=> sprintf( __( 'Add %s', 'autoroyal' ), $singular ),
					'edit' 			=> __( 'Edit', 'autoroyal' ),
					'edit_item' 		=> sprintf( __( 'Edit %s', 'autoroyal' ), $singular ),
					'new_item' 		=> sprintf( __( 'New %s', 'autoroyal' ), $singular ),
					'view' 			=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'view_item' 		=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'search_items' 		=> sprintf( __( 'Search %s', 'autoroyal' ), $plural ),
					'not_found' 		=> sprintf( __( 'No %s found', 'autoroyal' ), $plural ),
					'not_found_in_trash' 	=> sprintf( __( 'No %s found in trash', 'autoroyal' ), $plural ),
					'parent' 		=> sprintf( __( 'Parent %s', 'autoroyal' ), $singular ),
				),
				'description' => sprintf( __( 'This is where you can create and manage %s.', 'autoroyal' ), $plural ),
				'public' 				=> true,
				'show_ui' 				=> true,
				'capability_type' 		=> 'vehicle',
				'map_meta_cap'          => true,
				'publicly_queryable' 	=> true,
				'exclude_from_search' 	=> false,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> array( 'title', 'editor', 'custom-fields', 'publicize', 'thumbnail', 'author' ),
				'has_archive' 			=> $has_archive,
				'show_in_nav_menus' 	=> false
			) )
		);

		/**
		 * Feeds
		 */
		add_feed( 'car_feed', array( $this, 'car_feed' ) );
	}

	/**
	 * Toggle filter on and off
	 */
	private function car_content_filter( $enable ) {
		if ( ! $enable ) {
			remove_filter( 'the_content', array( $this, 'car_content' ) );
		} else {
			add_filter( 'the_content', array( $this, 'car_content' ) );
		}
	}

	/**
	 * Add extra content before/after the post for single car listings.
	 */
	public function car_content( $content ) {
		global $post;

		if ( ! is_singular( 'vehicle' ) || ! in_the_loop() || 'vehicle' !== $post->post_type ) {
			return $content;
		}

		ob_start();

		$this->car_content_filter( false );

		do_action( 'car_content_start' );

		get_autoroyal_template_part( 'content-single', 'vehicle' );

		do_action( 'car_content_end' );

		$this->car_content_filter( true );

		return apply_filters( 'autoroyal_single_car_content', ob_get_clean(), $post );
	}

	/**
	 * car listing feeds
	 */
	public function car_feed() {
		$query_args = array(
			'post_type'           => 'vehicle',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'posts_per_page'      => isset( $_GET['posts_per_page'] ) ? absint( $_GET['posts_per_page'] ) : 10,
			'tax_query'           => array(),
			'meta_query'          => array()
		);

		if ( ! empty( $_GET['car_categories'] ) ) {
			$cats     = explode( ',', sanitize_text_field( $_GET['car_categories'] ) ) + array( 0 );
			$field    = is_numeric( $cats ) ? 'term_id' : 'slug';
			$operator = 'all' === get_option( 'autoroyal_category_filter_type', 'all' ) && sizeof( $args['search_categories'] ) > 1 ? 'AND' : 'IN';
			$query_args['tax_query'][] = array(
				'taxonomy'         => 'vehicle_model',
				'field'            => $field,
				'terms'            => $cats,
				'include_children' => $operator !== 'AND' ,
				'operator'         => $operator
			);
		}

		if ( $autoroyal_keyword = sanitize_text_field( $_GET['search_keywords'] ) ) {
			$query_args['_keyword'] = $autoroyal_keyword; // Does nothing but needed for unique hash
			add_filter( 'posts_clauses', 'get_cars_keyword_search' );
		}

		if ( empty( $query_args['meta_query'] ) ) {
			unset( $query_args['meta_query'] );
		}

		if ( empty( $query_args['tax_query'] ) ) {
			unset( $query_args['tax_query'] );
		}

		query_posts( apply_filters( 'car_feed_args', $query_args ) );
		add_action( 'rss2_ns', array( $this, 'car_feed_namespace' ) );
		add_action( 'rss2_item', array( $this, 'car_feed_item' ) );
		do_feed_rss2( false );
	}

	/**
	 * Add a custom namespace to the car feed
	 */
	public function car_feed_namespace() {
		echo 'xmlns:vehicle="' .  site_url() . '"' . "\n";
	}

	/**
	 * Add custom data to the car feed
	 */
	public function car_feed_item() {
		$post_id  = get_the_ID();
		
		/**
		 * Fires at the end of each car RSS feed item.
		 *
		 * @param int $post_id The post ID of the car.
		 */
		 do_action( 'car_feed_item', $post_id );
	}

	/**
	 * Fix post name when wp_update_post changes it
	 * @param  array $data
	 * @return array
	 */
	public function fix_car_post_name( $data, $postarr ) {

		global $post, $id;

	  	if( 'vehicle' == $data['post_type'] && isset($data['post_type']) ) {

	  		$id = $postarr['ID'];

			if($id) {

				$postID = $id;

				if( isset($_POST['add-car-manually'] ) ) {

					if( isset($_POST['cq-year-manually'])) {
						$vehicle_year = esc_attr( $_POST['cq-year-manually'] );
					} else {
						$vehicle_year = "";
					}

					if( isset($_POST['cq-make-manually'])) {
						$vehicle_make_slug = esc_attr( $_POST['cq-make-manually'] );
					} else {
						$vehicle_make_slug = "";
					}

					if( isset($_POST['cq-make-manually'])) {
						$vehicle_make_desc_init = esc_attr( $_POST['cq-make-manually'] );
					} else {
						$vehicle_make_desc_init = "";
					}

					if( isset($_POST['cq-model-manually'])) {
						$vehicle_model = esc_attr( $_POST['cq-model-manually'] );
					} else {
						$vehicle_model = "";
					}

					if( isset($_POST['cq-trim-manually'])) {
						$vehicle_trim_desc_init = esc_attr( $_POST['cq-trim-manually'] );
					} else {
						$vehicle_trim_desc_init = "";
					}

				} else {

					if( isset($_POST['cq-year'])) {
						$vehicle_year = esc_attr( $_POST['cq-year'] );
					} else {
						$vehicle_year = "";
					}

					if( isset($_POST['cq-make'])) {
						$vehicle_make_slug = esc_attr( $_POST['cq-make'] );
					} else {
						$vehicle_make_slug = "";
					}

					if( isset($_POST['vehicle_make_desc_init'])) {
						$vehicle_make_desc_init = esc_attr( $_POST['vehicle_make_desc_init'] );
					} else {
						$vehicle_make_desc_init = "";
					}

					if( isset($_POST['cq-model'])) {
						$vehicle_model = esc_attr( $_POST['cq-model'] );
					} else {
						$vehicle_model = "";
					}

					if( isset($_POST['vehicle_trim_desc_init'])) {
						$vehicle_trim_desc_init = esc_attr( $_POST['vehicle_trim_desc_init'] );
					} else {
						$vehicle_trim_desc_init = "";
					}

				}

				if( !empty($vehicle_year) AND !empty($vehicle_make_slug) AND !empty($vehicle_model) AND !empty($vehicle_trim_desc_init) ) {

					$postNewTitle = $vehicle_year . " " . $vehicle_make_slug . " " . $vehicle_model . " " . $vehicle_trim_desc_init . " #" . $postID;
					$data['post_name'] = sanitize_title( $postNewTitle );

				}

				if( !empty($vehicle_year) AND !empty($vehicle_make_desc_init) AND !empty($vehicle_model) AND !empty($vehicle_trim_desc_init) ) {

					$postNewName = $vehicle_year . " " . $vehicle_make_desc_init . " " . $vehicle_model . " " . $vehicle_trim_desc_init;
					$data['post_title'] = $postNewName;

				}

				if( isset($_POST['price_set'])) {
					$price_set = $_POST['price_set'];
					update_post_meta($postID, 'vehicle_for_rent', 1);
				} else {
					$price_set = "";
					delete_post_meta($postID, 'vehicle_for_rent', 1);
				}
				update_post_meta($postID, 'vehicle_rent_price_set', $price_set);

			}

		}

	  	return $data; // Returns the modified data.

	}


	/**
	 * Maybe set default meta data for car listings
	 * @param  int $post_id
	 * @param  WP_Post $post
	 */
	public function maybe_add_default_meta_data( $post_id, $post = '' ) {

		if ( empty( $post ) || 'vehicle' === $post->post_type ) {

			add_post_meta( $post_id, '_promoted', 0, true );
			add_post_meta( $post_id, '_featured', 0, true );
			add_post_meta( $post_id, '_paid_featured', 0, true );
			add_post_meta( $post_id, '_sold', 0, true );
			add_post_meta( $post_id, '_sold_date', "", true );
			add_post_meta( $post_id, '_submit_fee', 0, true );

			$cat_ids = array();

			$vehicle_year = esc_attr(get_post_meta($post_id, 'vehicle_year',true));
			$vehicle_make = esc_attr(get_post_meta($post_id, 'vehicle_make',true));
			$vehicle_model = esc_attr(get_post_meta($post_id, 'vehicle_model',true));
			$vehicle_trim_desc_init = esc_attr(get_post_meta($post_id, 'vehicle_trim_desc_init',true));
			$vehicle_make_desc_init = esc_attr(get_post_meta($post_id, 'vehicle_make_desc_init',true));

			if(!empty($vehicle_year)) {
				$v_year = $this->insert_term( $vehicle_year, 'vehicle_model' );
			}
			
			if( !empty($vehicle_year) AND !empty($vehicle_make) ) {
				$v_make = $this->insert_term( $vehicle_make_desc_init , 'vehicle_model', array('parent'=>$v_year['term_id']) );
			}

			if( !empty($vehicle_year) AND !empty($vehicle_make) AND !empty($vehicle_model) ) {
				$v_model = $this->insert_term( $vehicle_model, 'vehicle_model', array('parent'=>$v_make['term_id']) );
			}

			if( !empty($vehicle_year) AND !empty($vehicle_make) AND !empty($vehicle_model) AND !empty($vehicle_trim_desc_init) ) {

				$v_trim = $this->insert_term( $vehicle_trim_desc_init, 'vehicle_model', array('parent'=>$v_model['term_id']) );

				$cat_ids = array( $v_year['term_id'], $v_make['term_id'], $v_model['term_id'], $v_trim['term_id'] );
				$cat_ids = array_map( 'intval', $cat_ids );
				$cat_ids = array_unique( $cat_ids );

				$vehicle_model_set = wp_set_object_terms( $post_id, $cat_ids, 'vehicle_model' );
				
			}

		}

		$fist_image_id = get_post_meta($post_id, 'vehicle_image_gallery',true);

		//delete_post_thumbnail( $post_id );
		//set_post_thumbnail( $post_id, $fist_image_id[0][id] ); 

	}

	public function insert_term ($term, $taxonomy, $args = array()) {

        if (isset($args['parent'])) {
            $parent = $args['parent'];
        } else {
            $parent = 0;
        }
        $result = term_exists($term, $taxonomy, $parent);
        if ($result == false || $result == 0) {
            return wp_insert_term($term, $taxonomy, $args);             
        } else {
            return (array) $result;
        }       

	}

}
