<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Shortcode_Account_Funds class.
 */
class autoroyal_Shortcode_Account_Funds {

	/**
	 * Inventory message
	 *
	 * @access private
	 * @var string
	 */
	private $car_inventory_message = '';

	/**
	 * Constructor
	 */
	public function __construct() {
		//add_action( 'wp', array( $this, 'shortcode_dashboard_action_handler' ) );
		add_shortcode( 'autoroyal_account_funds', array( $this, 'autoroyal_account_funds' ) );
	}

	/**
	 * Handle actions which need to be run before the shortcode e.g. post actions
	 */
	public function shortcode_dashboard_action_handler() {
		global $post;

		if ( is_page() && strstr( $post->post_content, '[autoroyal_account_funds' ) ) {
			$this->car_dashboard_handler();
		}
	}

	/**
	 * Handles actions on autoroyal dashboard
	 */
	public function car_dashboard_handler() {

		if ( isset( $_POST['autoroyal_WC_Account_Funds_topup'] ) && isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'account-funds-topup' ) ) {
			$min          = max( 0, get_option( 'autoroyal_account_funds_min_topup' ) );
			$max          = get_option( 'autoroyal_account_funds_max_topup' );
			$topup_amount = wc_clean( $_POST['topup_amount'] );

			if ( $topup_amount < $min ) {
				wc_add_notice( sprintf( __( 'The minimum amount that can be topped up is %s', 'autoroyal' ), wc_price( $min ) ), 'error' );
				return;
			} elseif ( $max && $topup_amount > $max ) {
				wc_add_notice( sprintf( __( 'The maximum amount that can be topped up is %s', 'autoroyal' ), wc_price( $max ) ), 'error' );
				return;
			}

			WC()->cart->add_to_cart( wc_get_page_id( 'myaccount' ), true, '', '', array( 'top_up_amount' => $topup_amount ) );
			
			wp_redirect( get_permalink( wc_get_page_id( 'cart' ) ) );
		}

	}

	/**
	 * Shortcode which lists the logged in user's cars
	 */
	public function autoroyal_account_funds( $atts ) {
		
		if ( ! is_user_logged_in() ) {
			ob_start();
			get_autoroyal_template( 'autoroyal-login.php' );
			return ob_get_clean();
		}

		wp_enqueue_script( 'charts' );

		ob_start();

		get_autoroyal_template( 'autoroyal-account-funds.php', array(  ) );

		return ob_get_clean();
	}

}

new autoroyal_Shortcode_Account_Funds();
