<?php
/* Create Custom Post Type : Megamenu */
if( !function_exists( 'create_megamenu_post_type' ) ){
    function create_megamenu_post_type(){
        $labels = array(
            'name' => esc_html__( 'Megamenu','autoroyal'),
            'singular_name' => esc_html__( 'Megamenu','autoroyal' ),
            'add_new' => esc_html__('Add New','autoroyal'),
            'add_new_item' => esc_html__('Add New Megamenu','autoroyal'),
            'edit_item' => esc_html__('Edit Megamenu','autoroyal'),
            'new_item' => esc_html__('New Megamenu','autoroyal'),
            'view_item' => esc_html__('View Megamenu','autoroyal'),
            'search_items' => esc_html__('Search Megamenu','autoroyal'),
            'not_found' =>  esc_html__('No Megamenu found','autoroyal'),
            'not_found_in_trash' => esc_html__('No Megamenu found in Trash','autoroyal'),
            'parent_item_colon' => ''
        );

        $args = array(
            'labels' => $labels,
            'public' => true,
            'exclude_from_search' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'query_var' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'menu_icon' => 'dashicons-menu',
            'menu_position' => 5,
            'supports' => array('title','editor','thumbnail','revisions'),
            'rewrite' => array( 'slug' => esc_html__('megamenu', 'autoroyal') )
        );

        register_post_type('megamenu',$args);
    }
}
add_action( 'init', 'create_megamenu_post_type' );

?>