<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function rent_slider_item_func( $atts, $content ) {

    extract( shortcode_atts( array(
        'post_id' => '',
        'bg_color' => '#b1f2eb',
    ), $atts ) );

    ob_start();

    if(!empty($post_id)) {

        $current_vehicle_year = esc_attr(get_post_meta($post_id, 'vehicle_year',true));
        $current_vehicle_make = esc_attr(get_post_meta($post_id, 'vehicle_make',true));
        $current_vehicle_model = esc_attr(get_post_meta($post_id, 'vehicle_model',true));
        $current_vehicle_make_desc_init = esc_attr(get_post_meta($post_id, 'vehicle_make_desc_init',true));

        $current_vehicle_name = "";
        if(!empty($current_vehicle_make_desc_init)) {
            $current_vehicle_name .= $current_vehicle_make_desc_init . " ";
        }
        if(!empty($current_vehicle_model)) {
            $current_vehicle_name .= $current_vehicle_model . " ";
        }

        //
        $current_vehicle_body_style = esc_attr(get_post_meta($post_id, 'vehicle_body_style',true));
        $current_vehicle_doors = esc_attr(get_post_meta($post_id, 'vehicle_doors',true));
        $current_vehicle_seats = esc_attr(get_post_meta($post_id, 'vehicle_seats',true));

        $current_vehicle_transmission = get_the_terms($post_id, 'vehicle_transmission' );
        if ($current_vehicle_transmission && ! is_wp_error($current_vehicle_transmission)) :
            $term_slugs_arr_cat = array();
                foreach ($current_vehicle_transmission as $term_cat) {
                    $term_vehicle_transmission = $term_cat->name;
                }
            $current_terms_vehicle_transmission = join( " ", $term_vehicle_transmission);
        endif;

        $minimum_age = get_post_meta($post_id, 'minimum_age',true);

        $current_vehicle_desc = "";
        if(!empty($current_vehicle_body_style)) {
            $current_vehicle_desc .= $current_vehicle_body_style . ", ";
        }
        if(!empty($current_vehicle_doors)) {
            $current_vehicle_desc .= $current_vehicle_doors .  " " . esc_html__('doors', 'autoroyal' ) . ", ";
        }
        if(!empty($current_vehicle_seats)) {
            $current_vehicle_desc .= $current_vehicle_seats . " " . esc_html__('seats', 'autoroyal' ) . ". ";
        }
        if(!empty($current_terms_vehicle_transmission)) { 
            $current_vehicle_desc .= esc_html__('Transmission:', 'autoroyal' ) . " " . esc_attr($current_terms_vehicle_transmission); 
            $current_vehicle_desc .= ". ";
        }
        if(!empty($minimum_age)) {
            $current_vehicle_desc .= esc_html__('Minimum age requirement:', 'autoroyal' ) . " " . $minimum_age .  " " . esc_html__('years', 'autoroyal' ) . ". ";
        }

        $vehicle_cover_image = get_post_meta($post_id, 'vehicle_cover_image',true);

        $vehicle_rent_price_min = get_post_meta($post_id, 'vehicle_rent_price_min',true);

    ?>

        <!-- slide -->
        <div class="item" style="background-color: <?php echo esc_attr($bg_color); ?>" id="car-rent-id-<?php echo esc_attr($post_id); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-md-7 col-lg-6">
                        <div class="car-desc animated fadeInLeft">

                            <h1 class="text-uppercase">
                                <?php echo esc_attr($current_vehicle_name); ?> <span><?php echo esc_attr($current_vehicle_year); ?></span>
                            </h1>

                            <span class="spects">
                                <?php echo esc_attr($current_vehicle_desc); ?>
                            </span>

                        </div>

                        <?php if(!empty($vehicle_cover_image)) { ?>
                        <img src="<?php echo esc_url($vehicle_cover_image); ?>" alt="mercedes-benz" class="img-responsive animated fadeInLeft">
                        <?php } ?>

                        <div id="car-price-sets-<?php echo esc_attr($post_id); ?>">

                            <?php

                                $vehicle_rent_price_set = get_post_meta($post_id, 'vehicle_rent_price_set',true);
                
                                $i = 0;

                                if(!empty($vehicle_rent_price_set)) {

                                    foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                        
                                        if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                            $i++;

                                            ?>

                                            <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
                                            <input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">

                                            <?php

                                        }

                                    }

                                }

                            ?>

                            <input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>">

                        </div>

                        <ul id="rent-price-table-<?php echo esc_attr($post_id); ?>" class="hidden">

                            <?php
                
                                $i = 0;

                                if(!empty($vehicle_rent_price_set)) {

                                    foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                        
                                        if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                            $i++;

                                            ?>

                                            <li class="clearfix">
                                                <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
                                                <span class="pull-right">
                                                    <b id="startR"><?php echo autoroyal_clean_price($vehicle_rent_price_set_item['price']); ?></b>
                                                </span>
                                            </li>

                                            <?php

                                        }

                                    }

                                }

                            ?>

                        </ul>

                    </div>
                  
                    <div class="col-md-5 col-lg-offset-2 col-lg-4">
                        <div class="rent-blk-rows bg-white shadow animated fadeInRight">
                            <div class="blk-intro">
                                <h4 class="pull-left"><?php esc_html_e('Rent this car', 'autoroyal'); ?></h4>
                                <span class="pull-right rent-price">
                                    <?php $currency = autoroyal_get_currency(); $currency_symbol = autoroyal_get_currency_symbol( $currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } ?><span><?php echo esc_attr($vehicle_rent_price_min); ?></span><?php esc_html_e('+', 'autoroyal'); ?><small>/<?php esc_html_e('day', 'autoroyal'); ?></small>
                                </span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="row blk-content">
                                <div class="col-sm-12 col-lg-12 form-group">
                                    <label><?php esc_html_e('Pick-up place', 'autoroyal'); ?> </label>
                                    <select class="cd-select select-region" style="width: 100%;">
                                        <?php

                                            $vehicle_rent_pickup = wp_get_post_terms( $post_id, 'vehicle_rent_pickup', array( 'orderby' => 'name', 'order' => 'ASC') ); 

                                            if( $vehicle_rent_pickup && ! is_wp_error($vehicle_rent_pickup) ) { 

                                                foreach ($vehicle_rent_pickup as $vehicle_rent_pickup_item) {

                                                    $nume_cat = $vehicle_rent_pickup_item->name;

                                        ?>
                                        <option value="<?php echo esc_attr($nume_cat); ?>"><?php echo esc_attr($nume_cat); ?></option>
                                        <?php } } ?>
                                    </select>
                                    <div class="customLoc">
                                        <select class="cd-select select-region" style="width: 100%;">
                                            <?php

                                            if( $vehicle_rent_pickup && ! is_wp_error($vehicle_rent_pickup) ) { 

                                                foreach ($vehicle_rent_pickup as $vehicle_rent_pickup_item) {

                                                    $nume_cat = $vehicle_rent_pickup_item->name;

                                        ?>
                                        <option value="<?php echo esc_attr($nume_cat); ?>"><?php echo esc_attr($nume_cat); ?></option>
                                        <?php } } ?>>
                                        </select>
                                    </div>
                                    <button type="button" class="btn btn-link addLoc"><?php esc_html_e('Specify a different Return location', 'autoroyal'); ?></button>
                                </div>
                                <div class="col-sm-6 col-lg-6 form-group input-append pickup-date-select">
                                    <label><?php esc_html_e('Pick-up date and time', 'autoroyal'); ?></label>
                                    <input type="text" placeholder="<?php esc_attr_e('Choose a date', 'autoroyal'); ?>" class="daySelect">
                                    <span class="icon"><i class="fa fa-angle-down"></i></span>
                                </div>
                                <div class="col-sm-6 col-lg-6 form-group input-append pickup-time-select timepick">
                                    <input type="text" placeholder="12:00 AM" class="timeSelect">
                                    <span class="icon"><i class="fa fa-angle-down"></i></span>
                                </div>
                                <div class="col-sm-6 col-lg-6 form-group input-append dropoff-date-select">
                                    <label><?php esc_html_e('Return date and time', 'autoroyal'); ?></label>
                                    <input type="text" placeholder="<?php esc_attr_e('Choose a date', 'autoroyal'); ?>" class="daySelect">
                                    <span class="icon"><i class="fa fa-angle-down"></i></span>
                                </div>
                                <div class="col-sm-6 col-lg-6 form-group input-append dropoff-time-select timepick">
                                    <input type="text" placeholder="12:00 AM" class="timeSelect">
                                    <span class="icon"><i class="fa fa-angle-down"></i></span>
                                </div>
                                <div class="col-sm-12 col-lg-12">
                                    <a href="#" class="btn btn-default" data-toggle="modal" data-target="#reservation-modal" data-car-id="<?php echo esc_attr($post_id); ?>"><?php esc_html_e('Continue to car reservation', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /. slide -->

    <?php

    }

    return ob_get_clean();

}
add_shortcode( 'rent_slider_item', 'rent_slider_item_func' );

//
$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
    'post_type'           => 'vehicle',
    'post_status'         => 'publish',
    'posts_per_page'      => -1,
    'meta_key'            => 'vehicle_rent_price_min',
));

$search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
$cars_query  = new WP_Query;
$cars        = $cars_query->query( $search_args );

$cars_array = array();

if ( $cars ) :

    foreach ( $cars as $car ) :

        $car_ID = $car->ID; 

        $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
        $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
        $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));

        $vehicle_name = $vehicle_make_desc_init . " " . $vehicle_model . " " . $vehicle_year;

        $cars_array[$vehicle_name] = $car_ID; 

    endforeach;

endif;

vc_map( array(
    'name' => esc_html__( 'Rent slider item', 'autoroyal' ),
    'base' => 'rent_slider_item',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoroyal rent slider item', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "content_element" => true,
    "as_child" => array('only' => 'rent_slider_container'), 
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Select Car', 'autoroyal' ),
            'param_name' => 'post_id',
            'admin_label' => true,
            'value' => $cars_array,
            'std' => '',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Background Color', 'autoroyal' ),
            'param_name' => 'bg_color',
            'description' => esc_html__( 'Select color for slide background.', 'autoroyal' ),
            'std' => '#b1f2eb',
        ),
    ),
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_rent_slider_item extends WPBakeryShortCode {
    }
}

