<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

?>

<div id="autoroyal-dashboard">
	
	<div class="table-toolbar">

		<?php

			$acc_funds = get_option( 'autoroyal_enable_account_funds' );

			if( $acc_funds == 1 ) {

				/**
				 * Get HTML string for topup form in my account.
				 *
				 * @since 2.0.12
				 *
				 * @return string HTML string
				 */
				function get_my_account_topup() {
					ob_start();
					my_account_topup();
					return ob_get_clean();
				}

				/**
				 * Show top up form
				 */
				function my_account_topup() {
					$min_topup     = get_option( 'autoroyal_account_funds_min_topup' );
					$max_topup     = get_option( 'autoroyal_account_funds_max_topup' );
					$items_in_cart = _get_topup_items_in_cart();
					$topup_in_cart = array_shift( $items_in_cart );
					if ( ! empty( $max_topup ) && ! empty( $topup_in_cart ) ) {
						printf(
							'<p class="woocommerce-info"><a href="%s" class="button wc-forward">%s</a> %s</p>',
							wc_get_page_permalink( 'cart' ),
							__( 'View Cart', 'autoroyal' ),
							sprintf( __( 'You have "%s" in your cart.', 'autoroyal' ), $topup_in_cart['data']->get_title() )
						);
						return;
					}

					$vars = array(
						'min_topup' => $min_topup,
						'max_topup' => $max_topup,
					);

					wc_get_template( 'myaccount/topup-form.php', $vars, '', autoroyal_PLUGIN_DIR . '/templates/' );
				}

				/**
				 * Get topup items in cart.
				 */
				function _get_topup_items_in_cart() {
					$item = "";
					$topup_items = array();
					if ( ! WC()->cart->is_empty() ) {
						$topup_items = array_filter( WC()->cart->get_cart(), 'filter_topup_items' );
					}

					return $topup_items;
				}

				/**
				 * Cart items filter callback to filter topup product.
				 *
				 * @return bool Returns true if item is topup product
				 */
				function filter_topup_items( $item ) {
					if ( isset( $item['data'] ) && is_callable( array( $item['data'], 'get_type' ) ) ) {
						return ( 'topup' === $item['data']->get_type() );
					}

					return false;
				}

				/**
				 * Endpoint HTML content.
				 */
				function endpoint_content() {
					$topup    = '';
					$products = '';

					$topup = get_my_account_topup();
					$recent_deposits = get_my_account_orders();
					$payouts = get_my_account_payouts();

					$vars = array(
						'funds'           => autoroyal_WC_Account_Funds::get_account_funds(),
						'topup'           => $topup,
						'products'        => $products,
						'payouts'         => $payouts,
						'recent_deposits' => $recent_deposits,
					);

					wc_get_template( 'myaccount/account-funds.php', $vars, '', autoroyal_PLUGIN_DIR . '/templates/' );
				}

				/**
				 * Show deposits
				 */
				function my_account_orders() {
					$deposits = get_posts( array(
						'numberposts' => 10,
						'meta_key'    => '_customer_user',
						'meta_value'  => get_current_user_id(),
						'post_type'   => 'shop_order',
						'post_status' => array( 'wc-completed', 'wc-processing', 'wc-on-hold' ),
						'meta_query'  => array(
							array(
								'key'   => '_funds_deposited',
								'value' => '1',
							)
						)
					) );

					if ( $deposits ) {
						$vars = array(
							'deposits' => $deposits,
						);
						wc_get_template( 'myaccount/recent-deposits.php', $vars, '', autoroyal_PLUGIN_DIR . '/templates/' );
					}
				}

				/**
				 * Get HTML string of recent deposits.
				 *
				 * @return string HTML string
				 */
				function get_my_account_orders() {
					ob_start();
					my_account_orders();
					return ob_get_clean();
				}

				/**
				 * Show deposits
				 */
				function my_account_payouts() {

					$user_id = get_current_user_id();
					$payouts = get_user_meta( $user_id, 'account_payouts', true );

					if ( $payouts ) {
						$payouts = array_reverse($payouts);
						$vars = array(
							'payouts' => $payouts,
						);
						wc_get_template( 'myaccount/recent-payouts.php', $vars, '', autoroyal_PLUGIN_DIR . '/templates/' );
					}
				}

				/**
				 * Get HTML string of recent payouts.
				 *
				 * @return string HTML string
				 */
				function get_my_account_payouts() {
					ob_start();
					my_account_payouts();
					return ob_get_clean();
				}

		?>

		<div class="options_group">

			<div class="row">

				<div class="col-md-12">

					<?php endpoint_content(); ?>

				</div>

			</div>

		</div>

		<?php } ?>
		
	</div>

</div>
