<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$user_id = get_current_user_id();
	$posts_per_page = "10";
			        
	$search_args = array(
		'post_type'           => 'filter',
		'post_status'         => 'publish',
		'posts_per_page'      => $posts_per_page,
		'offset'              => ( max( 1, get_query_var('paged') ) - 1 ) * $posts_per_page,
		'orderby'             => 'date',
		'order'               => 'desc'
	);

	$filters_query = new WP_Query;
	$filters = $filters_query->query( $search_args );

	$max_num_pages = $filters_query->max_num_pages;

?>

<div id="autoroyal-inventory">

	<div class="table-toolbar">

		<div class="row">

			<div class="col-sm-12">

				<div class="dataTables_length autoroyal-filter-subscribers" id="posts_per_page">

					<?php

						$paged    = max( 1, get_query_var('paged') );
						$per_page = $posts_per_page;
						$total    = $filters_query->found_posts;
						$first    = ( $per_page * $paged ) - $per_page + 1;
						$last     = min( $total, $posts_per_page * $paged );

						if ( $total <= $per_page || -1 == $per_page ) {
							/* translators: %d: total results */
							printf( _n( 'Showing the single filter subscribers', 'Showing all %d filter subscribers', $total, 'autoroyal' ), $total );
						} else {
							/* translators: 1: first result 2: last result 3: total results */
							printf( _nx( 'Showing the single filter subscribers', 'Showing %1$d to %2$d of %3$d', $total, 'with first and last filter subscribers', 'autoroyal' ), $first, $last, $total );
						}

					?>

				</div>

			</div>

		</div>

	</div>

	<table id="autoroyal_filters_table" class="car-manager-cars">
		<thead>
			<tr>
				<th class="d-none d-lg-table-cell autoroyal-date"><?php esc_html_e( 'Date', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Name', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Email', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Phone', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Make', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Model', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell autoroyal-fuel"><?php esc_html_e( 'Fuel Type', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Price', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Year', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell autoroyal-mileage"><?php esc_html_e( 'Mileage', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell"><?php esc_html_e( 'Condition', 'autoroyal' ); ?></th>
				<th class="d-md-table-cell d-lg-none"><?php esc_html_e( 'Filter', 'autoroyal' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 

				if ( ! $filters ) : 

			?>
				<tr>
					<td colspan="11"><?php esc_html_e( 'There are no filters yet.', 'autoroyal' ); ?></td>
				</tr>
			<?php else : ?>
				<?php foreach ( $filters as $filter ) : ?>

					<?php 

						$filter_ID = $filter->ID; 

						$post_filter_make = get_post_meta($filter_ID, 'filter_make',true);
				        $post_filter_model = get_post_meta($filter_ID, 'filter_model',true);
				        $post_filter_fuel_type = get_post_meta($filter_ID, 'filter_fuel_type',true);
				        $post_filter_price = get_post_meta($filter_ID, 'filter_price',true);
				        $post_filter_year = get_post_meta($filter_ID, 'filter_year',true);
				        $post_filter_mileage = get_post_meta($filter_ID, 'filter_mileage',true);
				        $post_filter_condition = get_post_meta($filter_ID, 'filter_condition',true);

				        $post_filter_email = get_post_meta($filter_ID, 'filter_email',true);
						$post_filter_user_id = get_post_meta($filter_ID, 'filter_user_id',true);

						$post_mobile_phone = esc_attr(get_post_meta($post_filter_user_id, 'lead_mobile_phone',true));

						$post_first_name = esc_attr(get_post_meta($post_filter_user_id, 'lead_first_name',true));
						$post_last_name = esc_attr(get_post_meta($post_filter_user_id, 'lead_last_name',true));

					?>

					<tr class="listing-item" data-id="<?php echo esc_attr($filter_ID); ?>">

						<td class="d-none d-lg-table-cell autoroyal-date">
							<?php echo get_the_date( get_option('date_format'), $filter_ID ); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_first_name); ?> <?php echo esc_attr($post_last_name); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_filter_email); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_mobile_phone); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_filter_make); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_filter_model); ?>
						</td>

						<td class="d-none d-lg-table-cell autoroyal-fuel">
							<?php if(!empty($post_filter_fuel_type)) { $term = get_term( $post_filter_fuel_type, 'vehicle_fuel_type' ); if(!empty($term)) { echo esc_attr($term->name); } } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_filter_price); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php echo esc_attr($post_filter_year); ?>
						</td>

						<td class="d-none d-lg-table-cell autoroyal-mileage">
							<?php echo esc_attr($post_filter_mileage); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if( empty($post_filter_condition)) { esc_html_e( 'Used', 'autoroyal' ); } else { esc_html_e( 'New', 'autoroyal' ); }; ?>
						</td>

						<td class="d-md-table-cell d-lg-none">
							<br><?php esc_html_e( 'Date', 'autoroyal' ); ?>: <?php echo get_the_date( get_option('date_format'), $filter_ID ); ?>
							<strong><?php echo esc_attr($post_first_name); ?> <?php echo esc_attr($post_last_name); ?></strong>
							<br><?php esc_html_e( 'Email', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_email); ?>
							<br><?php esc_html_e( 'Phone', 'autoroyal' ); ?>: <?php echo esc_attr($post_mobile_phone); ?>
							<br><?php esc_html_e( 'Make', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_make); ?>
							<br><?php esc_html_e( 'Model', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_model); ?>
							<br><?php esc_html_e( 'Fuel Type', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_fuel_type); ?>
							<br><?php esc_html_e( 'Price', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_price); ?>
							<br><?php esc_html_e( 'Year', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_year); ?>
							<br><?php esc_html_e( 'Mileage', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_mileage); ?>
							<br><?php esc_html_e( 'Condition', 'autoroyal' ); ?>: <?php echo esc_attr($post_filter_condition); ?>
						</td>

					</tr>

				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
	</table>
	<?php get_autoroyal_template( 'pagination.php', array( 'max_num_pages' => $max_num_pages ) ); ?>
</div>
