<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Content class.
 */
class autoroyal_Deal_Post_Type_MetaBoxes {

	/**
	 * Constructor
	 */
	public function __construct() {

		add_action('add_meta_boxes', 'register_deal_settings');
		function register_deal_settings () {
			add_meta_box('deal_main_buyer_info', 'Buyer', 'display_deal_main_buyer_info','deal');
			add_meta_box('deal_co_buyer_info', 'Co-Buyer', 'display_deal_co_buyer_info','deal');
			add_meta_box('deal_vehicle_info', 'Vehicle Information', 'display_deal_vehicle_info','deal');
			add_meta_box('deal_trade_in', 'Trade-In', 'display_deal_trade_in','deal');
			add_meta_box('deal_transaction', 'Transaction', 'display_deal_transaction','deal');
		}

		function display_deal_main_buyer_info ($post) {

			// Enqueue styles
			wp_enqueue_style( 'jquery-ui' );

			// Enqueue scripts
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_script( 'jquery-ui-autocomplete' );
			wp_enqueue_script( 'time-picker' );
			wp_enqueue_script( 'loan-rate' );

			//get the post meta data
			
			$customer_type = esc_attr(get_post_meta($post->ID, 'customer_type',true));
			$existing_customer = esc_attr(get_post_meta($post->ID, 'existing_customer',true));

			$deal_first_name = esc_attr(get_post_meta($post->ID, 'deal_first_name',true));
			$deal_middle_name = esc_attr(get_post_meta($post->ID, 'deal_middle_name',true));
			$deal_last_name = esc_attr(get_post_meta($post->ID, 'deal_last_name',true));

			$deal_address_1 = esc_attr(get_post_meta($post->ID, 'deal_address_1',true));
			$deal_address_2 = esc_attr(get_post_meta($post->ID, 'deal_address_2',true));

			$deal_city = esc_attr(get_post_meta($post->ID, 'deal_city',true));
			$deal_state = esc_attr(get_post_meta($post->ID, 'deal_state',true));
			$deal_zip = esc_attr(get_post_meta($post->ID, 'deal_zip',true));

			$deal_home_phone = esc_attr(get_post_meta($post->ID, 'deal_home_phone',true));
			$deal_mobile_phone = esc_attr(get_post_meta($post->ID, 'deal_mobile_phone',true));
			$deal_work_phone = esc_attr(get_post_meta($post->ID, 'deal_work_phone',true));

			$deal_email = esc_attr(get_post_meta($post->ID, 'deal_email',true));
			$deal_birth_date = esc_attr(get_post_meta($post->ID, 'deal_birth_date',true));
			$deal_social_security = esc_attr(get_post_meta($post->ID, 'deal_social_security',true));

			$deal_driver_license_state = esc_attr(get_post_meta($post->ID, 'deal_driver_license_state',true));
			$deal_driver_license_number = esc_attr(get_post_meta($post->ID, 'deal_driver_license_number',true));
			$deal_driver_license_exp = esc_attr(get_post_meta($post->ID, 'deal_driver_license_exp',true));

			?>
			
			<input type="hidden" name="cmb_nonce" value="<?php echo wp_create_nonce(basename(__FILE__)); ?>" />

			<div id='options_group'>

				<fieldset>
					
					<div class="row">

						<div class="col-md-12">

							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>

						    	<h5 class="autoroyal-https-error"><?php esc_html_e('This page is not secure!', 'autoroyal' ); ?><br><br><?php esc_html_e('Sensitive fields will be hidden.', 'autoroyal' ); ?><br><br><?php esc_html_e('Please contact the site administrator for more information.', 'autoroyal' ); ?></h5>

						    <?php } ?>

					    </div>

						<div class="col-md-6">

							<label for="customer_type" class="control-label"><?php esc_html_e('Customer Type:', 'autoroyal' ); ?></label>
							<select name="customer_type" id="customer_type" class="form-control input-lg">
								<option value="New Customer" <?php selected( "New Customer", $customer_type ); ?>><?php esc_html_e('New Customer', 'autoroyal' ); ?></option>
								<option value="Existing Customer" <?php selected( "Existing Customer", $customer_type ); ?>><?php esc_html_e('Existing Customer', 'autoroyal' ); ?></option>
							</select>

						</div>

						<div class="col-md-6">

							<div id="existing_customer_container" <?php if($customer_type == "Existing Customer") { ?>style="display: block;"<?php } ?> >

								<label for="existing_customer" class="control-label"><?php esc_html_e('Existing Customer', 'autoroyal' ); ?></label>
								<select class="" name="existing_customer" id="existing_customer" data-live-search="true" >

									<option value="none" <?php selected( "Existing Customer", $customer_type ); ?>><?php esc_html_e('Select Customer', 'autoroyal' ); ?></option>

									<?php 

										$search_args = apply_filters( 'autoroyal_get_leads_args', array(
											'post_type'           => 'lead',
											'post_status'         => 'publish',
											'posts_per_page'      => -1,
											'orderby'             => 'date',
											'order'               => 'desc'
										) );
										$lead_query = new WP_Query;
										$leads = $lead_query->query( $search_args );

										if ( $leads ) : 

											foreach ( $leads as $lead ) :

												$lead_ID = $lead->ID; 

												$lead_first_name = esc_attr(get_post_meta($lead_ID, 'lead_first_name',true));
												$lead_middle_name = esc_attr(get_post_meta($lead_ID, 'lead_middle_name',true));
												$lead_last_name = esc_attr(get_post_meta($lead_ID, 'lead_last_name',true));

												$lead_address_1 = esc_attr(get_post_meta($lead_ID, 'lead_address_1',true));
												$lead_address_2 = esc_attr(get_post_meta($lead_ID, 'lead_address_2',true));

												$lead_city = esc_attr(get_post_meta($lead_ID, 'lead_city',true));
												$lead_state = esc_attr(get_post_meta($lead_ID, 'lead_state',true));
												$lead_zip = esc_attr(get_post_meta($lead_ID, 'lead_zip',true));

												$lead_home_phone = esc_attr(get_post_meta($lead_ID, 'lead_home_phone',true));
												$lead_mobile_phone = esc_attr(get_post_meta($lead_ID, 'lead_mobile_phone',true));
												$lead_work_phone = esc_attr(get_post_meta($lead_ID, 'lead_work_phone',true));

												$lead_email = esc_attr(get_post_meta($lead_ID, 'lead_email',true));
												$lead_birth_date = esc_attr(get_post_meta($lead_ID, 'lead_birth_date',true));
												$lead_social_security = esc_attr(get_post_meta($lead_ID, 'lead_social_security',true));

												$lead_driver_license_state = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_state',true));
												$lead_driver_license_number = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_number',true));
												$lead_driver_license_exp = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_exp',true));

									?>
										<option 

											data-first-name="<?php echo esc_attr($lead_first_name); ?>"
											data-middle-name="<?php echo esc_attr($lead_middle_name); ?>"
											data-last-name="<?php echo esc_attr($lead_last_name); ?>" 
											data-address-1="<?php echo esc_attr($lead_address_1); ?>" 
											data-address-2="<?php echo esc_attr($lead_address_2); ?>" 
											data-city="<?php echo esc_attr($lead_city); ?>" 
											data-state="<?php echo esc_attr($lead_state); ?>" 
											data-zip="<?php echo esc_attr($lead_zip); ?>" 
											data-home-phone="<?php echo esc_attr($lead_home_phone); ?>" 
											data-mobile-phone="<?php echo esc_attr($lead_mobile_phone); ?>" 
											data-work-phone="<?php echo esc_attr($lead_work_phone); ?>" 
											data-email="<?php echo esc_attr($lead_email); ?>" 
											data-birth-date="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_birth_date); } ?>" 
											data-social-security="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_social_security); } ?>" 
											data-driver-license-state="<?php echo esc_attr($lead_driver_license_state); ?>" 
											data-driver-license-number="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_driver_license_number); } ?>" 
											data-driver-license-exp="<?php echo esc_attr($lead_driver_license_exp); ?>" 

											value="<?php echo esc_attr($lead_ID); ?>" 

											<?php selected( $lead_ID, $existing_customer ); ?>><?php echo esc_attr($lead_first_name); ?> <?php echo esc_attr($lead_last_name); ?></option>
									<?php 

											endforeach; 

										endif;

									?>
									
								</select>

							</div>

						</div>

					</div>

				</fieldset>

				<fieldset>
					
					<div class="row">

						<div class="col-md-4">

							<label for="deal_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_first_name" name="deal_first_name" value="<?php echo esc_attr($deal_first_name); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_middle_name" name="deal_middle_name" value="<?php echo esc_attr($deal_middle_name); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_last_name" name="deal_last_name" value="<?php echo esc_attr($deal_last_name); ?>" placeholder="" />

						</div>

						<div class="col-md-6">

							<label for="deal_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_address_1" name="deal_address_1" value="<?php echo esc_attr($deal_address_1); ?>" placeholder="" />

						</div>

						<div class="col-md-6">

							<label for="deal_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_address_2" name="deal_address_2" value="<?php echo esc_attr($deal_address_2); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_city" name="deal_city" value="<?php echo esc_attr($deal_city); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_state" name="deal_state" value="<?php echo esc_attr($deal_state); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_zip" name="deal_zip" value="<?php echo esc_attr($deal_zip); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_home_phone" name="deal_home_phone" value="<?php echo esc_attr($deal_home_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_mobile_phone" name="deal_mobile_phone" value="<?php echo esc_attr($deal_mobile_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_work_phone" name="deal_work_phone" value="<?php echo esc_attr($deal_work_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_email" name="deal_email" value="<?php echo esc_attr($deal_email); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_birth_date" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

							<div class="autoroyal-input-has-icon">
								<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
									<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
								<?php } else { ?>
									<input class="date_picker_past autoroyal-input-icon-left" type="text" id="deal_birth_date" name="deal_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($deal_birth_date); ?>" />
									<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
								<?php } ?>
							</div>

						</div>

						<div class="col-md-4">

							<label for="deal_social_security" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Social Security:', 'autoroyal' ); ?></label>
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input type="text" id="deal_social_security" name="deal_social_security" value="<?php echo esc_attr($deal_social_security); ?>" placeholder="" />
							<?php } ?>

						</div>

						<div class="col-md-4">

							<label for="deal_driver_license_state" class="control-label"><?php esc_html_e('Drivers License State:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_driver_license_state" name="deal_driver_license_state" value="<?php echo esc_attr($deal_driver_license_state); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_driver_license_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Drivers License Number:', 'autoroyal' ); ?></label>
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input type="text" id="deal_driver_license_number" name="deal_driver_license_number" value="<?php echo esc_attr($deal_driver_license_number); ?>" placeholder="" />
							<?php } ?>

						</div>

						<div class="col-md-4">

							<label for="deal_driver_license_exp" class="control-label"><?php esc_html_e('Drivers License Exp:', 'autoroyal' ); ?></label>

							<div class="autoroyal-input-has-icon">
								<input class="date_picker_future autoroyal-input-icon-left" type="text" id="deal_driver_license_exp" name="deal_driver_license_exp" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($deal_driver_license_exp); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							</div>

						</div>

					</div>
					
				</fieldset>

				<br>

			</div>	<!-- end review_options_pop -->

		<?php

		}

		function display_deal_co_buyer_info ($post) {

			//get the post meta data
			
			$cobuyer_customer_type = esc_attr(get_post_meta($post->ID, 'cobuyer_customer_type',true));
			$cobuyer_existing_customer = esc_attr(get_post_meta($post->ID, 'cobuyer_existing_customer',true));

			$deal_cobuyer_first_name = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_first_name',true));
			$deal_cobuyer_middle_name = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_middle_name',true));
			$deal_cobuyer_last_name = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_last_name',true));

			$deal_cobuyer_address_1 = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_address_1',true));
			$deal_cobuyer_address_2 = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_address_2',true));

			$deal_cobuyer_city = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_city',true));
			$deal_cobuyer_state = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_state',true));
			$deal_cobuyer_zip = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_zip',true));

			$deal_cobuyer_home_phone = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_home_phone',true));
			$deal_cobuyer_mobile_phone = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_mobile_phone',true));
			$deal_cobuyer_work_phone = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_work_phone',true));

			$deal_cobuyer_email = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_email',true));
			$deal_cobuyer_birth_date = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_birth_date',true));
			$deal_cobuyer_social_security = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_social_security',true));

			$deal_cobuyer_driver_license_state = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_driver_license_state',true));
			$deal_cobuyer_driver_license_number = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_driver_license_number',true));
			$deal_cobuyer_driver_license_exp = esc_attr(get_post_meta($post->ID, 'deal_cobuyer_driver_license_exp',true));

			?>

			<div id='options_group'>

				<fieldset>
					
					<div class="row">

						<div class="col-md-6">

							<label for="cobuyer_customer_type" class="control-label"><?php esc_html_e('Customer Type:', 'autoroyal' ); ?></label>
							<select name="cobuyer_customer_type" id="cobuyer_customer_type" class="form-control input-lg">
								<option value="New Customer" <?php selected( "New Customer", $cobuyer_customer_type ); ?>><?php esc_html_e('New Customer', 'autoroyal' ); ?></option>
								<option value="Existing Customer" <?php selected( "Existing Customer", $cobuyer_customer_type ); ?>><?php esc_html_e('Existing Customer', 'autoroyal' ); ?></option>
							</select>

						</div>

						<div class="col-md-6">

							<div id="existing_cobuyer_customer_container" <?php if($cobuyer_customer_type == "Existing Customer") { ?>style="display: block;"<?php } ?> >

								<label for="cobuyer_existing_customer" class="control-label"><?php esc_html_e('Existing Customer', 'autoroyal' ); ?></label>
								<select class="" name="cobuyer_existing_customer" id="cobuyer_existing_customer" data-show-subtext="true" data-live-search="true" >

									<option value="none"><?php esc_html_e('Select Customer', 'autoroyal' ); ?></option>

									<?php 

										$search_args = apply_filters( 'autoroyal_get_leads_args', array(
											'post_type'           => 'lead',
											'post_status'         => 'publish',
											'posts_per_page'      => -1,
											'orderby'             => 'date',
											'order'               => 'desc'
										) );
										$lead_query = new WP_Query;
										$leads = $lead_query->query( $search_args );

										if ( $leads ) : 

											foreach ( $leads as $lead ) :

												$lead_ID = $lead->ID; 

												$lead_first_name = esc_attr(get_post_meta($lead_ID, 'lead_first_name',true));
												$lead_middle_name = esc_attr(get_post_meta($lead_ID, 'lead_middle_name',true));
												$lead_last_name = esc_attr(get_post_meta($lead_ID, 'lead_last_name',true));

												$lead_address_1 = esc_attr(get_post_meta($lead_ID, 'lead_address_1',true));
												$lead_address_2 = esc_attr(get_post_meta($lead_ID, 'lead_address_2',true));

												$lead_city = esc_attr(get_post_meta($lead_ID, 'lead_city',true));
												$lead_state = esc_attr(get_post_meta($lead_ID, 'lead_state',true));
												$lead_zip = esc_attr(get_post_meta($lead_ID, 'lead_zip',true));

												$lead_home_phone = esc_attr(get_post_meta($lead_ID, 'lead_home_phone',true));
												$lead_mobile_phone = esc_attr(get_post_meta($lead_ID, 'lead_mobile_phone',true));
												$lead_work_phone = esc_attr(get_post_meta($lead_ID, 'lead_work_phone',true));

												$lead_email = esc_attr(get_post_meta($lead_ID, 'lead_email',true));
												$lead_birth_date = esc_attr(get_post_meta($lead_ID, 'lead_birth_date',true));
												$lead_social_security = esc_attr(get_post_meta($lead_ID, 'lead_social_security',true));

												$lead_driver_license_state = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_state',true));
												$lead_driver_license_number = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_number',true));
												$lead_driver_license_exp = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_exp',true));

									?>
										<option 

											data-first-name="<?php echo esc_attr($lead_first_name); ?>"
											data-middle-name="<?php echo esc_attr($lead_middle_name); ?>"
											data-last-name="<?php echo esc_attr($lead_last_name); ?>" 
											data-address-1="<?php echo esc_attr($lead_address_1); ?>" 
											data-address-2="<?php echo esc_attr($lead_address_2); ?>" 
											data-city="<?php echo esc_attr($lead_city); ?>" 
											data-state="<?php echo esc_attr($lead_state); ?>" 
											data-zip="<?php echo esc_attr($lead_zip); ?>" 
											data-home-phone="<?php echo esc_attr($lead_home_phone); ?>" 
											data-mobile-phone="<?php echo esc_attr($lead_mobile_phone); ?>" 
											data-work-phone="<?php echo esc_attr($lead_work_phone); ?>" 
											data-email="<?php echo esc_attr($lead_email); ?>" 
											data-birth-date="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {  echo esc_attr($lead_birth_date); } ?>" 
											data-social-security="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_social_security); } ?>" 
											data-driver-license-state="<?php echo esc_attr($lead_driver_license_state); ?>" 
											data-driver-license-number="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_driver_license_number); } ?>" 
											data-driver-license-exp="<?php echo esc_attr($lead_driver_license_exp); ?>" 

											value="<?php echo esc_attr($lead_ID); ?>" 

											<?php selected( $lead_ID, $cobuyer_existing_customer ); ?>><?php echo esc_attr($lead_first_name); ?> <?php echo esc_attr($lead_last_name); ?></option>
									<?php 

											endforeach; 

										endif;

									?>
									
								</select>

							</div>

						</div>

					</div>

				</fieldset>

				<fieldset>
					
					<div class="row">

						<div class="col-md-4">

							<label for="deal_cobuyer_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_first_name" name="deal_cobuyer_first_name" value="<?php echo esc_attr($deal_cobuyer_first_name); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_middle_name" name="deal_cobuyer_middle_name" value="<?php echo esc_attr($deal_cobuyer_middle_name); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_last_name" name="deal_cobuyer_last_name" value="<?php echo esc_attr($deal_cobuyer_last_name); ?>" placeholder="" />

						</div>

						<div class="col-md-6">

							<label for="deal_cobuyer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_address_1" name="deal_cobuyer_address_1" value="<?php echo esc_attr($deal_cobuyer_address_1); ?>" placeholder="" />

						</div>

						<div class="col-md-6">

							<label for="deal_cobuyer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_address_2" name="deal_cobuyer_address_2" value="<?php echo esc_attr($deal_cobuyer_address_2); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_city" name="deal_cobuyer_city" value="<?php echo esc_attr($deal_cobuyer_city); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_state" name="deal_cobuyer_state" value="<?php echo esc_attr($deal_cobuyer_state); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_zip" name="deal_cobuyer_zip" value="<?php echo esc_attr($deal_cobuyer_zip); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_home_phone" name="deal_cobuyer_home_phone" value="<?php echo esc_attr($deal_cobuyer_home_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_mobile_phone" name="deal_cobuyer_mobile_phone" value="<?php echo esc_attr($deal_cobuyer_mobile_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_work_phone" name="deal_cobuyer_work_phone" value="<?php echo esc_attr($deal_cobuyer_work_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_email" name="deal_cobuyer_email" value="<?php echo esc_attr($deal_cobuyer_email); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_birth_date" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

							<div class="autoroyal-input-has-icon">
								<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
									<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
								<?php } else { ?>
									<input class="date_picker_past autoroyal-input-icon-left" type="text" id="deal_cobuyer_birth_date" name="deal_cobuyer_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($deal_cobuyer_birth_date); ?>" />
									<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
								<?php } ?>
							</div>

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_social_security" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Social Security:', 'autoroyal' ); ?></label>
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input type="text" id="deal_cobuyer_social_security" name="deal_cobuyer_social_security" value="<?php echo esc_attr($deal_cobuyer_social_security); ?>" placeholder="" />
							<?php } ?>

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_driver_license_state" class="control-label"><?php esc_html_e('Drivers License State:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_cobuyer_driver_license_state" name="deal_cobuyer_driver_license_state" value="<?php echo esc_attr($deal_cobuyer_driver_license_state); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_driver_license_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Drivers License Number:', 'autoroyal' ); ?></label>
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input type="text" id="deal_cobuyer_driver_license_number" name="deal_cobuyer_driver_license_number" value="<?php echo esc_attr($deal_cobuyer_driver_license_number); ?>" placeholder="" />
							<?php } ?>

						</div>

						<div class="col-md-4">

							<label for="deal_cobuyer_driver_license_exp" class="control-label"><?php esc_html_e('Drivers License Exp:', 'autoroyal' ); ?></label>

							<div class="autoroyal-input-has-icon">
								<input class="date_picker_future autoroyal-input-icon-left" type="text" id="deal_cobuyer_driver_license_exp" name="deal_cobuyer_driver_license_exp" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($deal_cobuyer_driver_license_exp); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							</div>

						</div>

					</div>
					
				</fieldset>

				<br>

			</div>	<!-- end review_options_pop -->

		<?php

		}

		function display_deal_vehicle_info ($post) {

			//get the post meta data
			
			$deal_vehicle_id = esc_attr(get_post_meta($post->ID, 'deal_vehicle_id',true));

			$deal_vehicle_sku = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_stock',true));
			$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
			$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
			$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
			$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));
			$deal_vehicle_vin = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_vin',true));

			$vehicle_exterior_color = get_the_terms($deal_vehicle_id, 'vehicle_exterior_color' );
			if(!empty($vehicle_exterior_color)) {
				$color              = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
				$color_id           = $vehicle_exterior_color[0]->term_id;
				$deal_vehicle_color = $vehicle_exterior_color[0]->name;
			} else {
				$deal_vehicle_color = "";
			}

			$deal_vehicle_mileage = autoroyal_number(get_post_meta($deal_vehicle_id, 'vehicle_mileage',true));
			$deal_vehicle_price = autoroyal_clean_price(get_post_meta($deal_vehicle_id, 'vehicle_price',true));
			$deal_vehicle_cost = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_cost',true));

			?>

			<div id='options_group'>

				<fieldset>
					
					<div class="row">

						<div class="col-md-12">

							<label for="deal_vehicle_id" class="control-label"><?php esc_html_e('Select Vehicle', 'autoroyal' ); ?></label>
							<select class="" name="deal_vehicle_id" id="deal_vehicle_id" data-live-search="true" >

								<?php 

									$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
										'post_type'           => 'vehicle',
										'post_status'         => 'publish',
										'posts_per_page'      => -1,
										'orderby'             => 'date',
										'order'               => 'desc'
									) );
									$cars_query = new WP_Query;
									$cars = $cars_query->query( $search_args );

									if ( $cars ) : 

										foreach ( $cars as $car ) :

											$car_ID = $car->ID; 

											$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
											$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
											$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
											$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
											$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
											$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
											$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

											$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
											if(!empty($vehicle_exterior_color)) {
												$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
												$color_id   = $vehicle_exterior_color[0]->term_id;
												$color_name = $vehicle_exterior_color[0]->name;
											} else {
												$color_name = "";
											}
											

											$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

											$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));
											$cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));

								?>
									<option data-sku="<?php echo esc_attr($vehicle_stock); ?>" data-year="<?php echo esc_attr($vehicle_year); ?>" data-make="<?php echo esc_attr($vehicle_make_desc_init); ?>" data-model="<?php echo esc_attr($vehicle_model); ?>" data-trim="<?php echo esc_attr($vehicle_trim_desc_init); ?>" data-vin="<?php echo esc_attr($vehicle_vin); ?>" data-color="<?php echo esc_attr($color_name); ?>" data-mileage="<?php echo autoroyal_number($vehicle_mileage); ?>" data-price="<?php echo autoroyal_clean_price($price); ?>" data-clean-price="<?php echo esc_attr($price); ?>" data-cost="<?php echo esc_attr($cost); ?>" value="<?php echo esc_attr($car_ID); ?>" <?php selected( $car_ID, $deal_vehicle_id ); ?>><?php if(!empty($vehicle_stock)) { echo esc_attr($vehicle_stock); } else { echo esc_attr($car_ID); } ?> - <?php echo esc_attr($vehicle_year); ?> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?></option>
								<?php 

										endforeach; 

									endif;

								?>
								
							</select>

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_sku" class="control-label"><?php esc_html_e('Stock Number:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_sku" name="deal_vehicle_sku" value="<?php echo esc_attr($deal_vehicle_sku); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_year" class="control-label"><?php esc_html_e('Year:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_year" name="deal_vehicle_year" value="<?php echo esc_attr($deal_vehicle_year); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_make" class="control-label"><?php esc_html_e('Make:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_make" name="deal_vehicle_make" value="<?php echo esc_attr($deal_vehicle_make); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_model" class="control-label"><?php esc_html_e('Model:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_model" name="deal_vehicle_model" value="<?php echo esc_attr($deal_vehicle_model); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_trim" class="control-label"><?php esc_html_e('Trim:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_trim" name="deal_vehicle_trim" value="<?php echo esc_attr($deal_vehicle_trim); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_vin" name="deal_vehicle_vin" value="<?php echo esc_attr($deal_vehicle_vin); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_color" name="deal_vehicle_color" value="<?php echo esc_attr($deal_vehicle_color); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_vehicle_mileage" name="deal_vehicle_mileage" value="<?php echo esc_attr($deal_vehicle_mileage); ?>" placeholder="" disabled="disabled" />

						</div>

						<div class="col-md-4">

							<label for="deal_vehicle_price" class="control-label"><?php esc_html_e('Price:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
							<input type="text" id="deal_vehicle_price" name="deal_vehicle_price" value="<?php echo esc_attr($deal_vehicle_price); ?>" placeholder="" disabled="disabled" />

						</div>

					</div>
					
				</fieldset>

				<br>

			</div>	<!-- end review_options_pop -->

		<?php

		}

		function display_deal_trade_in ($post) {

			//get the post meta data
			
			$deal_tradein_vehicle_year = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_year',true));
			$deal_tradein_vehicle_make = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_make',true));
			$deal_tradein_vehicle_model = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_model',true));
			$deal_tradein_vehicle_trim_id = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_trim_id',true));
			$deal_tradein_vehicle_trim_desc_init = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_trim_desc_init',true));
			$deal_tradein_vehicle_make_desc_init = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_make_desc_init',true));

			$deal_tradein_vehicle_vin = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_vin',true));
			$deal_tradein_vehicle_mileage = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_mileage',true));
			$deal_tradein_vehicle_color = esc_attr(get_post_meta($post->ID, 'deal_tradein_vehicle_color',true));

			$deal_tradein_allowance = esc_attr(get_post_meta($post->ID, 'deal_tradein_allowance',true));
			$deal_tradein_payoff = esc_attr(get_post_meta($post->ID, 'deal_tradein_payoff',true));
			$deal_tradein_payoff_good = esc_attr(get_post_meta($post->ID, 'deal_tradein_payoff_good',true));
			$deal_tradein_lien_holder_name = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_name',true));
			$deal_tradein_lien_holder_addres_1 = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_addres_1',true));
			$deal_tradein_lien_holder_addres_2 = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_addres_2',true));
			$deal_tradein_lien_holder_city = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_city',true));
			$deal_tradein_lien_holder_state = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_state',true));
			$deal_tradein_lien_holder_zip = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_zip',true));
			$deal_tradein_lien_holder_phone = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_phone',true));
			$deal_tradein_lien_holder_acc_number = esc_attr(get_post_meta($post->ID, 'deal_tradein_lien_holder_acc_number',true));

			?>

			<input id="vehicle_year_init" type="hidden" name="vehicle_year_init" value="<?php echo esc_attr($deal_tradein_vehicle_year); ?>" />
			<input id="vehicle_make_init" type="hidden" name="vehicle_make_init" value="<?php echo esc_attr($deal_tradein_vehicle_make); ?>" />
			<input id="vehicle_model_init" type="hidden" name="vehicle_model_init" value="<?php echo esc_attr($deal_tradein_vehicle_model); ?>" />
			<input id="vehicle_trim_id_init" type="hidden" name="vehicle_trim_id_init" value="<?php echo esc_attr($deal_tradein_vehicle_trim_id); ?>" />
			<input id="vehicle_trim_desc_init" type="hidden" name="vehicle_trim_desc_init" value="<?php echo esc_attr($deal_tradein_vehicle_trim_desc_init); ?>" />
			<input id="vehicle_make_desc_init" type="hidden" name="vehicle_make_desc_init" value="<?php echo esc_attr($deal_tradein_vehicle_make_desc_init); ?>" />

			<div id='options_group'>

				<fieldset class="select-car-model-table">

					<table id="select-car-model">

						<tbody>

							<tr valign="bottom">
								<th><?php esc_html_e('Make', 'autoroyal' ); ?></th>
								<th><?php esc_html_e('Model', 'autoroyal' ); ?></th>
								<th><?php esc_html_e('Year', 'autoroyal' ); ?></th>
								<th><?php esc_html_e('Trim', 'autoroyal' ); ?></th>
							</tr>

							<tr>

								<td>
									<select name="cq-make" id="cq-make" class="cq-make"></select>
								</td>

								<td>
									<select name="cq-model" id="cq-model" class="cq-model" <?php if(empty($deal_tradein_vehicle_model)) { ?>disabled<?php } ?>></select>
								</td>

								<td>
									<select name="cq-year" id="cq-year" class="cq-year" <?php if(empty($deal_tradein_vehicle_year)) { ?>disabled<?php } ?>></select>
								</td>

								<td>
									<select name="cq-trim" id="cq-trim" class="cq-trim" <?php if(empty($deal_tradein_vehicle_trim_id)) { ?>disabled<?php } ?>></select>
								</td>

							</tr>

						</tbody>

					</table>

				</fieldset>

				<fieldset>
					
					<div class="row">

						<div class="col-md-4">

							<label for="deal_tradein_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_vehicle_vin" name="deal_tradein_vehicle_vin" value="<?php echo esc_attr($deal_tradein_vehicle_vin); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_vehicle_mileage" name="deal_tradein_vehicle_mileage" value="<?php echo esc_attr($deal_tradein_vehicle_mileage); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_vehicle_color" name="deal_tradein_vehicle_color" value="<?php echo esc_attr($deal_tradein_vehicle_color); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_allowance" class="control-label"><?php esc_html_e('Trade-In Allowance:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
							<input type="text" id="deal_tradein_allowance" name="deal_tradein_allowance" value="<?php echo esc_attr($deal_tradein_allowance); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_payoff" class="control-label"><?php esc_html_e('Trade-In Payoff:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
							<input type="text" id="deal_tradein_payoff" name="deal_tradein_payoff" value="<?php echo esc_attr($deal_tradein_payoff); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_payoff_good" class="control-label"><?php esc_html_e('Trade Payoff Good Thru:', 'autoroyal' ); ?></label>
							<div class="autoroyal-input-has-icon">
								<input class="date_picker_future autoroyal-input-icon-left" type="text" id="deal_tradein_payoff_good" name="deal_tradein_payoff_good" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($deal_tradein_payoff_good); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							</div>

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_lien_holder_name" class="control-label"><?php esc_html_e('Lien Holder Name:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_name" name="deal_tradein_lien_holder_name" value="<?php echo esc_attr($deal_tradein_lien_holder_name); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_lien_holder_addres_1" class="control-label"><?php esc_html_e('Lien Holder Address 1:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_addres_1" name="deal_tradein_lien_holder_addres_1" value="<?php echo esc_attr($deal_tradein_lien_holder_addres_1); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_lien_holder_addres_2" class="control-label"><?php esc_html_e('Lien Holder Address 2:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_addres_2" name="deal_tradein_lien_holder_addres_2" value="<?php echo esc_attr($deal_tradein_lien_holder_addres_2); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_lien_holder_city" class="control-label"><?php esc_html_e('Lien Holder City:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_city" name="deal_tradein_lien_holder_city" value="<?php echo esc_attr($deal_tradein_lien_holder_city); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_lien_holder_state" class="control-label"><?php esc_html_e('Lien Holder State:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_state" name="deal_tradein_lien_holder_state" value="<?php echo esc_attr($deal_tradein_lien_holder_state); ?>" placeholder="" />

						</div>

						<div class="col-md-4">

							<label for="deal_tradein_lien_holder_zip" class="control-label"><?php esc_html_e('Lien Holder Zip:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_zip" name="deal_tradein_lien_holder_zip" value="<?php echo esc_attr($deal_tradein_lien_holder_zip); ?>" placeholder="" />

						</div>

						<div class="col-md-6">

							<label for="deal_tradein_lien_holder_phone" class="control-label"><?php esc_html_e('Lien Holder Phone:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_phone" name="deal_tradein_lien_holder_phone" value="<?php echo esc_attr($deal_tradein_lien_holder_phone); ?>" placeholder="" />

						</div>

						<div class="col-md-6">

							<label for="deal_tradein_lien_holder_acc_number" class="control-label"><?php esc_html_e('Lien Holder Account Number:', 'autoroyal' ); ?></label>
							<input type="text" id="deal_tradein_lien_holder_acc_number" name="deal_tradein_lien_holder_acc_number" value="<?php echo esc_attr($deal_tradein_lien_holder_acc_number); ?>" placeholder="" />

						</div>

					</div>
					
				</fieldset>

				<br>

			</div>	<!-- end review_options_pop -->

		<?php

		}

		function display_deal_transaction ($post) {

			//get the post meta data
			
			$deal_sold_date = esc_attr(get_post_meta($post->ID, 'deal_sold_date',true));
			$today = strtotime("now");
			if(empty($deal_sold_date)) {
				$deal_sold_date = date( "m/d/Y", $today);
			}
			$deal_sale_type = esc_attr(get_post_meta($post->ID, 'deal_sale_type',true));
			$deal_vehicle_id = esc_attr(get_post_meta($post->ID, 'deal_vehicle_id',true));
			$deal_vehicle_price = get_post_meta($deal_vehicle_id, 'vehicle_price',true);
			$deal_vehicle_cost = get_post_meta($deal_vehicle_id, 'vehicle_cost',true);
			$deal_purchase_price = get_post_meta($post->ID, 'deal_purchase_price',true);
			if(empty($deal_purchase_price) OR !isset($deal_purchase_price)) {
				$deal_purchase_price = $deal_vehicle_price;
			}

			$deal_trade_in_payoff = get_post_meta($post->ID, 'deal_trade_in_payoff',true);
			$deal_trade_in_allowance = get_post_meta($post->ID, 'deal_trade_in_allowance',true);
			$deal_total_price = get_post_meta($post->ID, 'deal_total_price',true);
			if(empty($deal_total_price) OR !isset($deal_total_price)) {
				$deal_total_price = $deal_vehicle_price;
			}

			$deal_down_payment = get_post_meta($post->ID, 'deal_down_payment',true);
			$deal_total_balance_due = get_post_meta($post->ID, 'deal_total_balance_due',true);
			if(empty($deal_total_balance_due) OR !isset($deal_total_balance_due)) {
				$deal_total_balance_due = $deal_vehicle_price;
			}

			$deal_loan_amount = get_post_meta($post->ID, 'deal_loan_amount',true);
			if(empty($deal_loan_amount) OR !isset($deal_loan_amount)) {
				$deal_loan_amount = $deal_total_balance_due;
			}

			$deal_interest_rate = get_post_meta($post->ID, 'deal_interest_rate',true);
			if(empty($deal_interest_rate) OR !isset($deal_interest_rate)) {
				$deal_interest_rate = 6;
			}

			$deal_sales_tax = get_post_meta($post->ID, 'deal_sales_tax',true);
			if(!isset($deal_sales_tax)) {
				$deal_sales_tax = 3;
			}

			$deal_sales_tax_fee = get_post_meta($post->ID, 'deal_sales_tax_fee',true);
			if(!isset($deal_sales_tax_fee)) {
				$deal_sales_tax_fee = 0;
			}

			$deal_loan_term = get_post_meta($post->ID, 'deal_loan_term',true);
			if(empty($deal_loan_term) OR !isset($deal_loan_term)) {
				$deal_loan_term = 5;
			}

			$deal_loan_term_priod = get_post_meta($post->ID, 'deal_loan_term_priod',true);
			$deal_loan_payment_amount = get_post_meta($post->ID, 'deal_loan_payment_amount',true);
			$deal_loan_payment_amount_x = get_post_meta($post->ID, 'deal_loan_payment_amount_x',true);
			$deal_loan_payment_final_amount = get_post_meta($post->ID, 'deal_loan_payment_final_amount',true);
			$deal_loan_payment_amount_period = get_post_meta($post->ID, 'deal_loan_payment_amount_period',true);

			$deal_profit = get_post_meta($post->ID, 'deal_profit',true);

			$deal_loan_payments_num = 0;
			$deal_loan_payments_num = get_post_meta($post->ID, 'deal_loan_payments_num',true);

			$deal_loan_payments = get_post_meta($post->ID, 'deal_loan_payments',true);
			$deal_loan_payments_period = get_post_meta($post->ID, 'deal_loan_payments_period',true);

			$deal_loan_final_date = get_post_meta($post->ID, 'deal_loan_final_date',true);

			$deal_loan_rate = get_post_meta($post->ID, 'deal_loan_rate',true);

			$deal_loan_payoff_date = get_post_meta($post->ID, 'deal_loan_payoff_date',true);

			$deal_loan_next_payments_date = esc_attr(get_post_meta($post->ID, 'deal_loan_next_payments_date',true));

			?>

			<div id='options_group'>

				<fieldset>
					
					<div class="row">

						<div class="col-md-6">

							<label for="deal_sold_date" class="control-label"><?php esc_html_e('Sold Date:', 'autoroyal' ); ?></label>

							<div class="autoroyal-input-has-icon">
								<input class="date_picker_range autoroyal-input-icon-left" type="text" id="deal_sold_date" name="deal_sold_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($deal_sold_date); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							</div>

						</div>

						<div class="col-md-6">

							<label for="deal_sale_type" class="control-label"><?php esc_html_e('Sales Type:', 'autoroyal' ); ?></label>
							<select name="deal_sale_type" id="deal_sale_type" class="form-control input-lg">
								<option value="Retail" <?php selected( "Retail", $deal_sale_type ); ?>><?php esc_html_e('Retail', 'autoroyal' ); ?></option>
								<option value="Wholesale" <?php selected( "Wholesale", $deal_sale_type ); ?>><?php esc_html_e('Wholesale', 'autoroyal' ); ?></option>
							</select>

						</div>

					</div>
					
				</fieldset>

				<fieldset>
					
					<div class="row">

						<div class="col-md-6">

							<div class="row">
								
								<div class="col-md-12">

									<label for="deal_purchase_price" class="control-label"><?php esc_html_e('Retail Price:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_purchase_price" name="deal_purchase_price" value="<?php echo esc_attr($deal_purchase_price); ?>" placeholder="" />

									<input type="hidden" id="deal_purchase_cost" name="deal_purchase_cost" value="<?php echo esc_attr($deal_vehicle_cost); ?>" />

								</div>

								<div class="col-md-12">

									<label for="deal_trade_in_payoff" class="control-label"><?php esc_html_e('+ Trade Payoff:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_trade_in_payoff" name="deal_trade_in_payoff" value="<?php echo esc_attr($deal_trade_in_payoff); ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="deal_trade_in_allowance" class="control-label"><?php esc_html_e('- Trade-In Allowance:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_trade_in_allowance" name="deal_trade_in_allowance" value="<?php echo esc_attr($deal_trade_in_allowance); ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="deal_total_price" class="control-label"><?php esc_html_e('Total Retail Price:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_total_price" name="deal_total_price" value="<?php echo esc_attr($deal_total_price); ?>" placeholder="" disabled="disabled" />

								</div>

								<div class="col-md-12">

									<label for="deal_down_payment" class="control-label"><?php esc_html_e('Down Payment:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_down_payment" name="deal_down_payment" value="<?php echo esc_attr($deal_down_payment); ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="deal_total_balance_due" class="control-label"><?php esc_html_e('Total Balance Due:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_total_balance_due" name="deal_total_balance_due" value="<?php echo esc_attr($deal_total_balance_due); ?>" placeholder="" disabled="disabled" />

								</div>

								<div class="col-md-12">

									<label for="deal_payment_method" class="control-label"><?php esc_html_e('Method of Payment:', 'autoroyal' ); ?></label>
									<select name="deal_payment_method" id="deal_payment_method" class="form-control input-lg">
										
										<?php

											$terms_cat = get_the_terms($post->ID, 'deal_payment_method' );
											if ($terms_cat && ! is_wp_error($terms_cat)) :
												$term_slugs_arr_cat = array();
													foreach ($terms_cat as $term_cat) {
														$term_slugs_arr_cat[] = $term_cat->slug;
													}
												$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
											endif;

											$categories = get_categories( array('taxonomy' => 'deal_payment_method', 'hide_empty' => false,  'parent' => 0) );

											foreach ($categories as $category) {
												$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
												$option .= $category->cat_name;
												$option .= '</option>';

												$catID = $category->term_id;

												$categories_child = get_categories( array('taxonomy' => 'deal_payment_method', 'hide_empty' => false,  'parent' => $catID) );

												foreach ($categories_child as $category_child) {
													$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
													$option .= $category_child->cat_name;
													$option .= '</option>';

												}

												echo $option;
											}

										?>

									</select>

								</div>

								<div class="col-md-12">

									<label for="deal_profit" class="control-label"><?php esc_html_e('Gross Profit:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_profit" name="deal_profit" value="<?php echo esc_attr($deal_profit); ?>" placeholder="" disabled="disabled" />
									<input type="hidden" id="deal_profit_hidden" name="deal_profit_hidden" value="<?php echo esc_attr($deal_profit); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div class="col-md-6">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-calculator" aria-hidden="true"></i> <?php esc_html_e('Loan Calculator', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-12">

									<label for="deal_sales_tax_fee" class="control-label"><?php esc_html_e('Sales Tax Fee:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_sales_tax_fee" name="deal_sales_tax_fee" value="<?php echo esc_attr($deal_sales_tax_fee); ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="deal_sales_tax" class="control-label"><?php esc_html_e('Sales Tax:', 'autoroyal' ); ?> (%)</label>
									<input type="text" id="deal_sales_tax" name="deal_sales_tax" value="<?php echo esc_attr($deal_sales_tax); ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="deal_interest_rate" class="control-label"><?php esc_html_e('Interest Rate:', 'autoroyal' ); ?> (%)</label>
									<input type="text" id="deal_interest_rate" name="deal_interest_rate" value="<?php echo esc_attr($deal_interest_rate); ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="deal_loan_term" class="control-label"><?php esc_html_e('Term of Loan:', 'autoroyal' ); ?></label>
									<input type="text" id="deal_loan_term" name="deal_loan_term" value="<?php echo esc_attr($deal_loan_term); ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="deal_loan_term_priod" class="control-label"><?php esc_html_e('Select:', 'autoroyal' ); ?></label>
									<select name="deal_loan_term_priod" id="deal_loan_term_priod" class="form-control input-lg">
										<option value="Years" <?php selected( "Years", $deal_loan_term_priod ); ?>><?php esc_html_e('Years', 'autoroyal' ); ?></option>
										<option value="Months" <?php selected( "Months", $deal_loan_term_priod ); ?>><?php esc_html_e('Months', 'autoroyal' ); ?></option>
										<option value="Weeks" <?php selected( "Weeks", $deal_loan_term_priod ); ?>><?php esc_html_e('Weeks', 'autoroyal' ); ?></option>
									</select>

								</div>

								<div class="col-md-12">

									<label for="deal_loan_amount" class="control-label"><?php esc_html_e('Loan Amount:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_loan_amount" name="deal_loan_amount" value="<?php echo esc_attr($deal_loan_amount); ?>" placeholder="" disabled="disabled" />

								</div>

								<div class="col-md-6">

									<label for="deal_loan_payment_amount" class="control-label"><?php esc_html_e('Payment:', 'autoroyal' ); ?>  (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="deal_loan_payment_amount" name="deal_loan_payment_amount" value="<?php echo esc_attr($deal_loan_payment_amount); ?>" placeholder="" disabled="disabled" />

								</div>

								<div class="col-md-6">

									<label for="deal_loan_payment_amount_period" class="control-label"><?php esc_html_e('Select:', 'autoroyal' ); ?></label>
									<select name="deal_loan_payment_amount_period" id="deal_loan_payment_amount_period" class="form-control input-lg">
										<option value="Monthly" <?php selected( "Monthly", $deal_loan_payment_amount_period ); ?>><?php esc_html_e('Monthly', 'autoroyal' ); ?></option>
										<option value="Semi-Monthly" <?php selected( "Semi-Monthly", $deal_loan_payment_amount_period ); ?>><?php esc_html_e('Semi-Monthly', 'autoroyal' ); ?></option>
										<option value="Weekly" <?php selected( "Weekly", $deal_loan_payment_amount_period ); ?>><?php esc_html_e('Weekly', 'autoroyal' ); ?></option>
										<option value="Bi-Weekly" <?php selected( "Bi-Weekly", $deal_loan_payment_amount_period ); ?>><?php esc_html_e('Bi-Weekly', 'autoroyal' ); ?></option>
									</select>

								</div>

								<div class="col-md-12">

									<div class="autoroyal_loan_new_table_box">

										<input type="checkbox" name="deal_new_schedule"> <?php esc_html_e( 'Check and click SAVE to generate the amortization schedule table', 'autoroyal' ); ?>

									</div>

								</div>

							</div>

						</div>

					</div>

				</fieldset>

				<fieldset>

					<div class="row">

						<input type="hidden" id="deal_loan_payments_num" name="deal_loan_payments_num" value="<?php echo esc_attr($deal_loan_payments_num); ?>" />
						<input type="hidden" id="deal_loan_payments_period" name="deal_loan_payments_period" value="<?php echo esc_attr($deal_loan_payments_period); ?>" />
						<input type="hidden" id="deal_loan_final_date" name="deal_loan_final_date" value="<?php echo esc_attr($deal_loan_final_date); ?>" />
						<input type="hidden" id="deal_loan_payment_amount_x" name="deal_loan_payment_amount_x" value="<?php echo esc_attr($deal_loan_payment_amount_x); ?>" />
						<input type="hidden" id="deal_loan_payment_amount_x_old" name="deal_loan_payment_amount_x_old" value="<?php echo esc_attr($deal_loan_payment_amount_x); ?>" />
						<input type="hidden" id="deal_loan_payment_final_amount" name="deal_loan_payment_final_amount" value="<?php echo esc_attr($deal_loan_payment_final_amount); ?>" />
						<input type="hidden" id="deal_loan_rate" name="deal_loan_rate" value="<?php echo esc_attr($deal_loan_rate); ?>" />

						<div class="col-md-12">

							<h2 class="options_group_header"><span><i class="material-icons">monetization_on</i> <?php esc_html_e('Amortization Schedule', 'autoroyal' ); ?></span></h2>

						</div>

						<?php

							if( !empty($deal_loan_payoff_date)) {

								$end_date_query = date(get_option('date_format'), strtotime($deal_loan_payoff_date));

						?>

						<div class="col-md-12">

							<h4 class="autoroyal-payoff-date"><span><?php echo esc_attr($end_date_query); ?></span> <?php esc_html_e('Pay-Off Date', 'autoroyal' ); ?></h4>

						</div>

						<?php } ?>

						<div class="col-md-12">

							<div id="autoroyal_amortization_schedule">

								<table id="autoroyal_deal_payments_table" class="car-manager-cars">

									<thead>
										<tr>
											<th class="">#</th>
											<th class=""><?php esc_html_e( 'Date', 'autoroyal' ); ?></th>
											<th class=""><?php esc_html_e( 'Payment', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</th>
											<th class=""><?php esc_html_e( 'Principal', 'autoroyal' ); ?></th>
											<th class=""><?php esc_html_e( 'Interest', 'autoroyal' ); ?></th>
											<th class=""><?php esc_html_e( 'Total Interest', 'autoroyal' ); ?></th>
											<th class=""><?php esc_html_e( 'Balance', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</th>
											<th class=""><?php esc_html_e( 'Status', 'autoroyal' ); ?></th>
										</tr>
									</thead>

									<tbody>

										<?php 

											$payedAmount = 0;
											$old_interest = 0;
											$initial_day_of_payment = date('d', strtotime( $deal_sold_date ));
											$initial_month_of_payment = date('m', strtotime( $deal_sold_date ));
											$initial_year_of_payment = date('Y', strtotime( $deal_sold_date ));
											$end_date_payment = date(get_option('date_format'),strtotime(  $deal_sold_date ));

											if(!empty($deal_purchase_price)) {

												$totalTaxes = ($deal_purchase_price * ($deal_sales_tax / 100)) + $deal_sales_tax_fee;
												$deal_purchase_price = $deal_purchase_price + $totalTaxes;

												if( $initial_day_of_payment >= 15 ) {
													$first_month_payment_date = $initial_day_of_payment - 14;
													$second_month_payment_date = $initial_day_of_payment;
													$current_day_of_payment = $first_month_payment_date;
												} else {
													$first_month_payment_date = $initial_day_of_payment;
													$second_month_payment_date = $initial_day_of_payment + 14;
													$current_day_of_payment = $second_month_payment_date;
												}

												for( $i = 0; $i < $deal_loan_payments_num; ++$i ){ 

													if( empty($deal_loan_payments[$i]['rate_value']) ) {
														$deal_loan_payments[$i]['rate_value'] = $deal_loan_payment_amount_x;
													}

													$loan_interest = $deal_purchase_price * $deal_loan_rate;
													$loan_principal = $deal_loan_payments[$i]['rate_value'] - $loan_interest;
													$balanceDue = $deal_purchase_price - $loan_principal;
													$deal_purchase_price = $balanceDue; 
													$total_interest = $old_interest + $loan_interest;
													$old_interest = $total_interest;

													if( ($deal_loan_payments_num - 1) == $i ) {
														$balanceDue = 0;
													}

													$current = $i;
													$current = $current + 1;

													if( $deal_loan_payment_amount_period == "Monthly" ) {

														$payment_date_raw = strtotime( $deal_sold_date . " +" . $current . " month" );
														$payment_date = date(get_option('date_format'), $payment_date_raw); 

													} elseif( $deal_loan_payment_amount_period == "Semi-Monthly" ) {

														if( $current_day_of_payment == $second_month_payment_date ) {

															$date = $second_month_payment_date . "-" . $initial_month_of_payment . "-" . $initial_year_of_payment;
															$payment_date = date(get_option('date_format'), strtotime($date)); 

															$end_date_payment = $payment_date;
															$initial_month_of_payment = date('m', strtotime( $end_date_payment ));
															$initial_year_of_payment = date('Y', strtotime( $end_date_payment ));

															$current_day_of_payment = $first_month_payment_date;

														} else {

															$x = strtotime($end_date_payment);
															$new_date_payment = date('Y-m-d', strtotime("+1 month",$x));

															$initial_month_of_payment = date('m', strtotime( $new_date_payment ));
															$initial_year_of_payment = date('Y', strtotime( $new_date_payment ));

															$date = $first_month_payment_date . "-" . $initial_month_of_payment . "-" . $initial_year_of_payment;
															$payment_date = date(get_option('date_format'), strtotime($date));
															$end_date_payment = $payment_date;

															$initial_month_of_payment = date('m', strtotime( $end_date_payment ));
															$initial_year_of_payment = date('Y', strtotime( $end_date_payment ));

															$current_day_of_payment = $second_month_payment_date;

														}

													} elseif( $deal_loan_payment_amount_period == "Weekly" ) {

														$payment_date_raw = strtotime( $deal_sold_date . " +" . $current . " week" );
														$payment_date = date(get_option('date_format'), $payment_date_raw); 

													} elseif( $deal_loan_payment_amount_period == "Bi-Weekly" ) {

														$current_x = $current * 2;

														$payment_date_raw = strtotime( $deal_sold_date . " +" . $current_x . " week" );
														$payment_date = date(get_option('date_format'), $payment_date_raw); 

													}

													$today = strtotime("now");

													if( $payment_date_raw <= $today ) {
														$class = "autoroyal_loan_payment_paid_faild";
													} else {
														$class = "";
													}

											?>

											<tr class="<?php if($deal_loan_payments[$i]['paid'] == "on") { echo "autoroyal_loan_payment_paid_success"; } else { echo esc_attr($class); } ?>">
												<td class=""><?php echo esc_attr($current); ?></td>
												<td class="">
													<?php echo esc_attr($payment_date); ?>
													<input type="hidden" id="deal_loan_payment_date_<?php echo esc_attr($i); ?>" name="deal_loan_payments[<?php echo esc_attr($i); ?>][date]" value="<?php echo esc_attr($payment_date); ?>" />
												</td>
												<td class="">

													<?php if(!empty($deal_loan_payments[$i]['paid']) AND $deal_loan_payments[$i]['paid'] == "on") { ?>
													<input data-id="<?php echo esc_attr($current); ?>" type="text" id="" class="deal_loan_payments_rate" name="" value="<?php echo esc_attr($deal_loan_payments[$i]['rate_value']); ?>" placeholder=""disabled="disabled" >
													<input type="hidden" id="deal_loan_payments_<?php echo esc_attr($current); ?>" class="deal_loan_payments_rate" name="deal_loan_payments[<?php echo esc_attr($i); ?>][rate_value]" value="<?php echo esc_attr($deal_loan_payments[$i]['rate_value']); ?>" />
													<?php } else { ?>
													<input data-id="<?php echo esc_attr($current); ?>" type="text" id="deal_loan_payments_<?php echo esc_attr($current); ?>" class="deal_loan_payments_rate" name="deal_loan_payments[<?php echo esc_attr($i); ?>][rate_value]" value="<?php echo esc_attr($deal_loan_payments[$i]['rate_value']); ?>" placeholder="" >
													<?php } ?>

												</td>
												<td class=""><input type="text" id="deal_loan_payments_principal_<?php echo esc_attr($current); ?>" class="deal_loan_payments_principal_" name="deal_loan_payments[<?php echo esc_attr($i); ?>][principal]" value="<?php echo number_format((float)$loan_principal, 2, '.', ''); ?>" placeholder="" disabled="disabled" ></td>
												<td class=""><input type="text" id="deal_loan_payments_interest_<?php echo esc_attr($current); ?>" class="deal_loan_payments_interest_" name="deal_loan_payments[<?php echo esc_attr($i); ?>][interest]" value="<?php echo number_format((float)$loan_interest, 2, '.', ''); ?>" placeholder="" disabled="disabled" ></td>
												<td class=""><input type="text" id="deal_loan_payments_total_interest_<?php echo esc_attr($current); ?>" class="deal_loan_payments_total_interest_" name="deal_loan_payments[<?php echo esc_attr($i); ?>][total_interest]" value="<?php echo number_format((float)$total_interest, 2, '.', ''); ?>" placeholder="" disabled="disabled" ></td>
												<td class=""><input type="text" id="deal_loan_payments_balance_<?php echo esc_attr($current); ?>" class="deal_loan_payments_balance" name="deal_loan_payments[<?php echo esc_attr($i); ?>][rate_balance]" value="<?php echo number_format((float)$balanceDue, 2, '.', ''); ?>" placeholder="" disabled="disabled" ></td>
												<td class=""><input type="checkbox" name="deal_loan_payments[<?php echo esc_attr($i); ?>][paid]" <?php if(!empty($deal_loan_payments[$i]['paid']) AND $deal_loan_payments[$i]['paid'] == "on") { echo "checked"; } ?>> <?php esc_html_e( 'Paid', 'autoroyal' ); ?></td>
											</tr>

										<?php } } ?>

										<input type="hidden" id="deal_loan_payoff_date" name="deal_loan_payoff_date" value="<?php echo esc_attr($payment_date); ?>" />

									</tbody>

								</table>

							</div>

						</div>	

					</div>

				</fieldset>

				<fieldset>

				<div class="row">

					<div class="col-md-12">

						<div class="autoroyal_loan_new_table_box">

							<input type="checkbox" name="deal_closed" <?php if(!empty($deal_loan_next_payments_date) AND $deal_loan_next_payments_date == "done" ) { echo "checked"; } ?>> <?php esc_html_e( 'Mark deal as closed', 'autoroyal' ); ?>

						</div>

					</div>

				</div>

			</fieldset>

				<br>

			</div>	<!-- end review_options_pop -->

		<?php

		}
		
		add_action ('save_post', 'update_deal_settings');
		function update_deal_settings ( $td_post_id ) {
			// verify nonce.  

			if (!isset($_POST['cmb_nonce'])) {
				return false;		
			}

			if (!wp_verify_nonce($_POST['cmb_nonce'], basename(__FILE__))) {
				return false;
			}

			// Deal Buyer Info
			update_post_meta($td_post_id, 'customer_type', sanitize_text_field($_POST['customer_type']));
			update_post_meta($td_post_id, 'existing_customer', sanitize_text_field($_POST['existing_customer']));

			update_post_meta($td_post_id, 'deal_first_name', sanitize_text_field($_POST['deal_first_name']));
			update_post_meta($td_post_id, 'deal_middle_name', sanitize_text_field($_POST['deal_middle_name']));
			update_post_meta($td_post_id, 'deal_last_name', sanitize_text_field($_POST['deal_last_name']));

			update_post_meta($td_post_id, 'deal_address_1', sanitize_text_field($_POST['deal_address_1']));
			update_post_meta($td_post_id, 'deal_address_2', sanitize_text_field($_POST['deal_address_2']));

			update_post_meta($td_post_id, 'deal_city', sanitize_text_field($_POST['deal_city']));
			update_post_meta($td_post_id, 'deal_state', sanitize_text_field($_POST['deal_state']));
			update_post_meta($td_post_id, 'deal_zip', sanitize_text_field($_POST['deal_zip']));

			update_post_meta($td_post_id, 'deal_home_phone', sanitize_text_field($_POST['deal_home_phone']));
			update_post_meta($td_post_id, 'deal_mobile_phone', sanitize_text_field($_POST['deal_mobile_phone']));
			update_post_meta($td_post_id, 'deal_work_phone', sanitize_text_field($_POST['deal_work_phone']));

			update_post_meta($td_post_id, 'deal_email', sanitize_text_field($_POST['deal_email']));
			if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
				update_post_meta($td_post_id, 'deal_birth_date', sanitize_text_field($_POST['deal_birth_date']));
				update_post_meta($td_post_id, 'deal_social_security', sanitize_text_field($_POST['deal_social_security']));
			}

			update_post_meta($td_post_id, 'deal_driver_license_state', sanitize_text_field($_POST['deal_driver_license_state']));
			if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
				update_post_meta($td_post_id, 'deal_driver_license_number', sanitize_text_field($_POST['deal_driver_license_number']));
			}
			update_post_meta($td_post_id, 'deal_driver_license_exp', sanitize_text_field($_POST['deal_driver_license_exp']));

			// Deal Co-Buyer Info
			update_post_meta($td_post_id, 'cobuyer_customer_type', sanitize_text_field($_POST['cobuyer_customer_type']));
			update_post_meta($td_post_id, 'cobuyer_existing_customer', sanitize_text_field($_POST['cobuyer_existing_customer']));

			update_post_meta($td_post_id, 'deal_cobuyer_first_name', sanitize_text_field($_POST['deal_cobuyer_first_name']));
			update_post_meta($td_post_id, 'deal_cobuyer_middle_name', sanitize_text_field($_POST['deal_cobuyer_middle_name']));
			update_post_meta($td_post_id, 'deal_cobuyer_last_name', sanitize_text_field($_POST['deal_cobuyer_last_name']));

			update_post_meta($td_post_id, 'deal_cobuyer_address_1', sanitize_text_field($_POST['deal_cobuyer_address_1']));
			update_post_meta($td_post_id, 'deal_cobuyer_address_2', sanitize_text_field($_POST['deal_cobuyer_address_2']));

			update_post_meta($td_post_id, 'deal_cobuyer_city', sanitize_text_field($_POST['deal_cobuyer_city']));
			update_post_meta($td_post_id, 'deal_cobuyer_state', sanitize_text_field($_POST['deal_cobuyer_state']));
			update_post_meta($td_post_id, 'deal_cobuyer_zip', sanitize_text_field($_POST['deal_cobuyer_zip']));

			update_post_meta($td_post_id, 'deal_cobuyer_home_phone', sanitize_text_field($_POST['deal_cobuyer_home_phone']));
			update_post_meta($td_post_id, 'deal_cobuyer_mobile_phone', sanitize_text_field($_POST['deal_cobuyer_mobile_phone']));
			update_post_meta($td_post_id, 'deal_cobuyer_work_phone', sanitize_text_field($_POST['deal_cobuyer_work_phone']));

			update_post_meta($td_post_id, 'deal_cobuyer_email', sanitize_text_field($_POST['deal_cobuyer_email']));
			if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
				update_post_meta($td_post_id, 'deal_cobuyer_birth_date', sanitize_text_field($_POST['deal_cobuyer_birth_date']));
				update_post_meta($td_post_id, 'deal_cobuyer_social_security', sanitize_text_field($_POST['deal_cobuyer_social_security']));
			}

			update_post_meta($td_post_id, 'deal_cobuyer_driver_license_state', sanitize_text_field($_POST['deal_cobuyer_driver_license_state']));
			if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
				update_post_meta($td_post_id, 'deal_cobuyer_driver_license_number', sanitize_text_field($_POST['deal_cobuyer_driver_license_number']));
			}
			update_post_meta($td_post_id, 'deal_cobuyer_driver_license_exp', sanitize_text_field($_POST['deal_cobuyer_driver_license_exp']));

			// Vehicle Information
			update_post_meta($td_post_id, 'deal_vehicle_id', sanitize_text_field($_POST['deal_vehicle_id']));
			$deal_vehicle_id = esc_attr(get_post_meta($td_post_id, 'deal_vehicle_id',true));
			$deal_vehicle_sku_own = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_stock',true));
			update_post_meta($td_post_id, 'deal_vehicle_sku', $deal_vehicle_sku_own);

			$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
			update_post_meta($td_post_id, 'deal_vehicle_make', $deal_vehicle_make);
			
			$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
			update_post_meta($td_post_id, 'deal_vehicle_model', $deal_vehicle_model);

			$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));
			update_post_meta($td_post_id, 'deal_vehicle_trim', $deal_vehicle_trim);

			$date = strtotime($_POST['deal_sold_date']);
			update_post_meta( $deal_vehicle_id, '_sold_date', $date );
			update_post_meta( $deal_vehicle_id, '_sold', 1 );

			$price = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_price',true));
			$cost = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_cost',true));
			$profit = $price - $cost;
			update_post_meta($td_post_id, 'deal_vehicle_price', $price);
			update_post_meta($td_post_id, 'deal_vehicle_cost', $cost);
			update_post_meta($td_post_id, 'deal_vehicle_profit', $profit);

			$pfx_date = get_the_date( $format, $deal_vehicle_id ); 
			$sold = esc_attr(get_post_meta($deal_vehicle_id, '_sold_date',true));

			if(!empty($sold)) {
				$now = $sold;
			} else {
				$now = strtotime(date("Y-m-d H:i:s")); 
			}

			$days = ($now - strtotime($pfx_date)) / (60 * 60 * 24); 
			update_post_meta($td_post_id, 'deal_vehicle_age', $days);

			//
			update_post_meta($td_post_id, 'deal_tradein_vehicle_year', sanitize_text_field($_POST['cq-year']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_make', sanitize_text_field($_POST['cq-make']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_model', sanitize_text_field($_POST['cq-model']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_trim_id', sanitize_text_field($_POST['cq-trim']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_trim_desc_init', sanitize_text_field($_POST['vehicle_trim_desc_init']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_make_desc_init', sanitize_text_field($_POST['vehicle_make_desc_init']));

			update_post_meta($td_post_id, 'deal_tradein_vehicle_vin', sanitize_text_field($_POST['deal_tradein_vehicle_vin']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_mileage', sanitize_text_field($_POST['deal_tradein_vehicle_mileage']));
			update_post_meta($td_post_id, 'deal_tradein_vehicle_color', sanitize_text_field($_POST['deal_tradein_vehicle_color']));

			update_post_meta($td_post_id, 'deal_tradein_allowance', sanitize_text_field($_POST['deal_tradein_allowance']));
			update_post_meta($td_post_id, 'deal_tradein_payoff', sanitize_text_field($_POST['deal_tradein_payoff']));
			update_post_meta($td_post_id, 'deal_tradein_payoff_good', sanitize_text_field($_POST['deal_tradein_payoff_good']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_name', sanitize_text_field($_POST['deal_tradein_lien_holder_name']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_addres_1', sanitize_text_field($_POST['deal_tradein_lien_holder_addres_1']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_addres_2', sanitize_text_field($_POST['deal_tradein_lien_holder_addres_2']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_city', sanitize_text_field($_POST['deal_tradein_lien_holder_city']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_state', sanitize_text_field($_POST['deal_tradein_lien_holder_state']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_zip', sanitize_text_field($_POST['deal_tradein_lien_holder_zip']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_phone', sanitize_text_field($_POST['deal_tradein_lien_holder_phone']));
			update_post_meta($td_post_id, 'deal_tradein_lien_holder_acc_number', sanitize_text_field($_POST['deal_tradein_lien_holder_acc_number']));

			//
			update_post_meta($td_post_id, 'deal_sold_date', sanitize_text_field($_POST['deal_sold_date']));
			update_post_meta($td_post_id, 'deal_purchase_price', sanitize_text_field($_POST['deal_purchase_price']));
			update_post_meta($td_post_id, 'deal_trade_in_payoff', sanitize_text_field($_POST['deal_trade_in_payoff']));
			update_post_meta($td_post_id, 'deal_trade_in_allowance', sanitize_text_field($_POST['deal_trade_in_allowance']));
			update_post_meta($td_post_id, 'deal_total_price', sanitize_text_field($_POST['deal_total_price']));
			update_post_meta($td_post_id, 'deal_down_payment', sanitize_text_field($_POST['deal_down_payment']));
			update_post_meta($td_post_id, 'deal_total_balance_due', sanitize_text_field($_POST['deal_total_balance_due']));

			if(!empty($_POST['deal_payment_method'])) {
				$deal_payment_method = $_POST['deal_payment_method'];
			} else {
				$deal_payment_method = "";
			}
			wp_set_post_terms( $td_post_id, $deal_payment_method, "deal_payment_method", false );

			update_post_meta($td_post_id, 'deal_loan_amount', sanitize_text_field($_POST['deal_loan_amount']));
			update_post_meta($td_post_id, 'deal_interest_rate', sanitize_text_field($_POST['deal_interest_rate']));
			update_post_meta($td_post_id, 'deal_sales_tax', sanitize_text_field($_POST['deal_sales_tax']));
			update_post_meta($td_post_id, 'deal_sales_tax_fee', sanitize_text_field($_POST['deal_sales_tax_fee']));
			update_post_meta($td_post_id, 'deal_loan_term', sanitize_text_field($_POST['deal_loan_term']));
			update_post_meta($td_post_id, 'deal_loan_term_priod', sanitize_text_field($_POST['deal_loan_term_priod']));
			update_post_meta($td_post_id, 'deal_loan_payment_amount', sanitize_text_field($_POST['deal_loan_payment_amount']));
			update_post_meta($td_post_id, 'deal_loan_payment_final_amount', sanitize_text_field($_POST['deal_loan_payment_final_amount']));
			update_post_meta($td_post_id, 'deal_loan_payment_amount_period', sanitize_text_field($_POST['deal_loan_payment_amount_period']));

			update_post_meta($td_post_id, 'deal_profit', sanitize_text_field($_POST['deal_profit_hidden']));

			update_post_meta($td_post_id, 'deal_loan_final_date', sanitize_text_field($_POST['deal_loan_final_date']));
			update_post_meta($td_post_id, 'deal_loan_rate', sanitize_text_field($_POST['deal_loan_rate']));

			if( $_POST['deal_new_schedule'] == "on" ) {
				update_post_meta($td_post_id, 'deal_loan_payments_num', sanitize_text_field($_POST['deal_loan_payments_num']));
				update_post_meta($td_post_id, 'deal_loan_payments_period', sanitize_text_field($_POST['deal_loan_payments_period']));
				update_post_meta($td_post_id, 'deal_loan_payments', "");
				update_post_meta($td_post_id, 'deal_loan_payment_amount_x', $_POST['deal_loan_payment_amount_x']);
			} else {
				update_post_meta($td_post_id, 'deal_loan_payments', $_POST['deal_loan_payments']);
				update_post_meta($td_post_id, 'deal_loan_payment_amount_x', $_POST['deal_loan_payment_amount_x_old']);
			}

			update_post_meta($td_post_id, 'deal_loan_payoff_date', sanitize_text_field($_POST['deal_loan_payoff_date']));

			if($_POST['deal_new_schedule'] == "on") {

				$deal_loan_next_payments_date = $deal_loan_payments[0][date];

			} else {

				$deal_loan_payments = get_post_meta($td_post_id, 'deal_loan_payments',true);
				$deal_loan_payments_num = get_post_meta($td_post_id, 'deal_loan_payments_num',true);
				$deal_loan_next_payments_date = $deal_loan_payments[0][date];

				for( $i = 0; $i < $deal_loan_payments_num; ++$i ){ 

					if( $deal_loan_payments[$i]['paid'] == "on" ) {
						$deal_loan_next_payments_date = $deal_loan_payments[$i+1][date];
					}

				}

			}

			if( $deal_loan_payments[$deal_loan_payments_num - 1]['paid'] == "on" ) {
				$deal_loan_next_payments_date = "done";
			}

			if( !empty($_POST['deal_closed']) AND $_POST['deal_closed'] == "on"  ) {
				$deal_loan_next_payments_date = "done";
			}

			update_post_meta($td_post_id, 'deal_loan_next_payments_date', $deal_loan_next_payments_date);

		}

	}

}