<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Shortcode_Reports class.
 */
class autoroyal_Shortcode_Reports {

	/**
	 * Inventory message
	 *
	 * @access private
	 * @var string
	 */
	private $car_inventory_message = '';

	/**
	 * Constructor
	 */
	public function __construct() {
		add_shortcode( 'autoroyal_reports', array( $this, 'autoroyal_reports' ) );
	}

	/**
	 * Shortcode which lists the logged in user's cars
	 */
	public function autoroyal_reports( $atts ) {
		
		if ( ! is_user_logged_in() ) {
			ob_start();
			get_autoroyal_template( 'autoroyal-login.php' );
			return ob_get_clean();
		}

		wp_enqueue_script( 'charts' );

		ob_start();

		get_autoroyal_template( 'autoroyal-reports.php', array(  ) );

		return ob_get_clean();
	}

}

new autoroyal_Shortcode_Reports();
