<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Shortcode_Reservations class.
 */
class autoroyal_Shortcode_Reservations {

	/**
	 * Reservations message
	 *
	 * @access private
	 * @var string
	 */
	private $car_reservations_message = '';

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'wp', array( $this, 'shortcode_reservations_action_handler' ) );
		add_shortcode( 'autoroyal_reservations', array( $this, 'autoroyal_reservations' ) );
	}

	/**
	 * Handle actions which need to be run before the shortcode e.g. post actions
	 */
	public function shortcode_reservations_action_handler() {
		global $post;

		if ( is_page() && strstr( $post->post_content, '[autoroyal_reservations' ) ) {
			$this->car_reservations_handler();
		}
	}

	/**
	 * Handles actions on car reservations
	 */
	public function car_reservations_handler() {
		if ( ! empty( $_REQUEST['action'] ) && ! empty( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'autoroyal_reservations_actions' ) ) {

			$action = sanitize_title( $_REQUEST['action'] );
			$car_id = absint( $_REQUEST['car_id'] );

			try {
				// Get car
				$car    = get_post( $car_id );

				// Check ownership
				if ( ! autoroyal_user_can_edit_car( $car_id ) ) {
					throw new Exception( __( 'Invalid ID', 'autoroyal' ) );
				}

				switch ( $action ) {
					case 'edit' :
						if ( ! autoroyal_get_permalink( 'submit_reservation_form' ) ) {
							throw new Exception( __( 'Missing reservation submission page.', 'autoroyal' ) );
						}

						if ( $car_id ) {
							wp_redirect( add_query_arg( array( 'action' => 'edit', 'car_id' => absint( $car_id ) ), autoroyal_get_permalink( 'submit_reservation_form' ) ) );
							exit;
						}

						break;
					default :
						do_action( 'autoroyal_reservations_do_action_' . $action );
						break;
				}

				do_action( 'autoroyal_my_car_do_action', $action, $car_id );

			} catch ( Exception $e ) {
				$this->car_reservations_message = '<div class="car-manager-error">' . $e->getMessage() . '</div>';
			}
		}
	}

	/**
	 * Shortcode which lists the logged in user's cars
	 */
	public function autoroyal_reservations( $atts ) {

		if ( ! is_user_logged_in() ) {
			ob_start();
			get_autoroyal_template( 'autoroyal-login.php' );
			return ob_get_clean();
		}

		ob_start();

		// If doing an action, show conditional content if needed....
		if ( ! empty( $_REQUEST['action'] ) ) {
			$action = sanitize_title( $_REQUEST['action'] );

			// Show alternative content if a plugin wants to
			if ( has_action( 'autoroyal_reservations_content_' . $action ) ) {
				do_action( 'autoroyal_reservations_content_' . $action, $atts );

				return ob_get_clean();
			}
		}

		echo $this->car_reservations_message;

		get_autoroyal_template( 'autoroyal-reservations.php' );

		return ob_get_clean();
	}

}

new autoroyal_Shortcode_Reservations();
