<?php 

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function autoroyal_vertical_search_filter_rent( $shortcode_filter ) { ?>

	<?php

		$autoroyal_vehicles_query = autoroyal_vehicle_query();

		$page_url = "";

		if( isset($shortcode_filter) AND $shortcode_filter == 1 ) {

			$page_url = autoroyal_get_permalink( 'cars' );

		} else {

			$page_url = get_permalink();

		}

		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'touch-punch' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

		$results_status = 0;

		$make = "0";
		if ( isset( $_GET['make'] ) ) {

	        $make = $_GET['make'];

	        if($make != "0" ) {
	        	$results_status = 1;
	        }

	    }

	    $model = "0";
		if ( isset( $_GET['model'] ) ) {

	        $model = $_GET['model'];

	        if( $model != "0" ) {
	        	$results_status = 1;
	        }

	    }

	    $posts_per_page_set = get_option("autoroyal_posts_per_page");
		if( isset($posts_per_page_set) AND !empty($posts_per_page_set) AND $posts_per_page_set != 0 ) {
			
			$posts_per_page = $posts_per_page_set;

		} else {

			$posts_per_page = "12";

		}
		if ( isset( $_GET['posts_per_page'] ) AND !empty($_GET['posts_per_page']) ) {
            $posts_per_page = $_GET['posts_per_page'];
        }

	    $fuel_type = "";
		if ( isset( $_GET['fuel_type'] ) ) {

	        $fuel_type = $_GET['fuel_type'];

	        if( $fuel_type != "0" ) {
	        	$results_status = 1;
	        }

	    }

	    $price_max = autoroyal_get_max_price();
	    $price = $price_max;
		if ( isset( $_GET['price'] ) ) {

	        $price = $_GET['price'];

	        if( $price != $price_max ) {
	        	$results_status = 1;
	        }

	    }

	    $price_min = autoroyal_get_min_price();
		if ( isset( $_GET['price_min'] ) ) {

	        $price_min = $_GET['price_min'];

	        if( $price_min != $price_min ) {
	        	$results_status = 1;
	        }

	    }

	    $vehicle_min_year = autoroyal_get_min_year();
		if ( isset( $_GET['vehicle_year_min'] ) ) {

	        $vehicle_min_year = $_GET['vehicle_year_min'];

	        if( $vehicle_min_year != $vehicle_min_year ) {
	        	$results_status = 1;
	        }

	    }

	    $vehicle_year_max = autoroyal_get_max_year();
		if ( isset( $_GET['vehicle_year_max'] ) ) {

	        $vehicle_year_max = $_GET['vehicle_year_max'];

	        if( $vehicle_year_max != $vehicle_year_max ) {
	        	$results_status = 1;
	        }

	    }

	    $vehicle_condition = "";
		if ( isset( $_GET['vehicle_condition'] ) ) {

	        $vehicle_condition = $_GET['vehicle_condition'];
	        $results_status = 1;

	    }

	    $mileage_min = autoroyal_get_min_mileage();
	    $mileage_min_value = $mileage_min;
		if ( isset( $_GET['mileage_min'] ) ) {

	        $mileage_min_value = $_GET['mileage_min'];
	        
	        if( ( $mileage_min_value * 1000 ) != $mileage_min ) {
	        	$results_status = 1;
	        }

	    }

	    $mileage = autoroyal_get_max_mileage();
	    $mileage_value = $mileage;
		if ( isset( $_GET['mileage'] ) ) {

	        $mileage_value = $_GET['mileage'];
	        
	        if( ( $mileage_value * 1000 ) != $mileage ) {
	        	$results_status = 1;
	        }

	    }

	    // Transmission
	    $transmission = array();
	    if ( isset( $_GET['transmission'] ) AND !empty($_GET['transmission'] ) ) {

	        $transmission = $_GET['transmission'];
	        $results_status = 1;

	    }

	    // Body Style
	    $body_style = array();
	    if ( isset( $_GET['body_style'] ) AND !empty($_GET['body_style'] ) ) {

	        $body_style = $_GET['body_style'];
	        $results_status = 1;

	    }

	    $orderby = "default";
		if ( isset( $_GET['orderby'] ) AND !empty($_GET['orderby']) ) {
	        $orderby = $_GET['orderby'];
	    }

	    // Vehicle Exterior Color
	    $vehicle_exterior_color = array();
	    if ( isset( $_GET['vehicle_exterior_color'] ) AND !empty($_GET['vehicle_exterior_color'] ) ) {

	        $vehicle_exterior_color = $_GET['vehicle_exterior_color'];
	        $results_status = 1;

	    }

	    if( !empty($page_url)) {

	?> 

		<div id="autoroyal-vertical-car-holder">
		
			<form id="autoroyal-advance-search-form" class="autoroyal-vertical-car-filter autoroyal-vertical-car-filter-rent" action="<?php echo esc_url($page_url); ?>" method="get" autocomplete="off">

				<div class="vertical-filter-fields-group">

					<div class="form-groupe">

						<div class="autoroyal-rent-filter-checkbox autoroyal-rent-filter-age">

							<div class="autoroyal-filter-heading"><?php esc_html_e('Your Age', 'autoroyal' ); ?></div>

							<?php 

								$categories = get_categories( array('taxonomy' => 'vehicle_rent_age', 'hide_empty' => true, 'parent' => 0) ); 
								$total_cat = count($categories);
								$current = 0;
								foreach ($categories as $category) {
									$current++;

							?>

							<div class="autoroyal-rent-filter-checkbox-unit form-check">

							  	<label class="form-check-label radio">

							  		<span><svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 26" xmlns:xlink="http://www.w3.org/1999/xlink" enable-background="new 0 0 26 26"><path d="m.3,14c-0.2-0.2-0.3-0.5-0.3-0.7s0.1-0.5 0.3-0.7l1.4-1.4c0.4-0.4 1-0.4 1.4,0l.1,.1 5.5,5.9c0.2,0.2 0.5,0.2 0.7,0l13.4-13.9h0.1v-8.88178e-16c0.4-0.4 1-0.4 1.4,0l1.4,1.4c0.4,0.4 0.4,1 0,1.4l0,0-16,16.6c-0.2,0.2-0.4,0.3-0.7,0.3-0.3,0-0.5-0.1-0.7-0.3l-7.8-8.4-.2-.3z"/></svg></span>

							    	<input class="form-check-input" type="radio" value="<?php echo esc_attr($category->cat_name); ?>">
							    	<?php echo esc_attr($category->cat_name); ?> <?php if( $current == $total_cat) { echo "+"; } ?>

							  	</label>

							</div>

							<?php } ?>

						</div>

					</div>

				</div>

				<div class="vertical-filter-fields-group">

					<div class="form-groupe">

						<div class="autoroyal-rent-filter-checkbox autoroyal-rent-filter-luggages">

							<div class="autoroyal-filter-heading"><?php esc_html_e('Luggages', 'autoroyal' ); ?></div>

							<?php 

								$categories = get_categories( array('taxonomy' => 'vehicle_luggages', 'hide_empty' => true,  'parent' => 0) ); 
								foreach ($categories as $category) {

							?>

							<div class="autoroyal-rent-filter-checkbox-unit form-check">

							  	<label class="form-check-label">

							  		<span><svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 26" xmlns:xlink="http://www.w3.org/1999/xlink" enable-background="new 0 0 26 26"><path d="m.3,14c-0.2-0.2-0.3-0.5-0.3-0.7s0.1-0.5 0.3-0.7l1.4-1.4c0.4-0.4 1-0.4 1.4,0l.1,.1 5.5,5.9c0.2,0.2 0.5,0.2 0.7,0l13.4-13.9h0.1v-8.88178e-16c0.4-0.4 1-0.4 1.4,0l1.4,1.4c0.4,0.4 0.4,1 0,1.4l0,0-16,16.6c-0.2,0.2-0.4,0.3-0.7,0.3-0.3,0-0.5-0.1-0.7-0.3l-7.8-8.4-.2-.3z"/></svg></span>

							    	<input class="form-check-input" type="checkbox" value="<?php echo esc_attr($category->cat_name); ?>">
							    	<?php echo esc_attr($category->cat_name); ?> <?php esc_html_e('Suitcases', 'autoroyal' ); ?>

							  	</label>

							</div>

							<?php } ?>

						</div>

					</div>

				</div>

				<div class="vertical-filter-fields-group">

					<div class="form-groupe">

						<div class="autoroyal-rent-filter-checkbox autoroyal-rent-filter-doors">

							<div class="autoroyal-filter-heading"><?php esc_html_e('Doors', 'autoroyal' ); ?></div>

							<?php 

								$categories = get_categories( array('taxonomy' => 'vehicle_doors', 'hide_empty' => true,  'parent' => 0) ); 
								foreach ($categories as $category) {

							?>

							<div class="autoroyal-rent-filter-checkbox-unit form-check">

							  	<label class="form-check-label">

							  		<span><svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 26" xmlns:xlink="http://www.w3.org/1999/xlink" enable-background="new 0 0 26 26"><path d="m.3,14c-0.2-0.2-0.3-0.5-0.3-0.7s0.1-0.5 0.3-0.7l1.4-1.4c0.4-0.4 1-0.4 1.4,0l.1,.1 5.5,5.9c0.2,0.2 0.5,0.2 0.7,0l13.4-13.9h0.1v-8.88178e-16c0.4-0.4 1-0.4 1.4,0l1.4,1.4c0.4,0.4 0.4,1 0,1.4l0,0-16,16.6c-0.2,0.2-0.4,0.3-0.7,0.3-0.3,0-0.5-0.1-0.7-0.3l-7.8-8.4-.2-.3z"/></svg></span>

							    	<input class="form-check-input" type="checkbox" value="<?php echo esc_attr($category->cat_name); ?>">
							    	<?php echo esc_attr($category->cat_name); ?> <?php esc_html_e('Doors', 'autoroyal' ); ?>

							  	</label>

							</div>

							<?php } ?>

						</div>

					</div>

				</div>

				<div class="vertical-filter-fields-group">

					<div class="form-groupe">

						<div class="autoroyal-rent-filter-checkbox autoroyal-rent-filter-seats">

							<div class="autoroyal-filter-heading"><?php esc_html_e('Seats', 'autoroyal' ); ?></div>

							<?php 

								$categories = get_categories( array('taxonomy' => 'vehicle_seats', 'hide_empty' => true,  'parent' => 0) ); 
								foreach ($categories as $category) {

							?>

							<div class="autoroyal-rent-filter-checkbox-unit form-check">

							  	<label class="form-check-label">

							  		<span><svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 26" xmlns:xlink="http://www.w3.org/1999/xlink" enable-background="new 0 0 26 26"><path d="m.3,14c-0.2-0.2-0.3-0.5-0.3-0.7s0.1-0.5 0.3-0.7l1.4-1.4c0.4-0.4 1-0.4 1.4,0l.1,.1 5.5,5.9c0.2,0.2 0.5,0.2 0.7,0l13.4-13.9h0.1v-8.88178e-16c0.4-0.4 1-0.4 1.4,0l1.4,1.4c0.4,0.4 0.4,1 0,1.4l0,0-16,16.6c-0.2,0.2-0.4,0.3-0.7,0.3-0.3,0-0.5-0.1-0.7-0.3l-7.8-8.4-.2-.3z"/></svg></span>

							    	<input class="form-check-input" type="checkbox" value="<?php echo esc_attr($category->cat_name); ?>">
							    	<?php echo esc_attr($category->cat_name); ?> <?php esc_html_e('Seats', 'autoroyal' ); ?>

							  	</label>

							</div>

							<?php } ?>

						</div>

					</div>

				</div>

				<div class="vertical-filter-fields-group">

					<div class="form-group custom-range"> 

						<p>
			                <label for="cd-registration2"><?php esc_html_e('Year', 'autoroyal' ); ?> 
			                	<span id="year_up" class="filter-dynamic-data">
			                		<span class="filter-dynamic-data-min"></span>
			                    	-
			                    	<span class="filter-dynamic-data-max"></span>
			                    </span>
			                </label>
			          	</p>

			          	<div class="range-holder">
			          		<div id="registrationRange2" class="pull-right"></div>
			          	</div>

			          	<input type="hidden" name="vehicle_year_max" id="cd-registration2" readonly class="filter-meta">
			        	<input type="hidden" name="vehicle_year_min" id="cd-registration1" readonly class="filter-meta">

						<script>
			          		jQuery("document").ready(function(){

			          			var regYearMin = parseFloat(<?php echo autoroyal_get_min_year(); ?>);
			          			var regYearMinValue = parseFloat(<?php echo $vehicle_min_year; ?>);

					            var regYearMax = parseFloat(<?php echo autoroyal_get_max_year(); ?>);
					            var regYearMaxValue = parseFloat(<?php echo $vehicle_year_max; ?>);

								$( "#registrationRange2" ).slider({
								    range: true,
								    min: regYearMin,
								    max: regYearMax,
								    values: [ regYearMinValue, regYearMaxValue ],
								    slide: function( event, ui ) {
								      	$( "#cd-registration1" ).val( ui.values[ 0 ] );
								      	$( "#cd-registration2" ).val( ui.values[ 1 ] );

								      	$( "#year_up span.filter-dynamic-data-min" ).text( ui.values[ 0 ] );
								      	$( "#year_up span.filter-dynamic-data-max" ).text( ui.values[ 1 ] );
								    }
							  	});
							  	$( "#cd-registration1" ).val( $( "#registrationRange2" ).slider( "values", 0 ) );
							  	$( "#cd-registration2" ).val( $( "#registrationRange2" ).slider( "values", 1 ) );

							  	$( "#year_up span.filter-dynamic-data-min" ).text( $( "#registrationRange2" ).slider( "values", 0 ) );
						      	$( "#year_up span.filter-dynamic-data-max" ).text( $( "#registrationRange2" ).slider( "values", 1 ) );

						      	$('#registrationRange2').draggable();

						  	})
			          	</script>
					
					</div>

					

				</div>

			</form>

		</div>

		<?php } else { ?>

			<?php esc_html_e( 'Point the search result page in settings.', 'autoroyal' ); ?>

		<?php } ?>

<?php } ?>