<?php
/* Property Custom Post Type */
if( !function_exists( 'create_partners_post_type' ) ){
    function create_partners_post_type(){

      $labels = array(
        'name' => esc_html__( 'Partners','autoroyal'),
        'singular_name' => esc_html__( 'Partner','autoroyal' ),
        'add_new' => esc_html__('Add New','autoroyal'),
        'add_new_item' => esc_html__('Add New Partner','autoroyal'),
        'edit_item' => esc_html__('Edit Partner','autoroyal'),
        'new_item' => esc_html__('New Partner','autoroyal'),
        'view_item' => esc_html__('View Partner','autoroyal'),
        'search_items' => esc_html__('Search Partner','autoroyal'),
        'not_found' =>  esc_html__('No Partner found','autoroyal'),
        'not_found_in_trash' => esc_html__('No Partner found in Trash','autoroyal'),
        'parent_item_colon' => ''
      );

      $args = array(
        'labels' => $labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'query_var' => true,
        'capability_type' => 'post',
        'hierarchical' => false,
        'menu_icon' => 'dashicons-groups',
        'menu_position' => 5,
        'exclude_from_search' => true,
        'supports' => array('title','thumbnail'),
        'rewrite' => array( 'slug' => esc_html__('partners', 'autoroyal') )
      );

      register_post_type('partners',$args);
    }
}
add_action('init', 'create_partners_post_type');


/* Add Custom Columns */
if( !function_exists( 'partners_edit_columns' ) ){
    function partners_edit_columns($columns){
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "title" => esc_html__('Partner','autoroyal'),
            "partner-thumb" => esc_html__('Logo','autoroyal'),
            "date" => esc_html__('Publish Time', 'autoroyal')
        );
        return $columns;
    }
}
add_filter("manage_edit-partners_columns", "partners_edit_columns");


if( !function_exists( 'partners_custom_columns' ) ){
    function partners_custom_columns($column){
        global $post;
        switch ($column){
            case 'partner-thumb':
                if(has_post_thumbnail($post->ID)){
                    the_post_thumbnail( 'autoroyal-partner-logo' );
                }
                else{
                    esc_html_e('No logo provided','autoroyal');
                }
                break;
        }
    }
}

add_action("manage_posts_custom_column",  "partners_custom_columns");

?>